/*
 * Decompiled with CFR 0.152.
 */
package com.energid.urcap.remotetcp.impl.Common;

import java.io.DataInputStream;
import java.net.Socket;

public class RobotRealtimeReader {
    private static String TCP_IP = "127.0.0.1";
    private static int TCP_port = 30003;

    public RobotRealtimeReader() {
        TCP_IP = "127.0.0.1";
        TCP_port = 30003;
    }

    public RobotRealtimeReader(String IP) {
        TCP_IP = IP;
        TCP_port = 30003;
    }

    public void readNow() {
        RobotRealtimeReader.readSocket();
    }

    private static double[] readSocket() {
        double[] RealtimeMessage = null;
        try {
            Socket rt = null;
            DataInputStream in = null;
            rt = new Socket(TCP_IP, TCP_port);
            if (!rt.isConnected()) {
                rt.close();
                return RealtimeMessage;
            }
            in = new DataInputStream(rt.getInputStream());
            int length = in.readInt();
            RealtimeMessage = new double[length];
            RealtimeMessage[0] = length;
            int data_available = (length - 4) / 8;
            for (int i = 1; i <= data_available; ++i) {
                RealtimeMessage[i] = in.readDouble();
            }
            rt.close();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return RealtimeMessage;
    }

    public static double getRobotMode() {
        double[] RealtimeMessage = RobotRealtimeReader.readSocket();
        if (RealtimeMessage != null) {
            double robotMode = RealtimeMessage[RTinfo.robotmode.index()];
            return robotMode;
        }
        return 0.0;
    }

    public static double getProgramState() {
        double[] RealtimeMessage = RobotRealtimeReader.readSocket();
        if (RealtimeMessage != null) {
            double prgState = RealtimeMessage[RTinfo.prgstate.index()];
            return prgState;
        }
        return 0.0;
    }

    public static Object[] getCurrentTCPData() {
        Object[] retArray = new Object[2];
        double[] qActual = new double[6];
        double[] tcpActual = new double[6];
        retArray[0] = qActual;
        retArray[1] = tcpActual;
        double[] realtimeMessage = RobotRealtimeReader.readSocket();
        if (realtimeMessage != null) {
            System.arraycopy(realtimeMessage, RTinfo.q_actual.index(), qActual, 0, RTinfo.q_actual.count());
            System.arraycopy(realtimeMessage, RTinfo.TCP_actual.index(), tcpActual, 0, RTinfo.TCP_actual.count());
            return retArray;
        }
        return null;
    }

    private static enum RTinfo {
        q_target(2, 6),
        qd_target(8, 6),
        qdd_target(14, 6),
        q_actual(32, 6),
        qd_actual(38, 6),
        TCP_actual(56, 6),
        TCPd_actual(62, 6),
        TCP_force(68, 6),
        TCP_target(74, 6),
        TCPd_target(80, 6),
        temp_joint(87, 6),
        robotmode(95, 1),
        jointmode(96, 6),
        safetymode(97, 1),
        tcp_accel(109, 3),
        speedscaling(118, 1),
        prgstate(132, 1);

        private final int index;
        private final int count;

        private RTinfo(int index, int count) {
            this.index = index;
            this.count = count;
        }

        private int index() {
            return this.index;
        }

        private int count() {
            return this.count;
        }
    }
}

