/*
 * Decompiled with CFR 0.152.
 */
package com.energid.urcap.remotetcp.impl.Common;

import com.energid.urcap.remotetcp.impl.Common.RtcpNamedPose;
import com.energid.urcap.remotetcp.impl.Common.RtcpNamedPoseCollectionHandler;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpMoveNode;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.value.PoseFactory;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;

public class RtcpCollectionHandler
extends RtcpNamedPoseCollectionHandler {
    private Vector<RtcpMoveNode> moveNodes;

    public RtcpCollectionHandler(DataModel dataModel, String poseNamePrefix, PoseFactory poseFactory, Vector<RtcpMoveNode> moveNodes) {
        super(dataModel, poseNamePrefix, poseFactory);
        this.moveNodes = moveNodes;
    }

    @Override
    protected void updateDataModelDefaultNamedPose() {
        this.dataModel.remove("RTCP_DEFAULT");
        this.dataModel.set("RTCP_DEFAULT", this.defaultNamedPose);
    }

    @Override
    public void updateDataModel() {
        this.updateDataModelDefaultNamedPose();
        this.dataModel.remove("RTCP_NAMES");
        this.dataModel.remove("RTCP_POSES");
        String[] rtcpNames = this.getAvailablePoses();
        double[] poseArray = this.createPoseArray(this.namedPoseCollection);
        this.dataModel.set("RTCP_NAMES", rtcpNames);
        this.dataModel.set("RTCP_POSES", poseArray);
    }

    @Override
    public void updatePoseName(String oldName, String newName) {
        LinkedHashMap<String, RtcpNamedPose> tempMap = new LinkedHashMap<String, RtcpNamedPose>();
        for (Map.Entry item : this.namedPoseCollection.entrySet()) {
            if (((String)item.getKey()).equals(oldName)) {
                RtcpNamedPose newRtcp = new RtcpNamedPose(newName, ((RtcpNamedPose)item.getValue()).getPose());
                tempMap.put(newName, newRtcp);
                continue;
            }
            tempMap.put((String)item.getKey(), (RtcpNamedPose)item.getValue());
        }
        this.namedPoseCollection.clear();
        this.namedPoseCollection.putAll(tempMap);
        if (this.defaultNamedPose.equals(oldName)) {
            this.setDefaultNamedPose(newName);
        }
        this.updateDataModel();
        for (RtcpMoveNode moveNode : this.moveNodes) {
            moveNode.updateSelectedRtcp(oldName, newName);
        }
    }
}

