/*
 * Decompiled with CFR 0.152.
 */
package com.energid.urcap.remotetcp.impl.Common;

import com.energid.urcap.remotetcp.impl.Common.RtcpConstants;
import com.energid.urcap.remotetcp.impl.Common.RtcpNamedPose;
import com.energid.urcap.remotetcp.impl.Interfaces.LocalizationInfo;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpCircleMoveNode;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpDaemonControl;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpMoveNode;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpNamedPoseInfo;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpProgramInfo;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpToolpathNode;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpWaypointNode;
import com.energid.urcap.remotetcp.impl.MoveNodes.RtcpCircleMoveProgramNodeService;
import com.energid.urcap.remotetcp.impl.RemoteTcpInstallationNodeContribution;
import com.energid.urcap.remotetcp.impl.WaypointNodes.RtcpWaypointProgramNodeService;
import com.ur.urcap.api.contribution.DaemonContribution;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.contribution.URCapProgramNodeService;
import com.ur.urcap.api.contribution.program.ProgramAPIProvider;
import com.ur.urcap.api.domain.ProgramAPI;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.program.ProgramModel;
import com.ur.urcap.api.domain.program.nodes.ProgramNode;
import com.ur.urcap.api.domain.program.nodes.ProgramNodeFactory;
import com.ur.urcap.api.domain.program.nodes.builtin.MoveNode;
import com.ur.urcap.api.domain.program.nodes.builtin.WaitNode;
import com.ur.urcap.api.domain.program.nodes.builtin.WaypointNode;
import com.ur.urcap.api.domain.program.nodes.contributable.URCapProgramNode;
import com.ur.urcap.api.domain.program.structure.ProgramNodeVisitor;
import com.ur.urcap.api.domain.program.structure.TreeNode;
import com.ur.urcap.api.domain.program.structure.TreeStructureException;
import com.ur.urcap.api.domain.undoredo.UndoRedoManager;
import com.ur.urcap.api.domain.undoredo.UndoableChanges;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.variable.Variable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Vector;

public class RtcpMoveNodeContributionBase
implements RtcpMoveNode {
    protected final ProgramAPI programApi;
    protected final ProgramAPIProvider apiProvider;
    protected final UndoRedoManager undoRedoManager;
    protected final DataModel model;
    protected String[] availableRtcps;
    protected final String DATAMODEL_SUBTREE_CREATED = "subtreeCreated";
    protected boolean subtreeCreated = false;
    protected boolean childFound;
    protected boolean nameDuplicate;
    protected int tcpMode = 1;
    protected static int moveIndex = 0;
    protected int moveId = 0;
    protected boolean isThisNodeNested = false;
    protected boolean isNestingChecked = false;
    protected boolean isInTheInternalList = false;
    private String defaultRtcpItem;

    public RtcpMoveNodeContributionBase(ProgramAPIProvider apiProvider, DataModel model) {
        this.programApi = apiProvider.getProgramAPI();
        this.undoRedoManager = apiProvider.getProgramAPI().getUndoRedoManager();
        this.apiProvider = apiProvider;
        this.model = model;
    }

    public void addToInternalList() {
        if (!this.isInTheInternalList) {
            this.getProgramInfo().addRtcpMoveNode(this);
        }
    }

    @Override
    public String getDefaultRtcpItem() {
        return this.defaultRtcpItem;
    }

    @Override
    public void setDefaultRtcpItem(String defaultRtcpItem) {
        this.defaultRtcpItem = defaultRtcpItem;
    }

    public RemoteTcpInstallationNodeContribution getInstallation() {
        return (RemoteTcpInstallationNodeContribution)this.programApi.getInstallationNode(RemoteTcpInstallationNodeContribution.class);
    }

    public RtcpProgramInfo getProgramInfo() {
        return this.getInstallation();
    }

    public RtcpDaemonControl getDaemonControl() {
        return this.getInstallation();
    }

    @Override
    public boolean locateChild(final RtcpWaypointNode waypoint) {
        this.setChildFound(false);
        this.programApi.getProgramModel().getRootTreeNode((ProgramNodeContribution)this).traverse(new ProgramNodeVisitor(){

            public void visit(URCapProgramNode childNode, int index, int depth) {
                try {
                    RtcpWaypointNode waypointNode;
                    if (childNode.canGetAs(RtcpWaypointNode.class) && (waypoint.equals(waypointNode = (RtcpWaypointNode)childNode.getAs(RtcpWaypointNode.class)) && waypointNode.getWaypointType() == RtcpWaypointNode.WaypointType.Waypoint && depth == 1 || waypoint.equals(waypointNode) && waypointNode.getWaypointType() == RtcpWaypointNode.WaypointType.Toolpath && depth == 1 || waypoint.equals(waypointNode) && waypointNode.getWaypointType() == RtcpWaypointNode.WaypointType.RegularTcpToolpath && depth == 1 || waypoint.equals(waypointNode) && waypointNode.getWaypointType() == RtcpWaypointNode.WaypointType.Viapoint && depth == 2 || waypoint.equals(waypointNode) && waypointNode.getWaypointType() == RtcpWaypointNode.WaypointType.Endpoint && depth == 2)) {
                        RtcpMoveNodeContributionBase.this.setChildFound(true);
                    }
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        });
        return this.isChildFound();
    }

    @Override
    public boolean locateChild(final RtcpMoveNode moveNode) {
        this.setChildFound(false);
        this.programApi.getProgramModel().getRootTreeNode((ProgramNodeContribution)this).traverse(new ProgramNodeVisitor(){

            public void visit(URCapProgramNode childNode, int index, int depth) {
                try {
                    RtcpMoveNode move;
                    if (childNode.canGetAs(RtcpMoveNode.class) && moveNode.equals(move = (RtcpMoveNode)childNode.getAs(RtcpMoveNode.class))) {
                        RtcpMoveNodeContributionBase.this.setChildFound(true);
                    }
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        });
        return this.isChildFound();
    }

    @Override
    public boolean locateChild(final RtcpCircleMoveNode circleMoveNode) {
        this.setChildFound(false);
        this.programApi.getProgramModel().getRootTreeNode((ProgramNodeContribution)this).traverse(new ProgramNodeVisitor(){

            public void visit(URCapProgramNode childNode, int index, int depth) {
                try {
                    RtcpCircleMoveNode move;
                    if (childNode.canGetAs(RtcpCircleMoveNode.class) && circleMoveNode.equals(move = (RtcpCircleMoveNode)childNode.getAs(RtcpCircleMoveNode.class))) {
                        RtcpMoveNodeContributionBase.this.setChildFound(true);
                    }
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        });
        return this.isChildFound();
    }

    @Override
    public void setBlendRadius(final double blendRadius) {
        this.undoRedoManager.recordChanges(new UndoableChanges(){

            public void executeChanges() {
                RtcpMoveNodeContributionBase.this.model.remove("BLEND_RADIUS");
                RtcpMoveNodeContributionBase.this.model.set("BLEND_RADIUS", blendRadius);
            }
        });
    }

    @Override
    public void setToolSpeed(final double toolSpeed) {
        this.undoRedoManager.recordChanges(new UndoableChanges(){

            public void executeChanges() {
                RtcpMoveNodeContributionBase.this.model.remove("TOOL_SPEED");
                RtcpMoveNodeContributionBase.this.model.set("TOOL_SPEED", toolSpeed);
            }
        });
    }

    @Override
    public void setToolAcceleration(final double toolAcceleration) {
        this.undoRedoManager.recordChanges(new UndoableChanges(){

            public void executeChanges() {
                RtcpMoveNodeContributionBase.this.model.remove("TOOL_ACCELERATION");
                RtcpMoveNodeContributionBase.this.model.set("TOOL_ACCELERATION", toolAcceleration);
            }
        });
    }

    @Override
    public double getToolSpeed() {
        return this.model.get("TOOL_SPEED", 100.0);
    }

    @Override
    public double getToolAcceleration() {
        return this.model.get("TOOL_ACCELERATION", 1000.0);
    }

    @Override
    public double getBlendRadius() {
        return this.model.get("BLEND_RADIUS", 25.0);
    }

    @Override
    public String getSelectedRtcp() {
        String selectedRTCP = this.getSelectedRtcpInternal();
        if (this.isDefaultRtcp(selectedRTCP)) {
            return this.defaultRtcpItem;
        }
        return selectedRTCP;
    }

    public String getSelectedRtcpInternal() {
        return this.model.get("SELECTED_RTCP", "RTCP_MOVEP_DATAMODEL_SELECT_RTCP_DEFAULTVALUE");
    }

    protected boolean isDefaultRtcp(String rtcp) {
        return rtcp.equals("RTCP_MOVEP_DATAMODEL_SELECT_RTCP_DEFAULTVALUE") || rtcp.equals("Use active RTCP");
    }

    @Override
    public void setSelectedRtcp(final String rtcp) {
        this.undoRedoManager.recordChanges(new UndoableChanges(){

            public void executeChanges() {
                RtcpMoveNodeContributionBase.this.model.remove("SELECTED_RTCP");
                if (rtcp.equals(RtcpMoveNodeContributionBase.this.defaultRtcpItem)) {
                    RtcpMoveNodeContributionBase.this.model.set("SELECTED_RTCP", "RTCP_MOVEP_DATAMODEL_SELECT_RTCP_DEFAULTVALUE");
                } else {
                    RtcpMoveNodeContributionBase.this.model.set("SELECTED_RTCP", rtcp);
                }
            }
        });
    }

    @Override
    public void setSelectedEndEffector(final String ee) {
        this.undoRedoManager.recordChanges(new UndoableChanges(){

            public void executeChanges() {
                RtcpMoveNodeContributionBase.this.model.remove("SELECTED_ENDEFFECTOR");
                RtcpMoveNodeContributionBase.this.model.set("SELECTED_ENDEFFECTOR", ee);
            }
        });
    }

    @Override
    public Pose getSelectedRtcpPose() {
        String selectedRtcp = this.getSelectedRtcpInternal();
        RtcpNamedPose rtcp = this.isDefaultRtcp(selectedRtcp) ? this.getNamedPoseInfo().getNamedPoseById(this.getNamedPoseInfo().getDefaultNamedPose()) : this.getNamedPoseInfo().getNamedPoseById(selectedRtcp);
        return rtcp.getPose();
    }

    @Override
    public String getSelectedEndEffectorName() {
        int endEffector = this.model.get("SELECTED_ENDEFFECTOR", 2);
        return RtcpConstants.RTCP_MOVEP_ENDEFFECTORS.get(endEffector);
    }

    @Override
    public int getSelectedEndEffectorIndex() {
        return this.model.get("SELECTED_ENDEFFECTOR", 2);
    }

    @Override
    public boolean isDuplicateWaypointName(final RtcpWaypointNode waypoint, final String name) {
        this.setNameDuplicate(false);
        this.programApi.getProgramModel().getRootTreeNode((ProgramNodeContribution)this).traverse(new ProgramNodeVisitor(){

            public void visit(URCapProgramNode childNode, int index, int depth) {
                try {
                    RtcpWaypointNode childWaypoint;
                    if (childNode.canGetAs(RtcpWaypointNode.class) && !waypoint.equals(childWaypoint = (RtcpWaypointNode)childNode.getAs(RtcpWaypointNode.class)) && name.equals(childWaypoint.getWaypointName())) {
                        RtcpMoveNodeContributionBase.this.setNameDuplicate(true);
                    }
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        });
        return this.isNameDuplicate();
    }

    private boolean isNameDuplicate() {
        return this.nameDuplicate;
    }

    private void setNameDuplicate(boolean nameDuplicate) {
        this.nameDuplicate = nameDuplicate;
    }

    @Override
    public void insertWaypoint(final TreeNode existingChildNode) {
        ProgramModel programModel = this.programApi.getProgramModel();
        final ProgramNodeFactory programNodeFactory = programModel.getProgramNodeFactory();
        final TreeNode rootTreeNode = programModel.getRootTreeNode((ProgramNodeContribution)this);
        rootTreeNode.setChildSequenceLocked(false);
        this.addToInternalList();
        this.undoRedoManager.recordChanges(new UndoableChanges(){

            public void executeChanges() {
                try {
                    rootTreeNode.insertChildAfter(existingChildNode, (ProgramNode)programNodeFactory.createURCapProgramNode(RtcpWaypointProgramNodeService.class));
                }
                catch (TreeStructureException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public void insertCircleMove(final TreeNode existingChildNode) {
        ProgramModel programModel = this.programApi.getProgramModel();
        final ProgramNodeFactory programNodeFactory = programModel.getProgramNodeFactory();
        final TreeNode rootTreeNode = programModel.getRootTreeNode((ProgramNodeContribution)this);
        rootTreeNode.setChildSequenceLocked(false);
        this.addToInternalList();
        this.undoRedoManager.recordChanges(new UndoableChanges(){

            public void executeChanges() {
                try {
                    rootTreeNode.insertChildAfter(existingChildNode, (ProgramNode)programNodeFactory.createURCapProgramNode(RtcpCircleMoveProgramNodeService.class));
                }
                catch (TreeStructureException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public void insertToolpath(final TreeNode existingChildNode, final Class<? extends URCapProgramNodeService> service) {
        ProgramModel programModel = this.programApi.getProgramModel();
        final ProgramNodeFactory programNodeFactory = programModel.getProgramNodeFactory();
        final TreeNode rootTreeNode = programModel.getRootTreeNode((ProgramNodeContribution)this);
        rootTreeNode.setChildSequenceLocked(false);
        this.undoRedoManager.recordChanges(new UndoableChanges(){

            public void executeChanges() {
                try {
                    rootTreeNode.insertChildAfter(existingChildNode, (ProgramNode)programNodeFactory.createURCapProgramNode(service));
                }
                catch (TreeStructureException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public Vector<RtcpWaypointNode> getWaypoints(final RtcpWaypointNode.WaypointType wpType) {
        final Vector<RtcpWaypointNode> retList = new Vector<RtcpWaypointNode>();
        this.programApi.getProgramModel().getRootTreeNode((ProgramNodeContribution)this).traverse(new ProgramNodeVisitor(){

            public void visit(URCapProgramNode childNode, int index, int depth) {
                try {
                    RtcpWaypointNode wpNode;
                    if (childNode.canGetAs(RtcpWaypointNode.class) && (wpNode = (RtcpWaypointNode)childNode.getAs(RtcpWaypointNode.class)).getWaypointType() == wpType) {
                        retList.add(wpNode);
                    }
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        });
        return retList;
    }

    @Override
    public void updateSelectedRtcp(String oldName, final String newName) {
        if (this.getSelectedRtcp().equals(oldName)) {
            this.undoRedoManager.recordChanges(new UndoableChanges(){

                public void executeChanges() {
                    RtcpMoveNodeContributionBase.this.model.remove("SELECTED_RTCP");
                    RtcpMoveNodeContributionBase.this.model.set("SELECTED_RTCP", newName);
                }
            });
        }
    }

    @Override
    public void updateUsesVariableForRtcp(final RtcpMode mode) {
        this.undoRedoManager.recordChanges(new UndoableChanges(){

            public void executeChanges() {
                RtcpMoveNodeContributionBase.this.model.remove("RTCP_MOVEP_DATAMODEL_RTCPMODESELECTION");
                RtcpMoveNodeContributionBase.this.model.set("RTCP_MOVEP_DATAMODEL_RTCPMODESELECTION", mode.name());
            }
        });
    }

    @Override
    public RtcpMode getRtcpModeSelection() {
        String val = this.model.get("RTCP_MOVEP_DATAMODEL_RTCPMODESELECTION", RtcpMode.FIXED.name());
        return RtcpMode.valueOf(val);
    }

    @Override
    public void updateVariableNameForRtcp(final String variableName) {
        this.undoRedoManager.recordChanges(new UndoableChanges(){

            public void executeChanges() {
                RtcpMoveNodeContributionBase.this.model.remove("VARNAME_RTCP");
                if (variableName.equals(RtcpMoveNodeContributionBase.this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_MOVEP_VARIABLE_DEFAULT))) {
                    RtcpMoveNodeContributionBase.this.model.set("VARNAME_RTCP", "RTCP_MOVEP_DATAMODEL_VARIABLE_DEFAULT_VALUE");
                } else {
                    RtcpMoveNodeContributionBase.this.model.set("VARNAME_RTCP", variableName);
                }
            }
        });
    }

    @Override
    public String getVariableNameForRtcp() {
        String varName = this.getVariableNameForRtcpInternal();
        if (varName.equals("RTCP_MOVEP_DATAMODEL_VARIABLE_DEFAULT_VALUE")) {
            return this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_MOVEP_VARIABLE_DEFAULT);
        }
        return varName;
    }

    protected String getVariableNameForRtcpInternal() {
        return this.model.get("VARNAME_RTCP", "RTCP_MOVEP_DATAMODEL_VARIABLE_DEFAULT_VALUE");
    }

    @Override
    public String[] getVariables() {
        Collection collectionVariables = this.apiProvider.getProgramAPI().getVariableModel().getAll();
        String[] variables = new String[collectionVariables.size()];
        int index = 0;
        for (Variable var : collectionVariables) {
            if (var.getType() == Variable.Type.FEATURE) continue;
            variables[index++] = var.getDisplayName();
        }
        return variables;
    }

    @Override
    public LocalizationInfo getLocalizationInfo() {
        return this.getInstallation();
    }

    @Override
    public void setInTheInternalList(boolean isInTheList) {
        this.isInTheInternalList = isInTheList;
    }

    @Override
    public void updateSelectedPcs(final String oldName, final String newName) {
        this.programApi.getProgramModel().getRootTreeNode((ProgramNodeContribution)this).traverse(new ProgramNodeVisitor(){

            public void visit(URCapProgramNode childNode, int index, int depth) {
                try {
                    RtcpWaypointNode waypointNode;
                    if (childNode.canGetAs(RtcpWaypointNode.class) && (waypointNode = (RtcpWaypointNode)childNode.getAs(RtcpWaypointNode.class)).getWaypointType() == RtcpWaypointNode.WaypointType.Toolpath) {
                        RtcpToolpathNode toolpathNode = (RtcpToolpathNode)childNode.getAs(RtcpToolpathNode.class);
                        toolpathNode.renameSelectedPcs(oldName, newName);
                    }
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        });
    }

    @Override
    public void appendCircleMove() {
        ProgramModel programModel = this.programApi.getProgramModel();
        final ProgramNodeFactory programNodeFactory = programModel.getProgramNodeFactory();
        final TreeNode rootTreeNode = programModel.getRootTreeNode((ProgramNodeContribution)this);
        rootTreeNode.setChildSequenceLocked(false);
        this.addToInternalList();
        final int waypointCount = this.getWaypointCount()[0];
        this.undoRedoManager.recordChanges(new UndoableChanges(){

            public void executeChanges() {
                try {
                    if (waypointCount == 0) {
                        RtcpMoveNodeContributionBase.this.appendWaypoint();
                    }
                    rootTreeNode.addChild((ProgramNode)programNodeFactory.createURCapProgramNode(RtcpCircleMoveProgramNodeService.class));
                }
                catch (TreeStructureException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    protected int[] getWaypointCount() {
        int[] waypointCount = new int[]{0, 0};
        return waypointCount;
    }

    @Override
    public void appendToolpath(final Class<? extends URCapProgramNodeService> service) {
        ProgramModel programModel = this.programApi.getProgramModel();
        final ProgramNodeFactory programNodeFactory = programModel.getProgramNodeFactory();
        final TreeNode rootTreeNode = programModel.getRootTreeNode((ProgramNodeContribution)this);
        rootTreeNode.setChildSequenceLocked(false);
        this.undoRedoManager.recordChanges(new UndoableChanges(){

            public void executeChanges() {
                try {
                    rootTreeNode.addChild((ProgramNode)programNodeFactory.createURCapProgramNode(service));
                }
                catch (TreeStructureException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public void appendWaypoint() {
        ProgramModel programModel = this.programApi.getProgramModel();
        final ProgramNodeFactory programNodeFactory = programModel.getProgramNodeFactory();
        final TreeNode rootTreeNode = programModel.getRootTreeNode((ProgramNodeContribution)this);
        rootTreeNode.setChildSequenceLocked(false);
        this.addToInternalList();
        this.undoRedoManager.recordChanges(new UndoableChanges(){

            public void executeChanges() {
                try {
                    rootTreeNode.addChild((ProgramNode)programNodeFactory.createURCapProgramNode(RtcpWaypointProgramNodeService.class));
                }
                catch (TreeStructureException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public String getErrorMessage() {
        if (this.getDaemonControl().getDaemonDesiredState() == DaemonContribution.State.STOPPED) {
            return this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_MOVEP_ERROR_DAEMONSTOPPED);
        }
        return "";
    }

    @Override
    public RtcpNamedPoseInfo getNamedPoseInfo() {
        return this.getInstallation().getRtcpHandler();
    }

    @Override
    public boolean isSelectedRtcpValid() {
        if (this.getRtcpModeSelection() == RtcpMode.VARIABLE) {
            String selectedVariable = this.getVariableNameForRtcpInternal();
            if (selectedVariable.equals("RTCP_MOVEP_DATAMODEL_VARIABLE_DEFAULT_VALUE")) {
                return false;
            }
            return Arrays.asList(this.getVariables()).contains(selectedVariable);
        }
        String selectedRtcp = this.getSelectedRtcpInternal();
        if (!this.isDefaultRtcp(selectedRtcp)) {
            return Arrays.asList(this.getNamedPoseInfo().getAvailablePoses()).contains(selectedRtcp);
        }
        return true;
    }

    public boolean isChildFound() {
        return this.childFound;
    }

    public void setChildFound(boolean childFound) {
        this.childFound = childFound;
    }

    public Object[] hasIllegalChildren() {
        final Object[] illegalNodes = new Object[]{"", 0};
        final int[] waypointCount = new int[]{0};
        this.programApi.getProgramModel().getRootTreeNode((ProgramNodeContribution)this).traverse(new ProgramNodeVisitor(){

            public void visit(MoveNode childNode, int index, int depth) {
                illegalNodes[0] = childNode.toString();
            }

            public void visit(WaypointNode childNode, int index, int depth) {
                illegalNodes[0] = childNode.toString();
            }

            public void visit(WaitNode childNode, int index, int depth) {
                illegalNodes[0] = childNode.toString();
            }

            public void visit(URCapProgramNode programNode, int index, int depth) {
                if (depth == 1 && programNode.canGetAs(RtcpWaypointNode.class)) {
                    waypointCount[0] = waypointCount[0] + 1;
                }
                if (depth == 1 && waypointCount[0] == 0 && programNode.canGetAs(RtcpCircleMoveNode.class)) {
                    illegalNodes[0] = programNode.toString();
                }
            }
        });
        illegalNodes[1] = waypointCount[0];
        return illegalNodes;
    }

    @Override
    public void updateIsFreeSpinZ(final boolean isFreeSpinZ) {
        this.undoRedoManager.recordChanges(new UndoableChanges(){

            public void executeChanges() {
                RtcpMoveNodeContributionBase.this.model.remove("RTCP_COMMON_DATAMODEL_FREESPINZ");
                RtcpMoveNodeContributionBase.this.model.set("RTCP_COMMON_DATAMODEL_FREESPINZ", isFreeSpinZ);
            }
        });
    }

    @Override
    public boolean isFreeSpinZ() {
        return this.model.get("RTCP_COMMON_DATAMODEL_FREESPINZ", false);
    }

    protected int getDoc() {
        return this.isFreeSpinZ() ? 5 : 6;
    }

    public static enum RtcpMode {
        FIXED,
        VARIABLE;

    }
}

