/*
 * Decompiled with CFR 0.152.
 */
package com.energid.urcap.remotetcp.impl.Common;

import com.energid.urcap.remotetcp.impl.Common.RtcpComboRenderer;
import com.energid.urcap.remotetcp.impl.Common.RtcpConstants;
import com.energid.urcap.remotetcp.impl.Common.RtcpMoveNodeContributionBase;
import com.energid.urcap.remotetcp.impl.Common.RtcpUtils;
import com.energid.urcap.remotetcp.impl.Common.RtcpViewHelperBase;
import com.energid.urcap.remotetcp.impl.Common.Style;
import com.energid.urcap.remotetcp.impl.Interfaces.LocalizationInfo;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpMoveNode;
import com.ur.urcap.api.contribution.URCapProgramNodeService;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardInputCallback;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class RtcpMoveViewHelperBase
extends RtcpViewHelperBase {
    protected RtcpMoveNode contribution;
    protected JLabel labelRtcp;
    protected JLabel labelVariable;
    protected JLabel desc1;
    protected JLabel desc2;
    protected JButton waypointButton;
    protected JButton circleMoveButton;
    protected JButton toolpathButton;
    protected Class<? extends URCapProgramNodeService> toolpathService;
    protected JButton resetButton;
    protected JComboBox selectRtcpCombo;
    protected JComboBox selectModeCombo;
    protected JComboBox selectVariableCombo;
    protected RtcpComboRenderer renderer;
    protected RtcpComboRenderer variableSelectionRenderer;
    protected JComboBox selectEndEffectorCombo;
    protected JTextField fieldToolSpeed;
    protected JTextField fieldToolAcceleration;
    protected JTextField fieldBlendRadius;
    protected JLabel labelToolSpeed;
    protected JLabel labelToolAcceleration;
    protected JLabel labelBlendRadius;
    protected JLabel labelToolSpeedUnit;
    protected JLabel labelToolAccelerationUnit;
    protected JLabel labelBlendRadiusUnit;
    protected JCheckBox freeSpinZCheckbox;
    protected final DecimalFormat format_2 = new DecimalFormat("#0.##");
    protected final DecimalFormat format_1 = new DecimalFormat("#0.#");
    protected boolean rtcpComboListens = true;
    protected boolean modeComboListens = true;
    protected boolean variableComboListens = true;
    protected JLabel messageLabel;
    protected boolean isUsingBlendRadius = true;
    protected Box boxModeContent;
    protected Box boxFixedRtcpArea;
    protected Box boxVariableRtcpArea;

    public RtcpMoveViewHelperBase(JPanel container, Style style) {
        this.style = style;
        this.container = container;
        this.formatters = new DecimalFormat[]{this.format_1, this.format_1, this.format_2};
        this.borderThickness = 0;
        this.defaultBorder = BorderFactory.createLineBorder(Color.BLACK, this.borderThickness);
        this.editFieldAlignmentY = 0.5f;
    }

    protected void setDefaultMotionValues() {
        this.updateRtcpList();
        this.updateVariableList();
        this.updateView();
    }

    public void buildMainPanel() {
        this.container.setLayout(new BoxLayout(this.container, 1));
        this.container.add(this.buildTextSection());
        this.container.add(this.createVerticalSpacing(25));
        JPanel lowerSection = new JPanel();
        lowerSection.setLayout(new BorderLayout());
        lowerSection.setAlignmentX(0.0f);
        lowerSection.setBorder(this.defaultBorder);
        lowerSection.add(this.buildRtcpSelectionArea(), "West");
        lowerSection.add(this.buildMoveParametersArea(), "East");
        this.container.add(lowerSection);
        Box messagesSection = Box.createHorizontalBox();
        messagesSection.setAlignmentX(0.0f);
        messagesSection.setBorder(this.defaultBorder);
        messagesSection.add(this.createsMessageArea());
        this.container.add(messagesSection);
    }

    private Component buildTextSection() {
        Box main = Box.createHorizontalBox();
        main.setAlignmentX(0.0f);
        main.setBorder(this.defaultBorder);
        Box box = Box.createVerticalBox();
        box.setAlignmentX(0.0f);
        box.setBorder(this.defaultBorder);
        this.desc1 = new JLabel();
        this.desc1.setHorizontalAlignment(2);
        this.desc1.setAlignmentX(0.0f);
        box.add(this.desc1);
        box.add(Box.createHorizontalGlue());
        box.add(this.createVerticalSpacing(20));
        this.desc2 = new JLabel();
        this.desc2.setHorizontalAlignment(2);
        this.desc2.setAlignmentX(0.0f);
        box.add(this.desc2);
        main.add(box);
        Box modeBox = this.makeModeArea();
        main.add(modeBox);
        return main;
    }

    protected Component buildRtcpSelectionArea() {
        this.freeSpinZCheckbox = new JCheckBox();
        this.labelRtcp = new JLabel();
        this.labelVariable = new JLabel();
        this.selectRtcpCombo = new JComboBox();
        this.selectVariableCombo = new JComboBox();
        this.waypointButton = new JButton();
        this.circleMoveButton = new JButton();
        this.toolpathButton = new JButton();
        this.boxModeContent = Box.createHorizontalBox();
        return null;
    }

    private Component buildMoveParametersArea() {
        Box box = Box.createVerticalBox();
        box.setAlignmentY(0.0f);
        box.setBorder(this.defaultBorder);
        this.fieldToolSpeed = this.createValueTextField(0);
        this.fieldToolSpeed.setName(this.controlNameBase + "_ToolSpeed");
        this.labelToolSpeed = new JLabel();
        this.labelToolSpeedUnit = new JLabel();
        box.add(this.createVerticalValueEditBlock(this.fieldToolSpeed, this.labelToolSpeed, this.labelToolSpeedUnit));
        box.add(this.createVerticalSpacing(20));
        this.fieldToolAcceleration = this.createValueTextField(1);
        this.fieldToolAcceleration.setName(this.controlNameBase + "_ToolAcceleration");
        this.labelToolAcceleration = new JLabel();
        this.labelToolAccelerationUnit = new JLabel();
        box.add(this.createVerticalValueEditBlock(this.fieldToolAcceleration, this.labelToolAcceleration, this.labelToolAccelerationUnit));
        box.add(this.createVerticalSpacing(20));
        this.fieldBlendRadius = this.createValueTextField(2);
        this.fieldBlendRadius.setName(this.controlNameBase + "_BlendRadius");
        this.labelBlendRadius = new JLabel();
        this.labelBlendRadiusUnit = new JLabel();
        Component blendRadiusArea = this.createVerticalValueEditBlock(this.fieldBlendRadius, this.labelBlendRadius, this.labelBlendRadiusUnit);
        if (this.isUsingBlendRadius) {
            box.add(blendRadiusArea);
            box.add(this.createVerticalSpacing(20));
        }
        this.resetButton = new JButton();
        this.resetButton.setName(this.controlNameBase + "_Reset");
        this.resetButton.setAlignmentX(0.0f);
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RtcpMoveViewHelperBase.this.contribution.setToolSpeed(100.0);
                RtcpMoveViewHelperBase.this.contribution.setToolAcceleration(1000.0);
                RtcpMoveViewHelperBase.this.contribution.setBlendRadius(25.0);
                RtcpMoveViewHelperBase.this.setDefaultMotionValues();
            }
        });
        box.add(this.resetButton);
        return box;
    }

    private Component createsMessageArea() {
        Box box = Box.createVerticalBox();
        box.setAlignmentY(0.0f);
        box.setBorder(this.defaultBorder);
        this.messageLabel = new JLabel();
        this.messageLabel.setName(this.controlNameBase + "_MessageLabel");
        this.messageLabel.setIcon(RtcpMoveViewHelperBase.getIconResource("warning_icon_small.png"));
        box.add(this.createVerticalSpacing(50));
        box.add(this.messageLabel);
        return box;
    }

    @Override
    protected KeyboardInputCallback<Double> getKeyboardCallbackForValue(final JTextField field, final int valueIndex) {
        return new KeyboardInputCallback<Double>(){

            public void onOk(Double value) {
                field.setText(RtcpMoveViewHelperBase.this.formatters[valueIndex].format(value));
                double metricVal = RtcpMoveViewHelperBase.this.contribution.getLocalizationInfo().getConvertedLengthForStorage(value);
                RtcpMoveViewHelperBase.this.updateMotionValue(valueIndex, metricVal);
            }
        };
    }

    protected void updateMotionValue(int motionValueIndex, double motionValue) {
        switch (motionValueIndex) {
            case 0: {
                this.contribution.setToolSpeed(motionValue);
                break;
            }
            case 1: {
                this.contribution.setToolAcceleration(motionValue);
                break;
            }
            case 2: {
                this.contribution.setBlendRadius(motionValue);
                break;
            }
        }
    }

    public String getSelectedRtcp() {
        Object item = this.selectRtcpCombo.getModel().getSelectedItem();
        if (item != null) {
            return item.toString();
        }
        return "";
    }

    public String getSelectedEndEffector() {
        Object item = this.selectEndEffectorCombo.getModel().getSelectedItem();
        if (item != null) {
            return item.toString();
        }
        return "";
    }

    public void updateRtcpList() {
        Border border;
        String[] listRtcps = this.contribution.getNamedPoseInfo().getAvailablePoses();
        this.rtcpComboListens = false;
        this.selectRtcpCombo.removeAllItems();
        this.renderer.setMissingItem("");
        String selectedRtcp = this.contribution.getSelectedRtcp();
        String defaultRtcp = this.contribution.getDefaultRtcpItem();
        if (!selectedRtcp.equals(defaultRtcp) && !this.contribution.isSelectedRtcpValid()) {
            this.renderer.setMissingItem(selectedRtcp);
            this.selectRtcpCombo.addItem(selectedRtcp);
            border = BorderFactory.createLineBorder(this.style.getGoldYellow2(), 2);
        } else {
            border = BorderFactory.createLineBorder(this.style.getBorderColor(), 1);
        }
        this.selectRtcpCombo.addItem(this.contribution.getDefaultRtcpItem());
        for (String rtcp : listRtcps) {
            this.selectRtcpCombo.addItem(rtcp);
        }
        this.selectRtcpCombo.getModel().setSelectedItem(this.contribution.getSelectedRtcp());
        this.selectRtcpCombo.setBorder(border);
        this.rtcpComboListens = true;
    }

    public void updateVariableList() {
        Border border;
        this.variableComboListens = false;
        String[] variables = this.contribution.getVariables();
        String selectedVariable = this.contribution.getVariableNameForRtcp();
        String defaultVariable = this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_MOVEP_VARIABLE_DEFAULT);
        this.selectVariableCombo.removeAllItems();
        this.variableSelectionRenderer.setMissingItem("");
        if (selectedVariable.equals(defaultVariable) || !selectedVariable.equals(defaultVariable) && !Arrays.asList(variables).contains(selectedVariable)) {
            this.variableSelectionRenderer.setMissingItem(selectedVariable);
            this.selectVariableCombo.addItem(selectedVariable);
            border = BorderFactory.createLineBorder(this.style.getGoldYellow2(), 2);
        } else {
            border = BorderFactory.createLineBorder(this.style.getBorderColor(), 1);
        }
        for (String item : variables) {
            this.selectVariableCombo.addItem(item);
        }
        if (selectedVariable != null && !selectedVariable.isEmpty()) {
            this.selectVariableCombo.getModel().setSelectedItem(selectedVariable);
        }
        this.selectVariableCombo.setBorder(border);
        this.variableComboListens = true;
    }

    public void updateView() {
        this.updateText();
        boolean isVariableMode = this.contribution.getRtcpModeSelection() == RtcpMoveNodeContributionBase.RtcpMode.VARIABLE;
        this.updateModeList(isVariableMode);
        if (isVariableMode) {
            this.updateVariableList();
            this.boxModeContent.add(this.boxVariableRtcpArea);
        } else {
            this.updateRtcpList();
            this.boxModeContent.add(this.boxFixedRtcpArea);
        }
        LocalizationInfo local = this.contribution.getLocalizationInfo();
        this.fieldToolSpeed.setText(this.formatters[0].format(local.getConvertedLengthForDisplay(this.contribution.getToolSpeed())));
        this.fieldToolAcceleration.setText(this.formatters[1].format(local.getConvertedLengthForDisplay(this.contribution.getToolAcceleration())));
        this.fieldBlendRadius.setText(this.formatters[2].format(local.getConvertedLengthForDisplay(this.contribution.getBlendRadius())));
        this.freeSpinZCheckbox.setSelected(this.contribution.isFreeSpinZ());
        this.showValidationWarning();
        this.container.invalidate();
        this.container.validate();
        this.container.repaint();
    }

    protected void updateText() {
        this.labelRtcp.setText(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_MOVEP_SET_RTCP));
        this.desc1.setText(RtcpUtils.encloseWithHtml(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_MOVEP_DESCRIPTION)));
        this.desc2.setText(RtcpUtils.encloseWithHtml(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_MOVEP_INFORMATION)));
        this.waypointButton.setText(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_WAYPOINT));
        this.circleMoveButton.setText(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_CIRCLEMOVE));
        this.toolpathButton.setText(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_TOOLPATH));
        this.resetButton.setText(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_RESET));
        this.labelToolSpeed.setText(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_TOOLSPEED));
        this.labelToolAcceleration.setText(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_TOOLACCELERATION));
        this.labelBlendRadius.setText(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_BLENDRADIUS));
        this.labelToolSpeedUnit.setText(this.contribution.getLocalizationInfo().getLocalizedSpeedUnit());
        this.labelToolAccelerationUnit.setText(RtcpUtils.encloseWithHtml(this.contribution.getLocalizationInfo().getLocalizedAccelerationUnit()));
        this.labelBlendRadiusUnit.setText(this.contribution.getLocalizationInfo().getLocalizedLengthUnit());
        this.freeSpinZCheckbox.setText(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_MOVEP_FREESPINZ));
    }

    private void showValidationWarning() {
        String message = this.contribution.getErrorMessage();
        this.messageLabel.setVisible(false);
        if (!message.isEmpty()) {
            this.messageLabel.setText(RtcpUtils.encloseWithHtml(message));
            this.messageLabel.setVisible(true);
        }
    }

    public void setContribution(RtcpMoveNode contribution) {
        this.contribution = contribution;
    }

    protected void updateModeList(boolean isVariableMode) {
    }

    protected Box makeModeArea() {
        Box main = Box.createHorizontalBox();
        return main;
    }
}

