/*
 * Decompiled with CFR 0.152.
 */
package com.energid.urcap.remotetcp.impl.Common;

import com.energid.urcap.remotetcp.impl.Common.RtcpNamedPose;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpNamedPoseInfo;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.PoseFactory;
import com.ur.urcap.api.domain.value.simple.Angle;
import com.ur.urcap.api.domain.value.simple.Length;
import java.util.HashMap;
import java.util.LinkedHashMap;

public class RtcpNamedPoseCollectionHandler
implements RtcpNamedPoseInfo {
    protected String defaultNamedPose = "";
    protected final LinkedHashMap<String, RtcpNamedPose> namedPoseCollection = new LinkedHashMap();
    protected final DataModel dataModel;
    private String poseNamePrefix;
    private final PoseFactory poseFactory;

    public RtcpNamedPoseCollectionHandler(DataModel dataModel, String poseNamePrefix, PoseFactory poseFactory) {
        this.dataModel = dataModel;
        this.poseNamePrefix = poseNamePrefix;
        this.poseFactory = poseFactory;
    }

    @Override
    public void initialize() {
        RtcpNamedPose pose = this.addNewNamedPoseToDatastore(this.poseNamePrefix);
        this.defaultNamedPose = pose.getName();
        this.updateDataModel();
    }

    @Override
    public String[] getAvailablePoses() {
        String[] poses = this.namedPoseCollection.keySet().toArray(new String[0]);
        return poses;
    }

    @Override
    public RtcpNamedPose getNamedPoseById(String id) {
        return this.namedPoseCollection.get(id);
    }

    @Override
    public String getDefaultNamedPose() {
        return this.defaultNamedPose;
    }

    @Override
    public boolean setDefaultNamedPose(String name) {
        if (this.namedPoseCollection.containsKey(name)) {
            this.defaultNamedPose = name;
            this.updateDataModelDefaultNamedPose();
            return true;
        }
        return false;
    }

    @Override
    public void updateDataModel() {
    }

    @Override
    public String createNewNamedPose() {
        String newName = this.makeNewPoseName();
        this.addNewNamedPoseToDatastore(newName);
        this.updateDataModel();
        return newName;
    }

    @Override
    public boolean deleteNamedPose(String name) {
        if (this.namedPoseCollection.containsKey(name)) {
            this.namedPoseCollection.remove(name);
            this.updateDataModel();
            return true;
        }
        return false;
    }

    @Override
    public boolean isNameDuplicate(String name) {
        return this.namedPoseCollection.containsKey(name);
    }

    @Override
    public void updatePoseName(String oldName, String newName) {
    }

    @Override
    public RtcpNamedPose addNamedPose(String name, Pose pose) {
        RtcpNamedPose namedPose = new RtcpNamedPose(name, pose);
        this.namedPoseCollection.put(name, namedPose);
        return namedPose;
    }

    protected void updateDataModelDefaultNamedPose() {
    }

    protected double[] createPoseArray(HashMap<String, RtcpNamedPose> namedPoses) {
        int poseCount = namedPoses.size();
        double[] poses = new double[poseCount * 6];
        int index = 0;
        for (RtcpNamedPose pose : namedPoses.values()) {
            double[] positions;
            for (double val : positions = pose.getPose().toArray(Length.Unit.MM, Angle.Unit.RAD)) {
                poses[index++] = val;
            }
        }
        return poses;
    }

    private String makeNewPoseName() {
        int index = 0;
        while (true) {
            String newName;
            String string = newName = index == 0 ? this.poseNamePrefix : this.poseNamePrefix + "_" + index;
            if (!this.namedPoseCollection.containsKey(newName)) {
                return newName;
            }
            ++index;
        }
    }

    private RtcpNamedPose addNewNamedPoseToDatastore(String name) {
        Pose pose = this.poseFactory.createPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Length.Unit.MM, Angle.Unit.RAD);
        return this.addNamedPose(name, pose);
    }
}

