/*
 * Decompiled with CFR 0.152.
 */
package com.energid.urcap.remotetcp.impl.Common;

import com.energid.urcap.remotetcp.impl.Common.RtcpConstants;
import com.energid.urcap.remotetcp.impl.Common.RtcpNamedPose;
import com.energid.urcap.remotetcp.impl.Common.RtcpUtils;
import com.energid.urcap.remotetcp.impl.Common.Style;
import com.energid.urcap.remotetcp.impl.InstallationNode.RtcpInstallationViewHelperBase;
import com.energid.urcap.remotetcp.impl.Interfaces.LocalizationInfo;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpNamedPoseInfo;
import com.ur.urcap.api.domain.userinteraction.inputvalidation.InputValidator;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardInputCallback;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardInputFactory;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardTextInput;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;

public class RtcpNamedPoseManagerPanel
extends RtcpInstallationViewHelperBase {
    private KeyboardInputFactory keyboardFactory;
    private JButton nameEditButton = null;
    private JComboBox namedPoseSelectionCombo = null;
    private JButton defaultNamedPoseButton = null;
    private JButton addNamedPoseButton = null;
    private JButton deleteNamePoseButton = null;
    private Icon defaultSelectedNamedPoseIcon = null;
    private Icon defaultNamedPoseIcon = null;
    private RtcpNamedPoseInfo namedPoseInfo;
    private NamedPoseChangeHandler changeHandler;
    private RtcpNamedPose currentNamedPose;
    private boolean comboListens = true;
    private String controlNameBase;
    private boolean isEnabled = true;

    public RtcpNamedPoseManagerPanel(RtcpNamedPoseInfo namedPoseInfo, LocalizationInfo localization, Style style, String controlNameBase, NamedPoseChangeHandler changeHandler) {
        super(localization, style);
        this.namedPoseInfo = namedPoseInfo;
        this.controlNameBase = controlNameBase;
        this.changeHandler = changeHandler;
        this.defaultSelectedNamedPoseIcon = this.getIconResource("default_icon_selected.png");
        this.defaultNamedPoseIcon = this.getIconResource("default_icon.png");
    }

    public Component buildNamedPoseSelectionSection() {
        JComboBox<Object> namedPoseCombo;
        Box namedPoseSelection = Box.createHorizontalBox();
        namedPoseSelection.setAlignmentX(0.0f);
        this.nameEditButton = new JButton();
        this.nameEditButton.setIcon(this.getIconResource("edit_icon.png"));
        this.nameEditButton.setName(this.controlNameBase + "_EditName");
        this.nameEditButton.setAlignmentX(0.0f);
        this.nameEditButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RtcpNamedPoseManagerPanel.this.RtcpNameEditHandler();
            }
        });
        this.nameEditButton.setMaximumSize(this.style.getSelectionButtonSize());
        this.nameEditButton.setPreferredSize(this.style.getSelectionButtonSize());
        namedPoseSelection.add(this.nameEditButton);
        namedPoseSelection.add(this.createHorizontalSpacing(10));
        this.namedPoseSelectionCombo = namedPoseCombo = new JComboBox<Object>();
        namedPoseCombo.setName(this.controlNameBase + "_Selection");
        namedPoseCombo.setAlignmentX(1.0f);
        namedPoseCombo.setMaximumSize(this.style.getSelectionComboboxSize());
        namedPoseCombo.setPreferredSize(this.style.getSelectionComboboxSize());
        RtcpInstallationComboRenderer renderer = new RtcpInstallationComboRenderer();
        renderer.setDefaultNamedPoseIcon(this.approveIcon);
        namedPoseCombo.setRenderer(renderer);
        namedPoseCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!RtcpNamedPoseManagerPanel.this.comboListens) {
                    return;
                }
                RtcpNamedPoseManagerPanel.this.setSelectedNamedPose(namedPoseCombo.getSelectedItem().toString());
            }
        });
        namedPoseSelection.add(namedPoseCombo);
        namedPoseSelection.add(Box.createHorizontalGlue());
        this.defaultNamedPoseButton = new JButton();
        this.defaultNamedPoseButton.setName("Rtcp_Set_Default");
        this.defaultNamedPoseButton.setMaximumSize(this.style.getSelectionButtonSize());
        this.defaultNamedPoseButton.setPreferredSize(this.style.getSelectionButtonSize());
        this.defaultNamedPoseButton.setIcon(this.defaultSelectedNamedPoseIcon);
        this.defaultNamedPoseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RtcpNamedPoseManagerPanel.this.setDefaultNamedPose(namedPoseCombo.getSelectedItem().toString(), namedPoseCombo);
            }
        });
        namedPoseSelection.add(this.defaultNamedPoseButton);
        namedPoseSelection.add(this.createHorizontalSpacing());
        this.addNamedPoseButton = new JButton();
        this.addNamedPoseButton.setIcon(this.getIconResource("plus_icon.png"));
        this.addNamedPoseButton.setName(this.controlNameBase + "_Add");
        this.addNamedPoseButton.setMaximumSize(this.style.getSelectionButtonSize());
        this.addNamedPoseButton.setPreferredSize(this.style.getSelectionButtonSize());
        this.addNamedPoseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RtcpNamedPoseManagerPanel.this.addNamedPose(namedPoseCombo);
            }
        });
        namedPoseSelection.add(this.addNamedPoseButton);
        namedPoseSelection.add(this.createHorizontalSpacing());
        this.deleteNamePoseButton = new JButton();
        this.deleteNamePoseButton.setIcon(this.getIconResource("delete.png"));
        this.deleteNamePoseButton.setName(this.controlNameBase + "_Delete");
        this.deleteNamePoseButton.setMaximumSize(this.style.getSelectionButtonSize());
        this.deleteNamePoseButton.setPreferredSize(this.style.getSelectionButtonSize());
        this.deleteNamePoseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RtcpNamedPoseManagerPanel.this.deleteNamedPose(namedPoseCombo.getSelectedItem().toString(), namedPoseCombo);
            }
        });
        namedPoseSelection.add(this.deleteNamePoseButton);
        return namedPoseSelection;
    }

    protected void setSelectedNamedPose(String name) {
        this.currentNamedPose = this.namedPoseInfo.getNamedPoseById(name);
        this.changeHandler.currentNamedPoseChanged(this.currentNamedPose);
        this.updateSelectionButtonStates();
    }

    protected void setDefaultNamedPose(String name, JComboBox tcpCombo) {
        if (!this.namedPoseInfo.setDefaultNamedPose(name)) {
            return;
        }
        this.updateSelectionButtonStates();
    }

    protected void deleteNamedPose(String name, JComboBox tcpCombo) {
        this.namedPoseInfo.deleteNamedPose(name);
        tcpCombo.removeItem(name);
        this.currentNamedPose = this.namedPoseInfo.getNamedPoseById(tcpCombo.getSelectedItem().toString());
        this.changeHandler.currentNamedPoseChanged(this.currentNamedPose);
        if (this.namedPoseInfo.getDefaultNamedPose().equals(name)) {
            this.namedPoseInfo.setDefaultNamedPose(this.currentNamedPose.getName());
        }
        this.updateSelectionButtonStates();
    }

    private void addNamedPose(JComboBox namedPoseCombo) {
        String newName = this.namedPoseInfo.createNewNamedPose();
        namedPoseCombo.addItem(newName);
        namedPoseCombo.setSelectedItem(newName);
        this.currentNamedPose = this.namedPoseInfo.getNamedPoseById(newName);
        this.changeHandler.currentNamedPoseChanged(this.currentNamedPose);
        this.updateSelectionButtonStates();
    }

    private void updateSelectionButtonStates() {
        if (!this.isEnabled) {
            return;
        }
        this.namedPoseSelectionCombo.repaint();
        if (this.namedPoseSelectionCombo.getSelectedItem().toString().equals(this.namedPoseInfo.getDefaultNamedPose())) {
            this.defaultNamedPoseButton.setIcon(this.defaultSelectedNamedPoseIcon);
        } else {
            this.defaultNamedPoseButton.setIcon(this.defaultNamedPoseIcon);
        }
        this.addNamedPoseButton.setEnabled(true);
        this.deleteNamePoseButton.setEnabled(this.namedPoseSelectionCombo.getItemCount() > 1);
    }

    protected void RtcpNameEditHandler() {
        KeyboardTextInput keyboardInput = this.keyboardFactory.createStringKeyboardInput();
        final String initialValue = this.namedPoseSelectionCombo.getSelectedItem().toString();
        keyboardInput.setInitialValue(initialValue);
        keyboardInput.setErrorValidator((InputValidator)new InputValidator<String>(){
            private String message = "";

            public boolean isValid(String value) {
                String modifiedName = RtcpUtils.modifyName(value);
                RtcpConstants.Strings messageEnum = RtcpUtils.validateName(modifiedName);
                if (!messageEnum.equals((Object)RtcpConstants.Strings.RTCP_VALIDATION_NAMEISVALID)) {
                    this.message = messageEnum.equals((Object)RtcpConstants.Strings.RTCP_VALIDATION_ERROR_DEFAULT) ? "" : RtcpNamedPoseManagerPanel.this.localization.getLocalizedText(messageEnum);
                    return false;
                }
                if (!value.equals(initialValue) && RtcpNamedPoseManagerPanel.this.namedPoseInfo.isNameDuplicate(modifiedName)) {
                    this.message = RtcpNamedPoseManagerPanel.this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_DUPLICATENAME_MESSAGE);
                    return false;
                }
                return true;
            }

            public String getMessage(String value) {
                return this.message;
            }
        });
        keyboardInput.show(this.nameEditButton, this.getKeyboardCallbackForRtcpName(initialValue));
    }

    private KeyboardInputCallback<String> getKeyboardCallbackForRtcpName(final String oldName) {
        return new KeyboardInputCallback<String>(){

            public void onOk(String value) {
                String modifiedName = RtcpUtils.modifyName(value);
                RtcpNamedPoseManagerPanel.this.namedPoseInfo.updatePoseName(oldName, modifiedName);
                int selectedIndex = RtcpNamedPoseManagerPanel.this.namedPoseSelectionCombo.getSelectedIndex();
                RtcpNamedPoseManagerPanel.this.namedPoseSelectionCombo.setModel(new DefaultComboBoxModel<String>(RtcpNamedPoseManagerPanel.this.namedPoseInfo.getAvailablePoses()));
                RtcpNamedPoseManagerPanel.this.namedPoseSelectionCombo.setSelectedIndex(selectedIndex);
                RtcpNamedPoseManagerPanel.this.namedPoseSelectionCombo.repaint();
            }
        };
    }

    public void setKeyboardFactory(KeyboardInputFactory keyboardFactory) {
        this.keyboardFactory = keyboardFactory;
    }

    public void updateView() {
        this.comboListens = false;
        String[] availablePoses = this.namedPoseInfo.getAvailablePoses();
        String defaultNamedPose = this.namedPoseInfo.getDefaultNamedPose();
        this.namedPoseSelectionCombo.removeAllItems();
        for (String name : availablePoses) {
            this.namedPoseSelectionCombo.addItem(name);
        }
        this.namedPoseSelectionCombo.setSelectedItem(defaultNamedPose);
        this.currentNamedPose = this.namedPoseInfo.getNamedPoseById(defaultNamedPose);
        this.updateSelectionButtonStates();
        this.changeHandler.currentNamedPoseChanged(this.currentNamedPose);
        this.comboListens = true;
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
        this.updateSelectionButtonStates();
    }

    private class RtcpInstallationComboRenderer
    extends DefaultListCellRenderer {
        private Icon approvedIcon = null;

        private RtcpInstallationComboRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setHorizontalAlignment(2);
            if (RtcpNamedPoseManagerPanel.this.namedPoseInfo.getDefaultNamedPose().equals(value.toString())) {
                this.setIcon(this.approvedIcon);
                this.setText(value.toString());
            }
            return this;
        }

        public void setDefaultNamedPoseIcon(Icon icon) {
            this.approvedIcon = icon;
        }
    }

    public static interface NamedPoseChangeHandler {
        public void currentNamedPoseChanged(RtcpNamedPose var1);
    }
}

