/*
 * Decompiled with CFR 0.152.
 */
package com.energid.urcap.remotetcp.impl.Common;

import com.energid.urcap.remotetcp.impl.Common.RtcpConstants;
import com.energid.urcap.remotetcp.impl.Common.RtcpNamedPose;
import com.energid.urcap.remotetcp.impl.Common.Style;
import com.energid.urcap.remotetcp.impl.Interfaces.LocalizationInfo;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpNamedPoseInfo;
import com.ur.urcap.api.contribution.installation.InstallationAPIProvider;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardInputCallback;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardInputFactory;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardNumberInput;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.PoseFactory;
import com.ur.urcap.api.domain.value.simple.Angle;
import com.ur.urcap.api.domain.value.simple.Length;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class RtcpPoseValuePanel {
    private PoseFactory poseFactory;
    private KeyboardInputFactory keyboardFactory;
    private LocalizationInfo localization;
    private final Style style;
    private final String controlNameBase;
    private RtcpNamedPoseInfo poseInfo;
    private Component positionPanel = null;
    private Component orientationPanel = null;
    private JTextField xField = null;
    private JTextField yField = null;
    private JTextField zField = null;
    private JTextField rxField = null;
    private JTextField ryField = null;
    private JTextField rzField = null;
    private JLabel labelOrientation;
    private JLabel labelPosition;
    private final String[] poseLabels = new String[]{"X", "Y", "Z", "RX", "RY", "RZ"};
    private JLabel[] unitLabels;
    private final DecimalFormat[] poseFormats;
    private Pose pose;
    private RtcpNamedPose namedPose;

    public RtcpPoseValuePanel(RtcpNamedPoseInfo poseInfo, Style style, String controlNameBase) {
        this.style = style;
        this.controlNameBase = controlNameBase;
        this.poseInfo = poseInfo;
        DecimalFormat formatterOrientation = new DecimalFormat("#0.0000");
        DecimalFormat formatterPosition = new DecimalFormat("##0.00");
        this.poseFormats = new DecimalFormat[]{formatterPosition, formatterPosition, formatterPosition, formatterOrientation, formatterOrientation, formatterOrientation};
        this.unitLabels = new JLabel[6];
    }

    public Component createPositionSection() {
        if (this.positionPanel != null) {
            return this.positionPanel;
        }
        this.positionPanel = this.buildPositionSection();
        return this.positionPanel;
    }

    public Component createOrientationSection() {
        if (this.orientationPanel != null) {
            return this.orientationPanel;
        }
        this.orientationPanel = this.buildOrientationSection();
        return this.orientationPanel;
    }

    public void updatePanel(RtcpNamedPose namedPose) {
        this.updateText();
        this.namedPose = namedPose;
        this.updatePose(namedPose.getPose());
    }

    private void updateText() {
        this.labelPosition.setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_POSITION));
        this.labelOrientation.setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_ORIENTATION));
        this.unitLabels[0].setText(this.localization.getLocalizedLengthUnit());
        this.unitLabels[1].setText(this.unitLabels[0].getText());
        this.unitLabels[2].setText(this.unitLabels[0].getText());
        this.unitLabels[3].setText("rad");
        this.unitLabels[4].setText(this.unitLabels[3].getText());
        this.unitLabels[5].setText(this.unitLabels[3].getText());
    }

    private void updatePose(Pose pose) {
        if (pose != null) {
            this.pose = pose;
            double[] values = pose.toArray(Length.Unit.MM, Angle.Unit.RAD);
            double xVal = this.localization.getConvertedLengthForDisplay(values[0]);
            double yVal = this.localization.getConvertedLengthForDisplay(values[1]);
            double zVal = this.localization.getConvertedLengthForDisplay(values[2]);
            this.xField.setText(this.poseFormats[0].format(xVal));
            this.yField.setText(this.poseFormats[1].format(yVal));
            this.zField.setText(this.poseFormats[2].format(zVal));
            this.rxField.setText(this.poseFormats[3].format(values[3]));
            this.ryField.setText(this.poseFormats[4].format(values[4]));
            this.rzField.setText(this.poseFormats[5].format(values[5]));
        }
    }

    private Component buildOrientationSection() {
        Box mainBox = Box.createVerticalBox();
        mainBox.setAlignmentY(0.0f);
        Box labelBox = Box.createHorizontalBox();
        labelBox.setAlignmentX(0.0f);
        this.labelOrientation = new JLabel();
        labelBox.add(this.labelOrientation);
        mainBox.add(labelBox);
        mainBox.add(this.createVerticalSpacing(5));
        this.rxField = this.createTcpValueTextField(3);
        this.rxField.setName(this.controlNameBase + "_RX");
        this.ryField = this.createTcpValueTextField(4);
        this.ryField.setName(this.controlNameBase + "_RY");
        this.rzField = this.createTcpValueTextField(5);
        this.rzField.setName(this.controlNameBase + "_RZ");
        mainBox.add(this.buildTcpValueStrip(3, this.rxField));
        mainBox.add(this.createVerticalSpacing(5));
        mainBox.add(this.buildTcpValueStrip(4, this.ryField));
        mainBox.add(this.createVerticalSpacing(5));
        mainBox.add(this.buildTcpValueStrip(5, this.rzField));
        return mainBox;
    }

    private Component buildPositionSection() {
        Box mainBox = Box.createVerticalBox();
        mainBox.setAlignmentY(0.0f);
        Box labelBox = Box.createHorizontalBox();
        labelBox.setAlignmentX(0.0f);
        this.labelPosition = new JLabel();
        labelBox.add(this.labelPosition);
        mainBox.add(labelBox);
        mainBox.add(this.createVerticalSpacing(5));
        this.xField = this.createTcpValueTextField(0);
        this.xField.setName(this.controlNameBase + "_X");
        this.yField = this.createTcpValueTextField(1);
        this.yField.setName(this.controlNameBase + "_Y");
        this.zField = this.createTcpValueTextField(2);
        this.zField.setName(this.controlNameBase + "_Z");
        mainBox.add(this.buildTcpValueStrip(0, this.xField));
        mainBox.add(this.createVerticalSpacing(5));
        mainBox.add(this.buildTcpValueStrip(1, this.yField));
        mainBox.add(this.createVerticalSpacing(5));
        mainBox.add(this.buildTcpValueStrip(2, this.zField));
        return mainBox;
    }

    private JTextField createTcpValueTextField(final int poseIndex) {
        final JTextField field = new JTextField();
        field.setHorizontalAlignment(4);
        field.setFocusable(false);
        field.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (field.isEnabled()) {
                    RtcpPoseValuePanel.this.tcpValueFieldHandler(field, poseIndex);
                }
            }
        });
        return field;
    }

    protected void tcpValueFieldHandler(JTextField field, int poseIndex) {
        KeyboardNumberInput<Double> keyboardInput = this.getKeyboardForNumberField();
        double initialValue = this.localization.parseForLocalizedValue(field.getText());
        keyboardInput.setInitialValue((Object)initialValue);
        keyboardInput.show(field, this.getKeyboardCallbackForTcpValue(field, poseIndex));
    }

    private KeyboardInputCallback<Double> getKeyboardCallbackForTcpValue(final JTextField field, final int poseIndex) {
        return new KeyboardInputCallback<Double>(){

            public void onOk(Double value) {
                field.setText(RtcpPoseValuePanel.this.poseFormats[poseIndex].format(value));
                double internalVal = value;
                if (poseIndex < 3) {
                    internalVal = RtcpPoseValuePanel.this.localization.getConvertedLengthForStorage(value);
                }
                RtcpPoseValuePanel.this.pose = RtcpPoseValuePanel.this.updatePoseWithNewValues(RtcpPoseValuePanel.this.pose, new double[]{internalVal}, new int[]{poseIndex});
                RtcpPoseValuePanel.this.namedPose.setPose(RtcpPoseValuePanel.this.pose);
                RtcpPoseValuePanel.this.poseInfo.updateDataModel();
            }
        };
    }

    private Pose updatePoseWithNewValues(Pose pose, double[] values, int[] poseIndices) {
        double[] poseArray = pose.toArray(Length.Unit.MM, Angle.Unit.RAD);
        int index = 0;
        for (int poseIndex : poseIndices) {
            poseArray[poseIndex] = values[index++];
        }
        Pose updatedPose = this.poseFactory.createPose(poseArray[0], poseArray[1], poseArray[2], poseArray[3], poseArray[4], poseArray[5], Length.Unit.MM, Angle.Unit.RAD);
        return updatedPose;
    }

    private KeyboardNumberInput<Double> getKeyboardForNumberField() {
        KeyboardNumberInput keyboardInput = this.getKeyboardFactory().createDoubleKeypadInput();
        return keyboardInput;
    }

    private KeyboardInputFactory getKeyboardFactory() {
        return this.keyboardFactory;
    }

    private Component buildTcpValueStrip(int poseIndex, JTextField textField) {
        Box valueStrip = Box.createHorizontalBox();
        valueStrip.setAlignmentX(0.0f);
        JLabel labelName = new JLabel(this.poseLabels[poseIndex]);
        labelName.setMaximumSize(new Dimension(30, 30));
        labelName.setMinimumSize(new Dimension(30, 30));
        labelName.setPreferredSize(new Dimension(30, 30));
        valueStrip.add(labelName);
        valueStrip.add(this.createHorizontalSpacing());
        textField.setMinimumSize(new Dimension(150, 30));
        textField.setMaximumSize(new Dimension(150, 30));
        textField.setPreferredSize(new Dimension(150, 30));
        valueStrip.add(textField);
        valueStrip.add(this.createHorizontalSpacing());
        this.unitLabels[poseIndex] = new JLabel();
        this.unitLabels[poseIndex].setName(this.controlNameBase + "_Unit_" + (poseIndex + 1));
        valueStrip.add(this.unitLabels[poseIndex]);
        return valueStrip;
    }

    private Component createHorizontalSpacing() {
        return Box.createRigidArea(new Dimension(this.style.getHorizontalSpacing(), 0));
    }

    private Component createHorizontalSpacing(int spacing) {
        return Box.createRigidArea(new Dimension(spacing, 0));
    }

    private Component createVerticalSpacing() {
        return Box.createRigidArea(new Dimension(0, this.style.getVerticalSpacing()));
    }

    private Component createVerticalSpacing(int spacing) {
        return Box.createRigidArea(new Dimension(0, spacing));
    }

    public void setApiProvider(InstallationAPIProvider apiProvider, LocalizationInfo localization) {
        this.poseFactory = apiProvider.getInstallationAPI().getValueFactoryProvider().getPoseFactory();
        this.keyboardFactory = apiProvider.getUserInterfaceAPI().getUserInteraction().getKeyboardInputFactory();
        this.localization = localization;
    }
}

