/*
 * Decompiled with CFR 0.152.
 */
package com.energid.urcap.remotetcp.impl.Common;

import com.energid.urcap.remotetcp.impl.Common.RtcpConstants;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.simple.Angle;
import com.ur.urcap.api.domain.value.simple.Length;
import java.util.regex.Pattern;

public class RtcpUtils {
    public static String modifyName(String name) {
        String modifiedName = name.trim();
        modifiedName = modifiedName.replace(' ', '_');
        return modifiedName;
    }

    public static RtcpConstants.Strings validateName(String name) {
        if (name == null) {
            return RtcpConstants.Strings.RTCP_VALIDATION_ERROR_DEFAULT;
        }
        Pattern p = Pattern.compile("[^a-zA-Z0-9_]");
        boolean hasSpecialChar = p.matcher(name).find();
        if (hasSpecialChar) {
            return RtcpConstants.Strings.RTCP_VALIDATION_ERROR_ILLEGAL;
        }
        p = Pattern.compile("^[0-9_]");
        boolean startsWithIllegal = p.matcher(name).find();
        if (startsWithIllegal) {
            return RtcpConstants.Strings.RTCP_VALIDATION_ERROR_ILLEGAL;
        }
        if (name.length() < 1) {
            return RtcpConstants.Strings.RTCP_VALIDATION_ERROR_DEFAULT;
        }
        if (name.length() > 15) {
            return RtcpConstants.Strings.RTCP_VALIDATION_ERROR_MAXLENGTH;
        }
        return RtcpConstants.Strings.RTCP_VALIDATION_NAMEISVALID;
    }

    public static String encloseWithHtml(String text) {
        return "<html>" + text + "</html>";
    }

    public static String getPoseString(Pose calculatedPcs, Length.Unit length) {
        if (calculatedPcs == null) {
            return "null Pose";
        }
        double[] values = calculatedPcs.toArray(length, Angle.Unit.RAD);
        return String.format("[%.2f, %.2f, %.2f, %.3f, %.3f, %.3f]", values[0], values[1], values[2], values[3], values[4], values[5]);
    }

    public static String getPositionString(Pose calculatedPcs, Length.Unit systemLengthUnit, String localizedLengthUnit) {
        if (calculatedPcs == null) {
            return "null Pose";
        }
        double[] values = calculatedPcs.toArray(systemLengthUnit, Angle.Unit.RAD);
        return String.format("[%.2f, %.2f, %.2f] %s", values[0], values[1], values[2], localizedLengthUnit);
    }

    public static String getOrienationString(Pose calculatedPcs) {
        if (calculatedPcs == null) {
            return "null Pose";
        }
        double[] values = calculatedPcs.toArray(Length.Unit.MM, Angle.Unit.RAD);
        return String.format("[%.3f, %.3f, %.3f] %s", values[3], values[4], values[5], "rad");
    }
}

