/*
 * Decompiled with CFR 0.152.
 */
package com.energid.urcap.remotetcp.impl.Common;

import com.energid.urcap.remotetcp.impl.Common.RtcpConstants;
import com.energid.urcap.remotetcp.impl.Common.RtcpUtils;
import com.energid.urcap.remotetcp.impl.Common.RtcpXmlRpcClient;
import com.energid.urcap.remotetcp.impl.Common.Style;
import com.energid.urcap.remotetcp.impl.Interfaces.LocalizationInfo;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpProgramInfo;
import com.energid.urcap.remotetcp.impl.RemoteTcpInstallationNodeContribution;
import com.ur.urcap.api.contribution.program.ProgramAPIProvider;
import com.ur.urcap.api.domain.undoredo.UndoRedoManager;
import com.ur.urcap.api.domain.userinteraction.inputvalidation.InputValidator;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardInputCallback;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardInputFactory;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardNumberInput;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardTextInput;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.jointposition.JointPositions;
import com.ur.urcap.api.domain.value.simple.Angle;
import com.ur.urcap.api.domain.value.simple.Length;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.Formatter;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;

public abstract class RtcpViewHelperBase {
    protected int borderThickness = 0;
    protected Border defaultBorder = BorderFactory.createLineBorder(Color.BLACK, this.borderThickness);
    protected KeyboardInputFactory keyboardFactory;
    protected UndoRedoManager undoRedoManager;
    protected ProgramAPIProvider apiProvider;
    protected Style style;
    protected JPanel container;
    protected DecimalFormat[] formatters;
    protected int textFieldWidth = 150;
    protected int textFieldHeight = 30;
    protected float valueBlockAlignmentX = 0.0f;
    protected float valueBlockAlignmentY = 0.0f;
    protected float editFieldAlignmentX = 0.0f;
    protected float editFieldAlignmentY = 0.0f;
    protected final int toolSpeedIndex = 0;
    protected final int toolAccelerationIndex = 1;
    protected final int blendRadiusIndex = 2;
    protected String controlNameBase;
    private final double mtomm = 1000.0;
    private final int ee_id = 0;

    protected Component createVerticalValueEditBlock(JTextField field, JLabel label, JLabel unitLabel) {
        Box box = Box.createVerticalBox();
        box.setAlignmentX(this.valueBlockAlignmentX);
        box.setAlignmentY(this.valueBlockAlignmentY);
        box.setBorder(this.defaultBorder);
        if (label != null) {
            label.setAlignmentX(0.0f);
            box.add(label);
            box.add(this.createVerticalSpacing(5));
        }
        Box valueBox = Box.createHorizontalBox();
        valueBox.setAlignmentX(0.0f);
        valueBox.setBorder(this.defaultBorder);
        valueBox.add(field);
        valueBox.add(this.createHorizontalSpacing(3));
        unitLabel.setAlignmentY(0.5f);
        unitLabel.setAlignmentX(0.0f);
        valueBox.add(unitLabel);
        box.add(valueBox);
        return box;
    }

    protected Component createVerticalValueEditBlock(JTextField field, String labelText, String unit) {
        Box box = Box.createVerticalBox();
        box.setAlignmentX(this.valueBlockAlignmentX);
        box.setAlignmentY(this.valueBlockAlignmentY);
        box.setBorder(this.defaultBorder);
        if (!labelText.isEmpty()) {
            JLabel label = new JLabel(labelText);
            label.setAlignmentX(0.0f);
            box.add(label);
            box.add(this.createVerticalSpacing(5));
        }
        Box valueBox = Box.createHorizontalBox();
        valueBox.setAlignmentX(0.0f);
        valueBox.setBorder(this.defaultBorder);
        valueBox.add(field);
        valueBox.add(this.createHorizontalSpacing(3));
        JLabel unitLabel = new JLabel(unit);
        unitLabel.setAlignmentY(0.5f);
        unitLabel.setAlignmentX(0.0f);
        valueBox.add(unitLabel);
        box.add(valueBox);
        return box;
    }

    protected Component createHorizontalValueEditBlock(JTextField field, String labelText, String unit) {
        Box box = Box.createHorizontalBox();
        box.setAlignmentY(this.valueBlockAlignmentY);
        box.setAlignmentX(this.valueBlockAlignmentX);
        box.setBorder(this.defaultBorder);
        if (!labelText.isEmpty()) {
            JLabel label = new JLabel(labelText);
            label.setAlignmentX(0.0f);
            box.add(label);
            box.add(this.createHorizontalSpacing(5));
        }
        box.add(field);
        box.add(this.createHorizontalSpacing(3));
        box.add(new JLabel(unit));
        return box;
    }

    protected Component createHorizontalValueEditBlock(JTextField field, JLabel labelText, JLabel unit) {
        Box box = Box.createHorizontalBox();
        box.setAlignmentY(this.valueBlockAlignmentY);
        box.setAlignmentX(this.valueBlockAlignmentX);
        box.setBorder(this.defaultBorder);
        if (labelText != null) {
            labelText.setAlignmentX(0.0f);
            box.add(labelText);
            box.add(this.createHorizontalSpacing(5));
        }
        box.add(field);
        box.add(this.createHorizontalSpacing(3));
        box.add(unit);
        return box;
    }

    protected JTextField createValueTextField(final int valueIndex) {
        final JTextField field = new JTextField();
        field.setHorizontalAlignment(4);
        field.setAlignmentX(this.editFieldAlignmentX);
        field.setAlignmentY(this.editFieldAlignmentY);
        field.setMinimumSize(new Dimension(this.textFieldWidth, this.textFieldHeight));
        field.setMaximumSize(new Dimension(this.textFieldWidth, this.textFieldHeight));
        field.setPreferredSize(new Dimension(this.textFieldWidth, this.textFieldHeight));
        field.setText(this.formatters[valueIndex].format(0.0));
        field.setFocusable(false);
        field.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (field.isEnabled()) {
                    RtcpViewHelperBase.this.valueFieldHandler(field, valueIndex);
                }
            }
        });
        return field;
    }

    protected void valueFieldHandler(JTextField field, int valueIndex) {
        KeyboardNumberInput<Double> keyboardInput = this.getKeyboardForNumberField();
        double initialValue = this.getLocalizationInfo().parseForLocalizedValue(field.getText());
        keyboardInput.setInitialValue((Object)initialValue);
        keyboardInput.setErrorValidator(this.getValidatorForValueInput(valueIndex));
        keyboardInput.show(field, this.getKeyboardCallbackForValue(field, valueIndex));
    }

    protected InputValidator<Double> getValidatorForValueInput(final int valueIndex) {
        return new InputValidator<Double>(){
            private String message = "";

            public boolean isValid(Double value) {
                this.message = RtcpViewHelperBase.this.checkValue(value, valueIndex);
                return this.message.isEmpty();
            }

            public String getMessage(Double value) {
                return this.message;
            }
        };
    }

    protected KeyboardInputCallback<Double> getKeyboardCallbackForValue(JTextField field, int valueIndex) {
        return null;
    }

    protected Component createVerticalSpacing(int spacing) {
        return Box.createRigidArea(new Dimension(0, spacing));
    }

    protected Component createHorizontalSpacing(int spacing) {
        return Box.createRigidArea(new Dimension(spacing, 0));
    }

    protected KeyboardInputFactory getKeyboardFactory() {
        return this.keyboardFactory;
    }

    public void setApiProvider(ProgramAPIProvider apiProvider) {
        this.apiProvider = apiProvider;
        this.keyboardFactory = apiProvider.getUserInterfaceAPI().getUserInteraction().getKeyboardInputFactory();
        this.undoRedoManager = apiProvider.getProgramAPI().getUndoRedoManager();
    }

    protected KeyboardNumberInput<Double> getKeyboardForNumberField() {
        KeyboardNumberInput keyboardInput = this.getKeyboardFactory().createPositiveDoubleKeypadInput();
        return keyboardInput;
    }

    protected KeyboardTextInput getKeyboardForStringField() {
        KeyboardTextInput keyboardInput = this.getKeyboardFactory().createStringKeyboardInput();
        return keyboardInput;
    }

    protected void setPanelEnabled(JPanel panel, Boolean isEnabled) {
        Component[] components;
        panel.setEnabled(isEnabled);
        for (Component component : components = panel.getComponents()) {
            if (component instanceof JPanel) {
                this.setPanelEnabled((JPanel)component, isEnabled);
                continue;
            }
            if (component instanceof Box) {
                this.setBoxEnabled((Box)component, isEnabled);
                continue;
            }
            component.setEnabled(isEnabled);
        }
    }

    protected void setBoxEnabled(Box box, Boolean isEnabled) {
        Component[] components;
        box.setEnabled(isEnabled);
        for (Component component : components = box.getComponents()) {
            if (component instanceof JPanel) {
                this.setPanelEnabled((JPanel)component, isEnabled);
                continue;
            }
            if (component instanceof Box) {
                this.setBoxEnabled((Box)component, isEnabled);
                continue;
            }
            component.setEnabled(isEnabled);
        }
    }

    public void setControlNameBase(String controlNameBase) {
        this.controlNameBase = controlNameBase;
    }

    public static Icon getIconResource(String resourceName) {
        ImageIcon icon = null;
        try {
            BufferedImage img = null;
            img = ImageIO.read(RtcpViewHelperBase.class.getClassLoader().getResource(resourceName));
            icon = new ImageIcon(img);
            return icon;
        }
        catch (Exception e1) {
            System.out.println("non-fatal exception resource " + resourceName);
            return null;
        }
    }

    public static Icon getIconResourceScaled(String resourceName, int width) {
        ImageIcon icon = null;
        try {
            Image img = null;
            img = ImageIO.read(RtcpViewHelperBase.class.getClassLoader().getResource(resourceName));
            img = img.getScaledInstance(width, -1, 4);
            icon = new ImageIcon(img);
            return icon;
        }
        catch (Exception e1) {
            System.out.println("non-fatal exception resource " + resourceName);
            return null;
        }
    }

    protected String checkValue(Double value, int valueIndex) {
        double convertedValue = this.getLocalizationInfo().getConvertedLengthForStorage(value);
        switch (valueIndex) {
            case 0: {
                if (!(convertedValue < 0.0) && !(convertedValue > 250.0)) break;
                double convertedLow = this.getLocalizationInfo().getConvertedLengthForDisplay(0.0);
                double convertedHigh = this.getLocalizationInfo().getConvertedLengthForDisplay(250.0);
                String unit = this.getLocalizationInfo().getLocalizedSpeedUnit();
                return this.createValueRangeMessage(convertedLow, convertedHigh, unit);
            }
            case 1: {
                if (!(convertedValue < 0.0) && !(convertedValue > 150000.0)) break;
                double convertedLow = this.getLocalizationInfo().getConvertedLengthForDisplay(0.0);
                double convertedHigh = this.getLocalizationInfo().getConvertedLengthForDisplay(150000.0);
                String unit = this.getLocalizationInfo().getLocalizedAccelerationUnit();
                return this.createValueRangeMessage(convertedLow, convertedHigh, unit);
            }
            case 2: {
                if (!(convertedValue < 0.0) && !(convertedValue > 1000.0)) break;
                double convertedLow = this.getLocalizationInfo().getConvertedLengthForDisplay(0.0);
                double convertedHigh = this.getLocalizationInfo().getConvertedLengthForDisplay(1000.0);
                String unit = this.getLocalizationInfo().getLocalizedLengthUnit();
                return this.createValueRangeMessage(convertedLow, convertedHigh, unit);
            }
        }
        return "";
    }

    private String createValueRangeMessage(double convertedLow, double convertedHigh, String unit) {
        String message = RtcpUtils.encloseWithHtml(this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_VALUERANGE_MESSAGE));
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb);
        formatter.format(message, convertedLow, unit, convertedHigh, unit);
        formatter.close();
        System.out.println(sb.toString());
        return sb.toString();
    }

    protected RemoteTcpInstallationNodeContribution getInstallation() {
        return (RemoteTcpInstallationNodeContribution)this.apiProvider.getProgramAPI().getInstallationNode(RemoteTcpInstallationNodeContribution.class);
    }

    protected RtcpProgramInfo getProgramInfo() {
        return this.getInstallation();
    }

    protected LocalizationInfo getLocalizationInfo() {
        return this.getInstallation();
    }

    protected Pose calculateRtcpPose(int ee_set_id, Pose selectedRtcpPose, JointPositions jointPositions) {
        boolean setKinRetVal = RtcpXmlRpcClient.setKinTransform(ee_set_id, 0, selectedRtcpPose);
        Object calcPoseObject = RtcpXmlRpcClient.calculateCartesianPlacement(ee_set_id, 0, jointPositions);
        Object[] values = (Object[])calcPoseObject;
        double[] poseArray = new double[]{(Double)values[0] * 1000.0, (Double)values[1] * 1000.0, (Double)values[2] * 1000.0, (Double)values[3], (Double)values[4], (Double)values[5]};
        Pose calculatedPose = this.apiProvider.getProgramAPI().getValueFactoryProvider().getPoseFactory().createPose(poseArray[0], poseArray[1], poseArray[2], poseArray[3], poseArray[4], poseArray[5], Length.Unit.MM, Angle.Unit.RAD);
        return calculatedPose;
    }

    protected Pose makePose(Object[] values) {
        double[] poseArray = new double[]{(Double)values[0], (Double)values[1], (Double)values[2], (Double)values[3], (Double)values[4], (Double)values[5]};
        Pose pose = this.apiProvider.getProgramAPI().getValueFactoryProvider().getPoseFactory().createPose(poseArray[0], poseArray[1], poseArray[2], poseArray[3], poseArray[4], poseArray[5], Length.Unit.M, Angle.Unit.RAD);
        return pose;
    }
}

