/*
 * Decompiled with CFR 0.152.
 */
package com.energid.urcap.remotetcp.impl.Common;

import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.jointposition.JointPosition;
import com.ur.urcap.api.domain.value.jointposition.JointPositions;
import com.ur.urcap.api.domain.value.simple.Angle;
import com.ur.urcap.api.domain.value.simple.Length;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import org.apache.xmlrpc.client.AsyncCallback;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;

public class RtcpXmlRpcClient {
    private static String errorMessage = "";
    private static String serverUrl = "http://127.0.0.1:7827/RPC2";
    private static XmlRpcClient _client;

    public static String getLastError() {
        return errorMessage;
    }

    public static void startXmlrpcClient() {
        try {
            _client = RtcpXmlRpcClient.createXmlrpcClient();
        }
        catch (MalformedURLException e) {
            errorMessage = "startXmlrpcClient failed.";
        }
    }

    public static void stopXmlrpcClient() {
        _client = null;
    }

    public static Object findSolution(int ee_set_id, Pose rtcpLink, Pose rtcpBase, int timeout) {
        errorMessage = "";
        Object retVal = null;
        try {
            XmlRpcClient client = RtcpXmlRpcClient.createXmlrpcClient(timeout * 1000);
            Object[] params = new Object[]{ee_set_id, new Object[]{rtcpLink.getPosition().getX(Length.Unit.M), rtcpLink.getPosition().getY(Length.Unit.M), rtcpLink.getPosition().getZ(Length.Unit.M), rtcpLink.getRotation().getRX(Angle.Unit.RAD), rtcpLink.getRotation().getRY(Angle.Unit.RAD), rtcpLink.getRotation().getRZ(Angle.Unit.RAD)}, new Object[]{rtcpBase.getPosition().getX(Length.Unit.M), rtcpBase.getPosition().getY(Length.Unit.M), rtcpBase.getPosition().getZ(Length.Unit.M), rtcpBase.getRotation().getRX(Angle.Unit.RAD), rtcpBase.getRotation().getRY(Angle.Unit.RAD), rtcpBase.getRotation().getRZ(Angle.Unit.RAD)}};
            retVal = client.execute("findSolution", params);
        }
        catch (Exception ex) {
            Throwable rootCause = RtcpXmlRpcClient.getCause(ex);
            errorMessage = rootCause instanceof SocketTimeoutException ? "Timed out" : "findSolution failed.";
        }
        return retVal;
    }

    public static Object moveHere(Pose rtcpLink, Pose rtcpBase, double[] qActual, double[] tcpActual, int timeout) {
        errorMessage = "";
        Object retVal = null;
        try {
            XmlRpcClient client = RtcpXmlRpcClient.createXmlrpcClient(timeout * 1000);
            Object[] params = new Object[]{new Object[]{rtcpLink.getPosition().getX(Length.Unit.M), rtcpLink.getPosition().getY(Length.Unit.M), rtcpLink.getPosition().getZ(Length.Unit.M), rtcpLink.getRotation().getRX(Angle.Unit.RAD), rtcpLink.getRotation().getRY(Angle.Unit.RAD), rtcpLink.getRotation().getRZ(Angle.Unit.RAD)}, new Object[]{rtcpBase.getPosition().getX(Length.Unit.M), rtcpBase.getPosition().getY(Length.Unit.M), rtcpBase.getPosition().getZ(Length.Unit.M), rtcpBase.getRotation().getRX(Angle.Unit.RAD), rtcpBase.getRotation().getRY(Angle.Unit.RAD), rtcpBase.getRotation().getRZ(Angle.Unit.RAD)}, new Object[]{qActual[0], qActual[1], qActual[2], qActual[3], qActual[4], qActual[5]}, new Object[]{tcpActual[0], tcpActual[1], tcpActual[2], tcpActual[3], tcpActual[4], tcpActual[5]}};
            retVal = client.execute("moveHere", params);
        }
        catch (Exception ex) {
            Throwable rootCause = RtcpXmlRpcClient.getCause(ex);
            errorMessage = rootCause instanceof SocketTimeoutException ? "Timed out" : ex.getMessage();
        }
        return retVal;
    }

    public static Object moveTcpHere(Pose targetPose, Pose selectedTcp, double[] qActual, double[] tcpActual, int timeout) {
        errorMessage = "";
        Object retVal = null;
        try {
            XmlRpcClient client = RtcpXmlRpcClient.createXmlrpcClient(timeout * 1000);
            Object[] params = new Object[]{new Object[]{targetPose.getPosition().getX(Length.Unit.M), targetPose.getPosition().getY(Length.Unit.M), targetPose.getPosition().getZ(Length.Unit.M), targetPose.getRotation().getRX(Angle.Unit.RAD), targetPose.getRotation().getRY(Angle.Unit.RAD), targetPose.getRotation().getRZ(Angle.Unit.RAD)}, new Object[]{selectedTcp.getPosition().getX(Length.Unit.M), selectedTcp.getPosition().getY(Length.Unit.M), selectedTcp.getPosition().getZ(Length.Unit.M), selectedTcp.getRotation().getRX(Angle.Unit.RAD), selectedTcp.getRotation().getRY(Angle.Unit.RAD), selectedTcp.getRotation().getRZ(Angle.Unit.RAD)}, new Object[]{qActual[0], qActual[1], qActual[2], qActual[3], qActual[4], qActual[5]}, new Object[]{tcpActual[0], tcpActual[1], tcpActual[2], tcpActual[3], tcpActual[4], tcpActual[5]}};
            retVal = client.execute("moveTCPToPath", params);
        }
        catch (Exception ex) {
            Throwable rootCause = RtcpXmlRpcClient.getCause(ex);
            errorMessage = rootCause instanceof SocketTimeoutException ? "Timed out" : ex.getMessage();
        }
        return retVal;
    }

    public static Object moveToFirstPoint(String toolpathFile, Pose pcs, int timeout) {
        errorMessage = "";
        Object retVal = null;
        try {
            XmlRpcClient client = RtcpXmlRpcClient.createXmlrpcClient(timeout * 1000);
            Object[] params = new Object[]{toolpathFile, new Object[]{pcs.getPosition().getX(Length.Unit.M), pcs.getPosition().getY(Length.Unit.M), pcs.getPosition().getZ(Length.Unit.M), pcs.getRotation().getRX(Angle.Unit.RAD), pcs.getRotation().getRY(Angle.Unit.RAD), pcs.getRotation().getRZ(Angle.Unit.RAD)}};
            retVal = client.execute("moveToPath", params);
        }
        catch (Exception ex) {
            Throwable rootCause = RtcpXmlRpcClient.getCause(ex);
            errorMessage = rootCause instanceof SocketTimeoutException ? "Timed out" : ex.getMessage();
        }
        return retVal;
    }

    public static boolean setKinTransform(int ee_set_id, int ee_id, Pose pose) {
        errorMessage = "";
        boolean retVal = false;
        try {
            XmlRpcClient client = RtcpXmlRpcClient.createXmlrpcClient();
            Object[] params = new Object[]{ee_set_id, ee_id, new Object[]{pose.getPosition().getX(Length.Unit.M), pose.getPosition().getY(Length.Unit.M), pose.getPosition().getZ(Length.Unit.M), pose.getRotation().getRX(Angle.Unit.RAD), pose.getRotation().getRY(Angle.Unit.RAD), pose.getRotation().getRZ(Angle.Unit.RAD)}};
            retVal = (Boolean)client.execute("setKinTransform", params);
        }
        catch (Exception ex) {
            errorMessage = "setKinTransform failed.";
        }
        return retVal;
    }

    public static Object calculateCartesianPlacement(int ee_set_id, int ee_id, JointPositions joint_positions) {
        errorMessage = "";
        Object retObject = null;
        try {
            XmlRpcClient client = RtcpXmlRpcClient.createXmlrpcClient();
            Object[] params = new Object[3];
            params[0] = ee_set_id;
            params[1] = ee_id;
            JointPosition[] allPositions = joint_positions.getAllJointPositions();
            params[2] = new Object[]{allPositions[0].getAngle(Angle.Unit.RAD), allPositions[1].getAngle(Angle.Unit.RAD), allPositions[2].getAngle(Angle.Unit.RAD), allPositions[3].getAngle(Angle.Unit.RAD), allPositions[4].getAngle(Angle.Unit.RAD), allPositions[5].getAngle(Angle.Unit.RAD)};
            retObject = client.execute("calculateCartesianPlacement", params);
        }
        catch (Exception ex) {
            errorMessage = "calculateCartesianPlacement failed.";
        }
        return retObject;
    }

    public static void calculateOrientation(AsyncCallback callback) {
        errorMessage = "";
        try {
            XmlRpcClient client = RtcpXmlRpcClient.createXmlrpcClient();
            Object[] params = new String[]{"ACTUAL_TCP_POSE", "/ur_rtde"};
            client.executeAsync("getDataStoreRealVector", params, callback);
        }
        catch (Exception ex) {
            errorMessage = "Orientation calculation failed.";
        }
    }

    public static Object calculatePosition(JointPositions[] teachPoints) {
        errorMessage = "";
        Object retObject = null;
        try {
            XmlRpcClient client = RtcpXmlRpcClient.createXmlrpcClient();
            Object[] params = RtcpXmlRpcClient.createArrayFromJointPositions(teachPoints);
            retObject = client.execute("calculateRemoteTcpPosition", params);
        }
        catch (Exception ex) {
            errorMessage = "Position calculation failed.";
        }
        return retObject;
    }

    public static Object calculateFrame(int ee_set_id, int ee_id, Pose rtcp, JointPositions jointOrigin, JointPositions jointX, JointPositions jointY) {
        errorMessage = "";
        Object retObject = null;
        try {
            XmlRpcClient client = RtcpXmlRpcClient.createXmlrpcClient();
            Object[] params = new Object[6];
            params[0] = ee_set_id;
            params[1] = ee_id;
            params[2] = new Object[]{rtcp.getPosition().getX(Length.Unit.M), rtcp.getPosition().getY(Length.Unit.M), rtcp.getPosition().getZ(Length.Unit.M), rtcp.getRotation().getRX(Angle.Unit.RAD), rtcp.getRotation().getRY(Angle.Unit.RAD), rtcp.getRotation().getRZ(Angle.Unit.RAD)};
            JointPosition[] positions = jointOrigin.getAllJointPositions();
            params[3] = new Object[]{positions[0].getAngle(Angle.Unit.RAD), positions[1].getAngle(Angle.Unit.RAD), positions[2].getAngle(Angle.Unit.RAD), positions[3].getAngle(Angle.Unit.RAD), positions[4].getAngle(Angle.Unit.RAD), positions[5].getAngle(Angle.Unit.RAD)};
            positions = jointX.getAllJointPositions();
            params[4] = new Object[]{positions[0].getAngle(Angle.Unit.RAD), positions[1].getAngle(Angle.Unit.RAD), positions[2].getAngle(Angle.Unit.RAD), positions[3].getAngle(Angle.Unit.RAD), positions[4].getAngle(Angle.Unit.RAD), positions[5].getAngle(Angle.Unit.RAD)};
            positions = jointY.getAllJointPositions();
            params[5] = new Object[]{positions[0].getAngle(Angle.Unit.RAD), positions[1].getAngle(Angle.Unit.RAD), positions[2].getAngle(Angle.Unit.RAD), positions[3].getAngle(Angle.Unit.RAD), positions[4].getAngle(Angle.Unit.RAD), positions[5].getAngle(Angle.Unit.RAD)};
            retObject = client.execute("calculateFrame", params);
        }
        catch (Exception ex) {
            errorMessage = "calculateFrame failed: " + ex.getMessage();
        }
        return retObject;
    }

    public static Object fitTransformation(Pose rtcp, Pose coord1, Pose coord2, Pose coord3, Pose coord4, JointPositions point1, JointPositions point2, JointPositions point3, JointPositions point4) {
        errorMessage = "";
        Object retObject = null;
        try {
            XmlRpcClient client = RtcpXmlRpcClient.createXmlrpcClient();
            Object[] params = new Object[3];
            params[0] = new Object[]{rtcp.getPosition().getX(Length.Unit.M), rtcp.getPosition().getY(Length.Unit.M), rtcp.getPosition().getZ(Length.Unit.M), rtcp.getRotation().getRX(Angle.Unit.RAD), rtcp.getRotation().getRY(Angle.Unit.RAD), rtcp.getRotation().getRZ(Angle.Unit.RAD)};
            if (coord4 == null) {
                params[1] = new Object[]{coord1.getPosition().getX(Length.Unit.M), coord1.getPosition().getY(Length.Unit.M), coord1.getPosition().getZ(Length.Unit.M), coord2.getPosition().getX(Length.Unit.M), coord2.getPosition().getY(Length.Unit.M), coord2.getPosition().getZ(Length.Unit.M), coord3.getPosition().getX(Length.Unit.M), coord3.getPosition().getY(Length.Unit.M), coord3.getPosition().getZ(Length.Unit.M)};
                JointPosition[] p1 = point1.getAllJointPositions();
                JointPosition[] p2 = point2.getAllJointPositions();
                JointPosition[] p3 = point3.getAllJointPositions();
                params[2] = new Object[]{p1[0].getAngle(Angle.Unit.RAD), p1[1].getAngle(Angle.Unit.RAD), p1[2].getAngle(Angle.Unit.RAD), p1[3].getAngle(Angle.Unit.RAD), p1[4].getAngle(Angle.Unit.RAD), p1[5].getAngle(Angle.Unit.RAD), p2[0].getAngle(Angle.Unit.RAD), p2[1].getAngle(Angle.Unit.RAD), p2[2].getAngle(Angle.Unit.RAD), p2[3].getAngle(Angle.Unit.RAD), p2[4].getAngle(Angle.Unit.RAD), p2[5].getAngle(Angle.Unit.RAD), p3[0].getAngle(Angle.Unit.RAD), p3[1].getAngle(Angle.Unit.RAD), p3[2].getAngle(Angle.Unit.RAD), p3[3].getAngle(Angle.Unit.RAD), p3[4].getAngle(Angle.Unit.RAD), p3[5].getAngle(Angle.Unit.RAD)};
            } else {
                params[1] = new Object[]{coord1.getPosition().getX(Length.Unit.M), coord1.getPosition().getY(Length.Unit.M), coord1.getPosition().getZ(Length.Unit.M), coord2.getPosition().getX(Length.Unit.M), coord2.getPosition().getY(Length.Unit.M), coord2.getPosition().getZ(Length.Unit.M), coord3.getPosition().getX(Length.Unit.M), coord3.getPosition().getY(Length.Unit.M), coord3.getPosition().getZ(Length.Unit.M), coord4.getPosition().getX(Length.Unit.M), coord4.getPosition().getY(Length.Unit.M), coord4.getPosition().getZ(Length.Unit.M)};
                JointPosition[] p1 = point1.getAllJointPositions();
                JointPosition[] p2 = point2.getAllJointPositions();
                JointPosition[] p3 = point3.getAllJointPositions();
                JointPosition[] p4 = point4.getAllJointPositions();
                params[2] = new Object[]{p1[0].getAngle(Angle.Unit.RAD), p1[1].getAngle(Angle.Unit.RAD), p1[2].getAngle(Angle.Unit.RAD), p1[3].getAngle(Angle.Unit.RAD), p1[4].getAngle(Angle.Unit.RAD), p1[5].getAngle(Angle.Unit.RAD), p2[0].getAngle(Angle.Unit.RAD), p2[1].getAngle(Angle.Unit.RAD), p2[2].getAngle(Angle.Unit.RAD), p2[3].getAngle(Angle.Unit.RAD), p2[4].getAngle(Angle.Unit.RAD), p2[5].getAngle(Angle.Unit.RAD), p3[0].getAngle(Angle.Unit.RAD), p3[1].getAngle(Angle.Unit.RAD), p3[2].getAngle(Angle.Unit.RAD), p3[3].getAngle(Angle.Unit.RAD), p3[4].getAngle(Angle.Unit.RAD), p3[5].getAngle(Angle.Unit.RAD), p4[0].getAngle(Angle.Unit.RAD), p4[1].getAngle(Angle.Unit.RAD), p4[2].getAngle(Angle.Unit.RAD), p4[3].getAngle(Angle.Unit.RAD), p4[4].getAngle(Angle.Unit.RAD), p4[5].getAngle(Angle.Unit.RAD)};
            }
            retObject = client.execute("fitTransformation", params);
        }
        catch (Exception ex) {
            errorMessage = "fitTransformation failed: " + ex.getMessage();
        }
        return retObject;
    }

    public static int loadToolpath(String toolpathFile, boolean useFeedRate, int timeout) {
        errorMessage = "";
        int pathID = -1;
        try {
            XmlRpcClient client = RtcpXmlRpcClient.createXmlrpcClient(timeout * 1000);
            Object[] params = new Object[]{toolpathFile, useFeedRate};
            pathID = (Integer)client.execute("loadPath", params);
            if (pathID < 0) {
                return -1;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            errorMessage = ex.getMessage();
            errorMessage = "loadToolpath failed: " + ex.getMessage();
            return -1;
        }
        return pathID;
    }

    public static Object clearToolpathCache(int timeout) {
        errorMessage = "";
        Object retObject = null;
        try {
            XmlRpcClient client = RtcpXmlRpcClient.createXmlrpcClient(timeout * 1000);
            Object[] params = new Object[]{};
            retObject = client.execute("clearPath", params);
        }
        catch (Exception ex) {
            errorMessage = "clearToolpathCache failed: " + ex.getMessage();
        }
        return retObject;
    }

    public static Object validateToolpathFile(String toolpathFile, int timeout) {
        errorMessage = "";
        try {
            XmlRpcClient client = RtcpXmlRpcClient.createXmlrpcClient(timeout * 1000);
            Object[] params = new Object[]{toolpathFile};
            boolean valid = (Boolean)client.execute("validateToolPath", params);
            if (!valid) {
                params = new Object[]{};
                Object errors = client.execute("getErrorMsg", params);
                return errors;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            errorMessage = ex.getMessage();
            return new Object[]{-1, -1};
        }
        return null;
    }

    public static boolean setToolpathIoMapping(String ioType, int[] mappingDescription, int timeout) {
        boolean retVal;
        errorMessage = "";
        try {
            XmlRpcClient client = RtcpXmlRpcClient.createXmlrpcClient(timeout * 1000);
            Object[] params = new Object[]{ioType, "/", new Object[]{mappingDescription[0], mappingDescription[1], mappingDescription[2], mappingDescription[3]}};
            retVal = (Boolean)client.execute("setDataStoreInt32Vector", params);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            errorMessage = ex.getMessage();
            return false;
        }
        return retVal;
    }

    public static Object[] getMethodList() {
        errorMessage = "";
        try {
            XmlRpcClient localClient = _client == null ? RtcpXmlRpcClient.createXmlrpcClient() : _client;
            Object[] params = new Object[]{};
            Object[] methodArray = (Object[])localClient.execute("system.listMethods", params);
            return methodArray;
        }
        catch (Exception ex) {
            errorMessage = "getMethodList failed.";
            return null;
        }
    }

    private static XmlRpcClient createXmlrpcClient() throws MalformedURLException {
        XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
        config.setServerURL(new URL(serverUrl));
        config.setConnectionTimeout(10000);
        config.setReplyTimeout(10000);
        XmlRpcClient client = new XmlRpcClient();
        client.setConfig((XmlRpcClientConfig)config);
        return client;
    }

    private static XmlRpcClient createXmlrpcClient(int replyTimeout) throws MalformedURLException {
        XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
        config.setServerURL(new URL(serverUrl));
        config.setConnectionTimeout(10000);
        config.setReplyTimeout(replyTimeout);
        XmlRpcClient client = new XmlRpcClient();
        client.setConfig((XmlRpcClientConfig)config);
        return client;
    }

    private static Object[] createArrayFromJointPositions(JointPositions[] teachPoints) {
        Object[] retArray = new Object[teachPoints.length];
        int indexPoint = 0;
        for (JointPositions jps : teachPoints) {
            Object[] jointValues = new Object[6];
            int indexJoint = 0;
            for (JointPosition jp : jps.getAllJointPositions()) {
                jointValues[indexJoint++] = jp.getPosition(Angle.Unit.RAD);
            }
            retArray[indexPoint++] = jointValues;
        }
        return retArray;
    }

    private static Throwable getCause(Throwable e) {
        Throwable cause = null;
        Throwable result = e;
        while (null != (cause = result.getCause()) && result != cause) {
            result = cause;
        }
        return result;
    }
}

