/*
 * Decompiled with CFR 0.152.
 */
package com.energid.urcap.remotetcp.impl.InstallationNode;

import com.energid.urcap.remotetcp.impl.Common.RtcpConstants;
import com.energid.urcap.remotetcp.impl.Common.RtcpUtils;
import com.energid.urcap.remotetcp.impl.Common.Style;
import com.energid.urcap.remotetcp.impl.InstallationNode.RtcpInstallationViewHelperBase;
import com.energid.urcap.remotetcp.impl.Interfaces.LocalizationInfo;
import com.energid.urcap.remotetcp.impl.RemoteTcpInstallationNodeView;
import com.ur.urcap.api.contribution.DaemonContribution;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class DaemonInstallationViewHelper
extends RtcpInstallationViewHelperBase {
    private JPanel daemonPanel = null;
    private JLabel labelDaemonTitle = null;
    private JButton btnStartDaemon = null;
    private JButton btnStopDaemon = null;
    private JLabel labelDaemonStatus = null;
    private JLabel labelDaemonInstruction = null;
    private JLabel labelSelectApplication = null;
    private JLabel labelRemoteTcp = null;
    private JLabel labelRegularTcp = null;
    private JButton btnRemoteTcpToolpath = null;
    private JButton btnRemoteTcpOther = null;
    private JButton btnRegularTcpToolpath = null;
    private RemoteTcpInstallationNodeView.ViewContentSelector viewContentSelector;

    public DaemonInstallationViewHelper(LocalizationInfo localization, Style style, RemoteTcpInstallationNodeView.ViewContentSelector viewContentSelector) {
        super(localization, style);
        this.viewContentSelector = viewContentSelector;
    }

    public JPanel createDaemonPanel() {
        this.daemonPanel = new JPanel();
        this.daemonPanel.setLayout(new BoxLayout(this.daemonPanel, 1));
        this.daemonPanel.setAlignmentY(0.0f);
        this.daemonPanel.setAlignmentX(0.0f);
        this.daemonPanel.setBorder(new EmptyBorder(0, 10, 10, 10));
        this.labelDaemonTitle = new JLabel();
        this.labelDaemonTitle.setFont(new Font(this.labelDaemonTitle.getFont().getName(), 1, 20));
        this.labelDaemonTitle.setHorizontalAlignment(2);
        this.labelDaemonTitle.setAlignmentX(0.0f);
        this.labelDaemonTitle.setAlignmentY(0.0f);
        this.daemonPanel.add(this.createDaemonSection());
        this.daemonPanel.add(this.createVerticalSpacing(80));
        this.daemonPanel.add(this.createApplicationSelectionSection());
        return this.daemonPanel;
    }

    private Component createApplicationSelectionSection() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setAlignmentY(0.0f);
        panel.setAlignmentX(0.0f);
        this.labelSelectApplication = new JLabel();
        this.labelSelectApplication.setHorizontalAlignment(2);
        this.labelSelectApplication.setAlignmentX(0.0f);
        this.labelSelectApplication.setAlignmentY(0.0f);
        panel.add(this.labelSelectApplication);
        this.labelRemoteTcp = new JLabel();
        this.labelRemoteTcp.setHorizontalAlignment(2);
        this.labelRemoteTcp.setFont(new Font(this.labelRemoteTcp.getFont().getName(), 1, this.labelRemoteTcp.getFont().getSize()));
        this.labelRemoteTcp.setAlignmentX(0.0f);
        this.labelRemoteTcp.setAlignmentY(0.0f);
        panel.add(this.createVerticalSpacing(20));
        panel.add(this.labelRemoteTcp);
        Box buttons = Box.createHorizontalBox();
        buttons.setAlignmentX(0.0f);
        Dimension buttonDimension = new Dimension(250, 30);
        this.btnRemoteTcpToolpath = new JButton();
        this.btnRemoteTcpToolpath.setName("Rtcp_Remote_Toolpath_Selection");
        this.btnRemoteTcpToolpath.setMinimumSize(buttonDimension);
        this.btnRemoteTcpToolpath.setMaximumSize(buttonDimension);
        this.btnRemoteTcpToolpath.setPreferredSize(buttonDimension);
        this.btnRemoteTcpToolpath.setAlignmentX(0.0f);
        this.btnRemoteTcpToolpath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DaemonInstallationViewHelper.this.viewContentSelector.setSelection(RemoteTcpInstallationNodeView.RtcpInstallationViewType.RemoteTcpToolpath);
            }
        });
        buttons.add(this.btnRemoteTcpToolpath);
        this.btnRemoteTcpOther = new JButton();
        this.btnRemoteTcpOther.setName("Rtcp_Remote_Other_Selection");
        this.btnRemoteTcpOther.setMinimumSize(buttonDimension);
        this.btnRemoteTcpOther.setMaximumSize(buttonDimension);
        this.btnRemoteTcpOther.setPreferredSize(buttonDimension);
        this.btnRemoteTcpOther.setAlignmentX(0.0f);
        this.btnRemoteTcpOther.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DaemonInstallationViewHelper.this.viewContentSelector.setSelection(RemoteTcpInstallationNodeView.RtcpInstallationViewType.RemoteTcpLinearCircular);
            }
        });
        buttons.add(this.createHorizontalSpacing(15));
        buttons.add(this.btnRemoteTcpOther);
        panel.add(this.createVerticalSpacing(10));
        panel.add(buttons);
        this.labelRegularTcp = new JLabel();
        this.labelRegularTcp.setHorizontalAlignment(2);
        this.labelRegularTcp.setFont(new Font(this.labelRegularTcp.getFont().getName(), 1, this.labelRegularTcp.getFont().getSize()));
        this.labelRegularTcp.setAlignmentX(0.0f);
        this.labelRegularTcp.setAlignmentY(0.0f);
        panel.add(this.createVerticalSpacing(30));
        panel.add(this.labelRegularTcp);
        this.btnRegularTcpToolpath = new JButton();
        this.btnRegularTcpToolpath.setName("Rtcp_Regular_Toolpath_Selection");
        this.btnRegularTcpToolpath.setMinimumSize(buttonDimension);
        this.btnRegularTcpToolpath.setMaximumSize(buttonDimension);
        this.btnRegularTcpToolpath.setPreferredSize(buttonDimension);
        this.btnRegularTcpToolpath.setAlignmentX(0.0f);
        this.btnRegularTcpToolpath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DaemonInstallationViewHelper.this.viewContentSelector.setSelection(RemoteTcpInstallationNodeView.RtcpInstallationViewType.RegularTcpToolpath);
            }
        });
        panel.add(this.createVerticalSpacing(10));
        panel.add(this.btnRegularTcpToolpath);
        return panel;
    }

    private Component createDaemonSection() {
        Box daemonSection = Box.createVerticalBox();
        daemonSection.setAlignmentX(0.0f);
        this.labelDaemonInstruction = new JLabel();
        this.labelDaemonInstruction.setHorizontalAlignment(2);
        this.labelDaemonInstruction.setAlignmentX(0.0f);
        this.labelDaemonInstruction.setAlignmentY(0.0f);
        daemonSection.add(this.createVerticalSpacing(10));
        daemonSection.add(this.labelDaemonInstruction);
        Box daemonButtons = Box.createHorizontalBox();
        daemonButtons.setAlignmentX(0.0f);
        Dimension daemonButtonDimension = new Dimension(150, 30);
        this.btnStartDaemon = new JButton();
        this.btnStartDaemon.setName("Rtcp_Daemon_Start");
        this.btnStartDaemon.setPreferredSize(daemonButtonDimension);
        this.btnStartDaemon.setEnabled(false);
        this.btnStartDaemon.putClientProperty("InitiallyEnabled", Boolean.FALSE);
        this.btnStartDaemon.setMinimumSize(daemonButtonDimension);
        this.btnStartDaemon.setMaximumSize(daemonButtonDimension);
        this.btnStartDaemon.setAlignmentX(1.0f);
        this.btnStartDaemon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DaemonInstallationViewHelper.this.btnStartDaemon.setEnabled(false);
                DaemonInstallationViewHelper.this.labelDaemonStatus.setText(DaemonInstallationViewHelper.this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_DAEMONSTATUS_STARTING));
                DaemonInstallationViewHelper.this.daemonControl.setDaemonEnabled(true);
                DaemonInstallationViewHelper.this.daemonControl.applyDesiredDaemonStatus();
                DaemonInstallationViewHelper.this.programInfo.updateDaemonStateStarted(true);
            }
        });
        daemonButtons.add(this.btnStartDaemon);
        this.btnStopDaemon = new JButton();
        this.btnStopDaemon.setName("Rtcp_Daemon_Stop");
        this.btnStopDaemon.setPreferredSize(daemonButtonDimension);
        this.btnStopDaemon.setEnabled(false);
        this.btnStopDaemon.putClientProperty("InitiallyEnabled", Boolean.FALSE);
        this.btnStopDaemon.setMinimumSize(daemonButtonDimension);
        this.btnStopDaemon.setMaximumSize(daemonButtonDimension);
        this.btnStopDaemon.setAlignmentX(1.0f);
        this.btnStopDaemon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DaemonInstallationViewHelper.this.btnStopDaemon.setEnabled(false);
                DaemonInstallationViewHelper.this.labelDaemonStatus.setText(DaemonInstallationViewHelper.this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_DAEMONSTATUS_STOPPING));
                DaemonInstallationViewHelper.this.daemonControl.setDaemonEnabled(false);
                DaemonInstallationViewHelper.this.daemonControl.applyDesiredDaemonStatus();
                DaemonInstallationViewHelper.this.programInfo.updateDaemonStateStarted(false);
            }
        });
        daemonButtons.add(this.createHorizontalSpacing(5));
        daemonButtons.add(this.btnStopDaemon);
        daemonSection.add(this.createVerticalSpacing(10));
        daemonSection.add(daemonButtons);
        this.labelDaemonStatus = new JLabel();
        this.labelDaemonStatus.setName("Rtcp_Daemon_Status");
        daemonSection.add(this.createVerticalSpacing(10));
        daemonSection.add(this.labelDaemonStatus);
        return daemonSection;
    }

    public void updateDaemonSection() {
        DaemonContribution.State state = this.daemonControl.getDaemonState();
        String text = "";
        switch (state) {
            case RUNNING: {
                text = this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_DAEMONSTATUS_RUNNING);
                break;
            }
            case STOPPED: {
                text = this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_DAEMONSTATUS_STOPPED);
                break;
            }
            case ERROR: {
                text = this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_DAEMONSTATUS_FAILED);
            }
        }
        this.labelDaemonStatus.setText(text);
        if (state == DaemonContribution.State.RUNNING) {
            this.btnStartDaemon.setEnabled(false);
            this.btnStopDaemon.setEnabled(true);
        } else {
            this.btnStartDaemon.setEnabled(true);
            this.btnStopDaemon.setEnabled(false);
        }
    }

    private void updateText() {
        this.btnStartDaemon.setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_START));
        this.btnStopDaemon.setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_STOP));
        this.labelDaemonTitle.setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_CONTROLLERDAEMON));
        this.labelDaemonInstruction.setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_DAEMONINSTRUCTION));
        this.labelSelectApplication.setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_SELECTAPPLICATION));
        this.labelRemoteTcp.setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_REMOTETCP));
        this.labelRegularTcp.setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_REGULARTCP));
        this.btnRemoteTcpToolpath.setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_TOOLPATHMOVES));
        this.btnRemoteTcpOther.setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_LINEARCIRCULARMOVES));
        this.btnRegularTcpToolpath.setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_TOOLPATHMOVES));
    }

    public void updateView() {
        this.updateText();
        this.updateDaemonSection();
    }

    private String getHtmlText(RtcpConstants.Strings message) {
        return RtcpUtils.encloseWithHtml(this.localization.getLocalizedText(message));
    }
}

