/*
 * Decompiled with CFR 0.152.
 */
package com.energid.urcap.remotetcp.impl.InstallationNode;

import com.energid.urcap.remotetcp.impl.Common.RtcpConstants;
import com.energid.urcap.remotetcp.impl.Common.RtcpNamedPose;
import com.energid.urcap.remotetcp.impl.Common.RtcpNamedPoseManagerPanel;
import com.energid.urcap.remotetcp.impl.Common.RtcpUtils;
import com.energid.urcap.remotetcp.impl.Common.RtcpXmlRpcClient;
import com.energid.urcap.remotetcp.impl.Common.Style;
import com.energid.urcap.remotetcp.impl.InstallationNode.RtcpInstallationViewHelperBase;
import com.energid.urcap.remotetcp.impl.Interfaces.LocalizationInfo;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpNamedPoseInfo;
import com.energid.urcap.remotetcp.impl.RemoteTcpInstallationNodeView;
import com.ur.urcap.api.domain.feature.Feature;
import com.ur.urcap.api.domain.userinteraction.RobotPositionCallback;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardInputCallback;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardInputFactory;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardNumberInput;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.jointposition.JointPositions;
import com.ur.urcap.api.domain.value.simple.Angle;
import com.ur.urcap.api.domain.value.simple.Length;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class RtcpInstallationSetupViewHelper
extends RtcpInstallationViewHelperBase {
    private RtcpNamedPoseInfo rtcpHandler;
    private final JPanel tcpValuesPanel;
    private final JPanel tcpTeachPanel;
    private boolean positionPanelBuilt = false;
    private boolean teachPanelBuilt = false;
    private RtcpNamedPose currentTcp = null;
    private RtcpNamedPoseManagerPanel selectionHelper;
    private urTcpValueSectionHelper valueHelper;
    private urTcpTeachSectionHelper teachHelper;
    private boolean isTeachPanelActive = false;

    public RtcpInstallationSetupViewHelper(RtcpNamedPoseInfo rtcpHandler, LocalizationInfo localization, Style style, RemoteTcpInstallationNodeView.ViewContentSelector viewContentSelector) {
        super(localization, style);
        this.rtcpHandler = rtcpHandler;
        this.tcpValuesPanel = new JPanel();
        this.tcpTeachPanel = new JPanel();
        this.selectionHelper = new RtcpNamedPoseManagerPanel(rtcpHandler, localization, style, "Rtcp", new RtcpNamedPoseManagerPanel.NamedPoseChangeHandler(){

            @Override
            public void currentNamedPoseChanged(RtcpNamedPose currentNamedPose) {
                RtcpInstallationSetupViewHelper.this.currentTcp = currentNamedPose;
                RtcpInstallationSetupViewHelper.this.valueHelper.updateTcpValueFields();
                RtcpInstallationSetupViewHelper.this.valueHelper.updateFeatureSection();
            }
        });
        this.valueHelper = new urTcpValueSectionHelper();
        this.teachHelper = new urTcpTeachSectionHelper(viewContentSelector);
    }

    public JPanel createRtcpPanel() {
        JPanel rtcpPanel = new JPanel();
        rtcpPanel.setLayout(new GridLayout(0, 2));
        JPanel leftPanel = this.buildTcpValuesPanel();
        JPanel rightPanel = this.buildTeachPanel();
        rtcpPanel.add(leftPanel);
        rtcpPanel.add(rightPanel);
        return rtcpPanel;
    }

    private JPanel buildTcpValuesPanel() {
        return this.valueHelper.buildTcpValuesPanel();
    }

    private JPanel buildTeachPanel() {
        return this.teachHelper.buildTeachPanel();
    }

    public void updateView() {
        this.setPanelEnabled(this.tcpValuesPanel, !this.isTeachPanelActive);
        this.selectionHelper.updateView();
        this.valueHelper.updateView();
        this.teachHelper.updateView();
        this.selectionHelper.setEnabled(!this.isTeachPanelActive);
    }

    public void setKeyboardFactory(KeyboardInputFactory keyboardFactory) {
        this.selectionHelper.setKeyboardFactory(keyboardFactory);
        this.valueHelper.setKeyboardFactory(keyboardFactory);
    }

    private class urTcpTeachSectionHelper {
        private JointPositions[] teachJointPositions;
        private int currentTeachPoint = 0;
        private JLabel labelTeachPosition;
        private JLabel instructionPosition;
        private JButton teachPositionSetButton;
        private JButton teachPositionCancelButton;
        private JButton[] teachPositionButtons = new JButton[]{null, null, null, null};
        private Box tcpTeachPositionBox;
        private Box tcpTeachGraphicsBox;
        private final double mtomm = 1000.0;
        private JPanel teachContentPanel;
        private RemoteTcpInstallationNodeView.ViewContentSelector viewContentSelector;
        private JButton homeButton;
        private Icon rtcpConfigToolpathIcon;
        private Icon rtcpConfigLinearCircularIcon;
        private JLabel rtcpConfigIllustrationLabel;
        protected Dimension messageBoxSize = new Dimension(515, 40);

        public urTcpTeachSectionHelper(RemoteTcpInstallationNodeView.ViewContentSelector viewContentSelector) {
            this.viewContentSelector = viewContentSelector;
        }

        private void initializeTeachData() {
            this.teachJointPositions = new JointPositions[]{null, null, null, null, null};
            this.currentTeachPoint = 0;
            String btnText = RtcpInstallationSetupViewHelper.this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_SETPOINT);
            int index = 0;
            for (JButton btn : this.teachPositionButtons) {
                int btnNo = index++ + 1;
                btn.setText(btnText + " " + btnNo);
                btn.setEnabled(false);
                btn.putClientProperty("isSet", Boolean.FALSE);
                btn.setIcon(null);
            }
            this.teachPositionButtons[0].setEnabled(true);
            this.teachPositionSetButton.setEnabled(false);
            RtcpInstallationSetupViewHelper.this.errorCode = -1;
            this.updateView();
        }

        private void updateTeachPanel(Box content) {
            this.teachContentPanel.removeAll();
            this.teachContentPanel.add(content);
            this.teachContentPanel.revalidate();
            this.teachContentPanel.repaint();
        }

        public JPanel buildTeachPanel() {
            if (RtcpInstallationSetupViewHelper.this.teachPanelBuilt) {
                return RtcpInstallationSetupViewHelper.this.tcpTeachPanel;
            }
            RtcpInstallationSetupViewHelper.this.tcpTeachPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
            RtcpInstallationSetupViewHelper.this.tcpTeachPanel.setLayout(new BoxLayout(RtcpInstallationSetupViewHelper.this.tcpTeachPanel, 1));
            RtcpInstallationSetupViewHelper.this.tcpTeachPanel.setAlignmentY(0.0f);
            this.tcpTeachGraphicsBox = this.buildTeachGraphicsSection();
            this.tcpTeachPositionBox = this.buildTeachPositionSection();
            this.homeButton = new JButton();
            this.homeButton.setName("Home_Button");
            this.homeButton.setIcon(RtcpInstallationSetupViewHelper.this.homeIcon);
            this.homeButton.setAlignmentX(0.5f);
            this.homeButton.setAlignmentY(0.0f);
            this.homeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    urTcpTeachSectionHelper.this.viewContentSelector.setSelection(RemoteTcpInstallationNodeView.RtcpInstallationViewType.Home);
                }
            });
            Box titleBox = Box.createHorizontalBox();
            titleBox.setAlignmentX(0.0f);
            titleBox.setAlignmentY(0.0f);
            titleBox.add(Box.createHorizontalGlue());
            titleBox.add(this.homeButton);
            RtcpInstallationSetupViewHelper.this.tcpTeachPanel.add(titleBox);
            this.teachContentPanel = new JPanel();
            this.teachContentPanel.setLayout(new BoxLayout(this.teachContentPanel, 1));
            this.teachContentPanel.setAlignmentY(0.0f);
            this.teachContentPanel.setAlignmentX(0.5f);
            RtcpInstallationSetupViewHelper.this.tcpTeachPanel.add(this.teachContentPanel);
            this.teachContentPanel.add(this.tcpTeachGraphicsBox);
            RtcpInstallationSetupViewHelper.this.teachPanelBuilt = true;
            return RtcpInstallationSetupViewHelper.this.tcpTeachPanel;
        }

        private Box buildTeachPositionSection() {
            Box box = Box.createVerticalBox();
            box.setAlignmentY(0.0f);
            this.labelTeachPosition = new JLabel();
            this.labelTeachPosition.setFont(new Font(this.labelTeachPosition.getFont().getName(), 1, 20));
            this.labelTeachPosition.setHorizontalAlignment(0);
            this.labelTeachPosition.setAlignmentX(0.5f);
            this.labelTeachPosition.setAlignmentY(0.0f);
            box.add(RtcpInstallationSetupViewHelper.this.createVerticalSpacing(10));
            box.add(this.labelTeachPosition);
            Box messageBox = Box.createHorizontalBox();
            messageBox.setMinimumSize(this.messageBoxSize);
            messageBox.setMaximumSize(this.messageBoxSize);
            messageBox.setPreferredSize(this.messageBoxSize);
            RtcpInstallationSetupViewHelper.this.calculationMessage = new JLabel();
            RtcpInstallationSetupViewHelper.this.calculationMessage.setHorizontalAlignment(2);
            RtcpInstallationSetupViewHelper.this.calculationMessage.setAlignmentX(0.0f);
            RtcpInstallationSetupViewHelper.this.calculationMessage.setAlignmentY(0.0f);
            RtcpInstallationSetupViewHelper.this.calculationMessage.setName("Rtcp_Teach_Message");
            messageBox.add(RtcpInstallationSetupViewHelper.this.calculationMessage);
            messageBox.add(Box.createHorizontalGlue());
            box.add(RtcpInstallationSetupViewHelper.this.createVerticalSpacing(20));
            box.add(messageBox);
            Box instBox = Box.createHorizontalBox();
            instBox.setAlignmentX(0.5f);
            this.instructionPosition = new JLabel();
            this.instructionPosition.setHorizontalAlignment(2);
            this.instructionPosition.setAlignmentX(0.0f);
            this.instructionPosition.setAlignmentY(0.0f);
            instBox.add(this.instructionPosition);
            instBox.add(Box.createHorizontalGlue());
            box.add(instBox);
            box.add(RtcpInstallationSetupViewHelper.this.createVerticalSpacing(30));
            box.add(this.createPositionTeachButton(0));
            box.add(RtcpInstallationSetupViewHelper.this.createVerticalSpacing(20));
            box.add(this.createPositionTeachButton(1));
            box.add(RtcpInstallationSetupViewHelper.this.createVerticalSpacing(20));
            box.add(this.createPositionTeachButton(2));
            box.add(RtcpInstallationSetupViewHelper.this.createVerticalSpacing(20));
            box.add(this.createPositionTeachButton(3));
            box.add(RtcpInstallationSetupViewHelper.this.createVerticalSpacing(40));
            this.teachPositionButtons[0].setName("Rtcp_Set_Position_1");
            this.teachPositionButtons[1].setName("Rtcp_Set_Position_2");
            this.teachPositionButtons[2].setName("Rtcp_Set_Position_3");
            this.teachPositionButtons[3].setName("Rtcp_Set_Position_4");
            Box setAndCancel = Box.createHorizontalBox();
            setAndCancel.setAlignmentX(0.5f);
            this.teachPositionSetButton = new JButton();
            this.teachPositionSetButton.setIcon(RtcpInstallationSetupViewHelper.this.approveIcon);
            this.teachPositionSetButton.setName("Rtcp_Teach_Position_Set");
            this.teachPositionSetButton.setEnabled(false);
            this.teachPositionSetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    urTcpTeachSectionHelper.this.updatePositionFromCalculatedPose();
                }
            });
            setAndCancel.add(this.teachPositionSetButton);
            setAndCancel.add(RtcpInstallationSetupViewHelper.this.createHorizontalSpacing(10));
            this.teachPositionCancelButton = new JButton();
            this.teachPositionCancelButton.setIcon(RtcpInstallationSetupViewHelper.this.cancelIcon);
            this.teachPositionCancelButton.setName("Rtcp_Teach_Position_Cancel");
            this.teachPositionCancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    urTcpTeachSectionHelper.this.updateTeachPanel(urTcpTeachSectionHelper.this.tcpTeachGraphicsBox);
                    RtcpInstallationSetupViewHelper.this.setPanelEnabled(RtcpInstallationSetupViewHelper.this.tcpValuesPanel, true);
                    RtcpInstallationSetupViewHelper.this.selectionHelper.setEnabled(true);
                    RtcpInstallationSetupViewHelper.this.isTeachPanelActive = false;
                }
            });
            setAndCancel.add(this.teachPositionCancelButton);
            box.add(setAndCancel);
            return box;
        }

        private Box buildTeachGraphicsSection() {
            Box box = Box.createHorizontalBox();
            box.setAlignmentX(0.5f);
            box.setAlignmentY(0.0f);
            box.setPreferredSize(new Dimension(600, 600));
            Image img = null;
            try {
                img = ImageIO.read(this.getClass().getClassLoader().getResource("RTCPConfiguration-LinearandCircleMoves.png"));
                img = img.getScaledInstance(RtcpInstallationSetupViewHelper.this.style.getTeachpanelGraphicsWidth() - 150, -1, 4);
                this.rtcpConfigLinearCircularIcon = new ImageIcon(img);
                img = ImageIO.read(this.getClass().getClassLoader().getResource("RTCPConfiguration-Toolpath.png"));
                img = img.getScaledInstance(RtcpInstallationSetupViewHelper.this.style.getTeachpanelGraphicsWidth() - 150, -1, 4);
                this.rtcpConfigToolpathIcon = new ImageIcon(img);
            }
            catch (Exception e1) {
                System.out.println("non-fatal Exception loading installation node image");
            }
            this.rtcpConfigIllustrationLabel = new JLabel();
            this.rtcpConfigIllustrationLabel.setAlignmentX(0.5f);
            box.add(this.rtcpConfigIllustrationLabel);
            return box;
        }

        private Component createPositionTeachButton(final int pointID) {
            JButton btnSetPosition;
            this.teachPositionButtons[pointID] = btnSetPosition = new JButton();
            btnSetPosition.setAlignmentX(0.5f);
            btnSetPosition.setEnabled(this.currentTeachPoint >= pointID);
            btnSetPosition.putClientProperty("isSet", Boolean.FALSE);
            btnSetPosition.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RtcpInstallationSetupViewHelper.this.getApiProvider().getUserInterfaceAPI().getUserInteraction().getUserDefinedRobotPosition(new RobotPositionCallback(){

                        public void onOk(Pose notUsed, JointPositions q) {
                            ((urTcpTeachSectionHelper)urTcpTeachSectionHelper.this).teachJointPositions[pointID] = q;
                            Object property = btnSetPosition.getClientProperty("isSet");
                            if (property instanceof Boolean && (Boolean)property == Boolean.FALSE) {
                                urTcpTeachSectionHelper.this.currentTeachPoint++;
                            }
                            String btnText = RtcpInstallationSetupViewHelper.this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_MODIFYPOINT);
                            btnSetPosition.setText(btnText + " " + (pointID + 1));
                            btnSetPosition.putClientProperty("isSet", Boolean.TRUE);
                            btnSetPosition.setIcon(RtcpInstallationSetupViewHelper.this.iconOffLed);
                            if (urTcpTeachSectionHelper.this.currentTeachPoint <= 3) {
                                urTcpTeachSectionHelper.this.teachPositionButtons[urTcpTeachSectionHelper.this.currentTeachPoint].setEnabled(true);
                            }
                            if (urTcpTeachSectionHelper.this.currentTeachPoint > 3) {
                                Object retVal = RtcpXmlRpcClient.calculatePosition(new JointPositions[]{urTcpTeachSectionHelper.this.teachJointPositions[0], urTcpTeachSectionHelper.this.teachJointPositions[1], urTcpTeachSectionHelper.this.teachJointPositions[2], urTcpTeachSectionHelper.this.teachJointPositions[3]});
                                if (retVal != null) {
                                    Object[] values = (Object[])retVal;
                                    if (values.length == 3) {
                                        double[] poseArray = new double[]{(Double)values[0], (Double)values[1], (Double)values[2], 0.0, 0.0, 0.0};
                                        RtcpInstallationSetupViewHelper.this.calculatedPose = RtcpInstallationSetupViewHelper.this.apiProvider.getInstallationAPI().getValueFactoryProvider().getPoseFactory().createPose(poseArray[0], poseArray[1], poseArray[2], poseArray[3], poseArray[4], poseArray[5], Length.Unit.M, Angle.Unit.RAD);
                                        urTcpTeachSectionHelper.this.teachPositionSetButton.setEnabled(true);
                                        RtcpInstallationSetupViewHelper.this.errorCode = -1;
                                    } else {
                                        urTcpTeachSectionHelper.this.teachPositionSetButton.setEnabled(false);
                                        RtcpInstallationSetupViewHelper.this.errorCode = 0;
                                    }
                                } else {
                                    urTcpTeachSectionHelper.this.teachPositionSetButton.setEnabled(false);
                                    String errorMsg = RtcpXmlRpcClient.getLastError();
                                    RtcpInstallationSetupViewHelper.this.errorCode = 1;
                                    System.out.println("Error message from XMLRPC: " + errorMsg);
                                }
                                urTcpTeachSectionHelper.this.updateView();
                            }
                        }
                    });
                }
            });
            return btnSetPosition;
        }

        private void updatePositionFromCalculatedPose() {
            int[] poseIndices = new int[]{0, 1, 2};
            double[] newPoseValues = RtcpInstallationSetupViewHelper.this.calculatedPose.toArray(Length.Unit.MM, Angle.Unit.RAD);
            RtcpInstallationSetupViewHelper.this.setPanelEnabled(RtcpInstallationSetupViewHelper.this.tcpValuesPanel, true);
            RtcpInstallationSetupViewHelper.this.selectionHelper.setEnabled(true);
            RtcpInstallationSetupViewHelper.this.isTeachPanelActive = false;
            this.updateTeachPanel(this.tcpTeachGraphicsBox);
            RtcpInstallationSetupViewHelper.this.valueHelper.updateFeatureSection();
            Pose newPose = RtcpInstallationSetupViewHelper.this.valueHelper.updatePoseWithNewValues(RtcpInstallationSetupViewHelper.this.currentTcp.getPose(), newPoseValues, poseIndices);
            RtcpInstallationSetupViewHelper.this.currentTcp.setPose(newPose);
            RtcpInstallationSetupViewHelper.this.valueHelper.updateTcpValueFields();
            RtcpInstallationSetupViewHelper.this.rtcpHandler.updateDataModel();
        }

        public void updateView() {
            this.labelTeachPosition.setText(RtcpUtils.encloseWithHtml(RtcpInstallationSetupViewHelper.this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_TEACHPOSITION)));
            this.instructionPosition.setText(RtcpUtils.encloseWithHtml(RtcpInstallationSetupViewHelper.this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_INSTRUCTIONPOSITION)));
            this.teachPositionSetButton.setText(RtcpInstallationSetupViewHelper.this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_SET));
            this.teachPositionCancelButton.setText(RtcpInstallationSetupViewHelper.this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_CANCEL));
            RemoteTcpInstallationNodeView.RtcpInstallationViewType curViewType = this.viewContentSelector.getViewType();
            if (curViewType == RemoteTcpInstallationNodeView.RtcpInstallationViewType.RemoteTcpLinearCircular) {
                this.rtcpConfigIllustrationLabel.setIcon(this.rtcpConfigLinearCircularIcon);
            } else if (curViewType == RemoteTcpInstallationNodeView.RtcpInstallationViewType.RemoteTcpToolpath) {
                this.rtcpConfigIllustrationLabel.setIcon(this.rtcpConfigToolpathIcon);
            }
            this.updateCalculationMessage();
            this.updateButtonStates();
        }

        private void updateButtonStates() {
            if (this.currentTeachPoint > 3) {
                if (RtcpInstallationSetupViewHelper.this.errorCode >= 0) {
                    this.teachPositionButtons[0].setIcon(RtcpInstallationSetupViewHelper.this.iconOffLed);
                    this.teachPositionButtons[1].setIcon(RtcpInstallationSetupViewHelper.this.iconOffLed);
                    this.teachPositionButtons[2].setIcon(RtcpInstallationSetupViewHelper.this.iconOffLed);
                    this.teachPositionButtons[3].setIcon(RtcpInstallationSetupViewHelper.this.iconOffLed);
                } else {
                    this.teachPositionButtons[0].setIcon(RtcpInstallationSetupViewHelper.this.iconGreenLed);
                    this.teachPositionButtons[1].setIcon(RtcpInstallationSetupViewHelper.this.iconGreenLed);
                    this.teachPositionButtons[2].setIcon(RtcpInstallationSetupViewHelper.this.iconGreenLed);
                    this.teachPositionButtons[3].setIcon(RtcpInstallationSetupViewHelper.this.iconGreenLed);
                }
            }
        }

        private void updateCalculationMessage() {
            if (this.currentTeachPoint <= 3) {
                RtcpInstallationSetupViewHelper.this.calculationMessage.setIcon(RtcpInstallationSetupViewHelper.this.iconOffLed);
                RtcpInstallationSetupViewHelper.this.calculationMessage.setText(RtcpInstallationSetupViewHelper.this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_TEACHPOSITION_MOREPOINTS));
                return;
            }
            if (RtcpInstallationSetupViewHelper.this.errorCode >= 0) {
                RtcpInstallationSetupViewHelper.this.calculationMessage.setIcon(RtcpInstallationSetupViewHelper.this.iconRedLed);
                String message = "Unknown error";
                if (RtcpInstallationSetupViewHelper.this.errorCode == 0) {
                    message = RtcpInstallationSetupViewHelper.this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_TEACHPOSITION_ERROR);
                } else if (RtcpInstallationSetupViewHelper.this.errorCode == 1) {
                    message = RtcpInstallationSetupViewHelper.this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_TEACHPOSITION_UNKNOWN_ERROR);
                }
                RtcpInstallationSetupViewHelper.this.calculationMessage.setText(message);
            } else if (RtcpInstallationSetupViewHelper.this.calculatedPose != null) {
                RtcpInstallationSetupViewHelper.this.calculationMessage.setIcon(RtcpInstallationSetupViewHelper.this.iconGreenLed);
                String message = RtcpInstallationSetupViewHelper.this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_CALCULATEDRTCPPOSITION) + ": " + RtcpUtils.getPositionString(RtcpInstallationSetupViewHelper.this.calculatedPose, RtcpInstallationSetupViewHelper.this.localization.getSystemLengthUnit(), RtcpInstallationSetupViewHelper.this.localization.getLocalizedLengthUnit());
                RtcpInstallationSetupViewHelper.this.calculationMessage.setText(RtcpUtils.encloseWithHtml(message));
            } else {
                RtcpInstallationSetupViewHelper.this.calculationMessage.setIcon(null);
                RtcpInstallationSetupViewHelper.this.calculationMessage.setText(" ");
            }
        }
    }

    private class urTcpValueSectionHelper {
        private JLabel labelTitle = null;
        private JLabel labelOrientation = null;
        private JLabel labelPosition = null;
        private JLabel labelDescription = null;
        private JLabel labelPositionInstruction = null;
        private JComboBox featureSelectionCombo = null;
        private JLabel featureLabel = null;
        private JTextField xField = null;
        private JTextField yField = null;
        private JTextField zField = null;
        private JTextField rxField = null;
        private JTextField ryField = null;
        private JTextField rzField = null;
        private KeyboardInputFactory keyboardFactory;
        private final String[] poseLabels = new String[]{"X", "Y", "Z", "RX", "RY", "RZ"};
        private JLabel[] poseUnitLabels;
        private final DecimalFormat[] poseFormats;
        private JButton btnTeachPosition = null;
        private Vector<Feature> features = null;
        private Dimension wizardLabelSize = new Dimension(281, 35);

        public urTcpValueSectionHelper() {
            this.setKeyboardFactory(this.keyboardFactory);
            DecimalFormat formatterOrientation = new DecimalFormat("#0.0000");
            DecimalFormat formatterPosition = new DecimalFormat("##0.00");
            this.poseFormats = new DecimalFormat[]{formatterPosition, formatterPosition, formatterPosition, formatterOrientation, formatterOrientation, formatterOrientation};
        }

        public JPanel buildTcpValuesPanel() {
            if (RtcpInstallationSetupViewHelper.this.positionPanelBuilt) {
                return RtcpInstallationSetupViewHelper.this.tcpValuesPanel;
            }
            RtcpInstallationSetupViewHelper.this.tcpValuesPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 5, RtcpInstallationSetupViewHelper.this.style.getLightGray2()));
            RtcpInstallationSetupViewHelper.this.tcpValuesPanel.setLayout(new BoxLayout(RtcpInstallationSetupViewHelper.this.tcpValuesPanel, 1));
            RtcpInstallationSetupViewHelper.this.tcpValuesPanel.setAlignmentY(0.0f);
            JPanel innerPanel = new JPanel();
            innerPanel.setBorder(new EmptyBorder(10, 5, 10, 10));
            innerPanel.setLayout(new BoxLayout(innerPanel, 1));
            innerPanel.setAlignmentY(0.0f);
            this.labelTitle = new JLabel();
            this.labelTitle.setFont(new Font(this.labelTitle.getFont().getName(), 1, 20));
            this.labelTitle.setHorizontalAlignment(2);
            this.labelTitle.setAlignmentX(0.0f);
            this.labelTitle.setAlignmentY(0.0f);
            innerPanel.add(this.labelTitle);
            this.labelDescription = new JLabel();
            this.labelDescription.setHorizontalAlignment(2);
            this.labelDescription.setAlignmentX(0.0f);
            this.labelDescription.setAlignmentY(0.0f);
            innerPanel.add(RtcpInstallationSetupViewHelper.this.createVerticalSpacing(5));
            innerPanel.add(this.labelDescription);
            innerPanel.add(RtcpInstallationSetupViewHelper.this.createVerticalSpacing(10));
            Component tcpSelectionSection = RtcpInstallationSetupViewHelper.this.selectionHelper.buildNamedPoseSelectionSection();
            Component tcpValuesSection = this.buildTcpValuesSection();
            innerPanel.add(tcpSelectionSection);
            innerPanel.add(RtcpInstallationSetupViewHelper.this.createVerticalSpacing(25));
            innerPanel.add(tcpValuesSection);
            RtcpInstallationSetupViewHelper.this.tcpValuesPanel.add(innerPanel);
            RtcpInstallationSetupViewHelper.this.positionPanelBuilt = true;
            return RtcpInstallationSetupViewHelper.this.tcpValuesPanel;
        }

        private Component createFeatureSection() {
            JComboBox featureCombo;
            Box featureSection = Box.createHorizontalBox();
            featureSection.setAlignmentX(0.0f);
            this.featureLabel = new JLabel();
            this.featureLabel.setName("Rtcp_Feature_Label");
            this.featureLabel.setPreferredSize(this.wizardLabelSize);
            this.featureLabel.setMinimumSize(this.wizardLabelSize);
            this.featureLabel.setMaximumSize(this.wizardLabelSize);
            this.featureLabel.setHorizontalAlignment(2);
            this.featureLabel.setAlignmentX(0.0f);
            this.featureLabel.setAlignmentY(0.5f);
            featureSection.add(this.featureLabel);
            this.featureSelectionCombo = featureCombo = new JComboBox();
            featureCombo.setName("Rtcp_Feature_Selection");
            featureCombo.setAlignmentX(1.0f);
            featureCombo.setEditable(false);
            featureCombo.setMaximumSize(RtcpInstallationSetupViewHelper.this.style.getSelectionComboboxSize());
            featureCombo.setPreferredSize(RtcpInstallationSetupViewHelper.this.style.getSelectionComboboxSize());
            ((JLabel)((Object)featureCombo.getRenderer())).setHorizontalAlignment(2);
            featureCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (featureCombo.getSelectedIndex() != 0) {
                        String featureName = featureCombo.getSelectedItem().toString();
                        for (Feature feature : urTcpValueSectionHelper.this.features) {
                            if (!feature.getName().equals(featureName)) continue;
                            Pose pose = feature.getPose();
                            double[] poseArray = pose.toArray(Length.Unit.MM, Angle.Unit.RAD);
                            int[] poseIndices = new int[]{3, 4, 5};
                            Pose newPose = RtcpInstallationSetupViewHelper.this.valueHelper.updatePoseWithNewValues(RtcpInstallationSetupViewHelper.this.currentTcp.getPose(), new double[]{poseArray[3], poseArray[4], poseArray[5]}, poseIndices);
                            RtcpInstallationSetupViewHelper.this.currentTcp.setPose(newPose);
                            RtcpInstallationSetupViewHelper.this.valueHelper.updateTcpValueFields();
                            RtcpInstallationSetupViewHelper.this.rtcpHandler.updateDataModel();
                        }
                    }
                }
            });
            featureSection.add(RtcpInstallationSetupViewHelper.this.createHorizontalSpacing(10));
            featureSection.add(this.featureSelectionCombo);
            return featureSection;
        }

        private Component buildTcpValuesSection() {
            Box tcpValues = Box.createVerticalBox();
            tcpValues.setAlignmentX(0.0f);
            this.poseUnitLabels = new JLabel[6];
            this.buildPositionSection(tcpValues);
            tcpValues.add(RtcpInstallationSetupViewHelper.this.createVerticalSpacing(30));
            this.buildOrientationSection(tcpValues);
            return tcpValues;
        }

        private void buildOrientationSection(Box tcpValues) {
            this.labelOrientation = new JLabel();
            tcpValues.add(this.labelOrientation);
            tcpValues.add(RtcpInstallationSetupViewHelper.this.createVerticalSpacing(5));
            tcpValues.add(this.createFeatureSection());
            this.rxField = this.createTcpValueTextField(3);
            this.rxField.setName("Rtcp_Pos_RX");
            this.ryField = this.createTcpValueTextField(4);
            this.ryField.setName("Rtcp_Pos_RY");
            this.rzField = this.createTcpValueTextField(5);
            this.rzField.setName("Rtcp_Pos_RZ");
            tcpValues.add(RtcpInstallationSetupViewHelper.this.createVerticalSpacing(10));
            tcpValues.add(this.buildTcpValueStrip(3, this.rxField));
            tcpValues.add(RtcpInstallationSetupViewHelper.this.createVerticalSpacing(5));
            tcpValues.add(this.buildTcpValueStrip(4, this.ryField));
            tcpValues.add(RtcpInstallationSetupViewHelper.this.createVerticalSpacing(5));
            tcpValues.add(this.buildTcpValueStrip(5, this.rzField));
        }

        private void buildPositionSection(Box tcpValues) {
            this.labelPosition = new JLabel();
            tcpValues.add(this.labelPosition);
            Box positionInstructionBox = Box.createHorizontalBox();
            positionInstructionBox.setAlignmentX(0.0f);
            this.labelPositionInstruction = new JLabel();
            this.labelPositionInstruction.setHorizontalAlignment(2);
            this.labelPositionInstruction.setAlignmentX(0.0f);
            this.labelPositionInstruction.setAlignmentY(0.5f);
            this.labelPositionInstruction.setPreferredSize(this.wizardLabelSize);
            this.labelPositionInstruction.setMinimumSize(this.wizardLabelSize);
            this.labelPositionInstruction.setMaximumSize(this.wizardLabelSize);
            positionInstructionBox.add(this.labelPositionInstruction);
            this.btnTeachPosition = new JButton();
            this.btnTeachPosition.setIcon(RtcpInstallationSetupViewHelper.this.teachWizardIcon);
            this.btnTeachPosition.setName("Rtcp_Teach_Position");
            this.btnTeachPosition.setMaximumSize(RtcpInstallationSetupViewHelper.this.style.getWizardButtonSize());
            this.btnTeachPosition.setPreferredSize(RtcpInstallationSetupViewHelper.this.style.getWizardButtonSize());
            this.btnTeachPosition.setAlignmentX(1.0f);
            this.btnTeachPosition.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!RtcpInstallationSetupViewHelper.this.canTeachProceed()) {
                        return;
                    }
                    RtcpInstallationSetupViewHelper.this.teachHelper.updateTeachPanel(RtcpInstallationSetupViewHelper.this.teachHelper.tcpTeachPositionBox);
                    RtcpInstallationSetupViewHelper.this.setPanelEnabled(RtcpInstallationSetupViewHelper.this.tcpValuesPanel, false);
                    RtcpInstallationSetupViewHelper.this.selectionHelper.setEnabled(false);
                    RtcpInstallationSetupViewHelper.this.isTeachPanelActive = true;
                    RtcpInstallationSetupViewHelper.this.teachHelper.initializeTeachData();
                }
            });
            positionInstructionBox.add(RtcpInstallationSetupViewHelper.this.createHorizontalSpacing(10));
            positionInstructionBox.add(this.btnTeachPosition);
            tcpValues.add(RtcpInstallationSetupViewHelper.this.createVerticalSpacing(5));
            tcpValues.add(positionInstructionBox);
            this.xField = this.createTcpValueTextField(0);
            this.xField.setName("Rtcp_Pos_X");
            this.yField = this.createTcpValueTextField(1);
            this.yField.setName("Rtcp_Pos_Y");
            this.zField = this.createTcpValueTextField(2);
            this.zField.setName("Rtcp_Pos_Z");
            tcpValues.add(RtcpInstallationSetupViewHelper.this.createVerticalSpacing(10));
            tcpValues.add(this.buildTcpValueStrip(0, this.xField));
            tcpValues.add(RtcpInstallationSetupViewHelper.this.createVerticalSpacing(5));
            tcpValues.add(this.buildTcpValueStrip(1, this.yField));
            tcpValues.add(RtcpInstallationSetupViewHelper.this.createVerticalSpacing(5));
            tcpValues.add(this.buildTcpValueStrip(2, this.zField));
        }

        private JTextField createTcpValueTextField(final int poseIndex) {
            final JTextField field = new JTextField();
            field.setHorizontalAlignment(4);
            field.setFocusable(false);
            field.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (field.isEnabled()) {
                        urTcpValueSectionHelper.this.tcpValueFieldHandler(field, poseIndex);
                    }
                }
            });
            return field;
        }

        protected void tcpValueFieldHandler(JTextField field, int poseIndex) {
            KeyboardNumberInput<Double> keyboardInput = this.getKeyboardForNumberField();
            double initialValue = RtcpInstallationSetupViewHelper.this.localization.parseForLocalizedValue(field.getText());
            keyboardInput.setInitialValue((Object)initialValue);
            keyboardInput.show(field, this.getKeyboardCallbackForTcpValue(field, poseIndex));
        }

        private Component buildTcpValueStrip(int poseIndex, JTextField textField) {
            Box valueStrip = Box.createHorizontalBox();
            valueStrip.setAlignmentX(0.0f);
            JLabel labelName = new JLabel(this.poseLabels[poseIndex]);
            labelName.setMaximumSize(new Dimension(30, 30));
            labelName.setMinimumSize(new Dimension(30, 30));
            labelName.setPreferredSize(new Dimension(30, 30));
            valueStrip.add(labelName);
            valueStrip.add(RtcpInstallationSetupViewHelper.this.createHorizontalSpacing());
            textField.setMinimumSize(new Dimension(150, 30));
            textField.setMaximumSize(new Dimension(150, 30));
            textField.setPreferredSize(new Dimension(150, 30));
            valueStrip.add(textField);
            valueStrip.add(RtcpInstallationSetupViewHelper.this.createHorizontalSpacing());
            this.poseUnitLabels[poseIndex] = new JLabel();
            this.poseUnitLabels[poseIndex].setName("Rtcp_Unit_" + (poseIndex + 1));
            valueStrip.add(this.poseUnitLabels[poseIndex]);
            return valueStrip;
        }

        private void updateTcpValueFields() {
            double[] values = RtcpInstallationSetupViewHelper.this.currentTcp.getPose().toArray(Length.Unit.MM, Angle.Unit.RAD);
            double xVal = RtcpInstallationSetupViewHelper.this.localization.getConvertedLengthForDisplay(values[0]);
            double yVal = RtcpInstallationSetupViewHelper.this.localization.getConvertedLengthForDisplay(values[1]);
            double zVal = RtcpInstallationSetupViewHelper.this.localization.getConvertedLengthForDisplay(values[2]);
            this.xField.setText(this.poseFormats[0].format(xVal));
            this.yField.setText(this.poseFormats[1].format(yVal));
            this.zField.setText(this.poseFormats[2].format(zVal));
            this.rxField.setText(this.poseFormats[3].format(values[3]));
            this.ryField.setText(this.poseFormats[4].format(values[4]));
            this.rzField.setText(this.poseFormats[5].format(values[5]));
        }

        private KeyboardNumberInput<Double> getKeyboardForNumberField() {
            KeyboardNumberInput keyboardInput = this.getKeyboardFactory().createDoubleKeypadInput();
            return keyboardInput;
        }

        private KeyboardInputCallback<Double> getKeyboardCallbackForTcpValue(final JTextField field, final int poseIndex) {
            return new KeyboardInputCallback<Double>(){

                public void onOk(Double value) {
                    field.setText(urTcpValueSectionHelper.this.poseFormats[poseIndex].format(value));
                    double internalVal = value;
                    if (poseIndex < 3) {
                        internalVal = RtcpInstallationSetupViewHelper.this.localization.getConvertedLengthForStorage(value);
                    }
                    Pose updatedPose = urTcpValueSectionHelper.this.updatePoseWithNewValues(RtcpInstallationSetupViewHelper.this.currentTcp.getPose(), new double[]{internalVal}, new int[]{poseIndex});
                    RtcpInstallationSetupViewHelper.this.currentTcp.setPose(updatedPose);
                    RtcpInstallationSetupViewHelper.this.rtcpHandler.updateDataModel();
                }
            };
        }

        private Pose updatePoseWithNewValues(Pose pose, double[] values, int[] poseIndices) {
            double[] poseArray = pose.toArray(Length.Unit.MM, Angle.Unit.RAD);
            int index = 0;
            for (int poseIndex : poseIndices) {
                poseArray[poseIndex] = values[index++];
            }
            Pose updatedPose = RtcpInstallationSetupViewHelper.this.poseFactory.createPose(poseArray[0], poseArray[1], poseArray[2], poseArray[3], poseArray[4], poseArray[5], Length.Unit.MM, Angle.Unit.RAD);
            return updatedPose;
        }

        private KeyboardInputFactory getKeyboardFactory() {
            return this.keyboardFactory;
        }

        public void setKeyboardFactory(KeyboardInputFactory keyboardFactory) {
            this.keyboardFactory = keyboardFactory;
        }

        public void updateView() {
            this.updateTcpValueFields();
            this.updateText();
            this.updateFeatureSection();
        }

        private void updateText() {
            this.labelTitle.setText(RtcpInstallationSetupViewHelper.this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_TITLE));
            this.labelOrientation.setText(RtcpInstallationSetupViewHelper.this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_ORIENTATION));
            this.labelPosition.setText(RtcpInstallationSetupViewHelper.this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_POSITION));
            this.labelPositionInstruction.setText(RtcpUtils.encloseWithHtml(RtcpInstallationSetupViewHelper.this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_POSITIONINSTRUCTION)));
            this.labelDescription.setText(RtcpInstallationSetupViewHelper.this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_DESCRIPTION));
            this.featureLabel.setText(RtcpUtils.encloseWithHtml(RtcpInstallationSetupViewHelper.this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_COPYFEATURE)));
            this.btnTeachPosition.setText(RtcpInstallationSetupViewHelper.this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_WIZARD));
            this.poseUnitLabels[0].setText(RtcpInstallationSetupViewHelper.this.localization.getLocalizedLengthUnit());
            this.poseUnitLabels[1].setText(this.poseUnitLabels[0].getText());
            this.poseUnitLabels[2].setText(this.poseUnitLabels[0].getText());
            this.poseUnitLabels[3].setText("rad");
            this.poseUnitLabels[4].setText(this.poseUnitLabels[3].getText());
            this.poseUnitLabels[5].setText(this.poseUnitLabels[3].getText());
        }

        public void updateFeatureSection() {
            this.features = new Vector();
            this.features.addAll(RtcpInstallationSetupViewHelper.this.programInfo.getPointFeatures());
            this.features.addAll(RtcpInstallationSetupViewHelper.this.programInfo.getPlaneFeatures());
            if (RtcpInstallationSetupViewHelper.this.isTeachPanelActive || this.features == null || this.features.isEmpty()) {
                this.featureLabel.setEnabled(false);
                this.featureSelectionCombo.setEnabled(false);
            } else {
                this.featureLabel.setEnabled(true);
                this.featureSelectionCombo.setEnabled(true);
                String[] featureNames = new String[this.features.size() + 1];
                featureNames[0] = RtcpInstallationSetupViewHelper.this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_SELECTFEATURE);
                int index = 1;
                for (Feature feature : this.features) {
                    featureNames[index++] = feature.getName();
                }
                this.featureSelectionCombo.setModel(new DefaultComboBoxModel<String>(featureNames));
            }
        }
    }
}

