/*
 * Decompiled with CFR 0.152.
 */
package com.energid.urcap.remotetcp.impl.InstallationNode;

import com.energid.urcap.remotetcp.impl.Common.RtcpConstants;
import com.energid.urcap.remotetcp.impl.Common.RtcpUtils;
import com.energid.urcap.remotetcp.impl.Common.Style;
import com.energid.urcap.remotetcp.impl.Interfaces.LocalizationInfo;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpDaemonControl;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpProgramInfo;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpRobotInfo;
import com.ur.urcap.api.contribution.DaemonContribution;
import com.ur.urcap.api.contribution.installation.InstallationAPIProvider;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.PoseFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class RtcpInstallationViewHelperBase {
    protected InstallationAPIProvider apiProvider;
    protected PoseFactory poseFactory;
    protected RtcpDaemonControl daemonControl;
    protected RtcpRobotInfo robotInfo;
    protected RtcpProgramInfo programInfo;
    protected LocalizationInfo localization;
    protected JLabel calculationMessage;
    protected Pose calculatedPose = null;
    protected int errorCode = -1;
    protected final Style style;
    protected Icon approveIcon = null;
    protected Icon cancelIcon = null;
    protected Icon teachWizardIcon = null;
    protected Icon homeIcon = null;
    protected Icon iconEmptyLed;
    protected Icon iconOffLed;
    protected Icon iconGreenLed;
    protected Icon iconRedLed;

    public RtcpInstallationViewHelperBase(LocalizationInfo localization, Style style) {
        this.style = style;
        this.localization = localization;
        this.daemonControl = (RtcpDaemonControl)((Object)localization);
        this.robotInfo = (RtcpRobotInfo)((Object)localization);
        this.programInfo = (RtcpProgramInfo)((Object)localization);
        this.approveIcon = this.getScaledIconResource("approve.png", style.getSelectionIconSize(), style.getSelectionIconSize());
        this.cancelIcon = this.getScaledIconResource("cancel.png", style.getSelectionIconSize(), style.getSelectionIconSize());
        this.teachWizardIcon = this.getIconResource("wizard_icon.png");
        this.iconEmptyLed = this.getIconResource("G5_led_empty.png");
        this.iconOffLed = this.getIconResource("G5_led_off.png");
        this.iconGreenLed = this.getIconResource("G5_led_green.png");
        this.iconRedLed = this.getIconResource("G5_led_red.png");
        this.homeIcon = this.getScaledIconResource("home.png", 20, 20);
    }

    protected InstallationAPIProvider getApiProvider() {
        return this.apiProvider;
    }

    public void setApiProvider(InstallationAPIProvider apiProvider) {
        this.apiProvider = apiProvider;
        this.poseFactory = apiProvider.getInstallationAPI().getValueFactoryProvider().getPoseFactory();
    }

    protected Component createHorizontalSpacing() {
        return Box.createRigidArea(new Dimension(this.style.getHorizontalSpacing(), 0));
    }

    protected Component createHorizontalSpacing(int spacing) {
        return Box.createRigidArea(new Dimension(spacing, 0));
    }

    protected Component createVerticalSpacing() {
        return Box.createRigidArea(new Dimension(0, this.style.getVerticalSpacing()));
    }

    protected Component createVerticalSpacing(int spacing) {
        return Box.createRigidArea(new Dimension(0, spacing));
    }

    public Icon getIconResource(String resourceName) {
        ImageIcon icon = null;
        try {
            BufferedImage img = null;
            img = ImageIO.read(this.getClass().getClassLoader().getResource(resourceName));
            icon = new ImageIcon(img);
            return icon;
        }
        catch (Exception e1) {
            System.out.println("Exception loading icon resource " + resourceName);
            return null;
        }
    }

    public Icon getScaledIconResource(String resourceName, int x, int y) {
        ImageIcon icon = null;
        try {
            Image img = null;
            img = ImageIO.read(this.getClass().getClassLoader().getResource(resourceName));
            img = img.getScaledInstance(x, y, 4);
            icon = new ImageIcon(img);
            return icon;
        }
        catch (Exception e1) {
            System.out.println("Exception loading icon resource " + resourceName);
            return null;
        }
    }

    protected boolean canTeachProceed() {
        if (this.checkAndReportRobotPower()) {
            return this.checkAndReportDaemonStatus();
        }
        return false;
    }

    protected boolean checkAndReportRobotPower() {
        if (!this.robotInfo.isPowerOn()) {
            JOptionPane.showMessageDialog(null, RtcpUtils.encloseWithHtml(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_POWEROFF_MESSAGE)), this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_WARNING_TITLE), 2);
            return false;
        }
        return true;
    }

    protected boolean checkAndReportDaemonStatus() {
        if (this.daemonControl.getDaemonDesiredState() != DaemonContribution.State.RUNNING || !this.daemonControl.isServerReachable()) {
            JOptionPane.showMessageDialog(null, RtcpUtils.encloseWithHtml(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_ERROR_DAEMONSTOPPED)), this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_WARNING_TITLE), 2);
            return false;
        }
        return true;
    }

    protected void setPanelEnabled(JPanel panel, Boolean isEnabled) {
        Component[] components;
        panel.setEnabled(isEnabled);
        for (Component component : components = panel.getComponents()) {
            if (component instanceof JPanel) {
                this.setPanelEnabled((JPanel)component, isEnabled);
                continue;
            }
            if (component instanceof Box) {
                this.setBoxEnabled((Box)component, isEnabled);
                continue;
            }
            component.setEnabled(isEnabled);
        }
    }

    protected void setBoxEnabled(Box box, Boolean isEnabled) {
        Component[] components;
        box.setEnabled(isEnabled);
        for (Component component : components = box.getComponents()) {
            if (component instanceof JPanel) {
                this.setPanelEnabled((JPanel)component, isEnabled);
                continue;
            }
            if (component instanceof Box) {
                this.setBoxEnabled((Box)component, isEnabled);
                continue;
            }
            component.setEnabled(isEnabled);
        }
    }
}

