/*
 * Decompiled with CFR 0.152.
 */
package com.energid.urcap.remotetcp.impl.InstallationNode;

import com.energid.urcap.remotetcp.impl.Common.RtcpConstants;
import com.energid.urcap.remotetcp.impl.Common.RtcpNamedPose;
import com.energid.urcap.remotetcp.impl.Common.RtcpPoseValuePanel;
import com.energid.urcap.remotetcp.impl.Common.Style;
import com.energid.urcap.remotetcp.impl.InstallationNode.RtcpInstallationViewHelperBase;
import com.energid.urcap.remotetcp.impl.InstallationNode.RtcpPcsTeachMethod2;
import com.energid.urcap.remotetcp.impl.Interfaces.LocalizationInfo;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpNamedPoseInfo;
import com.ur.urcap.api.contribution.installation.InstallationAPIProvider;
import com.ur.urcap.api.domain.value.Pose;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;

public class RtcpPcsCoordinateEntry
extends RtcpInstallationViewHelperBase
implements RtcpNamedPoseInfo {
    private RtcpPoseValuePanel poseValuePanel;
    private JLabel referenceTitle;
    private JLabel coordTitle;
    private JButton buttonSet;
    private JButton buttonCancel;
    private Box coordinateEntryBox;
    private RtcpNamedPose pose;
    private RtcpConstants.Strings referenceString;
    private RtcpPcsTeachMethod2.SetCancelHandler setcancelHandler;

    public RtcpPcsCoordinateEntry(LocalizationInfo localization, Style style) {
        super(localization, style);
        this.poseValuePanel = new RtcpPoseValuePanel(this, style, "PcsCoordinates");
        this.poseValuePanel.createPositionSection();
        this.poseValuePanel.createOrientationSection();
    }

    @Override
    public void setApiProvider(InstallationAPIProvider apiProvider) {
        super.setApiProvider(apiProvider);
        this.poseValuePanel.setApiProvider(apiProvider, this.localization);
    }

    public void updateView() {
        this.updateText();
        if (this.pose != null) {
            this.poseValuePanel.updatePanel(this.pose);
        }
    }

    protected void updateText() {
        if (this.coordinateEntryBox != null) {
            this.coordTitle.setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_PCS_TITLE_COORDINATES));
            this.referenceTitle.setText(this.localization.getLocalizedText(this.referenceString));
            this.buttonSet.setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_SET));
            this.buttonCancel.setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_CANCEL));
        }
    }

    public Box createCoordinateEntry(RtcpNamedPose pose, RtcpConstants.Strings referenceString, RtcpPcsTeachMethod2.SetCancelHandler setcancelHandler) {
        this.pose = pose;
        this.referenceString = referenceString;
        this.setcancelHandler = setcancelHandler;
        if (this.coordinateEntryBox == null) {
            this.createCoordinateBox();
        }
        return this.coordinateEntryBox;
    }

    protected void createCoordinateBox() {
        Box main = Box.createVerticalBox();
        this.referenceTitle = new JLabel();
        this.referenceTitle.setFont(new Font(this.referenceTitle.getFont().getName(), 1, 20));
        this.referenceTitle.setHorizontalAlignment(0);
        this.referenceTitle.setAlignmentX(0.5f);
        this.referenceTitle.setAlignmentY(0.0f);
        main.add(this.createVerticalSpacing(50));
        main.add(this.referenceTitle);
        this.coordTitle = new JLabel();
        this.coordTitle.setFont(new Font(this.coordTitle.getFont().getName(), 1, 16));
        this.coordTitle.setHorizontalAlignment(0);
        this.coordTitle.setAlignmentX(0.5f);
        this.coordTitle.setAlignmentY(0.0f);
        main.add(this.createVerticalSpacing(10));
        main.add(this.coordTitle);
        main.add(this.createVerticalSpacing(30));
        Box coords = Box.createHorizontalBox();
        coords.setAlignmentX(0.5f);
        coords.add(this.poseValuePanel.createPositionSection());
        main.add(coords);
        main.add(this.createVerticalSpacing(30));
        main.add(this.createSetCancel());
        this.coordinateEntryBox = main;
    }

    protected Box createSetCancel() {
        Box setAndCancel = Box.createHorizontalBox();
        setAndCancel.setAlignmentX(0.5f);
        this.buttonSet = new JButton();
        this.buttonSet.setIcon(this.approveIcon);
        this.buttonSet.setName("Pcs_Coordinate_Set");
        this.buttonSet.setEnabled(true);
        this.buttonSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RtcpPcsCoordinateEntry.this.setcancelHandler.handleSet();
            }
        });
        setAndCancel.add(this.buttonSet);
        setAndCancel.add(this.createHorizontalSpacing(10));
        this.buttonCancel = new JButton();
        this.buttonCancel.setIcon(this.cancelIcon);
        this.buttonCancel.setName("Pcs_Coordinate_Cancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RtcpPcsCoordinateEntry.this.setcancelHandler.handleCancel();
            }
        });
        setAndCancel.add(this.buttonCancel);
        return setAndCancel;
    }

    @Override
    public void initialize() {
    }

    @Override
    public String[] getAvailablePoses() {
        return null;
    }

    @Override
    public RtcpNamedPose getNamedPoseById(String id) {
        return null;
    }

    @Override
    public String getDefaultNamedPose() {
        return null;
    }

    @Override
    public boolean setDefaultNamedPose(String name) {
        return false;
    }

    @Override
    public void updateDataModel() {
    }

    @Override
    public String createNewNamedPose() {
        return null;
    }

    @Override
    public boolean deleteNamedPose(String name) {
        return false;
    }

    @Override
    public boolean isNameDuplicate(String name) {
        return false;
    }

    @Override
    public void updatePoseName(String oldName, String newName) {
    }

    @Override
    public RtcpNamedPose addNamedPose(String name, Pose pose) {
        return null;
    }
}

