/*
 * Decompiled with CFR 0.152.
 */
package com.energid.urcap.remotetcp.impl.InstallationNode;

import com.energid.urcap.remotetcp.impl.Common.RtcpConstants;
import com.energid.urcap.remotetcp.impl.Common.RtcpNamedPose;
import com.energid.urcap.remotetcp.impl.Common.RtcpNamedPoseManagerPanel;
import com.energid.urcap.remotetcp.impl.Common.RtcpPoseValuePanel;
import com.energid.urcap.remotetcp.impl.Common.Style;
import com.energid.urcap.remotetcp.impl.InstallationNode.RtcpInstallationViewHelperBase;
import com.energid.urcap.remotetcp.impl.InstallationNode.RtcpPcsTeachPanel;
import com.energid.urcap.remotetcp.impl.Interfaces.LocalizationInfo;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpNamedPoseInfo;
import com.energid.urcap.remotetcp.impl.RemoteTcpInstallationNodeView;
import com.ur.urcap.api.contribution.installation.InstallationAPIProvider;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardInputFactory;
import com.ur.urcap.api.domain.value.Pose;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class RtcpPcsInstallationViewHelper
extends RtcpInstallationViewHelperBase {
    private RtcpNamedPoseInfo pcsInfo;
    private RtcpNamedPoseInfo rtcpInfo;
    private RtcpNamedPoseManagerPanel selectionHelper;
    private RtcpPoseValuePanel poseValueHelper;
    private JPanel pcsValuesPanel;
    private JLabel labelTitle = null;
    private RtcpNamedPose currentPcs;
    private boolean isTeachPanelActive = false;
    private RtcpPcsTeachPanel pcsTeachPanel;
    private JLabel labelDescription;
    private JButton btnTeachPcs;

    public RtcpPcsInstallationViewHelper(RtcpNamedPoseInfo pcsInfo, RtcpNamedPoseInfo rtcpInfo, LocalizationInfo localization, Style style, RemoteTcpInstallationNodeView.ViewContentSelector viewContentSelector) {
        super(localization, style);
        this.pcsInfo = pcsInfo;
        this.rtcpInfo = rtcpInfo;
        this.pcsValuesPanel = null;
        this.pcsTeachPanel = new RtcpPcsTeachPanel(this, pcsInfo, rtcpInfo, localization, style, viewContentSelector);
    }

    public JPanel createPcsPanel() {
        JPanel pcsPanel = new JPanel();
        pcsPanel.setLayout(new GridLayout(1, 2));
        JPanel leftPanel = this.buildPcsValuesPanel();
        JPanel rightPanel = this.buildTeachPanel();
        pcsPanel.add(leftPanel);
        pcsPanel.add(rightPanel);
        return pcsPanel;
    }

    private JPanel buildTeachPanel() {
        return this.pcsTeachPanel.createPcsTeachPanel();
    }

    private JPanel buildPcsValuesPanel() {
        if (this.pcsValuesPanel != null) {
            return this.pcsValuesPanel;
        }
        this.pcsValuesPanel = new JPanel();
        this.pcsValuesPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 5, this.style.getLightGray2()));
        this.pcsValuesPanel.setLayout(new BoxLayout(this.pcsValuesPanel, 1));
        this.pcsValuesPanel.setAlignmentY(0.0f);
        JPanel innerPanel = new JPanel();
        innerPanel.setBorder(new EmptyBorder(10, 5, 10, 10));
        innerPanel.setLayout(new BoxLayout(innerPanel, 1));
        innerPanel.setAlignmentY(0.0f);
        this.labelTitle = new JLabel();
        this.labelTitle.setFont(new Font(this.labelTitle.getFont().getName(), 1, 20));
        this.labelTitle.setHorizontalAlignment(2);
        this.labelTitle.setAlignmentX(0.0f);
        this.labelTitle.setAlignmentY(0.0f);
        innerPanel.add(this.labelTitle);
        this.labelDescription = new JLabel();
        this.labelDescription.setHorizontalAlignment(2);
        this.labelDescription.setAlignmentX(0.0f);
        this.labelDescription.setAlignmentY(0.0f);
        innerPanel.add(this.createVerticalSpacing(5));
        innerPanel.add(this.labelDescription);
        innerPanel.add(this.createVerticalSpacing(10));
        this.selectionHelper = new RtcpNamedPoseManagerPanel(this.pcsInfo, this.localization, this.style, "Rtcp_Pcs", new RtcpNamedPoseManagerPanel.NamedPoseChangeHandler(){

            @Override
            public void currentNamedPoseChanged(RtcpNamedPose currentNamedPose) {
                RtcpPcsInstallationViewHelper.this.currentPcs = currentNamedPose;
                RtcpPcsInstallationViewHelper.this.poseValueHelper.updatePanel(RtcpPcsInstallationViewHelper.this.currentPcs);
            }
        });
        Component tcpSelectionSection = this.selectionHelper.buildNamedPoseSelectionSection();
        innerPanel.add(tcpSelectionSection);
        innerPanel.add(this.createVerticalSpacing(25));
        this.poseValueHelper = new RtcpPoseValuePanel(this.pcsInfo, this.style, "PCS");
        innerPanel.add(this.poseValueHelper.createPositionSection());
        this.btnTeachPcs = new JButton();
        this.btnTeachPcs.setIcon(this.teachWizardIcon);
        this.btnTeachPcs.setName("Rtcp_Teach_Pcs");
        this.btnTeachPcs.setMaximumSize(this.style.getWizardButtonSize());
        this.btnTeachPcs.setPreferredSize(this.style.getWizardButtonSize());
        this.btnTeachPcs.setAlignmentX(1.0f);
        this.btnTeachPcs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!RtcpPcsInstallationViewHelper.this.canTeachProceed()) {
                    return;
                }
                RtcpPcsInstallationViewHelper.this.enableTeachView(true);
            }
        });
        Box buttonBox = Box.createHorizontalBox();
        buttonBox.setAlignmentX(0.0f);
        buttonBox.add(this.createHorizontalSpacing(291));
        buttonBox.add(this.btnTeachPcs);
        innerPanel.add(buttonBox);
        innerPanel.add(this.poseValueHelper.createOrientationSection());
        this.pcsValuesPanel.add(innerPanel);
        return this.pcsValuesPanel;
    }

    public void updateView() {
        this.updateText();
        this.pcsTeachPanel.updateView();
        this.selectionHelper.updateView();
        this.poseValueHelper.updatePanel(this.currentPcs);
        this.setPanelEnabled(this.pcsValuesPanel, !this.isTeachPanelActive);
        this.pcsTeachPanel.enableTeachPanel(this.isTeachPanelActive);
        this.selectionHelper.setEnabled(!this.isTeachPanelActive);
    }

    public void updatePcsPose(Pose pose) {
        this.currentPcs.setPose(pose);
        this.poseValueHelper.updatePanel(this.currentPcs);
        this.pcsInfo.updateDataModel();
    }

    private void updateText() {
        this.labelTitle.setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_PCS_TITLE));
        this.labelDescription.setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_PCS_DESCRIPTION));
        this.btnTeachPcs.setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_WIZARD));
    }

    public void setKeyboardFactory(KeyboardInputFactory keyboardFactory) {
        this.selectionHelper.setKeyboardFactory(keyboardFactory);
    }

    @Override
    public void setApiProvider(InstallationAPIProvider apiProvider) {
        super.setApiProvider(apiProvider);
        this.poseValueHelper.setApiProvider(apiProvider, this.localization);
        this.pcsTeachPanel.setApiProvider(apiProvider);
    }

    public void enableTeachView(boolean enable) {
        this.pcsTeachPanel.enableTeachPanel(enable);
        this.setPanelEnabled(this.pcsValuesPanel, !enable);
        this.selectionHelper.setEnabled(!enable);
        this.isTeachPanelActive = enable;
    }
}

