/*
 * Decompiled with CFR 0.152.
 */
package com.energid.urcap.remotetcp.impl.InstallationNode;

import com.energid.urcap.remotetcp.impl.Common.RtcpComboRenderer;
import com.energid.urcap.remotetcp.impl.Common.RtcpConstants;
import com.energid.urcap.remotetcp.impl.Common.RtcpUtils;
import com.energid.urcap.remotetcp.impl.Common.Style;
import com.energid.urcap.remotetcp.impl.InstallationNode.RtcpInstallationViewHelperBase;
import com.energid.urcap.remotetcp.impl.InstallationNode.RtcpPcsInstallationViewHelper;
import com.energid.urcap.remotetcp.impl.InstallationNode.RtcpPcsTeachPanel;
import com.energid.urcap.remotetcp.impl.Interfaces.LocalizationInfo;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpNamedPoseInfo;
import com.ur.urcap.api.domain.userinteraction.RobotPositionCallback;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.jointposition.JointPositions;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class RtcpPcsTeachMethod
extends RtcpInstallationViewHelperBase {
    protected RtcpNamedPoseInfo pcsInfo;
    protected RtcpNamedPoseInfo rtcpInfo;
    protected RtcpPcsInstallationViewHelper viewHelper;
    protected RtcpPcsTeachPanel container;
    protected Box boxMain;
    protected JPanel panelMain;
    protected JLabel title;
    protected JLabel[] labelInstruction;
    protected JLabel[] labelStep;
    protected JLabel[] labelStepLed;
    protected JButton[] buttonSetPoint;
    protected JButton buttonSet;
    protected JButton buttonCancel;
    protected Dimension stepColumnSize;
    protected JComboBox rtcpSelection;
    protected RtcpComboRenderer selectionRenderer;
    protected boolean rtcpComboListens = false;
    protected Dimension mainSize = new Dimension(515, 800);
    protected Dimension messageBoxSize = new Dimension(515, 40);
    protected String selectedRtcp;
    protected String defaultRtcp;
    protected JointPositions[] teachPoints;

    public RtcpPcsTeachMethod(RtcpPcsInstallationViewHelper viewHelper, RtcpNamedPoseInfo pcsInfo, RtcpNamedPoseInfo rtcpInfo, RtcpPcsTeachPanel container, LocalizationInfo localization, Style style) {
        super(localization, style);
        this.panelMain = new JPanel();
        this.stepColumnSize = new Dimension(15, 40);
        this.pcsInfo = pcsInfo;
        this.rtcpInfo = rtcpInfo;
        this.viewHelper = viewHelper;
        this.container = container;
        String name = "Pcs_Teach_Step_Label_";
        this.labelStep = new JLabel[]{this.makeLabel(name, 0), this.makeLabel(name, 1), this.makeLabel(name, 2), this.makeLabel(name, 3), this.makeLabel(name, 4), this.makeLabel(name, 5)};
        name = "Pcs_Teach_Instruction_Label_";
        this.labelInstruction = new JLabel[]{this.makeLabel(name, 0), this.makeLabel(name, 1), this.makeLabel(name, 2), this.makeLabel(name, 3), this.makeLabel(name, 4), this.makeLabel(name, 5)};
        name = "Pcs_Teach_LED_Label_";
        this.labelStepLed = new JLabel[]{this.makeLabel(name, 0), this.makeLabel(name, 1), this.makeLabel(name, 2), this.makeLabel(name, 3), this.makeLabel(name, 4), this.makeLabel(name, 5)};
        name = "Pcs_Teach_SetPoint_Button_";
        this.buttonSetPoint = new JButton[]{this.makeSetPointButton(name, 0), this.makeSetPointButton(name, 1), this.makeSetPointButton(name, 2), this.makeSetPointButton(name, 3), this.makeSetPointButton(name, 4), this.makeSetPointButton(name, 5)};
    }

    private JLabel makeLabel(String name, int i) {
        JLabel label = new JLabel();
        label.setName(name + i);
        return label;
    }

    private JButton makeSetPointButton(String name, final int index) {
        JButton button = new JButton();
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RtcpPcsTeachMethod.this.getApiProvider().getUserInterfaceAPI().getUserInteraction().getUserDefinedRobotPosition(new RobotPositionCallback(){

                    public void onOk(Pose notUsed, JointPositions q) {
                        RtcpPcsTeachMethod.this.teachPoints[index] = q;
                        RtcpPcsTeachMethod.this.errorCode = -1;
                        RtcpPcsTeachMethod.this.calculatedPose = null;
                        RtcpPcsTeachMethod.this.buttonSet.setEnabled(false);
                        if (RtcpPcsTeachMethod.this.validateMethod() && RtcpPcsTeachMethod.this.calculatePcs()) {
                            RtcpPcsTeachMethod.this.buttonSet.setEnabled(true);
                        }
                        RtcpPcsTeachMethod.this.updateView();
                    }
                });
            }
        });
        button.setName(name + index);
        return button;
    }

    protected void initializeTeach() {
        this.selectedRtcp = this.defaultRtcp = this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_MOVEP_SELECT_RTCP_DEFAULT);
        this.teachPoints = new JointPositions[]{null, null, null, null, null, null};
        this.calculatedPose = null;
        for (JLabel item : this.labelStepLed) {
            item.setIcon(this.iconEmptyLed);
        }
        this.errorCode = -1;
    }

    protected void updateView() {
        this.updateRtcpList();
        this.buttonSet.setEnabled(this.validateMethod() && this.calculatedPose != null);
        this.updateText();
        this.updateCalculationMessage();
    }

    private void updateCalculationMessage() {
        if (this.errorCode >= 0) {
            this.calculationMessage.setIcon(this.iconRedLed);
            String message = "Unknown error";
            if (this.errorCode == 0) {
                message = this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_ERROR_PCSERROR0);
            } else if (this.errorCode == 1) {
                message = this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_ERROR_PCSERROR1);
            } else if (this.errorCode == 2) {
                message = this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_ERROR_PCSERROR2);
            } else if (this.errorCode == 3) {
                message = this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_ERROR_PCSERROR3);
            } else if (this.errorCode == 4) {
                message = this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_ERROR_PCSERROR4);
            }
            this.calculationMessage.setText(message);
        } else if (this.calculatedPose != null) {
            this.calculationMessage.setIcon(this.iconGreenLed);
            String message = this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_CALCULATEDPCSPOSITION) + ": " + RtcpUtils.getPositionString(this.calculatedPose, this.localization.getSystemLengthUnit(), this.localization.getLocalizedLengthUnit()) + "<br/>" + this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_CALCULATEDPCSORIENTATION) + ": " + RtcpUtils.getOrienationString(this.calculatedPose);
            this.calculationMessage.setText(RtcpUtils.encloseWithHtml(message));
        } else {
            this.calculationMessage.setIcon(null);
            this.calculationMessage.setText(" ");
        }
    }

    protected boolean validateMethod() {
        return false;
    }

    protected void updateText() {
        int index = 1;
        for (JLabel item : this.labelStep) {
            item.setText(String.format("%d", index++));
            item.setFont(new Font(item.getFont().getName(), 1, item.getFont().getSize()));
        }
        this.buttonSet.setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_SET));
        this.buttonCancel.setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_CANCEL));
    }

    protected void createMethodExecution() {
    }

    protected Box createStepBox(JLabel labelStep, JLabel labelInstruction, Component tool1, Component tool2, JLabel led) {
        labelStep.setAlignmentX(0.0f);
        labelInstruction.setAlignmentX(0.0f);
        Box boxStep = Box.createHorizontalBox();
        boxStep.setAlignmentX(0.5f);
        labelStep.setPreferredSize(this.stepColumnSize);
        boxStep.add(labelStep);
        boxStep.add(this.createHorizontalSpacing(5));
        boxStep.add(labelInstruction);
        boxStep.add(Box.createHorizontalGlue());
        if (tool1 != null) {
            boxStep.add(this.createHorizontalSpacing(5));
            boxStep.add(tool1);
        }
        if (tool2 != null) {
            boxStep.add(this.createHorizontalSpacing(5));
            boxStep.add(tool2);
        }
        if (led != null) {
            boxStep.add(this.createHorizontalSpacing(10));
            boxStep.add(led);
        }
        return boxStep;
    }

    protected Box createSetCancel() {
        Box setAndCancel = Box.createHorizontalBox();
        setAndCancel.setAlignmentX(0.5f);
        this.buttonSet = new JButton();
        this.buttonSet.setIcon(this.approveIcon);
        this.buttonSet.setName("Pcs_Teach_Method_Set");
        this.buttonSet.setEnabled(false);
        this.buttonSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RtcpPcsTeachMethod.this.teachSetHandler();
                RtcpPcsTeachMethod.this.container.disableTeach();
            }
        });
        setAndCancel.add(this.buttonSet);
        setAndCancel.add(this.createHorizontalSpacing(10));
        this.buttonCancel = new JButton();
        this.buttonCancel.setIcon(this.cancelIcon);
        this.buttonCancel.setName("Pcs_Teach_Method_Cancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RtcpPcsTeachMethod.this.container.disableTeach();
            }
        });
        setAndCancel.add(this.buttonCancel);
        return setAndCancel;
    }

    protected void teachSetHandler() {
        if (this.calculatedPose != null) {
            this.viewHelper.updatePcsPose(this.calculatedPose);
        }
    }

    protected boolean calculatePcs() {
        return false;
    }

    protected void updateRtcpList() {
        String[] listRtcps = this.rtcpInfo.getAvailablePoses();
        this.rtcpComboListens = false;
        this.rtcpSelection.removeAllItems();
        String defaultRtcp = this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_MOVEP_SELECT_RTCP_DEFAULT);
        this.selectionRenderer.setMissingItem("");
        this.rtcpSelection.getModel();
        if (!this.selectedRtcp.equals(defaultRtcp) && !this.isSelectedRtcpValid()) {
            this.selectionRenderer.setMissingItem(this.selectedRtcp);
            this.rtcpSelection.addItem(this.selectedRtcp);
        }
        this.rtcpSelection.addItem(defaultRtcp);
        for (String rtcp : listRtcps) {
            this.rtcpSelection.addItem(rtcp);
        }
        this.rtcpSelection.setSelectedItem(this.selectedRtcp);
        this.rtcpComboListens = true;
    }

    protected boolean isSelectedRtcpValid() {
        if (!this.defaultRtcp.equals(this.selectedRtcp)) {
            return Arrays.asList(this.rtcpInfo.getAvailablePoses()).contains(this.selectedRtcp);
        }
        return true;
    }

    protected boolean checkTeachPoint(int step) {
        if (this.teachPoints[step] != null) {
            this.buttonSetPoint[step].setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_MODIFYPOINT));
            if (this.calculatedPose != null) {
                this.labelStepLed[step].setIcon(this.iconGreenLed);
            } else {
                this.labelStepLed[step].setIcon(this.iconOffLed);
            }
            return true;
        }
        this.buttonSetPoint[step].setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_SETPOINT));
        this.labelStepLed[step].setIcon(this.iconEmptyLed);
        return false;
    }

    public Component getMethodExecution() {
        return this.panelMain;
    }
}

