/*
 * Decompiled with CFR 0.152.
 */
package com.energid.urcap.remotetcp.impl.InstallationNode;

import com.energid.urcap.remotetcp.impl.Common.RtcpComboRenderer;
import com.energid.urcap.remotetcp.impl.Common.RtcpConstants;
import com.energid.urcap.remotetcp.impl.Common.RtcpUtils;
import com.energid.urcap.remotetcp.impl.Common.RtcpXmlRpcClient;
import com.energid.urcap.remotetcp.impl.Common.Style;
import com.energid.urcap.remotetcp.impl.InstallationNode.RtcpPcsInstallationViewHelper;
import com.energid.urcap.remotetcp.impl.InstallationNode.RtcpPcsTeachMethod;
import com.energid.urcap.remotetcp.impl.InstallationNode.RtcpPcsTeachPanel;
import com.energid.urcap.remotetcp.impl.Interfaces.LocalizationInfo;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpNamedPoseInfo;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.simple.Angle;
import com.ur.urcap.api.domain.value.simple.Length;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class RtcpPcsTeachMethod1
extends RtcpPcsTeachMethod {
    public RtcpPcsTeachMethod1(RtcpPcsInstallationViewHelper viewHelper, RtcpNamedPoseInfo pcsInfo, RtcpNamedPoseInfo rtcpInfo, RtcpPcsTeachPanel rtcpPcsTeachPanel, LocalizationInfo localization, Style style) {
        super(viewHelper, pcsInfo, rtcpInfo, rtcpPcsTeachPanel, localization, style);
        this.initializeTeach();
        this.createMethodExecution();
    }

    @Override
    protected boolean validateMethod() {
        boolean validationPassed = true;
        int stepIndex = 1;
        if (this.isSelectedRtcpValid()) {
            this.labelStepLed[stepIndex].setIcon(this.iconGreenLed);
        } else {
            this.labelStepLed[stepIndex].setIcon(this.iconRedLed);
            validationPassed = false;
        }
        for (stepIndex = 2; stepIndex <= 4; ++stepIndex) {
            if (this.checkTeachPoint(stepIndex)) continue;
            validationPassed = false;
        }
        return validationPassed;
    }

    @Override
    protected void updateText() {
        super.updateText();
        this.title.setText(RtcpUtils.encloseWithHtml(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_PCS_TITLE_METHOD1)));
        this.labelInstruction[0].setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_PCS_TEACH1_STEP1));
        this.labelInstruction[1].setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_PCS_TEACH1_STEP2));
        this.labelInstruction[2].setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_PCS_TEACH1_STEP3));
        this.labelInstruction[3].setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_PCS_TEACH1_STEP4));
        this.labelInstruction[4].setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_PCS_TEACH1_STEP5));
    }

    @Override
    protected void createMethodExecution() {
        Box main = Box.createVerticalBox();
        main.setPreferredSize(this.mainSize);
        main.setAlignmentX(0.0f);
        this.title = new JLabel();
        this.title.setFont(new Font(this.title.getFont().getName(), 1, 20));
        this.title.setHorizontalAlignment(2);
        this.title.setAlignmentX(0.5f);
        this.title.setAlignmentY(0.0f);
        main.add(this.createVerticalSpacing(25));
        main.add(this.title);
        Box messageBox = Box.createHorizontalBox();
        messageBox.setMinimumSize(this.messageBoxSize);
        messageBox.setMaximumSize(this.messageBoxSize);
        messageBox.setPreferredSize(this.messageBoxSize);
        this.calculationMessage = new JLabel();
        this.calculationMessage.setHorizontalAlignment(2);
        this.calculationMessage.setAlignmentX(0.0f);
        this.calculationMessage.setAlignmentY(0.0f);
        this.calculationMessage.setName("Pcs_Teach_Message_Method1");
        messageBox.add(this.calculationMessage);
        messageBox.add(Box.createHorizontalGlue());
        main.add(this.createVerticalSpacing(20));
        main.add(messageBox);
        int stepIndex = 0;
        Box boxStep1 = this.createStepBox(this.labelStep[stepIndex], this.labelInstruction[stepIndex], null, null, null);
        ++stepIndex;
        this.rtcpSelection = new JComboBox();
        this.rtcpSelection.setName("Pcs_Rtcp_Selection");
        this.rtcpSelection.setAlignmentX(0.0f);
        this.selectionRenderer = new RtcpComboRenderer(this.style);
        this.rtcpSelection.setRenderer(this.selectionRenderer);
        this.rtcpSelection.setMaximumSize(this.style.getSelectionComboboxSize());
        this.rtcpSelection.setPreferredSize(this.style.getSelectionComboboxSize());
        this.rtcpSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!RtcpPcsTeachMethod1.this.rtcpComboListens) {
                    return;
                }
                Object item = RtcpPcsTeachMethod1.this.rtcpSelection.getModel().getSelectedItem();
                if (item != null) {
                    RtcpPcsTeachMethod1.this.selectedRtcp = item.toString();
                }
                RtcpPcsTeachMethod1.this.updateView();
            }
        });
        Box boxStep2 = this.createStepBox(this.labelStep[stepIndex], this.labelInstruction[stepIndex], null, this.rtcpSelection, this.labelStepLed[stepIndex]);
        Box boxStep3 = this.createStepBox(this.labelStep[++stepIndex], this.labelInstruction[stepIndex], null, this.buttonSetPoint[stepIndex], this.labelStepLed[stepIndex]);
        Box boxStep4 = this.createStepBox(this.labelStep[++stepIndex], this.labelInstruction[stepIndex], null, this.buttonSetPoint[stepIndex], this.labelStepLed[stepIndex]);
        Box boxStep5 = this.createStepBox(this.labelStep[++stepIndex], this.labelInstruction[stepIndex], null, this.buttonSetPoint[stepIndex], this.labelStepLed[stepIndex]);
        main.add(this.createVerticalSpacing(20));
        main.add(boxStep1);
        main.add(this.createVerticalSpacing(20));
        main.add(boxStep2);
        main.add(this.createVerticalSpacing(20));
        main.add(boxStep3);
        main.add(this.createVerticalSpacing(20));
        main.add(boxStep4);
        main.add(this.createVerticalSpacing(20));
        main.add(boxStep5);
        main.add(this.createVerticalSpacing(50));
        main.add(this.createSetCancel());
        this.boxMain = main;
        this.panelMain.add(this.boxMain);
    }

    @Override
    protected boolean calculatePcs() {
        int ee_set_id = 2;
        int ee_id = 0;
        Pose rtcp = !this.defaultRtcp.equals(this.selectedRtcp) ? this.rtcpInfo.getNamedPoseById(this.selectedRtcp).getPose() : this.rtcpInfo.getNamedPoseById(this.rtcpInfo.getDefaultNamedPose()).getPose();
        Object retVal = RtcpXmlRpcClient.calculateFrame(ee_set_id, ee_id, rtcp, this.teachPoints[2], this.teachPoints[3], this.teachPoints[4]);
        if (retVal != null) {
            Object[] values = (Object[])retVal;
            if (values.length == 6) {
                double[] poseArray = new double[]{(Double)values[0], (Double)values[1], (Double)values[2], (Double)values[3], (Double)values[4], (Double)values[5]};
                this.calculatedPose = this.apiProvider.getInstallationAPI().getValueFactoryProvider().getPoseFactory().createPose(poseArray[0], poseArray[1], poseArray[2], poseArray[3], poseArray[4], poseArray[5], Length.Unit.M, Angle.Unit.RAD);
                return true;
            }
            this.errorCode = (Integer)values[0];
        } else {
            String errorMsg = RtcpXmlRpcClient.getLastError();
            System.out.println("Error message from XMLRPC: " + errorMsg);
            JOptionPane.showMessageDialog(null, this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_ERROR_PCSTEACHFAILED), this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_WARNING_TITLE), 2);
        }
        return false;
    }
}

