/*
 * Decompiled with CFR 0.152.
 */
package com.energid.urcap.remotetcp.impl.InstallationNode;

import com.energid.urcap.remotetcp.impl.Common.RtcpComboRenderer;
import com.energid.urcap.remotetcp.impl.Common.RtcpConstants;
import com.energid.urcap.remotetcp.impl.Common.RtcpNamedPose;
import com.energid.urcap.remotetcp.impl.Common.RtcpUtils;
import com.energid.urcap.remotetcp.impl.Common.RtcpXmlRpcClient;
import com.energid.urcap.remotetcp.impl.Common.Style;
import com.energid.urcap.remotetcp.impl.InstallationNode.RtcpPcsCoordinateEntry;
import com.energid.urcap.remotetcp.impl.InstallationNode.RtcpPcsInstallationViewHelper;
import com.energid.urcap.remotetcp.impl.InstallationNode.RtcpPcsTeachMethod;
import com.energid.urcap.remotetcp.impl.InstallationNode.RtcpPcsTeachPanel;
import com.energid.urcap.remotetcp.impl.Interfaces.LocalizationInfo;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpNamedPoseInfo;
import com.ur.urcap.api.contribution.installation.InstallationAPIProvider;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.simple.Angle;
import com.ur.urcap.api.domain.value.simple.Length;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class RtcpPcsTeachMethod2
extends RtcpPcsTeachMethod {
    private Box boxExecution;
    private RtcpPcsCoordinateEntry coordinateEntry;
    protected JButton[] buttonCoordinates;
    protected RtcpNamedPose[] namedPoses;

    public RtcpPcsTeachMethod2(RtcpPcsInstallationViewHelper viewHelper, RtcpNamedPoseInfo pcsInfo, RtcpNamedPoseInfo rtcpInfo, RtcpPcsTeachPanel rtcpPcsTeachPanel, LocalizationInfo localization, Style style) {
        super(viewHelper, pcsInfo, rtcpInfo, rtcpPcsTeachPanel, localization, style);
        String name = "Pcs_Teach_Coordinates_Button_";
        this.buttonCoordinates = new JButton[]{this.makeCoordinatesButton(name, 0, null), this.makeCoordinatesButton(name, 1, null), this.makeCoordinatesButton(name, 2, RtcpConstants.Strings.RTCP_INST_PCS_TEACH2_STEP3), this.makeCoordinatesButton(name, 3, RtcpConstants.Strings.RTCP_INST_PCS_TEACH2_STEP4), this.makeCoordinatesButton(name, 4, RtcpConstants.Strings.RTCP_INST_PCS_TEACH2_STEP5), this.makeCoordinatesButton(name, 5, RtcpConstants.Strings.RTCP_INST_PCS_TEACH2_STEP6)};
        this.coordinateEntry = new RtcpPcsCoordinateEntry(localization, style);
        this.createMethodExecution();
    }

    @Override
    protected void initializeTeach() {
        super.initializeTeach();
        this.initializeNamedPoses();
    }

    private void initializeNamedPoses() {
        this.namedPoses = new RtcpNamedPose[6];
    }

    private Pose makePose() {
        return this.poseFactory.createPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Length.Unit.M, Angle.Unit.RAD);
    }

    @Override
    protected boolean validateMethod() {
        boolean validationPassed = true;
        int stepIndex = 1;
        if (this.isSelectedRtcpValid()) {
            this.labelStepLed[stepIndex].setIcon(this.iconGreenLed);
        } else {
            this.labelStepLed[stepIndex].setIcon(this.iconRedLed);
            validationPassed = false;
        }
        for (stepIndex = 2; stepIndex <= 5; ++stepIndex) {
            if (this.checkTeachPoint(stepIndex) || stepIndex > 4) continue;
            validationPassed = false;
        }
        return validationPassed;
    }

    @Override
    protected boolean calculatePcs() {
        Object retVal;
        Pose rtcp = !this.defaultRtcp.equals(this.selectedRtcp) ? this.rtcpInfo.getNamedPoseById(this.selectedRtcp).getPose() : this.rtcpInfo.getNamedPoseById(this.rtcpInfo.getDefaultNamedPose()).getPose();
        Pose pose4 = null;
        if (this.namedPoses[5] != null) {
            pose4 = this.namedPoses[5].getPose();
        }
        if ((retVal = RtcpXmlRpcClient.fitTransformation(rtcp, this.namedPoses[2].getPose(), this.namedPoses[3].getPose(), this.namedPoses[4].getPose(), pose4, this.teachPoints[2], this.teachPoints[3], this.teachPoints[4], this.teachPoints[5])) != null) {
            Object[] values = (Object[])retVal;
            if (values.length == 6) {
                double[] poseArray = new double[]{(Double)values[0], (Double)values[1], (Double)values[2], (Double)values[3], (Double)values[4], (Double)values[5]};
                this.calculatedPose = this.apiProvider.getInstallationAPI().getValueFactoryProvider().getPoseFactory().createPose(poseArray[0], poseArray[1], poseArray[2], poseArray[3], poseArray[4], poseArray[5], Length.Unit.M, Angle.Unit.RAD);
                return true;
            }
            this.errorCode = (Integer)values[0];
        } else {
            String errorMsg = RtcpXmlRpcClient.getLastError();
            System.out.println("Error message from XMLRPC: " + errorMsg);
            JOptionPane.showMessageDialog(null, this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_ERROR_PCSTEACHFAILED), this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_WARNING_TITLE), 2);
        }
        return false;
    }

    @Override
    protected void updateText() {
        super.updateText();
        this.title.setText(RtcpUtils.encloseWithHtml(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_PCS_TITLE_METHOD2)));
        this.labelInstruction[0].setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_PCS_TEACH2_STEP1));
        this.labelInstruction[1].setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_PCS_TEACH2_STEP2));
        this.labelInstruction[2].setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_PCS_TEACH2_STEP3));
        this.labelInstruction[3].setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_PCS_TEACH2_STEP4));
        this.labelInstruction[4].setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_PCS_TEACH2_STEP5));
        this.labelInstruction[5].setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_PCS_TEACH2_STEP6));
        for (JButton item : this.buttonCoordinates) {
            item.setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_COORDINATES));
        }
        this.coordinateEntry.updateText();
    }

    @Override
    protected void updateView() {
        super.updateView();
        this.coordinateEntry.updateView();
    }

    @Override
    protected void createMethodExecution() {
        Box main = Box.createVerticalBox();
        main.setPreferredSize(this.mainSize);
        main.setAlignmentX(0.0f);
        this.title = new JLabel();
        this.title.setFont(new Font(this.title.getFont().getName(), 1, 20));
        this.title.setHorizontalAlignment(0);
        this.title.setAlignmentX(0.5f);
        this.title.setAlignmentY(0.0f);
        main.add(this.createVerticalSpacing(25));
        main.add(this.title);
        Box messageBox = Box.createHorizontalBox();
        messageBox.setMinimumSize(this.messageBoxSize);
        messageBox.setMaximumSize(this.messageBoxSize);
        messageBox.setPreferredSize(this.messageBoxSize);
        this.calculationMessage = new JLabel();
        this.calculationMessage.setHorizontalAlignment(2);
        this.calculationMessage.setAlignmentX(0.0f);
        this.calculationMessage.setAlignmentY(0.0f);
        this.calculationMessage.setName("Pcs_Teach_Message_Method2");
        messageBox.add(this.calculationMessage);
        messageBox.add(Box.createHorizontalGlue());
        main.add(this.createVerticalSpacing(20));
        main.add(messageBox);
        int stepIndex = 0;
        Box boxStep1 = this.createStepBox(this.labelStep[stepIndex], this.labelInstruction[stepIndex], null, null, null);
        ++stepIndex;
        this.rtcpSelection = new JComboBox();
        this.rtcpSelection.setName("Pcs_Rtcp_Selection");
        this.rtcpSelection.setAlignmentX(0.0f);
        this.selectionRenderer = new RtcpComboRenderer(this.style);
        this.rtcpSelection.setRenderer(this.selectionRenderer);
        this.rtcpSelection.setMaximumSize(this.style.getSelectionComboboxSize());
        this.rtcpSelection.setPreferredSize(this.style.getSelectionComboboxSize());
        this.rtcpSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!RtcpPcsTeachMethod2.this.rtcpComboListens) {
                    return;
                }
                Object item = RtcpPcsTeachMethod2.this.rtcpSelection.getModel().getSelectedItem();
                if (item != null) {
                    RtcpPcsTeachMethod2.this.selectedRtcp = item.toString();
                }
                RtcpPcsTeachMethod2.this.updateView();
            }
        });
        Box boxStep2 = this.createStepBox(this.labelStep[stepIndex], this.labelInstruction[stepIndex], null, this.rtcpSelection, this.labelStepLed[stepIndex]);
        Box boxStep3 = this.createStepBox(this.labelStep[++stepIndex], this.labelInstruction[stepIndex], this.buttonCoordinates[stepIndex], this.buttonSetPoint[stepIndex], this.labelStepLed[stepIndex]);
        Box boxStep4 = this.createStepBox(this.labelStep[++stepIndex], this.labelInstruction[stepIndex], this.buttonCoordinates[stepIndex], this.buttonSetPoint[stepIndex], this.labelStepLed[stepIndex]);
        Box boxStep5 = this.createStepBox(this.labelStep[++stepIndex], this.labelInstruction[stepIndex], this.buttonCoordinates[stepIndex], this.buttonSetPoint[stepIndex], this.labelStepLed[stepIndex]);
        Box boxStep6 = this.createStepBox(this.labelStep[++stepIndex], this.labelInstruction[stepIndex], this.buttonCoordinates[stepIndex], this.buttonSetPoint[stepIndex], this.labelStepLed[stepIndex]);
        main.add(this.createVerticalSpacing(20));
        main.add(boxStep1);
        main.add(this.createVerticalSpacing(20));
        main.add(boxStep2);
        main.add(this.createVerticalSpacing(20));
        main.add(boxStep3);
        main.add(this.createVerticalSpacing(20));
        main.add(boxStep4);
        main.add(this.createVerticalSpacing(20));
        main.add(boxStep5);
        main.add(this.createVerticalSpacing(20));
        main.add(boxStep6);
        main.add(this.createVerticalSpacing(50));
        main.add(this.createSetCancel());
        this.boxExecution = main;
        this.boxMain = main;
        this.panelMain.removeAll();
        this.panelMain.add(this.boxMain);
        this.panelMain.revalidate();
        this.panelMain.repaint();
    }

    @Override
    public void setApiProvider(InstallationAPIProvider apiProvider) {
        super.setApiProvider(apiProvider);
        this.coordinateEntry.setApiProvider(apiProvider);
        this.initializeTeach();
    }

    private JButton makeCoordinatesButton(String name, final int index, final RtcpConstants.Strings localizationString) {
        JButton button = new JButton();
        if (localizationString != null) {
            button.putClientProperty("localizationString", (Object)localizationString);
        }
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RtcpPcsTeachMethod2.this.panelMain.removeAll();
                Pose tempPose = RtcpPcsTeachMethod2.this.namedPoses[index] != null ? RtcpPcsTeachMethod2.this.poseFactory.createPose(RtcpPcsTeachMethod2.this.namedPoses[index].getPose().getPosition().getX(Length.Unit.M), RtcpPcsTeachMethod2.this.namedPoses[index].getPose().getPosition().getY(Length.Unit.M), RtcpPcsTeachMethod2.this.namedPoses[index].getPose().getPosition().getZ(Length.Unit.M), RtcpPcsTeachMethod2.this.namedPoses[index].getPose().getRotation().getRX(Angle.Unit.RAD), RtcpPcsTeachMethod2.this.namedPoses[index].getPose().getRotation().getRY(Angle.Unit.RAD), RtcpPcsTeachMethod2.this.namedPoses[index].getPose().getRotation().getRZ(Angle.Unit.RAD), Length.Unit.M, Angle.Unit.RAD) : RtcpPcsTeachMethod2.this.makePose();
                final RtcpNamedPose tempNamedPose = new RtcpNamedPose("reference_" + index, tempPose);
                RtcpPcsTeachMethod2.this.panelMain.add(RtcpPcsTeachMethod2.this.coordinateEntry.createCoordinateEntry(tempNamedPose, localizationString, new SetCancelHandler(){

                    @Override
                    public void handleSet() {
                        RtcpPcsTeachMethod2.this.namedPoses[index] = tempNamedPose;
                        RtcpPcsTeachMethod2.this.errorCode = -1;
                        RtcpPcsTeachMethod2.this.calculatedPose = null;
                        RtcpPcsTeachMethod2.this.buttonSet.setEnabled(false);
                        if (RtcpPcsTeachMethod2.this.validateMethod() && RtcpPcsTeachMethod2.this.calculatePcs()) {
                            RtcpPcsTeachMethod2.this.buttonSet.setEnabled(true);
                        }
                        RtcpPcsTeachMethod2.this.showExecution();
                    }

                    @Override
                    public void handleCancel() {
                        RtcpPcsTeachMethod2.this.showExecution();
                    }
                }));
                RtcpPcsTeachMethod2.this.coordinateEntry.updateView();
                RtcpPcsTeachMethod2.this.panelMain.revalidate();
                RtcpPcsTeachMethod2.this.panelMain.repaint();
            }
        });
        button.setName(name + index);
        return button;
    }

    private void showExecution() {
        this.panelMain.removeAll();
        this.panelMain.add(this.boxExecution);
        this.panelMain.revalidate();
        this.panelMain.repaint();
        this.updateView();
    }

    @Override
    protected boolean checkTeachPoint(int step) {
        boolean valid = false;
        if (this.teachPoints[step] != null) {
            this.buttonSetPoint[step].setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_MODIFYPOINT));
            if (this.namedPoses[step] != null) {
                valid = true;
            }
        } else {
            this.buttonSetPoint[step].setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_SETPOINT));
            valid = false;
        }
        if (valid) {
            this.labelStepLed[step].setIcon(this.iconOffLed);
        } else {
            this.labelStepLed[step].setIcon(this.iconEmptyLed);
        }
        return valid;
    }

    public static interface SetCancelHandler {
        public void handleSet();

        public void handleCancel();
    }
}

