/*
 * Decompiled with CFR 0.152.
 */
package com.energid.urcap.remotetcp.impl.InstallationNode;

import com.energid.urcap.remotetcp.impl.Common.RtcpConstants;
import com.energid.urcap.remotetcp.impl.Common.RtcpUtils;
import com.energid.urcap.remotetcp.impl.Common.Style;
import com.energid.urcap.remotetcp.impl.InstallationNode.RtcpInstallationViewHelperBase;
import com.energid.urcap.remotetcp.impl.InstallationNode.RtcpPcsInstallationViewHelper;
import com.energid.urcap.remotetcp.impl.InstallationNode.RtcpPcsTeachMethod;
import com.energid.urcap.remotetcp.impl.InstallationNode.RtcpPcsTeachMethod1;
import com.energid.urcap.remotetcp.impl.InstallationNode.RtcpPcsTeachMethod2;
import com.energid.urcap.remotetcp.impl.Interfaces.LocalizationInfo;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpNamedPoseInfo;
import com.energid.urcap.remotetcp.impl.RemoteTcpInstallationNodeView;
import com.ur.urcap.api.contribution.installation.InstallationAPIProvider;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;

public class RtcpPcsTeachPanel
extends RtcpInstallationViewHelperBase {
    private RtcpPcsInstallationViewHelper viewHelper;
    private JRadioButton radiobuttonMethod1;
    private JRadioButton radiobuttonMethod2;
    private JLabel labelMethod1;
    private JButton buttonNext;
    private JButton buttonCancelMethodSelection;
    private ImageIcon iconMethod1;
    private ImageIcon iconMethod2;
    private final int imageScaleWidth = 400;
    private JLabel labelTeachMethodImage;
    private int selectedMethodIndex;
    private RemoteTcpInstallationNodeView.ViewContentSelector viewContentSelector;
    private JButton homeButton;
    private JPanel mainPanel;
    private JPanel teachContentPanel;
    private RtcpPcsTeachMethod1 method1;
    private RtcpPcsTeachMethod2 method2;
    private RtcpPcsTeachMethod currentMethod;
    private Box methodSelection;

    public RtcpPcsTeachPanel(RtcpPcsInstallationViewHelper viewHelper, RtcpNamedPoseInfo pcsInfo, RtcpNamedPoseInfo rtcpInfo, LocalizationInfo localization, Style style, RemoteTcpInstallationNodeView.ViewContentSelector viewContentSelector) {
        super(localization, style);
        this.viewHelper = viewHelper;
        this.viewContentSelector = viewContentSelector;
        this.method1 = new RtcpPcsTeachMethod1(viewHelper, pcsInfo, rtcpInfo, this, localization, style);
        this.method2 = new RtcpPcsTeachMethod2(viewHelper, pcsInfo, rtcpInfo, this, localization, style);
        this.selectedMethodIndex = 1;
        this.currentMethod = null;
    }

    @Override
    public void setApiProvider(InstallationAPIProvider apiProvider) {
        super.setApiProvider(apiProvider);
        this.method1.setApiProvider(apiProvider);
        this.method2.setApiProvider(apiProvider);
    }

    public void updateView() {
        if (this.currentMethod != null) {
            this.currentMethod.updateView();
        }
        this.updateText();
    }

    private void updateText() {
        this.radiobuttonMethod1.setText(RtcpUtils.encloseWithHtml(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_PCS_SELECT_TEACHMETHOD1)));
        this.labelMethod1.setText(RtcpUtils.encloseWithHtml(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_PCS_SELECT_TEACHMETHOD1)));
        this.radiobuttonMethod2.setText(RtcpUtils.encloseWithHtml(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_PCS_SELECT_TEACHMETHOD2)));
        this.buttonNext.setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_NEXT));
        this.buttonCancelMethodSelection.setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_CANCEL));
    }

    public JPanel createPcsTeachPanel() {
        this.mainPanel = this.createMainPanel();
        this.methodSelection = this.createMethodSelection();
        this.teachContentPanel.add(this.methodSelection);
        return this.mainPanel;
    }

    private JPanel createMainPanel() {
        JPanel main = new JPanel();
        main.setLayout(new BoxLayout(main, 1));
        main.setAlignmentY(0.0f);
        main.setAlignmentX(0.5f);
        this.homeButton = new JButton();
        this.homeButton.setName("Home_Button");
        this.homeButton.setIcon(this.homeIcon);
        this.homeButton.setAlignmentX(0.5f);
        this.homeButton.setAlignmentY(0.0f);
        this.homeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RtcpPcsTeachPanel.this.viewContentSelector.setSelection(RemoteTcpInstallationNodeView.RtcpInstallationViewType.Home);
            }
        });
        Box titleBox = Box.createHorizontalBox();
        titleBox.setBorder(new EmptyBorder(10, 0, 0, 10));
        titleBox.setAlignmentX(0.0f);
        titleBox.setAlignmentY(0.0f);
        titleBox.add(Box.createHorizontalGlue());
        titleBox.add(this.homeButton);
        main.add(titleBox);
        this.teachContentPanel = new JPanel();
        this.teachContentPanel.setLayout(new BoxLayout(this.teachContentPanel, 1));
        this.teachContentPanel.setAlignmentY(0.0f);
        this.teachContentPanel.setAlignmentX(0.5f);
        this.teachContentPanel.setBorder(new EmptyBorder(0, 10, 0, 0));
        main.add(this.teachContentPanel);
        return main;
    }

    private Box createMethodSelection() {
        Box main = Box.createVerticalBox();
        main.setAlignmentX(0.0f);
        Image imgMethod1 = null;
        Image imgMethod2 = null;
        try {
            imgMethod1 = ImageIO.read(this.getClass().getClassLoader().getResource("RTCP_PCS.png"));
            imgMethod2 = ImageIO.read(this.getClass().getClassLoader().getResource("pcs_teachmethod_2.png"));
        }
        catch (Exception e1) {
            System.out.println("non-fatal Exception loading PCS teach method images");
        }
        imgMethod1 = imgMethod1.getScaledInstance(400, -1, 4);
        imgMethod2 = imgMethod2.getScaledInstance(400, -1, 4);
        this.iconMethod1 = new ImageIcon(imgMethod1);
        this.iconMethod2 = new ImageIcon(imgMethod2);
        this.labelTeachMethodImage = new JLabel();
        this.labelTeachMethodImage.setAlignmentX(0.5f);
        main.add(this.labelTeachMethodImage);
        main.add(this.createVerticalSpacing(5));
        this.radiobuttonMethod1 = new JRadioButton();
        this.radiobuttonMethod1.setAlignmentX(0.5f);
        this.radiobuttonMethod1.setName("TeachPCS_SelectMethod1");
        this.radiobuttonMethod2 = new JRadioButton();
        this.radiobuttonMethod2.setAlignmentX(0.5f);
        this.radiobuttonMethod2.setName("TeachPCS_SelectMethod2");
        ButtonGroup group = new ButtonGroup();
        group.add(this.radiobuttonMethod1);
        group.add(this.radiobuttonMethod2);
        this.radiobuttonMethod1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RtcpPcsTeachPanel.this.modeSelectionHandler();
            }
        });
        this.radiobuttonMethod2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RtcpPcsTeachPanel.this.modeSelectionHandler();
            }
        });
        this.labelMethod1 = new JLabel();
        this.labelMethod1.setAlignmentX(0.5f);
        this.labelMethod1.setName("TeachPCS_Method1");
        main.add(this.radiobuttonMethod1);
        main.add(this.radiobuttonMethod2);
        this.radiobuttonMethod1.setSelected(true);
        this.radiobuttonMethod2.setSelected(false);
        this.updateTeachMethodGraphics(1);
        Dimension buttonSize = this.style.getCancelButtonSize();
        this.buttonNext = new JButton();
        this.buttonNext.setName("TeachPcs_Next");
        this.buttonNext.setAlignmentX(0.5f);
        this.buttonNext.setMinimumSize(buttonSize);
        this.buttonNext.setMaximumSize(buttonSize);
        this.buttonNext.setPreferredSize(buttonSize);
        this.buttonNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RtcpPcsTeachPanel.this.showSelectedTeachMethod();
            }
        });
        this.buttonCancelMethodSelection = new JButton();
        this.buttonCancelMethodSelection.setIcon(this.cancelIcon);
        this.buttonCancelMethodSelection.setName("Pcs_Teach_MethodSelection_Cancel");
        this.buttonCancelMethodSelection.setAlignmentX(0.5f);
        this.buttonCancelMethodSelection.setMinimumSize(buttonSize);
        this.buttonCancelMethodSelection.setMaximumSize(buttonSize);
        this.buttonCancelMethodSelection.setPreferredSize(buttonSize);
        this.buttonCancelMethodSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RtcpPcsTeachPanel.this.viewHelper.enableTeachView(false);
            }
        });
        Box nextAndCancel = Box.createHorizontalBox();
        nextAndCancel.setAlignmentX(0.5f);
        nextAndCancel.add(this.buttonNext);
        nextAndCancel.add(this.createHorizontalSpacing(10));
        nextAndCancel.add(this.buttonCancelMethodSelection);
        main.add(this.createVerticalSpacing(25));
        main.add(nextAndCancel);
        return main;
    }

    public void showSelectedTeachMethod() {
        this.teachContentPanel.removeAll();
        this.currentMethod = this.selectedMethodIndex == 1 ? this.method1 : this.method2;
        this.currentMethod.initializeTeach();
        this.teachContentPanel.add(this.currentMethod.getMethodExecution());
        this.teachContentPanel.revalidate();
        this.teachContentPanel.repaint();
        this.currentMethod.updateView();
    }

    protected void modeSelectionHandler() {
        this.selectedMethodIndex = this.radiobuttonMethod1.isSelected() ? 1 : 2;
        this.updateTeachMethodGraphics(1);
    }

    public void enableTeachPanel(boolean enabled) {
        if (this.currentMethod == null) {
            this.setPanelEnabled(this.teachContentPanel, enabled);
            this.labelTeachMethodImage.setEnabled(true);
        }
    }

    private void updateTeachMethodGraphics(int method) {
        if (method == 1) {
            this.labelTeachMethodImage.setIcon(this.iconMethod1);
        } else {
            this.labelTeachMethodImage.setIcon(this.iconMethod2);
        }
    }

    public void disableTeach() {
        this.teachContentPanel.removeAll();
        this.teachContentPanel.add(this.methodSelection);
        this.teachContentPanel.revalidate();
        this.teachContentPanel.repaint();
        this.enableTeachPanel(false);
        this.currentMethod = null;
        this.viewHelper.enableTeachView(false);
    }
}

