/*
 * Decompiled with CFR 0.152.
 */
package com.energid.urcap.remotetcp.impl.InstallationNode;

import com.energid.urcap.remotetcp.impl.Common.RtcpConstants;
import com.energid.urcap.remotetcp.impl.Common.RtcpUtils;
import com.energid.urcap.remotetcp.impl.Common.RtcpXmlRpcClient;
import com.energid.urcap.remotetcp.impl.Common.Style;
import com.energid.urcap.remotetcp.impl.InstallationNode.RtcpInstallationViewHelperBase;
import com.energid.urcap.remotetcp.impl.Interfaces.LocalizationInfo;
import com.energid.urcap.remotetcp.impl.Interfaces.ToolpathInfo;
import com.energid.urcap.remotetcp.impl.RemoteTcpInstallationNodeView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class ToolpathInstallationViewHelper
extends RtcpInstallationViewHelperBase {
    private JPanel importPanel;
    private JList<String> listImported;
    private DefaultListModel<String> modelImported;
    private JList<String> listSource;
    private DefaultListModel<String> modelSource;
    private String[] importedFiles;
    private String[] sourceFiles;
    private ToolpathInfo toolpathInfo;
    private JLabel labelToolpathImport;
    private JLabel labelImportedFiles;
    private JLabel labelUsbFiles;
    private JButton importButton;
    private JButton removeButton;
    private final int LIST_WIDTH = 400;
    private final int LIST_HEIGHT = 500;
    private final int CONTROL_WIDTH = 150;
    private static final HashMap<Integer, RtcpConstants.Strings> validationErrors = new HashMap();
    private RemoteTcpInstallationNodeView.ViewContentSelector viewContentSelector;
    private JButton homeButton;
    private JLabel labelReload;
    private JButton reloadButton;

    public ToolpathInstallationViewHelper(ToolpathInfo toolpathInfo, LocalizationInfo localization, Style style, RemoteTcpInstallationNodeView.ViewContentSelector viewContentSelector) {
        super(localization, style);
        this.toolpathInfo = toolpathInfo;
        this.viewContentSelector = viewContentSelector;
        validationErrors.put(0, RtcpConstants.Strings.RTCP_TOOLPATH_VALIDATION_ERROR_NONE);
        validationErrors.put(1, RtcpConstants.Strings.RTCP_TOOLPATH_VALIDATION_ERROR_FILELOAD);
        validationErrors.put(2, RtcpConstants.Strings.RTCP_TOOLPATH_VALIDATION_ERROR_PARSE);
        validationErrors.put(3, RtcpConstants.Strings.RTCP_TOOLPATH_VALIDATION_ERROR_EMPTYTOOLPATH);
        validationErrors.put(4, RtcpConstants.Strings.RTCP_TOOLPATH_VALIDATION_ERROR_UNSUPPORTEDTYPE);
    }

    public void updateView() {
        this.updateText();
        this.importedFiles = this.toolpathInfo.getImportedToolpathFiles();
        Arrays.sort(this.importedFiles);
        this.modelImported.clear();
        for (String file : this.importedFiles) {
            this.modelImported.addElement(file);
        }
        String sourceDirectory = this.toolpathInfo.getSourceToolpathDirectory();
        this.modelSource.clear();
        if (!sourceDirectory.isEmpty()) {
            this.sourceFiles = this.toolpathInfo.getSourceToolpathFiles(sourceDirectory);
            Arrays.sort(this.sourceFiles);
            for (String file : this.sourceFiles) {
                this.modelSource.addElement(file);
            }
        }
    }

    private void updateText() {
        this.labelToolpathImport.setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_TOOLPATH_FILES));
        this.labelImportedFiles.setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_TOOLPATH_IMPORTEDFILES));
        this.labelUsbFiles.setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_TOOLPATH_USBFILES));
        this.importButton.setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_TOOLPATH_IMPORT));
        this.removeButton.setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_TOOLPATH_REMOVE));
        this.labelReload.setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_TOOLPATH_PLUGINUSB));
        this.reloadButton.setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_TOOLPATH_LOADFROMUSB));
    }

    public JPanel createToolpathPanel() {
        this.importPanel = new JPanel();
        this.importPanel.setLayout(new BoxLayout(this.importPanel, 1));
        this.importPanel.setAlignmentY(0.0f);
        this.importPanel.setAlignmentX(0.5f);
        this.importPanel.setBorder(new EmptyBorder(10, 5, 10, 10));
        this.labelToolpathImport = new JLabel();
        this.labelToolpathImport.setFont(new Font(this.labelToolpathImport.getFont().getName(), 1, 20));
        this.labelToolpathImport.setHorizontalAlignment(2);
        this.labelToolpathImport.setAlignmentX(0.0f);
        this.labelToolpathImport.setAlignmentY(0.0f);
        this.homeButton = new JButton();
        this.homeButton.setName("Home_Button");
        this.homeButton.setIcon(this.homeIcon);
        this.homeButton.setAlignmentX(0.5f);
        this.homeButton.setAlignmentY(0.0f);
        this.homeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ToolpathInstallationViewHelper.this.viewContentSelector.setSelection(RemoteTcpInstallationNodeView.RtcpInstallationViewType.Home);
            }
        });
        Box titleBox = Box.createHorizontalBox();
        titleBox.setAlignmentX(0.0f);
        titleBox.setAlignmentY(0.0f);
        titleBox.add(this.labelToolpathImport);
        titleBox.add(Box.createHorizontalGlue());
        titleBox.add(this.homeButton);
        this.importPanel.add(titleBox);
        Box reloadBox = Box.createHorizontalBox();
        reloadBox.setAlignmentX(0.0f);
        reloadBox.setAlignmentY(0.0f);
        this.labelReload = new JLabel();
        this.labelReload.setHorizontalAlignment(2);
        this.labelReload.setAlignmentX(0.0f);
        this.labelReload.setAlignmentY(0.5f);
        this.labelReload.setVerticalAlignment(0);
        this.reloadButton = new JButton();
        this.reloadButton.setAlignmentY(0.5f);
        this.reloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolpathInstallationViewHelper.this.updateView();
            }
        });
        reloadBox.add(this.labelReload);
        reloadBox.add(this.createHorizontalSpacing(50));
        reloadBox.add(this.reloadButton);
        this.importPanel.add(reloadBox);
        Box box = Box.createHorizontalBox();
        box.setAlignmentX(0.0f);
        box.setAlignmentY(0.0f);
        box.add(this.createSourceSection());
        box.add(this.createSourceControlSection());
        box.add(this.createImportedSection());
        box.add(this.createImportedControlSection());
        this.importPanel.add(box);
        return this.importPanel;
    }

    private Component createImportedControlSection() {
        Box box = Box.createVerticalBox();
        box.setAlignmentX(0.0f);
        box.setAlignmentY(0.0f);
        box.setBorder(new EmptyBorder(10, 10, 10, 10));
        Dimension size = new Dimension(150, 500);
        box.setPreferredSize(size);
        box.setMaximumSize(size);
        this.removeButton = new JButton();
        this.removeButton.setAlignmentX(0.5f);
        this.removeButton.setAlignmentY(0.0f);
        this.removeButton.setName("Remove_Button");
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String message;
                int decision;
                List selectedValues = ToolpathInstallationViewHelper.this.listImported.getSelectedValuesList();
                if (!selectedValues.isEmpty() && (decision = JOptionPane.showConfirmDialog(null, message = RtcpUtils.encloseWithHtml(ToolpathInstallationViewHelper.this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_DELETESELECTEDFILES) + "<br/>" + ToolpathInstallationViewHelper.this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_TOOLPATHDELETEWARNING)), ToolpathInstallationViewHelper.this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_DELETESELECTEDFILES), 2)) == 0) {
                    ToolpathInstallationViewHelper.this.deleteToolpathFiles(selectedValues);
                }
            }
        });
        box.add(Box.createVerticalGlue());
        box.add(this.removeButton);
        box.add(Box.createVerticalGlue());
        return box;
    }

    private void deleteToolpathFiles(List<String> selectedValues) {
        for (String file : selectedValues) {
            try {
                String path = "/programs/" + file;
                ProcessBuilder pb = new ProcessBuilder("rm", "-v", path);
                Process p = pb.start();
                p.waitFor();
                if (p.exitValue() != 0) {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                    while ((line = reader.readLine()) != null) {
                        System.out.println(line);
                    }
                }
                p.destroy();
                this.updateView();
            }
            catch (Exception ex) {
                System.err.println("Remote TCP cannot remove toolpath file " + file + ".");
            }
        }
    }

    private Component createSourceControlSection() {
        Box box = Box.createVerticalBox();
        box.setAlignmentX(0.0f);
        box.setAlignmentY(0.0f);
        box.setBorder(new EmptyBorder(10, 10, 10, 10));
        Dimension size = new Dimension(150, 500);
        box.setPreferredSize(size);
        box.setMaximumSize(size);
        this.importButton = new JButton();
        this.importButton.setAlignmentX(0.5f);
        this.importButton.setAlignmentY(0.0f);
        this.importButton.setName("Import_Button");
        this.importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (String file : ToolpathInstallationViewHelper.this.listSource.getSelectedValuesList()) {
                    try {
                        if (!ToolpathInstallationViewHelper.this.checkAndReportDaemonStatus()) {
                            return;
                        }
                        String sourceDirectory = ToolpathInstallationViewHelper.this.toolpathInfo.getSourceToolpathDirectory();
                        if (sourceDirectory.isEmpty()) {
                            return;
                        }
                        String sourcePath = sourceDirectory + "/" + file;
                        String targetPath = "/programs";
                        if (!this.checkForOverwrite(file, targetPath)) {
                            return;
                        }
                        if (!this.checkFileValidity(sourcePath, file)) {
                            return;
                        }
                        this.importFile(sourcePath, targetPath);
                        ToolpathInstallationViewHelper.this.updateView();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        System.err.println("Remote TCP cannot import toolpath file " + file + ".");
                    }
                }
            }

            public void importFile(String sourcePath, String targetPath) throws IOException, InterruptedException {
                ProcessBuilder pb = new ProcessBuilder("cp", sourcePath, targetPath);
                Process p = pb.start();
                p.waitFor();
                if (p.exitValue() != 0) {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                    while ((line = reader.readLine()) != null) {
                        System.out.println(line);
                    }
                }
                p.destroy();
            }

            public boolean checkFileValidity(String sourcePath, String file) {
                Object validationResult = RtcpXmlRpcClient.validateToolpathFile(sourcePath, 120);
                if (validationResult != null) {
                    String errorMessage;
                    Object[] results = (Object[])validationResult;
                    if ((Integer)results[0] != -1) {
                        String errorType = ToolpathInstallationViewHelper.this.localization.getLocalizedText((RtcpConstants.Strings)((Object)validationErrors.get(results[0])));
                        String rawMessage = ToolpathInstallationViewHelper.this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_TOOLPATH_VALIDATION_ERROR_MESSAGE);
                        StringBuilder sb = new StringBuilder();
                        Formatter formatter = new Formatter(sb);
                        formatter.format(rawMessage, file, errorType, (Integer)results[1]);
                        formatter.close();
                        errorMessage = sb.toString();
                    } else {
                        errorMessage = RtcpXmlRpcClient.getLastError();
                    }
                    JOptionPane.showMessageDialog(null, RtcpUtils.encloseWithHtml(errorMessage), ToolpathInstallationViewHelper.this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_WARNING_TITLE), 2);
                    return false;
                }
                return true;
            }

            public boolean checkForOverwrite(String file, String targetPath) {
                String message;
                int retval;
                File f = new File(targetPath + "/" + file);
                return !f.exists() || f.isDirectory() || (retval = JOptionPane.showConfirmDialog(null, RtcpUtils.encloseWithHtml(message = String.format(ToolpathInstallationViewHelper.this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_TOOLPATH_WARNING_FILEEXISTS), file)), ToolpathInstallationViewHelper.this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_WARNING_TITLE), 2, 2)) != 2;
            }
        });
        box.add(Box.createVerticalGlue());
        box.add(this.importButton);
        box.add(Box.createVerticalGlue());
        return box;
    }

    private Component createImportedSection() {
        this.modelImported = new DefaultListModel();
        this.listImported = new JList<String>(this.modelImported);
        this.listImported.setName("Imported_Files");
        this.labelImportedFiles = new JLabel();
        return this.createListSectionLayout(this.listImported, this.modelImported, this.labelImportedFiles);
    }

    private Component createSourceSection() {
        this.modelSource = new DefaultListModel();
        this.listSource = new JList<String>(this.modelSource);
        this.listSource.setName("USB_Files");
        this.labelUsbFiles = new JLabel();
        return this.createListSectionLayout(this.listSource, this.modelSource, this.labelUsbFiles);
    }

    private Component createListSectionLayout(JList<String> list, DefaultListModel<String> listModel, JLabel label) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setAlignmentX(0.0f);
        panel.setAlignmentY(0.0f);
        Dimension size = new Dimension(400, 500);
        panel.setPreferredSize(size);
        panel.setMaximumSize(size);
        label.setHorizontalAlignment(2);
        label.setAlignmentX(0.0f);
        label.setAlignmentY(0.0f);
        panel.add(this.createVerticalSpacing(20));
        panel.add(label);
        list.setAlignmentX(0.0f);
        list.setAlignmentY(0.0f);
        list.setLayoutOrientation(0);
        JScrollPane scrollPane = new JScrollPane(list);
        scrollPane.setAlignmentX(0.0f);
        scrollPane.setAlignmentY(0.0f);
        scrollPane.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        panel.add(this.createVerticalSpacing(10));
        panel.add(scrollPane);
        return panel;
    }
}

