/*
 * Decompiled with CFR 0.152.
 */
package com.energid.urcap.remotetcp.impl.InstallationNode;

import com.energid.urcap.remotetcp.impl.Common.RtcpConstants;
import com.energid.urcap.remotetcp.impl.Common.RtcpUtils;
import com.energid.urcap.remotetcp.impl.Common.RtcpXmlRpcClient;
import com.energid.urcap.remotetcp.impl.Interfaces.LocalizationInfo;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpDaemonControl;
import com.energid.urcap.remotetcp.impl.Interfaces.ToolpathIoInfo;
import com.ur.urcap.api.contribution.DaemonContribution;
import com.ur.urcap.api.domain.data.DataModel;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.swing.JOptionPane;

public class ToolpathIoHandler
implements ToolpathIoInfo {
    private DataModel dataModel;
    private final LinkedHashMap<Integer, Integer> inputPorts;
    private final LinkedHashMap<Integer, Integer> outputPorts;
    private LocalizationInfo localization;
    private RtcpDaemonControl daemonControl;
    private final int IS_DAEMON_REACHABLE_TIMEOUT = 10000;

    public ToolpathIoHandler(DataModel dataModel, LocalizationInfo localization, RtcpDaemonControl daemonControl) {
        this.dataModel = dataModel;
        this.inputPorts = new LinkedHashMap();
        this.outputPorts = new LinkedHashMap();
        this.localization = localization;
        this.daemonControl = daemonControl;
        this.initializeIoPorts();
    }

    @Override
    public void getIoPortsFromDataModel() {
        int[] mappedOutputPorts;
        int[] outputPortIds;
        this.initializeIoPorts();
        int[] inputPortIds = this.dataModel.get("INPUT_PORT_IDS", new int[0]);
        int[] mappedInputPorts = this.dataModel.get("MAPPED_INPUT_PORTS", new int[0]);
        if (inputPortIds.length != mappedInputPorts.length) {
            // empty if block
        }
        if (inputPortIds.length > 0) {
            for (int index = 0; index != inputPortIds.length; ++index) {
                this.inputPorts.put(inputPortIds[index], mappedInputPorts[index]);
            }
        }
        if ((outputPortIds = this.dataModel.get("OUTPUT_PORT_IDS", new int[0])).length != (mappedOutputPorts = this.dataModel.get("MAPPED_OUTPUT_PORTS", new int[0])).length) {
            // empty if block
        }
        if (outputPortIds.length > 0) {
            for (int index = 0; index != outputPortIds.length; ++index) {
                this.outputPorts.put(outputPortIds[index], mappedOutputPorts[index]);
            }
        }
    }

    @Override
    public boolean updateSelectedIo(int portId, int mappedPort, boolean isInput) {
        if (isInput) {
            return this.updateSelectedIo_Internal(portId, mappedPort, this.inputPorts, "DIGITAL_INPUT_MAPPING");
        }
        return this.updateSelectedIo_Internal(portId, mappedPort, this.outputPorts, "DIGITAL_OUTPUT_MAPPING");
    }

    private boolean updateSelectedIo_Internal(int portId, int mappedPort, LinkedHashMap<Integer, Integer> ports, String updateType) {
        Integer prevMappedPort = ports.put(portId, mappedPort);
        boolean retVal = this.updateController_Internal(ports, updateType);
        if (!retVal) {
            ports.put(portId, prevMappedPort);
            return false;
        }
        this.updateDataModel();
        return true;
    }

    @Override
    public int getSelectedIo(int portId, boolean isInput) {
        int mappedPort = isInput ? this.inputPorts.get(portId).intValue() : this.outputPorts.get(portId).intValue();
        return mappedPort;
    }

    private void initializeIoPorts() {
        for (int index = 0; index < 4; ++index) {
            this.inputPorts.put(index, 0);
            this.outputPorts.put(index, 0);
        }
    }

    private void updateDataModel() {
        Set<Integer> keys = this.inputPorts.keySet();
        int[] ioPortIds = new int[keys.size()];
        int[] mappedPorts = new int[keys.size()];
        int index = 0;
        for (Integer key : keys) {
            ioPortIds[index] = key;
            mappedPorts[index] = this.inputPorts.get(key);
            ++index;
        }
        this.dataModel.set("INPUT_PORT_IDS", ioPortIds);
        this.dataModel.set("MAPPED_INPUT_PORTS", mappedPorts);
        keys = this.outputPorts.keySet();
        ioPortIds = new int[keys.size()];
        mappedPorts = new int[keys.size()];
        index = 0;
        for (Integer key : keys) {
            ioPortIds[index] = key;
            mappedPorts[index] = this.outputPorts.get(key);
            ++index;
        }
        this.dataModel.set("OUTPUT_PORT_IDS", ioPortIds);
        this.dataModel.set("MAPPED_OUTPUT_PORTS", mappedPorts);
    }

    @Override
    public boolean updateController() {
        if (this.daemonControl.getDaemonDesiredState() == DaemonContribution.State.RUNNING && this.daemonControl.waitForDaemon(10000)) {
            return this.updateController_Internal(this.inputPorts, "DIGITAL_INPUT_MAPPING") & this.updateController_Internal(this.outputPorts, "DIGITAL_OUTPUT_MAPPING");
        }
        return false;
    }

    private boolean updateController_Internal(LinkedHashMap<Integer, Integer> ports, String ioPortType) {
        Set<Integer> keys = ports.keySet();
        int[] bitmaps = new int[keys.size()];
        int index = 0;
        for (Integer key : keys) {
            bitmaps[index] = this.getBitmapForPortIndex(ports.get(key));
            ++index;
        }
        boolean retVal = RtcpXmlRpcClient.setToolpathIoMapping(ioPortType, bitmaps, 10);
        if (!retVal) {
            String errorMsg = RtcpXmlRpcClient.getLastError();
            JOptionPane.showMessageDialog(null, RtcpUtils.encloseWithHtml(errorMsg), this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_WARNING_TITLE), 2);
            return false;
        }
        return true;
    }

    private int getBitmapForPortIndex(int portIndex) {
        if (portIndex <= 8) {
            return portIndex;
        }
        if (portIndex <= 10) {
            return portIndex + 8;
        }
        return portIndex - 2;
    }
}

