/*
 * Decompiled with CFR 0.152.
 */
package com.energid.urcap.remotetcp.impl.InstallationNode;

import com.energid.urcap.remotetcp.impl.Common.RtcpConstants;
import com.energid.urcap.remotetcp.impl.Common.RtcpUtils;
import com.energid.urcap.remotetcp.impl.Common.Style;
import com.energid.urcap.remotetcp.impl.InstallationNode.RtcpInstallationViewHelperBase;
import com.energid.urcap.remotetcp.impl.Interfaces.LocalizationInfo;
import com.energid.urcap.remotetcp.impl.Interfaces.ToolpathIoInfo;
import com.energid.urcap.remotetcp.impl.RemoteTcpInstallationNodeView;
import com.ur.urcap.api.contribution.DaemonContribution;
import com.ur.urcap.api.domain.io.DigitalIO;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;

public class ToolpathIoViewHelper
extends RtcpInstallationViewHelperBase {
    public static boolean ComboListens = true;
    private RemoteTcpInstallationNodeView.ViewContentSelector viewContentSelector;
    private ToolpathIoInfo toolpathIoInfo;
    private JPanel ioPanel;
    private JLabel labelToolpathIo;
    private JLabel labelPortName;
    private JLabel labelSelectIo;
    private JLabel labelInput;
    private JLabel labelOutput;
    private JButton homeButton;
    private Vector<PortMapItem> inputPorts;
    private Vector<PortMapItem> outputPorts;

    public ToolpathIoViewHelper(ToolpathIoInfo toolpathIoInfo, LocalizationInfo localization, Style style, RemoteTcpInstallationNodeView.ViewContentSelector viewContentSelector) {
        super(localization, style);
        this.toolpathIoInfo = toolpathIoInfo;
        this.viewContentSelector = viewContentSelector;
        this.inputPorts = new Vector();
        this.outputPorts = new Vector();
        for (int index = 0; index < 4; ++index) {
            this.inputPorts.addElement(new PortMapItem(index, true));
            this.outputPorts.addElement(new PortMapItem(index, false));
        }
    }

    public void updateView() {
        this.updateText();
        this.updateIoSelectionCombos();
    }

    private void updateText() {
        this.labelToolpathIo.setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_TOOLPATH_IO));
        this.labelPortName.setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_TPIO_PORTINNCFILE));
        this.labelSelectIo.setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_TPIO_SELECTIO));
        this.labelInput.setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_TPIO_INPUT));
        this.labelOutput.setText(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_TPIO_OUTPUT));
    }

    public JPanel createToolpathIoPanel() {
        this.ioPanel = new JPanel();
        this.ioPanel.setLayout(new BoxLayout(this.ioPanel, 1));
        this.ioPanel.setAlignmentY(0.0f);
        this.ioPanel.setAlignmentX(0.0f);
        this.ioPanel.setBorder(new EmptyBorder(10, 5, 10, 10));
        this.labelToolpathIo = new JLabel();
        this.labelToolpathIo.setFont(new Font(this.labelToolpathIo.getFont().getName(), 1, 20));
        this.labelToolpathIo.setHorizontalAlignment(2);
        this.labelToolpathIo.setAlignmentX(0.0f);
        this.labelToolpathIo.setAlignmentY(0.0f);
        this.homeButton = new JButton();
        this.homeButton.setName("Home_Button");
        this.homeButton.setIcon(this.homeIcon);
        this.homeButton.setAlignmentX(0.5f);
        this.homeButton.setAlignmentY(0.0f);
        this.homeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ToolpathIoViewHelper.this.viewContentSelector.setSelection(RemoteTcpInstallationNodeView.RtcpInstallationViewType.Home);
            }
        });
        Box titleBox = Box.createHorizontalBox();
        titleBox.setAlignmentX(0.0f);
        titleBox.setAlignmentY(0.0f);
        titleBox.add(this.labelToolpathIo);
        titleBox.add(Box.createHorizontalGlue());
        titleBox.add(this.homeButton);
        this.ioPanel.add(titleBox);
        this.ioPanel.add(this.createIoMappingSection());
        return this.ioPanel;
    }

    private JPanel createInputPanel() {
        return null;
    }

    private JPanel createOutputPanel() {
        return null;
    }

    protected JPanel createIoMappingSection() {
        JPanel ioPanel = new JPanel(new GridBagLayout());
        ioPanel.setAlignmentX(0.0f);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridheight = 4;
        this.labelOutput = new JLabel();
        this.labelOutput.setFont(new Font(this.labelOutput.getFont().getName(), 1, 18));
        this.labelOutput.setAlignmentX(0.5f);
        ioPanel.add((Component)this.labelOutput, gbc);
        gbc.gridx = 0;
        gbc.gridy = 7;
        gbc.gridheight = 4;
        gbc.insets = new Insets(0, 50, 0, 50);
        gbc.fill = 1;
        this.labelInput = new JLabel();
        this.labelInput.setFont(new Font(this.labelInput.getFont().getName(), 1, 18));
        this.labelInput.setAlignmentX(0.5f);
        ioPanel.add((Component)this.labelInput, gbc);
        gbc.gridheight = 1;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = new Insets(15, 100, 15, 100);
        this.labelPortName = new JLabel();
        this.labelPortName.setFont(new Font(this.labelPortName.getFont().getName(), 1, 16));
        this.labelPortName.setAlignmentX(0.5f);
        this.labelPortName.setHorizontalAlignment(2);
        ioPanel.add((Component)this.labelPortName, gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        this.labelSelectIo = new JLabel();
        this.labelSelectIo.setFont(new Font(this.labelSelectIo.getFont().getName(), 1, 16));
        this.labelSelectIo.setAlignmentX(0.5f);
        this.labelSelectIo.setHorizontalAlignment(2);
        ioPanel.add((Component)this.labelSelectIo, gbc);
        int col = 1;
        int row = 2;
        for (PortMapItem item : this.outputPorts) {
            this.addPortLabel(col, row, item, ioPanel);
            this.addPortSelectionCombo(col + 1, row++, item, ioPanel);
        }
        col = 1;
        row = 7;
        for (PortMapItem item : this.inputPorts) {
            this.addPortLabel(col, row, item, ioPanel);
            this.addPortSelectionCombo(col + 1, row++, item, ioPanel);
        }
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 3;
        gbc.fill = 2;
        ioPanel.add((Component)new JSeparator(0), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.gridwidth = 3;
        gbc.fill = 2;
        ioPanel.add((Component)new JSeparator(0), gbc);
        return ioPanel;
    }

    private void addPortLabel(int x, int y, PortMapItem item, JPanel container) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.insets = new Insets(12, 100, 12, 100);
        JLabel labelPortId = new JLabel();
        labelPortId.setAlignmentX(0.5f);
        labelPortId.setHorizontalAlignment(2);
        labelPortId.setFont(new Font(labelPortId.getFont().getName(), 1, 16));
        labelPortId.setText(item.portName);
        labelPortId.setName(item.componentNamePrefix);
        container.add((Component)labelPortId, gbc);
    }

    private void addPortSelectionCombo(int x, int y, final PortMapItem item, JPanel container) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.insets = new Insets(12, 100, 12, 100);
        gbc.fill = 1;
        item.combo.setAlignmentX(0.5f);
        item.combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ComboListens) {
                    return;
                }
                Integer previousSelectedPort = ToolpathIoViewHelper.this.toolpathIoInfo.getSelectedIo(item.portId, item.isInput);
                if (ToolpathIoViewHelper.this.daemonControl.getDaemonDesiredState() != DaemonContribution.State.RUNNING || !ToolpathIoViewHelper.this.daemonControl.isServerReachable()) {
                    item.combo.setSelectedIndex(previousSelectedPort);
                    item.combo.setPopupVisible(false);
                    JOptionPane.showMessageDialog(null, RtcpUtils.encloseWithHtml(ToolpathIoViewHelper.this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_ERROR_DAEMONSTOPPED)), ToolpathIoViewHelper.this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_WARNING_TITLE), 2);
                } else {
                    int selectedIndex = item.combo.getSelectedIndex();
                    if (!ToolpathIoViewHelper.this.toolpathIoInfo.updateSelectedIo(item.portId, selectedIndex, item.isInput)) {
                        item.combo.setSelectedIndex(previousSelectedPort);
                        item.combo.setPopupVisible(false);
                    }
                }
                ToolpathIoViewHelper.this.updateView();
            }
        });
        container.add((Component)item.combo, gbc);
    }

    private void updateIoSelectionCombos() {
        Collection ios = this.apiProvider.getInstallationAPI().getIOModel().getIOs(DigitalIO.class);
        for (PortMapItem item : this.inputPorts) {
            this.updateIoSelectionCombo(item, ios);
        }
        for (PortMapItem item : this.outputPorts) {
            this.updateIoSelectionCombo(item, ios);
        }
    }

    private void updateIoSelectionCombo(PortMapItem item, Collection<DigitalIO> ios) {
        ComboListens = false;
        item.combo.removeAllItems();
        int selectedIo = this.toolpathIoInfo.getSelectedIo(item.portId, item.isInput);
        String defaultIoPortName = item.isInput ? "<Di.Input>" : "<Di.Output>";
        item.combo.addItem(defaultIoPortName);
        for (DigitalIO io : ios) {
            if (io.isInput() != item.isInput) continue;
            item.combo.addItem(io.getName());
        }
        item.combo.setSelectedIndex(selectedIo);
        ComboListens = true;
    }

    public class PortMapItem {
        public int portId;
        public String portName;
        public JComboBox combo;
        public boolean isInput;
        public String componentNamePrefix;

        public PortMapItem(int portId, boolean isInput) {
            this.portId = portId;
            this.portName = "P" + portId;
            this.isInput = isInput;
            this.componentNamePrefix = this.portName + (isInput ? "_Input_" : "_Output_");
            this.combo = new JComboBox();
            this.combo.setName(this.componentNamePrefix + "Combo");
        }
    }
}

