/*
 * Decompiled with CFR 0.152.
 */
package com.energid.urcap.remotetcp.impl.Instructions;

import com.energid.urcap.remotetcp.impl.Instructions.InstructionsContentPanel;
import com.energid.urcap.remotetcp.impl.Instructions.InstructionsViewHelper;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JPanel;

public class InstructionsContentPresenter {
    private ArrayList<InstructionStep> stepDescriptions = new ArrayList();
    private int currentIndex = -1;
    private InstructionsContentPanel contentPanel = new InstructionsContentPanel();

    protected InstructionsContentPresenter() {
    }

    public void setTitle(String title) {
        this.contentPanel.setTitle(title);
    }

    public void addStep(String step) {
        this.stepDescriptions.add(new InstructionStep(step, null, 0));
    }

    public void addStep(String step, Icon illustration) {
        this.stepDescriptions.add(new InstructionStep(step, illustration, 0));
    }

    public void addStep(String step, Icon illustration, int verticalSpace) {
        this.stepDescriptions.add(new InstructionStep(step, illustration, verticalSpace));
    }

    public JPanel getContentPanel() {
        return this.contentPanel;
    }

    public void moveNext() {
        if (this.currentIndex < this.stepDescriptions.size() - 1) {
            InstructionStep step = this.stepDescriptions.get(++this.currentIndex);
            this.updatePresenter(step);
        }
    }

    public void movePrev() {
        if (this.currentIndex > 0) {
            InstructionStep step = this.stepDescriptions.get(--this.currentIndex);
            this.updatePresenter(step);
        }
    }

    private void updatePresenter(InstructionStep step) {
        String detail = this.getDetail(this.currentIndex, step);
        this.contentPanel.setDetail(detail);
        this.contentPanel.setIllustration(step.illustration, step.verticalSpace);
    }

    private String getDetail(int index, InstructionStep step) {
        String detail = "<b>" + InstructionsViewHelper.localizedStep + " " + (index + 1) + "/" + this.stepDescriptions.size() + ".</b> " + step.detail;
        return detail;
    }

    public void reset() {
        this.currentIndex = -1;
        this.moveNext();
    }

    public boolean hasNext() {
        return this.currentIndex < this.stepDescriptions.size() - 1;
    }

    public boolean hasPrevious() {
        return this.currentIndex > 0;
    }

    private class InstructionStep {
        public String detail;
        public Icon illustration;
        public int verticalSpace;

        public InstructionStep(String detail, Icon illustration, int verticalSpace) {
            this.detail = detail;
            this.illustration = illustration;
            this.verticalSpace = verticalSpace;
        }
    }
}

