/*
 * Decompiled with CFR 0.152.
 */
package com.energid.urcap.remotetcp.impl.Instructions;

import com.energid.urcap.remotetcp.impl.Common.RtcpConstants;
import com.energid.urcap.remotetcp.impl.Common.RtcpViewHelperBase;
import com.energid.urcap.remotetcp.impl.Common.Style;
import com.energid.urcap.remotetcp.impl.InstallationNode.RtcpInstallationViewHelperBase;
import com.energid.urcap.remotetcp.impl.Instructions.InstructionsContentPresenter;
import com.energid.urcap.remotetcp.impl.Interfaces.LocalizationInfo;
import com.energid.urcap.remotetcp.impl.RemoteTcpInstallationNodeView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

public class InstructionsViewHelper
extends RtcpInstallationViewHelperBase {
    private LocalizationInfo localization;
    private RemoteTcpInstallationNodeView.ViewContentSelector viewContentSelector;
    private JButton homeButton;
    private JPanel mainPanel;
    private JPanel contentPanel;
    private InstructionsContentPresenter presenterRegularToolpath;
    private InstructionsContentPresenter presenterRemoteToolpath;
    private InstructionsContentPresenter presenterRemoteLinear;
    private InstructionsContentPresenter currentPresenter;
    private JButton btnNext;
    private JButton btnPrev;
    public static String localizedStep;

    public InstructionsViewHelper(LocalizationInfo localization, Style style, RemoteTcpInstallationNodeView.ViewContentSelector viewContentSelector) {
        super(localization, style);
        this.localization = localization;
        this.viewContentSelector = viewContentSelector;
        localizedStep = localization.getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_STEP);
        this.createMainPanel();
        this.initializeInstructionManager();
    }

    public JPanel getInstructionsPanel() {
        return this.mainPanel;
    }

    public InstructionsContentPresenter createContentPresenter(String title) {
        InstructionsContentPresenter presenter = new InstructionsContentPresenter();
        presenter.setTitle(title);
        return presenter;
    }

    private void createMainPanel() {
        this.mainPanel = new JPanel();
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.mainPanel.setLayout(new BorderLayout());
        this.homeButton = new JButton();
        this.homeButton.setName("Home_Button");
        this.homeButton.setIcon(this.homeIcon);
        this.homeButton.setAlignmentX(0.5f);
        this.homeButton.setAlignmentY(0.0f);
        this.homeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                InstructionsViewHelper.this.viewContentSelector.setSelection(RemoteTcpInstallationNodeView.RtcpInstallationViewType.Home);
            }
        });
        Box contentWithHome = Box.createVerticalBox();
        contentWithHome.setAlignmentX(0.5f);
        Box titleBox = Box.createHorizontalBox();
        titleBox.setAlignmentX(0.0f);
        titleBox.setAlignmentY(0.0f);
        titleBox.add(Box.createHorizontalGlue());
        titleBox.add(this.homeButton);
        contentWithHome.add(titleBox);
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 1));
        this.contentPanel.setAlignmentX(0.5f);
        contentWithHome.add(this.contentPanel);
        this.mainPanel.add((Component)contentWithHome, "North");
        BufferedImage imgNext = null;
        BufferedImage imgPrev = null;
        try {
            imgNext = ImageIO.read(this.getClass().getClassLoader().getResource("right_arrow3.png"));
            imgPrev = ImageIO.read(this.getClass().getClassLoader().getResource("left_arrow3.png"));
        }
        catch (Exception e1) {
            System.out.println("non-fatal Exception loading images");
        }
        ImageIcon iconNext = new ImageIcon(imgNext);
        ImageIcon iconPrev = new ImageIcon(imgPrev);
        Dimension naviButtonSize = new Dimension(200, 40);
        this.btnNext = new JButton(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_NEXT));
        this.btnNext.setPreferredSize(naviButtonSize);
        this.btnNext.setAlignmentX(0.5f);
        this.btnNext.setIcon(iconNext);
        this.btnNext.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        this.btnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                InstructionsViewHelper.this.currentPresenter.moveNext();
                InstructionsViewHelper.this.updateNavi();
            }
        });
        this.btnPrev = new JButton(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_PREVIOUS));
        this.btnPrev.setPreferredSize(naviButtonSize);
        this.btnPrev.setAlignmentX(0.5f);
        this.btnPrev.setIcon(iconPrev);
        this.btnPrev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                InstructionsViewHelper.this.currentPresenter.movePrev();
                InstructionsViewHelper.this.updateNavi();
            }
        });
        this.mainPanel.add(Box.createVerticalGlue());
        Box navi = Box.createHorizontalBox();
        navi.setAlignmentX(0.5f);
        navi.add(Box.createHorizontalGlue());
        navi.add(this.btnPrev);
        navi.add(Box.createHorizontalStrut(5));
        navi.add(this.btnNext);
        navi.add(Box.createHorizontalGlue());
        this.mainPanel.add((Component)navi, "South");
    }

    protected void updateNavi() {
        this.btnNext.setEnabled(this.currentPresenter.hasNext());
        this.btnPrev.setEnabled(this.currentPresenter.hasPrevious());
    }

    public void setInstructionsContent(RemoteTcpInstallationNodeView.RtcpInstallationViewType viewType) {
        switch (viewType) {
            case Home: {
                break;
            }
            case RegularTcpToolpath: {
                this.currentPresenter = this.presenterRegularToolpath;
                break;
            }
            case RemoteTcpLinearCircular: {
                this.currentPresenter = this.presenterRemoteLinear;
                break;
            }
            case RemoteTcpToolpath: {
                this.currentPresenter = this.presenterRemoteToolpath;
                break;
            }
        }
        this.currentPresenter.reset();
        this.updateContent(this.currentPresenter.getContentPanel());
        this.updateNavi();
    }

    private void updateContent(JPanel content) {
        this.contentPanel.removeAll();
        this.contentPanel.add(content);
        this.contentPanel.revalidate();
        this.contentPanel.repaint();
    }

    private void initializeInstructionManager() {
        this.presenterRegularToolpath = this.createContentPresenter(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_INSTRUCTIONS_TAB_REGULARTOOLPATH));
        this.presenterRegularToolpath.addStep(this.localization.getLocalizedText(RtcpConstants.Strings.REGULARTCP_INSTRUCTIONS_STEP1), RtcpViewHelperBase.getIconResourceScaled("Toolpath.png", 350));
        this.presenterRegularToolpath.addStep(this.localization.getLocalizedText(RtcpConstants.Strings.REGULARTCP_INSTRUCTIONS_STEP2), RtcpViewHelperBase.getIconResourceScaled("GCodeToPolyscope.png", 700));
        this.presenterRegularToolpath.addStep(this.localization.getLocalizedText(RtcpConstants.Strings.REGULARTCP_INSTRUCTIONS_STEP3), RtcpViewHelperBase.getIconResourceScaled("RegularTCP-Toolpath.png", 350));
        this.presenterRegularToolpath.addStep(this.localization.getLocalizedText(RtcpConstants.Strings.REGULARTCP_INSTRUCTIONS_STEP4));
        this.presenterRegularToolpath.addStep(this.localization.getLocalizedText(RtcpConstants.Strings.REGULARTCP_INSTRUCTIONS_STEP5));
        this.presenterRegularToolpath.addStep(this.localization.getLocalizedText(RtcpConstants.Strings.REGULARTCP_INSTRUCTIONS_STEP6));
        this.presenterRegularToolpath.addStep(this.localization.getLocalizedText(RtcpConstants.Strings.REGULARTCP_INSTRUCTIONS_STEP7), RtcpViewHelperBase.getIconResourceScaled("MoveJ_before_Toolpath_Move.png", 250), 20);
        this.presenterRegularToolpath.addStep(this.localization.getLocalizedText(RtcpConstants.Strings.REGULARTCP_INSTRUCTIONS_STEP8));
        this.presenterRegularToolpath.reset();
        this.presenterRemoteToolpath = this.createContentPresenter(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_INSTRUCTIONS_TAB_TOOLPATH));
        this.presenterRemoteToolpath.addStep(this.localization.getLocalizedText(RtcpConstants.Strings.REMOTETCP_INSTRUCTIONS_STEP1), RtcpViewHelperBase.getIconResourceScaled("Toolpath.png", 325));
        this.presenterRemoteToolpath.addStep(this.localization.getLocalizedText(RtcpConstants.Strings.REMOTETCP_INSTRUCTIONS_STEP2), RtcpViewHelperBase.getIconResourceScaled("GCodeToPolyscope.png", 700));
        this.presenterRemoteToolpath.addStep(this.localization.getLocalizedText(RtcpConstants.Strings.REMOTETCP_INSTRUCTIONS_STEP3), RtcpViewHelperBase.getIconResourceScaled("RTCPConfiguration-Toolpath.png", 320));
        this.presenterRemoteToolpath.addStep(this.localization.getLocalizedText(RtcpConstants.Strings.REMOTETCP_INSTRUCTIONS_STEP4));
        this.presenterRemoteToolpath.addStep(this.localization.getLocalizedText(RtcpConstants.Strings.REMOTETCP_INSTRUCTIONS_STEP5));
        this.presenterRemoteToolpath.addStep(this.localization.getLocalizedText(RtcpConstants.Strings.REMOTETCP_INSTRUCTIONS_STEP6));
        this.presenterRemoteToolpath.addStep(this.localization.getLocalizedText(RtcpConstants.Strings.REMOTETCP_INSTRUCTIONS_STEP7), RtcpViewHelperBase.getIconResourceScaled("MoveJ_before_RTCP_Move.png", 250), 20);
        this.presenterRemoteToolpath.addStep(this.localization.getLocalizedText(RtcpConstants.Strings.REMOTETCP_INSTRUCTIONS_STEP8));
        this.presenterRemoteToolpath.reset();
        this.presenterRemoteLinear = this.createContentPresenter(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_INSTRUCTIONS_TAB_RTCP));
        this.presenterRemoteLinear.addStep(this.localization.getLocalizedText(RtcpConstants.Strings.REMOTETCP_LINEAR_INSTRUCTIONS_STEP1), RtcpViewHelperBase.getIconResourceScaled("RTCPConfiguration-LinearandCircleMoves.png", 350), 20);
        this.presenterRemoteLinear.addStep(this.localization.getLocalizedText(RtcpConstants.Strings.REMOTETCP_LINEAR_INSTRUCTIONS_STEP2));
        this.presenterRemoteLinear.addStep(this.localization.getLocalizedText(RtcpConstants.Strings.REMOTETCP_LINEAR_INSTRUCTIONS_STEP3));
        this.presenterRemoteLinear.addStep(this.localization.getLocalizedText(RtcpConstants.Strings.REMOTETCP_LINEAR_INSTRUCTIONS_STEP4));
        this.presenterRemoteLinear.reset();
    }
}

