/*
 * Decompiled with CFR 0.152.
 */
package com.energid.urcap.remotetcp.impl.MoveNodes;

import com.energid.urcap.remotetcp.impl.Common.RtcpConstants;
import com.energid.urcap.remotetcp.impl.Common.RtcpMotionParameters;
import com.energid.urcap.remotetcp.impl.Interfaces.LocalizationInfo;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpCircleMoveNode;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpMoveNode;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpProgramInfo;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpWaypointNode;
import com.energid.urcap.remotetcp.impl.MoveNodes.RtcpCircleMoveProgramNodeView;
import com.energid.urcap.remotetcp.impl.RemoteTcpInstallationNodeContribution;
import com.energid.urcap.remotetcp.impl.WaypointNodes.RtcpEndpointProgramNodeService;
import com.energid.urcap.remotetcp.impl.WaypointNodes.RtcpToolpathProgramNodeService;
import com.energid.urcap.remotetcp.impl.WaypointNodes.RtcpViapointProgramNodeService;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.contribution.program.ProgramAPIProvider;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.program.ProgramModel;
import com.ur.urcap.api.domain.program.nodes.ProgramNode;
import com.ur.urcap.api.domain.program.nodes.ProgramNodeFactory;
import com.ur.urcap.api.domain.program.nodes.contributable.URCapProgramNode;
import com.ur.urcap.api.domain.program.structure.ProgramNodeVisitor;
import com.ur.urcap.api.domain.program.structure.TreeNode;
import com.ur.urcap.api.domain.program.structure.TreeStructureException;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.undoredo.UndoRedoManager;
import com.ur.urcap.api.domain.undoredo.UndoableChanges;

public class RtcpCircleMoveProgramNodeContribution
implements ProgramNodeContribution,
RtcpCircleMoveNode {
    private final ProgramAPIProvider apiProvider;
    private final UndoRedoManager undoRedoManager;
    private final RtcpCircleMoveProgramNodeView view;
    private final DataModel model;
    private final String DATAMODEL_SUBTREE_CREATED = "subtreeCreated";
    private boolean subtreeCreated = false;
    private String scriptId;

    public RtcpCircleMoveProgramNodeContribution(ProgramAPIProvider apiProvider, RtcpCircleMoveProgramNodeView view, DataModel model) {
        this.apiProvider = apiProvider;
        this.undoRedoManager = apiProvider.getProgramAPI().getUndoRedoManager();
        this.view = view;
        this.model = model;
        this.subtreeCreated = model.get("subtreeCreated", false);
        if (!this.subtreeCreated) {
            this.createWaypoints();
            this.subtreeCreated = true;
            model.set("subtreeCreated", this.subtreeCreated);
        }
        this.apiProvider.getProgramAPI().getProgramModel().getRootTreeNode((ProgramNodeContribution)this).setChildSequenceLocked(true);
    }

    private void createWaypoints() {
        ProgramModel programModel = this.apiProvider.getProgramAPI().getProgramModel();
        final ProgramNodeFactory programNodeFactory = programModel.getProgramNodeFactory();
        final TreeNode rootTreeNode = programModel.getRootTreeNode((ProgramNodeContribution)this);
        rootTreeNode.setChildSequenceLocked(false);
        this.undoRedoManager.recordChanges(new UndoableChanges(){

            public void executeChanges() {
                try {
                    rootTreeNode.addChild((ProgramNode)programNodeFactory.createURCapProgramNode(RtcpViapointProgramNodeService.class));
                    rootTreeNode.addChild((ProgramNode)programNodeFactory.createURCapProgramNode(RtcpEndpointProgramNodeService.class));
                }
                catch (TreeStructureException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void openView() {
        this.view.getHelper().setContribution(this);
        this.view.getHelper().setApiProvider(this.apiProvider);
        this.updateView();
    }

    private void updateView() {
        this.readDataModel();
        this.view.getHelper().updateView();
    }

    public void closeView() {
        this.updateDataModel();
    }

    public String getTitle() {
        LocalizationInfo localizationInfo = (LocalizationInfo)this.apiProvider.getProgramAPI().getInstallationNode(RemoteTcpInstallationNodeContribution.class);
        return localizationInfo.getLocalizedText(RtcpConstants.Strings.RTCP_CIRCLEMOVE_PROGRAMNODE_TREETEXT);
    }

    public boolean isDefined() {
        return true;
    }

    public void generateScript(ScriptWriter writer) {
        writer.appendLine("mc_run_motion(" + this.scriptId + ")");
    }

    public void updateDataModel() {
        this.undoRedoManager.recordChanges(new UndoableChanges(){

            public void executeChanges() {
                RtcpCircleMoveProgramNodeContribution.this.updateDataModelWithUndo();
            }
        });
    }

    private void updateDataModelWithUndo() {
        this.model.remove("MODE_FIXED");
        this.model.set("MODE_FIXED", this.view.getHelper().getUsingModeFixed());
    }

    public void readDataModel() {
        this.view.getHelper().setUsingModeFixed(this.isUsingModeFixed());
    }

    public boolean isUsingModeFixed() {
        return this.model.get("MODE_FIXED", false);
    }

    @Override
    public void writeScriptForMoveNode(ScriptWriter writer, String scriptId, RtcpMotionParameters params) {
        this.scriptId = scriptId;
        final RtcpWaypointNode[] nodes = new RtcpWaypointNode[2];
        this.apiProvider.getProgramAPI().getProgramModel().getRootTreeNode((ProgramNodeContribution)this).traverse(new ProgramNodeVisitor(){

            public void visit(URCapProgramNode childNode, int index, int depth) {
                try {
                    if (childNode.canGetAs(RtcpWaypointNode.class)) {
                        RtcpWaypointNode waypointNode = (RtcpWaypointNode)childNode.getAs(RtcpWaypointNode.class);
                        waypointNode.writeScriptForMoveNode(null, "", 0, null);
                        if (waypointNode.getWaypointType().equals((Object)RtcpWaypointNode.WaypointType.Viapoint)) {
                            nodes[0] = waypointNode;
                        } else if (waypointNode.getWaypointType().equals((Object)RtcpWaypointNode.WaypointType.Endpoint)) {
                            nodes[1] = waypointNode;
                        }
                    }
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        });
        String viaPose = nodes[0].getCalculatedPose().toString();
        String endPose = nodes[1].getCalculatedPose().toString();
        writer.appendLine("mc_debugMsg(\"" + nodes[0].getWaypointName() + " \", " + viaPose + ")");
        writer.appendLine("mc_debugMsg(\"" + nodes[1].getWaypointName() + " \", " + endPose + ")");
        int circleMode = this.isUsingModeFixed() ? 0 : 1;
        String script = scriptId + " = mc_add_circular(" + viaPose + ", " + endPose + ", " + nodes[1].getToolAcceleration() / 1000.0 + ", " + nodes[1].getToolSpeed() / 1000.0 + ", " + nodes[1].getBlendRadius() / 1000.0 + ", " + circleMode + ")";
        writer.appendLine(script);
        writer.appendLine("mc_debugMsg(\"" + nodes[0].getWaypointName() + " is ID \", " + scriptId + ")");
        writer.appendLine("mc_debugMsg(\"" + nodes[1].getWaypointName() + " is ID \", " + scriptId + ")");
    }

    public void appendWaypoint() {
        TreeNode thisNode = this.apiProvider.getProgramAPI().getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        this.getParent().insertWaypoint(thisNode);
    }

    public void appendCircleMove() {
        TreeNode thisNode = this.apiProvider.getProgramAPI().getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        this.getParent().insertCircleMove(thisNode);
    }

    public void appendToolpath() {
        TreeNode thisNode = this.apiProvider.getProgramAPI().getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        this.getParent().insertToolpath(thisNode, RtcpToolpathProgramNodeService.class);
    }

    private RtcpMoveNode getParent() {
        RtcpProgramInfo programInfo = (RtcpProgramInfo)this.apiProvider.getProgramAPI().getInstallationNode(RemoteTcpInstallationNodeContribution.class);
        return programInfo.getParent(this);
    }
}

