/*
 * Decompiled with CFR 0.152.
 */
package com.energid.urcap.remotetcp.impl.MoveNodes;

import com.energid.urcap.remotetcp.impl.Common.RtcpConstants;
import com.energid.urcap.remotetcp.impl.Common.RtcpUtils;
import com.energid.urcap.remotetcp.impl.Common.RtcpViewHelperBase;
import com.energid.urcap.remotetcp.impl.Common.Style;
import com.energid.urcap.remotetcp.impl.MoveNodes.RtcpCircleMoveProgramNodeContribution;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class RtcpCircleMoveViewHelper
extends RtcpViewHelperBase {
    private RtcpCircleMoveProgramNodeContribution contribution;
    private JLabel commonMessage;
    private JLabel modeMessage;
    private JRadioButton fixedRadioButton;
    private JRadioButton unconstrainedRadioButton;
    private JLabel selectionText;
    private JButton waypointButton;
    private JButton circleMoveButton;
    private JButton toolpathButton;
    private final int messageAreaWidth = 350;
    private final int graphicsAreaWidth = 350;
    private final int graphicsAreaHeight = 300;
    private final int imageScaleWidth = 300;
    private final int upperHeight = 280;
    private boolean usingModeFixed = true;
    private JLabel labelModeImage;
    private ImageIcon iconFixed;
    private ImageIcon iconUnconstrained;

    public RtcpCircleMoveViewHelper(JPanel panel, Style style) {
        this.style = style;
        this.container = panel;
        this.borderThickness = 0;
        this.defaultBorder = BorderFactory.createLineBorder(Color.BLACK, this.borderThickness);
    }

    public void buildMainPanel() {
        this.container.setLayout(new BoxLayout(this.container, 1));
        Box upperSection = this.createUpperSection();
        Box lowerSection = this.createLowerSection();
        this.container.add(upperSection);
        this.container.add(lowerSection);
    }

    private Box createUpperSection() {
        Box main = Box.createHorizontalBox();
        main.setAlignmentX(0.0f);
        main.setAlignmentY(0.0f);
        main.setMinimumSize(new Dimension(700, 280));
        main.setMaximumSize(new Dimension(700, 280));
        main.setPreferredSize(new Dimension(700, 280));
        main.setBorder(this.defaultBorder);
        Box messageSection = this.createMessageSection();
        Box graphicsSection = this.createGraphicsSection();
        main.add(messageSection);
        main.add(graphicsSection);
        return main;
    }

    private Box createGraphicsSection() {
        Box main = Box.createVerticalBox();
        main.setAlignmentX(0.0f);
        main.setMinimumSize(new Dimension(350, 300));
        main.setMaximumSize(new Dimension(350, 300));
        main.setPreferredSize(new Dimension(350, 300));
        main.setBorder(this.defaultBorder);
        Image imgFixedMode = null;
        Image imgUnconstrainedMode = null;
        try {
            imgFixedMode = ImageIO.read(this.getClass().getClassLoader().getResource("circle_mode_fixed.png"));
            imgUnconstrainedMode = ImageIO.read(this.getClass().getClassLoader().getResource("circle_mode_unconstrained.png"));
        }
        catch (Exception e1) {
            System.out.println("non-fatal Exception loading MoveCircle images");
        }
        imgFixedMode = imgFixedMode.getScaledInstance(300, -1, 4);
        imgUnconstrainedMode = imgUnconstrainedMode.getScaledInstance(300, -1, 4);
        this.iconFixed = new ImageIcon(imgFixedMode);
        this.iconUnconstrained = new ImageIcon(imgUnconstrainedMode);
        this.labelModeImage = new JLabel();
        main.add(this.labelModeImage);
        return main;
    }

    private Box createMessageSection() {
        Box main = Box.createVerticalBox();
        main.setAlignmentX(0.0f);
        main.setMinimumSize(new Dimension(350, 280));
        main.setMaximumSize(new Dimension(350, 280));
        main.setPreferredSize(new Dimension(350, 280));
        main.setBorder(this.defaultBorder);
        this.commonMessage = new JLabel();
        main.add(this.commonMessage);
        main.add(this.createVerticalSpacing(30));
        this.modeMessage = new JLabel();
        this.modeMessage.setName(this.controlNameBase + "_ModeMessage");
        main.add(this.modeMessage);
        return main;
    }

    private Box createLowerSection() {
        Box main = Box.createVerticalBox();
        main.setAlignmentX(0.0f);
        main.setAlignmentY(0.0f);
        main.setMaximumSize(new Dimension(700, 300));
        main.setBorder(this.defaultBorder);
        this.selectionText = new JLabel();
        main.add(this.selectionText);
        this.fixedRadioButton = new JRadioButton();
        this.fixedRadioButton.setAlignmentY(0.5f);
        this.fixedRadioButton.setName(this.controlNameBase + "_SelectFixed");
        this.unconstrainedRadioButton = new JRadioButton();
        this.unconstrainedRadioButton.setAlignmentY(0.5f);
        this.unconstrainedRadioButton.setName(this.controlNameBase + "_SelectUnconstrained");
        ButtonGroup group = new ButtonGroup();
        group.add(this.fixedRadioButton);
        group.add(this.unconstrainedRadioButton);
        this.fixedRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RtcpCircleMoveViewHelper.this.modeSelectionHandler();
            }
        });
        this.unconstrainedRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RtcpCircleMoveViewHelper.this.modeSelectionHandler();
            }
        });
        main.add(this.fixedRadioButton);
        main.add(this.unconstrainedRadioButton);
        Icon plusIcon = RtcpCircleMoveViewHelper.getIconResource("plus_icon.png");
        main.add(this.createVerticalSpacing(20));
        JPanel buttonBox = new JPanel(new GridLayout(3, 1, 5, 10));
        buttonBox.setMaximumSize(new Dimension(200, 120));
        buttonBox.setPreferredSize(new Dimension(200, 120));
        buttonBox.setAlignmentX(0.0f);
        buttonBox.setAlignmentY(0.0f);
        this.waypointButton = new JButton();
        this.waypointButton.setIcon(plusIcon);
        this.waypointButton.setHorizontalAlignment(2);
        this.waypointButton.setMargin(new Insets(3, 10, 3, 10));
        this.waypointButton.setName(this.controlNameBase + "_AddWaypoint");
        this.waypointButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RtcpCircleMoveViewHelper.this.contribution.appendWaypoint();
            }
        });
        this.circleMoveButton = new JButton();
        this.circleMoveButton.setIcon(plusIcon);
        this.circleMoveButton.setHorizontalAlignment(2);
        this.circleMoveButton.setMargin(new Insets(3, 10, 3, 10));
        this.circleMoveButton.setName(this.controlNameBase + "_AddCircleMove");
        this.circleMoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RtcpCircleMoveViewHelper.this.contribution.appendCircleMove();
            }
        });
        this.toolpathButton = new JButton();
        this.toolpathButton.setIcon(plusIcon);
        this.toolpathButton.setHorizontalAlignment(2);
        this.toolpathButton.setMargin(new Insets(3, 10, 3, 10));
        this.toolpathButton.setName(this.controlNameBase + "_AddToolpath");
        this.toolpathButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RtcpCircleMoveViewHelper.this.contribution.appendToolpath();
            }
        });
        buttonBox.add(this.waypointButton);
        buttonBox.add(this.circleMoveButton);
        buttonBox.add(this.toolpathButton);
        Box westBox = Box.createHorizontalBox();
        westBox.setAlignmentX(0.0f);
        westBox.add(buttonBox);
        westBox.add(Box.createHorizontalGlue());
        main.add(westBox);
        return main;
    }

    protected void modeSelectionHandler() {
        this.usingModeFixed = this.fixedRadioButton.isSelected();
        this.updateModeMessage();
        this.updateModeGraphics();
        this.contribution.updateDataModel();
    }

    private void updateModeMessage() {
        String message = this.usingModeFixed ? RtcpUtils.encloseWithHtml(this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_CIRCLEMOVE_FIXEDMODE_MESSAGE)) : RtcpUtils.encloseWithHtml(this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_CIRCLEMOVE_UNCONTSRAINEDMODE_MESSAGE));
        this.modeMessage.setText(message);
    }

    private void updateModeGraphics() {
        if (this.usingModeFixed) {
            this.labelModeImage.setIcon(this.iconFixed);
        } else {
            this.labelModeImage.setIcon(this.iconUnconstrained);
        }
    }

    public void updateView() {
        this.updateText();
        this.fixedRadioButton.setSelected(this.usingModeFixed);
        this.unconstrainedRadioButton.setSelected(!this.usingModeFixed);
        this.updateModeMessage();
        this.updateModeGraphics();
    }

    private void updateText() {
        this.commonMessage.setText(RtcpUtils.encloseWithHtml(this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_CIRCLEMOVE_COMMON_MESSAGE)));
        this.fixedRadioButton.setText(this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_CIRCLEMOVE_ORIENTATIONMODE_FIXED));
        this.unconstrainedRadioButton.setText(this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_CIRCLEMOVE_ORIENTATIONMODE_UNCONSTRAINED));
        this.selectionText.setText(this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_CIRCLEMOVE_SELECTMODE));
        this.waypointButton.setText(this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_WAYPOINT));
        this.circleMoveButton.setText(this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_CIRCLEMOVE));
        this.toolpathButton.setText(this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_TOOLPATH));
    }

    public void setUsingModeFixed(boolean value) {
        this.usingModeFixed = value;
    }

    public void setContribution(RtcpCircleMoveProgramNodeContribution contribution) {
        this.contribution = contribution;
    }

    public boolean getUsingModeFixed() {
        return this.usingModeFixed;
    }
}

