/*
 * Decompiled with CFR 0.152.
 */
package com.energid.urcap.remotetcp.impl.MoveNodes;

import com.energid.urcap.remotetcp.impl.Common.RtcpConstants;
import com.energid.urcap.remotetcp.impl.Common.RtcpMotionParameters;
import com.energid.urcap.remotetcp.impl.Common.RtcpMoveNodeContributionBase;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpCircleMoveNode;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpNamedPoseInfo;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpWaypointNode;
import com.energid.urcap.remotetcp.impl.MoveNodes.RtcpMoveProgramNodeView;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.contribution.program.ProgramAPIProvider;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.program.nodes.contributable.URCapProgramNode;
import com.ur.urcap.api.domain.program.structure.ProgramNodeVisitor;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.value.Pose;

public class RtcpMoveProgramNodeContribution
extends RtcpMoveNodeContributionBase
implements ProgramNodeContribution {
    private final RtcpMoveProgramNodeView view;

    public RtcpMoveProgramNodeContribution(ProgramAPIProvider apiProvider, RtcpMoveProgramNodeView view, DataModel model) {
        super(apiProvider, model);
        this.view = view;
        this.setDefaultRtcpItem(this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_MOVEP_SELECT_RTCP_DEFAULT));
        this.moveId = ++moveIndex;
        this.addToInternalList();
        this.subtreeCreated = model.get("subtreeCreated", false);
        if (!this.subtreeCreated) {
            this.appendWaypoint();
            this.subtreeCreated = true;
            model.set("subtreeCreated", this.subtreeCreated);
        }
    }

    public void openView() {
        this.view.getHelper().setContribution(this);
        this.view.setApiProvider(this.apiProvider);
        this.view.getHelper().updateRtcpList();
        this.view.getHelper().updateView();
    }

    public void closeView() {
    }

    public String getTitle() {
        return this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_MOVEP_PROGRAMNODE_TREETEXT);
    }

    public boolean isDefined() {
        this.addToInternalList();
        String errorMessage = this.getErrorMessage();
        return errorMessage.isEmpty();
    }

    public void generateScript(final ScriptWriter writer) {
        this.addToInternalList();
        if (!this.getDaemonControl().hasDeamonStarted() && !this.getDaemonControl().isServerReachable()) {
            writer.appendLine("popup(\"" + this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_MOVEP_ERROR_DAEMONSTOPPED) + "\")");
            return;
        }
        int[] waypointCounts = this.getWaypointCount();
        if (waypointCounts[0] == 0 && waypointCounts[1] == 0) {
            writer.writeChildren();
            return;
        }
        if (this.getRtcpModeSelection() == RtcpMoveNodeContributionBase.RtcpMode.VARIABLE) {
            String rtcpVariable = this.getVariableNameForRtcp();
            String resetLine = "mc_initialize(" + this.tcpMode + ", " + rtcpVariable + ", " + this.getDoc() + ")";
            writer.appendLine(resetLine);
        } else {
            Pose rtcpPose = this.getSelectedRtcpPose();
            String resetLine = "mc_initialize(" + this.tcpMode + ", " + rtcpPose.toString() + ", " + this.getDoc() + ")";
            writer.appendLine(resetLine);
        }
        int eeSetIndex = this.getSelectedEndEffectorIndex();
        int gmmBufferSize = waypointCounts[0] + waypointCounts[1];
        final RtcpMotionParameters params = new RtcpMotionParameters();
        params.eeSetIndex = eeSetIndex;
        params.toolSpeed = this.getToolSpeed();
        params.toolAcceleration = this.getToolAcceleration();
        params.blendRadius = this.getBlendRadius();
        final String[] motionId = new String[1];
        this.programApi.getProgramModel().getRootTreeNode((ProgramNodeContribution)this).traverse(new ProgramNodeVisitor(){
            int waypointIndex = 0;

            public void visit(URCapProgramNode childNode, int index, int depth) {
                try {
                    if (childNode.canGetAs(RtcpWaypointNode.class)) {
                        RtcpWaypointNode waypointNode = (RtcpWaypointNode)childNode.getAs(RtcpWaypointNode.class);
                        if (waypointNode.getWaypointType().equals((Object)RtcpWaypointNode.WaypointType.Waypoint) || waypointNode.getWaypointType().equals((Object)RtcpWaypointNode.WaypointType.Toolpath)) {
                            motionId[0] = "id_" + RtcpMoveProgramNodeContribution.this.moveId + "_" + ++this.waypointIndex;
                            waypointNode.writeScriptForMoveNode(writer, motionId[0], this.waypointIndex, params);
                        }
                    } else if (childNode.canGetAs(RtcpCircleMoveNode.class)) {
                        motionId[0] = "id_" + RtcpMoveProgramNodeContribution.this.moveId + "_" + ++this.waypointIndex;
                        RtcpCircleMoveNode circleMoveNode = (RtcpCircleMoveNode)childNode.getAs(RtcpCircleMoveNode.class);
                        circleMoveNode.writeScriptForMoveNode(writer, motionId[0], params);
                    }
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        });
        writer.appendLine("mc_last_motion_id = " + motionId[0]);
        writer.writeChildren();
    }

    @Override
    public RtcpNamedPoseInfo getNamedPoseInfo() {
        return this.getInstallation().getRtcpHandler();
    }

    @Override
    public String getErrorMessage() {
        if (!this.isSelectedRtcpValid()) {
            return this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_MOVEP_ERROR_RTCPMISSING);
        }
        if (!this.isNestingChecked) {
            this.isThisNodeNested = this.getProgramInfo().isNestedMoveNode(this);
            this.isNestingChecked = true;
        }
        if (this.isThisNodeNested) {
            return this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_MOVEP_ERROR_NESTEDMOVE);
        }
        Object[] childInfo = this.hasIllegalChildren();
        String illegalChildName = (String)childInfo[0];
        int rtcpWaypointCount = (Integer)childInfo[1];
        if (rtcpWaypointCount == 0) {
            return this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_MOVEP_ERROR_NOWAYPOINTS);
        }
        if (!illegalChildName.isEmpty()) {
            if (illegalChildName.equals(this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_CIRCLEMOVE_PROGRAMNODE_TREETEXT))) {
                return this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_MOVEP_ERROR_CIRCLEMOVEFIRSTNODE);
            }
            return this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_MOVEP_ERROR_ILLEGALCHILD) + illegalChildName;
        }
        return super.getErrorMessage();
    }

    @Override
    protected int[] getWaypointCount() {
        final int[] waypointCount = new int[]{0, 0};
        this.programApi.getProgramModel().getRootTreeNode((ProgramNodeContribution)this).traverse(new ProgramNodeVisitor(){

            public void visit(URCapProgramNode childNode, int index, int depth) {
                try {
                    if (childNode.canGetAs(RtcpWaypointNode.class)) {
                        RtcpWaypointNode node = (RtcpWaypointNode)childNode.getAs(RtcpWaypointNode.class);
                        if (node.getWaypointType().equals((Object)RtcpWaypointNode.WaypointType.Waypoint) || node.getWaypointType().equals((Object)RtcpWaypointNode.WaypointType.Toolpath)) {
                            waypointCount[0] = waypointCount[0] + 1;
                        }
                    } else if (childNode.canGetAs(RtcpCircleMoveNode.class)) {
                        waypointCount[1] = waypointCount[1] + 1;
                    }
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        });
        return waypointCount;
    }
}

