/*
 * Decompiled with CFR 0.152.
 */
package com.energid.urcap.remotetcp.impl.MoveNodes;

import com.energid.urcap.remotetcp.impl.Common.RtcpComboRenderer;
import com.energid.urcap.remotetcp.impl.Common.RtcpConstants;
import com.energid.urcap.remotetcp.impl.Common.RtcpMoveNodeContributionBase;
import com.energid.urcap.remotetcp.impl.Common.RtcpMoveViewHelperBase;
import com.energid.urcap.remotetcp.impl.Common.RtcpUtils;
import com.energid.urcap.remotetcp.impl.Common.Style;
import com.energid.urcap.remotetcp.impl.WaypointNodes.RtcpToolpathProgramNodeService;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class RtcpMoveViewHelper
extends RtcpMoveViewHelperBase {
    public RtcpMoveViewHelper(JPanel panel, Style style) {
        super(panel, style);
    }

    @Override
    protected Component buildRtcpSelectionArea() {
        super.buildRtcpSelectionArea();
        Box box = Box.createVerticalBox();
        box.setAlignmentY(0.0f);
        box.setBorder(this.defaultBorder);
        this.boxFixedRtcpArea = this.makeFixedRtcpSelectionArea();
        this.boxVariableRtcpArea = this.makeVariableRtcpSelectionArea();
        this.boxModeContent = Box.createVerticalBox();
        this.boxModeContent.setAlignmentX(0.0f);
        this.boxModeContent.setBorder(this.defaultBorder);
        box.add(this.boxModeContent);
        box.add(this.createVerticalSpacing(20));
        Icon plusIcon = RtcpMoveViewHelper.getIconResource("plus_icon.png");
        JPanel buttonBox = new JPanel(new GridLayout(3, 1, 5, 10));
        buttonBox.setBorder(this.defaultBorder);
        buttonBox.setMaximumSize(new Dimension(200, 120));
        buttonBox.setPreferredSize(new Dimension(200, 120));
        buttonBox.setAlignmentX(0.0f);
        buttonBox.setAlignmentY(0.0f);
        box.add(this.createVerticalSpacing(50));
        this.waypointButton = new JButton();
        this.waypointButton.setIcon(plusIcon);
        this.waypointButton.setHorizontalAlignment(2);
        this.waypointButton.setMargin(new Insets(3, 10, 3, 10));
        this.waypointButton.setName(this.controlNameBase + "_AddWaypoint");
        this.waypointButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RtcpMoveViewHelper.this.contribution.appendWaypoint();
            }
        });
        this.circleMoveButton = new JButton();
        this.circleMoveButton.setIcon(plusIcon);
        this.circleMoveButton.setHorizontalAlignment(2);
        this.circleMoveButton.setMargin(new Insets(3, 10, 3, 10));
        this.circleMoveButton.setName(this.controlNameBase + "_AddCircleMove");
        this.circleMoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RtcpMoveViewHelper.this.contribution.appendCircleMove();
            }
        });
        this.toolpathButton = new JButton();
        this.toolpathButton.setIcon(plusIcon);
        this.toolpathButton.setHorizontalAlignment(2);
        this.toolpathButton.setMargin(new Insets(3, 10, 3, 10));
        this.toolpathButton.setName(this.controlNameBase + "_AddToolpath");
        this.toolpathButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RtcpMoveViewHelper.this.contribution.appendToolpath(RtcpToolpathProgramNodeService.class);
            }
        });
        buttonBox.add(this.waypointButton);
        buttonBox.add(this.circleMoveButton);
        buttonBox.add(this.toolpathButton);
        Box westBox = Box.createHorizontalBox();
        westBox.setAlignmentX(0.0f);
        westBox.setBorder(this.defaultBorder);
        westBox.add(buttonBox);
        box.add(westBox);
        return box;
    }

    private Box makeFixedRtcpSelectionArea() {
        Box main = Box.createVerticalBox();
        main.setAlignmentX(0.0f);
        this.labelRtcp = new JLabel();
        main.add(this.labelRtcp);
        main.add(this.createVerticalSpacing(5));
        this.selectRtcpCombo = new JComboBox();
        this.selectRtcpCombo.setName(this.controlNameBase + "_SetRctp");
        this.selectRtcpCombo.setAlignmentX(0.0f);
        this.selectRtcpCombo.setMaximumSize(this.style.getSelectionComboboxSize());
        this.selectRtcpCombo.setPreferredSize(this.style.getSelectionComboboxSize());
        this.renderer = new RtcpComboRenderer(this.style);
        this.selectRtcpCombo.setRenderer(this.renderer);
        this.selectRtcpCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!RtcpMoveViewHelper.this.rtcpComboListens) {
                    return;
                }
                Object item = RtcpMoveViewHelper.this.selectRtcpCombo.getModel().getSelectedItem();
                if (item != null) {
                    String selectedRtcp = item.toString();
                    RtcpMoveViewHelper.this.contribution.setSelectedRtcp(selectedRtcp);
                    RtcpMoveViewHelper.this.updateView();
                }
            }
        });
        main.add(this.selectRtcpCombo);
        return main;
    }

    private Box makeVariableRtcpSelectionArea() {
        Box main = Box.createVerticalBox();
        main.setAlignmentX(0.0f);
        this.labelVariable = new JLabel();
        main.add(this.labelVariable);
        main.add(this.createVerticalSpacing(5));
        this.selectVariableCombo = new JComboBox();
        this.selectVariableCombo.setName(this.controlNameBase + "_SelectVariable");
        this.selectVariableCombo.setAlignmentX(0.0f);
        this.selectVariableCombo.setMaximumSize(this.style.getSelectionComboboxSize());
        this.selectVariableCombo.setPreferredSize(this.style.getSelectionComboboxSize());
        this.variableSelectionRenderer = new RtcpComboRenderer(this.style);
        this.selectVariableCombo.setRenderer(this.variableSelectionRenderer);
        this.selectVariableCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!RtcpMoveViewHelper.this.variableComboListens) {
                    return;
                }
                Object item = RtcpMoveViewHelper.this.selectVariableCombo.getModel().getSelectedItem();
                if (item != null) {
                    String selectedVariable = item.toString();
                    RtcpMoveViewHelper.this.contribution.updateVariableNameForRtcp(selectedVariable);
                    RtcpMoveViewHelper.this.updateView();
                }
            }
        });
        main.add(this.selectVariableCombo);
        return main;
    }

    @Override
    protected void updateText() {
        super.updateText();
        this.labelRtcp.setText(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_MOVEP_SET_RTCP));
        this.labelVariable.setText(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_MOVEP_SELECT_VARIABLE));
        this.desc1.setText(RtcpUtils.encloseWithHtml(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_MOVEP_DESCRIPTION)));
        this.desc2.setText(RtcpUtils.encloseWithHtml(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_MOVEP_INFORMATION)));
    }

    @Override
    protected void updateModeList(boolean isVariableMode) {
        this.modeComboListens = false;
        this.selectModeCombo.removeAllItems();
        this.selectModeCombo.addItem(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_MOVEP_MODE_FIXEDRTCP));
        this.selectModeCombo.addItem(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_MOVEP_MODE_VARIABLERTCP));
        this.boxModeContent.removeAll();
        if (isVariableMode) {
            this.selectModeCombo.setSelectedIndex(1);
        } else {
            this.selectModeCombo.setSelectedIndex(0);
        }
        this.modeComboListens = true;
    }

    @Override
    protected Box makeModeArea() {
        Box main = Box.createHorizontalBox();
        main.setAlignmentX(0.0f);
        main.setBorder(this.defaultBorder);
        this.selectModeCombo = new JComboBox();
        this.selectModeCombo.setName(this.controlNameBase + "_SelectMode");
        this.selectModeCombo.setAlignmentX(0.0f);
        this.selectModeCombo.setMaximumSize(this.style.getSelectionComboboxSize());
        this.selectModeCombo.setPreferredSize(this.style.getSelectionComboboxSize());
        this.selectModeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!RtcpMoveViewHelper.this.modeComboListens) {
                    return;
                }
                int modeIndex = RtcpMoveViewHelper.this.selectModeCombo.getSelectedIndex();
                if (modeIndex != -1) {
                    RtcpMoveNodeContributionBase.RtcpMode rtcpMode = modeIndex == 0 ? RtcpMoveNodeContributionBase.RtcpMode.FIXED : RtcpMoveNodeContributionBase.RtcpMode.VARIABLE;
                    RtcpMoveViewHelper.this.contribution.updateUsesVariableForRtcp(RtcpMoveNodeContributionBase.RtcpMode.values()[modeIndex]);
                    RtcpMoveViewHelper.this.updateView();
                }
            }
        });
        main.add(this.selectModeCombo);
        return main;
    }
}

