/*
 * Decompiled with CFR 0.152.
 */
package com.energid.urcap.remotetcp.impl.RegularTcp;

import com.energid.urcap.remotetcp.impl.Common.RtcpConstants;
import com.energid.urcap.remotetcp.impl.Common.RtcpMotionParameters;
import com.energid.urcap.remotetcp.impl.Common.RtcpMoveNodeContributionBase;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpCircleMoveNode;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpNamedPoseInfo;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpWaypointNode;
import com.energid.urcap.remotetcp.impl.RegularTcp.RegularTcpMoveNodeView;
import com.energid.urcap.remotetcp.impl.RegularTcp.RegularTcpToolpathNodeService;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.contribution.program.ProgramAPIProvider;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.program.nodes.builtin.MoveNode;
import com.ur.urcap.api.domain.program.nodes.builtin.WaitNode;
import com.ur.urcap.api.domain.program.nodes.builtin.WaypointNode;
import com.ur.urcap.api.domain.program.nodes.contributable.URCapProgramNode;
import com.ur.urcap.api.domain.program.structure.ProgramNodeVisitor;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.value.Pose;
import java.util.Arrays;

public class RegularTcpMoveNodeContribution
extends RtcpMoveNodeContributionBase
implements ProgramNodeContribution {
    private final RegularTcpMoveNodeView view;

    public RegularTcpMoveNodeContribution(ProgramAPIProvider apiProvider, RegularTcpMoveNodeView view, DataModel model) {
        super(apiProvider, model);
        this.view = view;
        this.setDefaultRtcpItem(this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.REGULARTCP_MOVE_SELECT_TCP_DEFAULT));
        this.moveId = ++moveIndex;
        this.tcpMode = 0;
        this.addToInternalList();
        this.subtreeCreated = model.get("subtreeCreated", false);
        if (!this.subtreeCreated) {
            this.appendToolpath(RegularTcpToolpathNodeService.class);
            this.subtreeCreated = true;
            model.set("subtreeCreated", this.subtreeCreated);
            this.updateIsFreeSpinZ(true);
        }
    }

    public void openView() {
        this.view.getHelper().setContribution(this);
        this.view.setApiProvider(this.apiProvider);
        this.updateView();
    }

    public void closeView() {
    }

    public String getTitle() {
        return this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.REGULARTCP_MOVE_NODE_TREETEXT);
    }

    public boolean isDefined() {
        String errorMessage = this.getErrorMessage();
        return errorMessage.isEmpty();
    }

    public void generateScript(final ScriptWriter writer) {
        String resetLine;
        String checkDivergence;
        this.addToInternalList();
        if (!this.getDaemonControl().hasDeamonStarted() && !this.getDaemonControl().isServerReachable()) {
            writer.appendLine("popup(\"" + this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_MOVEP_ERROR_DAEMONSTOPPED) + "\")");
            return;
        }
        int[] waypointCounts = this.getWaypointCount();
        if (waypointCounts[0] == 0 && waypointCounts[1] == 0) {
            writer.writeChildren();
            return;
        }
        int gmmBufferSize = waypointCounts[0] + waypointCounts[1];
        String string = checkDivergence = this.apiProvider.getSystemAPI().getRobotSimulation().isRealRobot() ? "True" : "False";
        if (this.getRtcpModeSelection() == RtcpMoveNodeContributionBase.RtcpMode.VARIABLE) {
            String rtcpVariable = this.getVariableNameForRtcp();
            resetLine = "mc_initialize(" + this.tcpMode + ", " + rtcpVariable + ", " + this.getDoc() + ")";
            writer.appendLine(resetLine);
        } else {
            Pose rtcpPose = this.getSelectedRtcpPose();
            resetLine = "mc_initialize(" + this.tcpMode + ", " + rtcpPose.toString() + ", " + this.getDoc() + ")";
            writer.appendLine(resetLine);
        }
        final RtcpMotionParameters params = new RtcpMotionParameters();
        params.toolSpeed = this.getToolSpeed();
        params.toolAcceleration = this.getToolAcceleration();
        params.blendRadius = this.getBlendRadius();
        final String[] motionId = new String[1];
        this.programApi.getProgramModel().getRootTreeNode((ProgramNodeContribution)this).traverse(new ProgramNodeVisitor(){
            int waypointIndex = 0;

            public void visit(URCapProgramNode childNode, int index, int depth) {
                try {
                    RtcpWaypointNode waypointNode;
                    if (childNode.canGetAs(RtcpWaypointNode.class) && (waypointNode = (RtcpWaypointNode)childNode.getAs(RtcpWaypointNode.class)).getWaypointType().equals((Object)RtcpWaypointNode.WaypointType.RegularTcpToolpath)) {
                        motionId[0] = "id_" + RegularTcpMoveNodeContribution.this.moveId + "_" + ++this.waypointIndex;
                        waypointNode.writeScriptForMoveNode(writer, motionId[0], this.waypointIndex, params);
                    }
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        });
        writer.appendLine("mc_last_motion_id = " + motionId[0]);
        writer.writeChildren();
    }

    @Override
    public RtcpNamedPoseInfo getNamedPoseInfo() {
        return this.getInstallation().getRegularTcpHandler();
    }

    @Override
    public boolean isSelectedRtcpValid() {
        if (!this.isTcpSelected()) {
            return false;
        }
        if (this.getRtcpModeSelection() == RtcpMoveNodeContributionBase.RtcpMode.VARIABLE) {
            String selectedVariable = this.getVariableNameForRtcpInternal();
            return Arrays.asList(this.getVariables()).contains(selectedVariable);
        }
        String selectedRtcp = this.getSelectedRtcpInternal();
        if (!this.isDefaultRtcp(selectedRtcp)) {
            return Arrays.asList(this.getNamedPoseInfo().getAvailablePoses()).contains(selectedRtcp);
        }
        return true;
    }

    @Override
    public String getErrorMessage() {
        if (!this.isTcpSelected()) {
            return this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.REGULARTCP_MOVE_SELECT_TCP_ERROR);
        }
        if (!this.isSelectedRtcpValid()) {
            return this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.REGULARTCP_MOVE_NODE_ERROR_TCPMISSING);
        }
        if (!this.isNestingChecked) {
            this.isThisNodeNested = this.getProgramInfo().isNestedMoveNode(this);
            this.isNestingChecked = true;
        }
        if (this.isThisNodeNested) {
            return this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.REGULARTCP_MOVE_NODE_ERROR_NESTEDMOVE);
        }
        Object[] childInfo = this.hasIllegalChildren();
        String illegalChildName = (String)childInfo[0];
        int rtcpWaypointCount = (Integer)childInfo[1];
        if (rtcpWaypointCount == 0) {
            return this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.REGULARTCP_MOVE_NODE_ERROR_NOWAYPOINTS);
        }
        if (!illegalChildName.isEmpty()) {
            return this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_MOVEP_ERROR_ILLEGALCHILD) + illegalChildName;
        }
        return super.getErrorMessage();
    }

    private boolean isTcpSelected() {
        if (this.getRtcpModeSelection() == RtcpMoveNodeContributionBase.RtcpMode.FIXED) {
            return !this.getSelectedRtcpInternal().equals("RTCP_MOVEP_DATAMODEL_SELECT_RTCP_DEFAULTVALUE");
        }
        return !this.getVariableNameForRtcpInternal().equals("RTCP_MOVEP_DATAMODEL_VARIABLE_DEFAULT_VALUE");
    }

    @Override
    protected int[] getWaypointCount() {
        final int[] waypointCount = new int[]{0, 0};
        this.programApi.getProgramModel().getRootTreeNode((ProgramNodeContribution)this).traverse(new ProgramNodeVisitor(){

            public void visit(URCapProgramNode childNode, int index, int depth) {
                try {
                    if (childNode.canGetAs(RtcpWaypointNode.class)) {
                        RtcpWaypointNode node = (RtcpWaypointNode)childNode.getAs(RtcpWaypointNode.class);
                        if (node.getWaypointType().equals((Object)RtcpWaypointNode.WaypointType.RegularTcpToolpath)) {
                            waypointCount[0] = waypointCount[0] + 1;
                        }
                    } else if (childNode.canGetAs(RtcpCircleMoveNode.class)) {
                        waypointCount[1] = waypointCount[1] + 1;
                    }
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        });
        return waypointCount;
    }

    private void updateView() {
        this.view.getHelper().updateRtcpList();
        this.view.getHelper().updateView();
    }

    @Override
    public Object[] hasIllegalChildren() {
        final Object[] illegalNodes = new Object[]{"", 0};
        final int[] waypointCount = new int[]{0};
        this.programApi.getProgramModel().getRootTreeNode((ProgramNodeContribution)this).traverse(new ProgramNodeVisitor(){

            public void visit(MoveNode childNode, int index, int depth) {
                illegalNodes[0] = childNode.toString();
            }

            public void visit(WaypointNode childNode, int index, int depth) {
                illegalNodes[0] = childNode.toString();
            }

            public void visit(WaitNode childNode, int index, int depth) {
                illegalNodes[0] = childNode.toString();
            }

            public void visit(URCapProgramNode programNode, int index, int depth) {
                RtcpWaypointNode node;
                if (depth == 1 && programNode.canGetAs(RtcpWaypointNode.class) && (node = (RtcpWaypointNode)programNode.getAs(RtcpWaypointNode.class)).getWaypointType() == RtcpWaypointNode.WaypointType.RegularTcpToolpath) {
                    waypointCount[0] = waypointCount[0] + 1;
                }
            }
        });
        illegalNodes[1] = waypointCount[0];
        return illegalNodes;
    }
}

