/*
 * Decompiled with CFR 0.152.
 */
package com.energid.urcap.remotetcp.impl.RegularTcp;

import com.energid.urcap.remotetcp.impl.Common.RtcpComboRenderer;
import com.energid.urcap.remotetcp.impl.Common.RtcpConstants;
import com.energid.urcap.remotetcp.impl.Common.RtcpMoveNodeContributionBase;
import com.energid.urcap.remotetcp.impl.Common.RtcpMoveViewHelperBase;
import com.energid.urcap.remotetcp.impl.Common.RtcpUtils;
import com.energid.urcap.remotetcp.impl.Common.Style;
import com.energid.urcap.remotetcp.impl.RegularTcp.RegularTcpToolpathNodeService;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class RegularTcpMoveViewHelper
extends RtcpMoveViewHelperBase {
    private JLabel labelTcpDescription;

    public RegularTcpMoveViewHelper(JPanel panel, Style style) {
        super(panel, style);
        this.isUsingBlendRadius = false;
    }

    @Override
    protected Component buildRtcpSelectionArea() {
        super.buildRtcpSelectionArea();
        Box box = Box.createVerticalBox();
        box.setAlignmentY(0.0f);
        box.setBorder(this.defaultBorder);
        this.boxFixedRtcpArea = this.makeFixedRtcpSelectionArea();
        this.boxVariableRtcpArea = this.makeVariableRtcpSelectionArea();
        this.boxModeContent = Box.createVerticalBox();
        this.boxModeContent.setAlignmentX(0.0f);
        this.boxModeContent.setBorder(this.defaultBorder);
        box.add(this.boxModeContent);
        this.labelTcpDescription = new JLabel();
        Dimension tcpDescriptionSize = new Dimension(400, 38);
        this.labelTcpDescription.setMaximumSize(tcpDescriptionSize);
        box.add(this.createVerticalSpacing(5));
        box.add(this.labelTcpDescription);
        this.freeSpinZCheckbox.setAlignmentY(0.0f);
        this.freeSpinZCheckbox.setName(this.controlNameBase + "_CheckFreeSpinZ");
        this.freeSpinZCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RegularTcpMoveViewHelper.this.contribution.updateIsFreeSpinZ(RegularTcpMoveViewHelper.this.freeSpinZCheckbox.isSelected());
            }
        });
        box.add(this.createVerticalSpacing(20));
        box.add(this.freeSpinZCheckbox);
        Icon plusIcon = RegularTcpMoveViewHelper.getIconResource("plus_icon.png");
        box.add(this.createVerticalSpacing(50));
        this.waypointButton = new JButton();
        this.circleMoveButton = new JButton();
        this.toolpathButton = new JButton();
        this.toolpathButton.setIcon(plusIcon);
        this.toolpathButton.setHorizontalAlignment(2);
        this.toolpathButton.setMaximumSize(new Dimension(200, 33));
        this.toolpathButton.setPreferredSize(new Dimension(200, 33));
        this.toolpathButton.setMargin(new Insets(3, 10, 3, 10));
        this.toolpathButton.setName(this.controlNameBase + "_AddToolpath");
        this.toolpathButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RegularTcpMoveViewHelper.this.contribution.appendToolpath(RegularTcpToolpathNodeService.class);
            }
        });
        box.add(this.toolpathButton);
        return box;
    }

    private Box makeFixedRtcpSelectionArea() {
        Box main = Box.createVerticalBox();
        main.setAlignmentX(0.0f);
        this.labelRtcp = new JLabel();
        this.labelRtcp.setMaximumSize(this.style.getSelectionComboboxLabelSize());
        this.labelRtcp.setPreferredSize(this.style.getSelectionComboboxLabelSize());
        main.add(this.labelRtcp);
        main.add(this.createVerticalSpacing(5));
        this.selectRtcpCombo = new JComboBox();
        this.selectRtcpCombo.setName(this.controlNameBase + "_SetRctp");
        this.selectRtcpCombo.setAlignmentX(0.0f);
        this.selectRtcpCombo.setMaximumSize(this.style.getSelectionComboboxSize());
        this.selectRtcpCombo.setPreferredSize(this.style.getSelectionComboboxSize());
        this.renderer = new RtcpComboRenderer(this.style);
        this.selectRtcpCombo.setRenderer(this.renderer);
        this.selectRtcpCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!RegularTcpMoveViewHelper.this.rtcpComboListens) {
                    return;
                }
                Object item = RegularTcpMoveViewHelper.this.selectRtcpCombo.getModel().getSelectedItem();
                if (item != null) {
                    String selectedRtcp = item.toString();
                    RegularTcpMoveViewHelper.this.contribution.setSelectedRtcp(selectedRtcp);
                    RegularTcpMoveViewHelper.this.updateRtcpList();
                    RegularTcpMoveViewHelper.this.updateView();
                }
            }
        });
        main.add(this.selectRtcpCombo);
        return main;
    }

    private Box makeVariableRtcpSelectionArea() {
        Box main = Box.createVerticalBox();
        main.setAlignmentX(0.0f);
        this.labelVariable = new JLabel();
        main.add(this.labelVariable);
        main.add(this.createVerticalSpacing(5));
        this.selectVariableCombo = new JComboBox();
        this.selectVariableCombo.setName(this.controlNameBase + "_SelectVariable");
        this.selectVariableCombo.setAlignmentX(0.0f);
        this.selectVariableCombo.setMaximumSize(this.style.getSelectionComboboxSize());
        this.selectVariableCombo.setPreferredSize(this.style.getSelectionComboboxSize());
        this.variableSelectionRenderer = new RtcpComboRenderer(this.style);
        this.selectVariableCombo.setRenderer(this.variableSelectionRenderer);
        this.selectVariableCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!RegularTcpMoveViewHelper.this.variableComboListens) {
                    return;
                }
                Object item = RegularTcpMoveViewHelper.this.selectVariableCombo.getModel().getSelectedItem();
                if (item != null) {
                    String selectedVariable = item.toString();
                    RegularTcpMoveViewHelper.this.contribution.updateVariableNameForRtcp(selectedVariable);
                    RegularTcpMoveViewHelper.this.updateView();
                }
            }
        });
        main.add(this.selectVariableCombo);
        return main;
    }

    @Override
    protected void updateText() {
        super.updateText();
        this.labelRtcp.setText(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.REGULARTCP_MOVE_SET_TCP));
        this.labelVariable.setText(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.REGULARTCP_MOVE_SELECT_VARIABLE));
        this.desc1.setText(RtcpUtils.encloseWithHtml(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.REGULARTCP_MOVE_DESCRIPTION)));
        this.desc2.setText(RtcpUtils.encloseWithHtml(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.REGULARTCP_MOVE_INFORMATION)));
        this.labelTcpDescription.setText(RtcpUtils.encloseWithHtml(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.REGULARTCP_MOVE_TCP_DESCRIPTION)));
    }

    @Override
    public void updateRtcpList() {
        Border border;
        String[] listRtcps = this.contribution.getNamedPoseInfo().getAvailablePoses();
        this.rtcpComboListens = false;
        this.selectRtcpCombo.removeAllItems();
        this.renderer.setMissingItem("");
        String selectedRtcp = this.contribution.getSelectedRtcp();
        String defaultRtcp = this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.REGULARTCP_MOVE_SELECT_TCP_DEFAULT);
        if (selectedRtcp.equals(defaultRtcp) || !selectedRtcp.equals(defaultRtcp) && !this.contribution.isSelectedRtcpValid()) {
            this.renderer.setMissingItem(selectedRtcp);
            this.selectRtcpCombo.addItem(selectedRtcp);
            border = BorderFactory.createLineBorder(this.style.getGoldYellow2(), 2);
            this.selectRtcpCombo.setBorder(border);
        } else {
            border = BorderFactory.createLineBorder(this.style.getBorderColor(), 1);
            this.selectRtcpCombo.setBorder(border);
        }
        for (String rtcp : listRtcps) {
            this.selectRtcpCombo.addItem(rtcp);
        }
        this.selectRtcpCombo.getModel().setSelectedItem(selectedRtcp);
        this.rtcpComboListens = true;
    }

    @Override
    protected void updateModeList(boolean isVariableMode) {
        this.modeComboListens = false;
        this.selectModeCombo.removeAllItems();
        this.selectModeCombo.addItem(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.REGULARTCP_MOVE_MODE_FIXEDTCP));
        this.selectModeCombo.addItem(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.REGULARTCP_MOVE_MODE_VARIABLETCP));
        this.boxModeContent.removeAll();
        if (isVariableMode) {
            this.selectModeCombo.setSelectedIndex(1);
        } else {
            this.selectModeCombo.setSelectedIndex(0);
        }
        this.modeComboListens = true;
    }

    @Override
    protected Box makeModeArea() {
        Box main = Box.createHorizontalBox();
        main.setAlignmentX(0.0f);
        main.setBorder(this.defaultBorder);
        this.selectModeCombo = new JComboBox();
        this.selectModeCombo.setName(this.controlNameBase + "_SelectMode");
        this.selectModeCombo.setAlignmentX(0.0f);
        this.selectModeCombo.setMaximumSize(this.style.getSelectionComboboxSize());
        this.selectModeCombo.setPreferredSize(this.style.getSelectionComboboxSize());
        this.selectModeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!RegularTcpMoveViewHelper.this.modeComboListens) {
                    return;
                }
                int modeIndex = RegularTcpMoveViewHelper.this.selectModeCombo.getSelectedIndex();
                if (modeIndex != -1) {
                    RtcpMoveNodeContributionBase.RtcpMode rtcpMode = modeIndex == 0 ? RtcpMoveNodeContributionBase.RtcpMode.FIXED : RtcpMoveNodeContributionBase.RtcpMode.VARIABLE;
                    RegularTcpMoveViewHelper.this.contribution.updateUsesVariableForRtcp(RtcpMoveNodeContributionBase.RtcpMode.values()[modeIndex]);
                    RegularTcpMoveViewHelper.this.updateView();
                }
            }
        });
        main.add(this.selectModeCombo);
        return main;
    }
}

