/*
 * Decompiled with CFR 0.152.
 */
package com.energid.urcap.remotetcp.impl.RegularTcp;

import com.energid.urcap.remotetcp.impl.Common.RtcpConstants;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpNamedPoseInfo;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpProgramInfo;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpWaypointNode;
import com.energid.urcap.remotetcp.impl.RegularTcp.RegularTcpToolpathNodeView;
import com.energid.urcap.remotetcp.impl.RemoteTcpInstallationNodeContribution;
import com.energid.urcap.remotetcp.impl.WaypointNodes.RtcpToolpathContributionBase;
import com.energid.urcap.remotetcp.impl.WaypointNodes.RtcpWaypointContributionBase;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.contribution.program.ProgramAPIProvider;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.undoredo.UndoableChanges;
import java.util.LinkedHashMap;

public class RegularTcpToolpathNodeContribution
extends RtcpToolpathContributionBase
implements ProgramNodeContribution {
    private RegularTcpToolpathNodeView view;

    public RegularTcpToolpathNodeContribution(ProgramAPIProvider apiProvider, RegularTcpToolpathNodeView view, DataModel model) {
        super(apiProvider, model);
        this.view = view;
        this.waypointName = model.get("WAYPOINT_NAME", "");
        if (this.waypointName.equals("")) {
            RtcpProgramInfo programInfo = (RtcpProgramInfo)this.programApi.getInstallationNode(RemoteTcpInstallationNodeContribution.class);
            LinkedHashMap<String, RtcpWaypointNode> toolpaths = programInfo.getAllWaypoints(RtcpWaypointNode.WaypointType.RegularTcpToolpath);
            this.waypointName = RtcpWaypointContributionBase.makeWaypointName(this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.REGULARTCP_TOOLPATH_NODE_TREETEXT), toolpaths);
        }
        model.set("WAYPOINT_NAME", this.waypointName);
    }

    public void openView() {
        this.checkParent();
        this.viewHelper = this.view.getHelper();
        this.viewHelper.setContribution(this);
        this.view.setApiProvider(this.apiProvider);
        this.viewHelper.updateView();
    }

    public void closeView() {
    }

    public String getTitle() {
        return this.getWaypointName();
    }

    public boolean isDefined() {
        return this.getErrorMessage().isEmpty();
    }

    public void generateScript(ScriptWriter writer) {
        if (this.isExecuting) {
            writer.appendLine("mc_run_motion(" + this.scriptId + ")");
        } else {
            String message = "popup(\"" + this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_SINGLESTEPPING_MESSAGE) + "\", title=\"" + this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_WARNING_TITLE) + "\", error=True, blocking=False)";
            writer.appendLine(message);
        }
        this.isExecuting = false;
    }

    @Override
    public RtcpWaypointNode.WaypointType getWaypointType() {
        return RtcpWaypointNode.WaypointType.RegularTcpToolpath;
    }

    @Override
    public String getSelectedPcs() {
        String selectedPcs = this.getSelectedPcsInternal();
        if (this.isDefaultPcs(selectedPcs)) {
            return this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.REGULARTCP_TOOLPATH_SELECTED_PLANE_DEFAULT);
        }
        return selectedPcs;
    }

    @Override
    public boolean isPcsSelected() {
        return !this.getSelectedPcsInternal().equals("RTCP_TOOLPATH_DATAMODEL_SELECTEDS_DEFAULT_VALUE");
    }

    @Override
    public double getBlendRadius() {
        return 0.0;
    }

    @Override
    public void updateSelectedPcs(final String pcs) {
        this.undoRedoManager.recordChanges(new UndoableChanges(){

            public void executeChanges() {
                RegularTcpToolpathNodeContribution.this.model.remove("SELECTED_PCS");
                if (pcs.equals(RegularTcpToolpathNodeContribution.this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.REGULARTCP_TOOLPATH_SELECTED_PLANE_DEFAULT))) {
                    RegularTcpToolpathNodeContribution.this.model.set("SELECTED_PCS", "RTCP_TOOLPATH_DATAMODEL_SELECTEDS_DEFAULT_VALUE");
                } else {
                    RegularTcpToolpathNodeContribution.this.model.set("SELECTED_PCS", pcs);
                }
            }
        });
    }

    @Override
    public void renameSelectedPcs(String oldName, final String newName) {
        if (this.getSelectedPcs().equals(oldName)) {
            this.undoRedoManager.recordChanges(new UndoableChanges(){

                public void executeChanges() {
                    RegularTcpToolpathNodeContribution.this.model.remove("SELECTED_PCS");
                    if (newName.equals(RegularTcpToolpathNodeContribution.this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.REGULARTCP_TOOLPATH_SELECTED_PLANE_DEFAULT))) {
                        RegularTcpToolpathNodeContribution.this.model.set("SELECTED_PCS", "RTCP_TOOLPATH_DATAMODEL_SELECTEDS_DEFAULT_VALUE");
                    } else {
                        RegularTcpToolpathNodeContribution.this.model.set("SELECTED_PCS", newName);
                    }
                }
            });
        }
    }

    @Override
    protected RtcpNamedPoseInfo getPcsInfo() {
        return ((RemoteTcpInstallationNodeContribution)this.programApi.getInstallationNode(RemoteTcpInstallationNodeContribution.class)).getPlaneFeatureHandler();
    }
}

