/*
 * Decompiled with CFR 0.152.
 */
package com.energid.urcap.remotetcp.impl.RegularTcp;

import com.energid.urcap.remotetcp.impl.Common.RobotRealtimeReader;
import com.energid.urcap.remotetcp.impl.Common.RtcpConstants;
import com.energid.urcap.remotetcp.impl.Common.RtcpXmlRpcClient;
import com.energid.urcap.remotetcp.impl.Common.Style;
import com.energid.urcap.remotetcp.impl.RegularTcp.RegularTcpToolpathNodeService;
import com.energid.urcap.remotetcp.impl.WaypointNodes.RtcpToolpathViewHelperBase;
import com.ur.urcap.api.domain.userinteraction.robot.movement.MovementCompleteEvent;
import com.ur.urcap.api.domain.userinteraction.robot.movement.MovementErrorEvent;
import com.ur.urcap.api.domain.userinteraction.robot.movement.RobotMovementCallback;
import com.ur.urcap.api.domain.value.Pose;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class RegularTcpToolpathViewHelper
extends RtcpToolpathViewHelperBase {
    public RegularTcpToolpathViewHelper(JPanel panel, Style style) {
        super(panel, style);
        this.canAddWaypoint = false;
        this.canAddCircleMove = false;
        this.toolpathService = RegularTcpToolpathNodeService.class;
        this.usesBlendRadius = false;
    }

    @Override
    public void updatePcsList() {
        Border border;
        String[] pcsList = this.toolpathContribution.getPcsList();
        this.pcsComboListens = false;
        this.selectPcsCombo.removeAllItems();
        this.pcsSelectionRenderer.setMissingItem("");
        String selectedPcs = this.toolpathContribution.getSelectedPcs();
        String defaultPcs = this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.REGULARTCP_TOOLPATH_SELECTED_PLANE_DEFAULT);
        if (selectedPcs.equals(defaultPcs) || !selectedPcs.equals(defaultPcs) && !Arrays.asList(pcsList).contains(selectedPcs)) {
            this.pcsSelectionRenderer.setMissingItem(selectedPcs);
            this.selectPcsCombo.addItem(selectedPcs);
            border = BorderFactory.createLineBorder(this.style.getGoldYellow2(), 2);
            this.selectPcsCombo.setBorder(border);
        } else {
            border = BorderFactory.createLineBorder(this.style.getBorderColor(), 1);
            this.selectPcsCombo.setBorder(border);
        }
        if (pcsList != null) {
            for (String pcs : pcsList) {
                this.selectPcsCombo.addItem(pcs);
            }
        }
        this.selectPcsCombo.getModel().setSelectedItem(this.toolpathContribution.getSelectedPcs());
        this.pcsComboListens = true;
    }

    @Override
    protected void actionMoveHere() {
        Object[] values;
        if (!this.checkDaemon()) {
            return;
        }
        Pose posePcs = this.toolpathContribution.getPoseForSelectedPcs();
        Pose poseFirstPoint = null;
        Object[] tcpData = RobotRealtimeReader.getCurrentTCPData();
        if (tcpData == null) {
            JOptionPane.showMessageDialog(null, this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_WAYPOINT_ERROR_MOVEHEREFAILED), this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_WARNING_TITLE), 2);
            return;
        }
        String toolpathPath = "/programs/" + this.toolpathContribution.getSelectedToolpath();
        Object retValFirstPoint = RtcpXmlRpcClient.moveToFirstPoint(toolpathPath, posePcs, 120);
        if (retValFirstPoint != null) {
            values = (Object[])retValFirstPoint;
            if (values.length == 0) {
                this.handleMoveHereError();
                return;
            }
        } else {
            this.handleMoveHereError();
            return;
        }
        poseFirstPoint = this.makePose(values);
        Pose selectedTcpPose = this.contribution.getParent().getSelectedRtcpPose();
        Object retVal = RtcpXmlRpcClient.moveTcpHere(poseFirstPoint, selectedTcpPose, (double[])tcpData[0], (double[])tcpData[1], 2);
        if (retVal != null) {
            Object[] values2 = (Object[])retVal;
            if (values2.length != 0) {
                poseFirstPoint = this.makePose(values2);
                try {
                    this.apiProvider.getUserInterfaceAPI().getUserInteraction().getRobotMovement().requestUserToMoveRobot(poseFirstPoint, new RobotMovementCallback(){

                        public void onComplete(MovementCompleteEvent event) {
                        }

                        public void onError(MovementErrorEvent event) {
                            RegularTcpToolpathViewHelper.this.reportMovementError(event);
                        }
                    });
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                return;
            }
            this.handleMoveHereError();
            return;
        }
        this.handleMoveHereError();
    }

    @Override
    public void updateText() {
        super.updateText();
        this.labelPcs.setText(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.REGULARTCP_TOOLPATH_SELECT_PCS));
    }
}

