/*
 * Decompiled with CFR 0.152.
 */
package com.energid.urcap.remotetcp.impl;

import com.energid.urcap.remotetcp.impl.Common.PcsCollectionHandler;
import com.energid.urcap.remotetcp.impl.Common.PlaneFeatureCollectionHandler;
import com.energid.urcap.remotetcp.impl.Common.RegularTcpCollectionHandler;
import com.energid.urcap.remotetcp.impl.Common.RobotRealtimeReader;
import com.energid.urcap.remotetcp.impl.Common.RtcpCollectionHandler;
import com.energid.urcap.remotetcp.impl.Common.RtcpConstants;
import com.energid.urcap.remotetcp.impl.Common.RtcpXmlRpcClient;
import com.energid.urcap.remotetcp.impl.InstallationNode.RtcpDaemonService;
import com.energid.urcap.remotetcp.impl.InstallationNode.ToolpathHandler;
import com.energid.urcap.remotetcp.impl.InstallationNode.ToolpathIoHandler;
import com.energid.urcap.remotetcp.impl.Interfaces.EcStoppableInterface;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpCircleMoveNode;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpMoveNode;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpProgramInfo;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpWaypointNode;
import com.energid.urcap.remotetcp.impl.Interfaces.ToolpathInfo;
import com.energid.urcap.remotetcp.impl.Interfaces.ToolpathIoInfo;
import com.energid.urcap.remotetcp.impl.RemoteTcpInstallationNodeView;
import com.energid.urcap.remotetcp.impl.RtcpInstallationContributionBase;
import com.ur.urcap.api.contribution.DaemonContribution;
import com.ur.urcap.api.contribution.InstallationNodeContribution;
import com.ur.urcap.api.contribution.installation.InstallationAPIProvider;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.feature.FeaturePlane;
import com.ur.urcap.api.domain.feature.FeaturePoint;
import com.ur.urcap.api.domain.function.FunctionException;
import com.ur.urcap.api.domain.function.FunctionModel;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.simple.Angle;
import com.ur.urcap.api.domain.value.simple.Length;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Vector;

public class RemoteTcpInstallationNodeContribution
extends RtcpInstallationContributionBase
implements InstallationNodeContribution,
EcStoppableInterface,
RtcpProgramInfo {
    private final RemoteTcpInstallationNodeView view;
    private RegularTcpCollectionHandler regularTcpHandler;
    private RtcpCollectionHandler rtcpHandler;
    private PcsCollectionHandler pcsHandler;
    private PlaneFeatureCollectionHandler planeFeatureHandler;
    private ToolpathHandler toolpathHandler;
    private ToolpathIoInfo toolpathIoHandler;
    private static final Vector<RtcpMoveNode> moveNodes = new Vector();

    public RemoteTcpInstallationNodeContribution(InstallationAPIProvider apiProvider, DataModel model, RemoteTcpInstallationNodeView view, RtcpDaemonService daemon) {
        super(apiProvider, model, daemon);
        this.view = view;
        this.setRegularTcpHandler(new RegularTcpCollectionHandler(apiProvider.getInstallationAPI().getTCPModel(), model, "", this.poseFactory));
        this.setRtcpHandler(new RtcpCollectionHandler(model, "RTCP", this.poseFactory, moveNodes));
        this.setPcsHandler(new PcsCollectionHandler(model, "RTCP_PCS", this.poseFactory, moveNodes));
        this.setPlaneFeatureHandler(new PlaneFeatureCollectionHandler(model, "", this.poseFactory, this));
        this.setToolpathHandler(new ToolpathHandler());
        this.setToolpathIoHandler(new ToolpathIoHandler(model, this, this));
        this.getToolpathIoHandler().getIoPortsFromDataModel();
        this.getRtcpsFromDataModel();
        this.getPcsFromDataModel();
        boolean startDaemon = this.dataModel.get("RTCP_DAEMON_STARTED", false);
        this.setDaemonEnabled(startDaemon);
        this.applyDesiredDaemonStatus();
        this.addAPIFunctions();
        this.getToolpathIoHandler().updateController();
    }

    private void addAPIFunctions() {
        FunctionModel functionModel = this.apiProvider.getInstallationAPI().getFunctionModel();
        try {
            functionModel.addFunction("mc_add_circular", new String[]{"pose_via", "pose_to", "a", "v", "r"});
            functionModel.addFunction("mc_add_linear", new String[]{"pose", "a", "v", "r"});
            functionModel.addFunction("mc_add_path", new String[]{"nc_file", "a", "v", "r"});
            functionModel.addFunction("mc_get_target_rtcp_speed", new String[0]);
            functionModel.addFunction("mc_initialize", new String[]{"tcp", "doc"});
            functionModel.addFunction("mc_run_motion", new String[]{"id"});
            functionModel.addFunction("mc_set_pcs", new String[]{"pcs"});
            functionModel.addFunction("mc_set_speed_factor", new String[]{"s"});
        }
        catch (FunctionException e) {
            e.printStackTrace();
        }
    }

    private void getPcsFromDataModel() {
        String[] pcsNames = this.dataModel.get("PCS_NAMES", new String[0]);
        double[] poses = this.dataModel.get("PCS_POSES", new double[0]);
        String defaultPcs = this.dataModel.get("PCS_DEFAULT", "");
        if (pcsNames.length == 0 || poses.length == 0 || defaultPcs == "") {
            this.pcsHandler.initialize();
        } else {
            int index = 0;
            for (String pcsName : pcsNames) {
                Pose pose = this.poseFactory.createPose(poses[index++], poses[index++], poses[index++], poses[index++], poses[index++], poses[index++], Length.Unit.MM, Angle.Unit.RAD);
                this.pcsHandler.addNamedPose(pcsName, pose);
            }
            this.pcsHandler.setDefaultNamedPose(defaultPcs);
        }
    }

    private void getRtcpsFromDataModel() {
        String[] rtcpNames = this.dataModel.get("RTCP_NAMES", new String[0]);
        double[] poses = this.dataModel.get("RTCP_POSES", new double[0]);
        String defaultRtcp = this.dataModel.get("RTCP_DEFAULT", "");
        if (rtcpNames.length == 0 || poses.length == 0 || defaultRtcp == "") {
            this.rtcpHandler.initialize();
        } else {
            int index = 0;
            for (String rtcpName : rtcpNames) {
                Pose pose = this.poseFactory.createPose(poses[index++], poses[index++], poses[index++], poses[index++], poses[index++], poses[index++], Length.Unit.MM, Angle.Unit.RAD);
                this.rtcpHandler.addNamedPose(rtcpName, pose);
            }
            this.rtcpHandler.setDefaultNamedPose(defaultRtcp);
        }
    }

    @Override
    public void openView() {
        this.view.setAPIProvider(this.apiProvider);
        this.view.updateView();
        this.startXmlrpcClient();
    }

    @Override
    public void closeView() {
        this.stopXmlrpcClient();
    }

    @Override
    public void generateScript(ScriptWriter writer) {
        this.daemonStarted = false;
        if (this.getDaemonDesiredState() == DaemonContribution.State.RUNNING && this.waitForDaemon(10000)) {
            this.daemonStarted = true;
            this.generateScriptInternal(writer);
        }
        for (RtcpMoveNode moveNode : moveNodes) {
            moveNode.setInTheInternalList(false);
        }
        moveNodes.clear();
        this.clearToolpathCache();
    }

    public void clearToolpathCache() {
        RtcpXmlRpcClient.clearToolpathCache(5);
    }

    public void generateScriptInternal(ScriptWriter writer) {
        try {
            this.writePresetVariables(writer);
            this.writeMainHeader(writer);
            this.writeMessageSection(writer);
            this.writeToolpathMessageSection(writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writePresetVariables(ScriptWriter writer) {
        String checkDivergence = this.apiProvider.getSystemAPI().getRobotSimulation().isRealRobot() ? "True" : "False";
        writer.appendLine("mc_check_divergence = " + checkDivergence);
    }

    private void writeMainHeader(ScriptWriter writer) throws IOException {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("script_api.txt");
        InputStreamReader isReader = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isReader);
        String line = null;
        while ((line = br.readLine()) != null) {
            writer.appendLine(line);
        }
        br.close();
        isReader.close();
    }

    private void writeMessageSection(ScriptWriter writer) throws IOException {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("script_getErrorMessage.txt");
        InputStreamReader isReader = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isReader);
        String line = null;
        while ((line = br.readLine()) != null) {
            line = line.replaceAll("RTCP_SCRIPT_ERROR_PATHDIVERGED", this.getLocalizedText(RtcpConstants.Strings.RTCP_SCRIPT_ERROR_PATHDIVERGED));
            line = line.replaceAll("RTCP_SCRIPT_ERROR_COLLISION", this.getLocalizedText(RtcpConstants.Strings.RTCP_SCRIPT_ERROR_COLLISION));
            line = line.replaceAll("RTCP_SCRIPT_ERROR_JOINTLIMIT", this.getLocalizedText(RtcpConstants.Strings.RTCP_SCRIPT_ERROR_JOINTLIMIT));
            line = line.replaceAll("RTCP_SCRIPT_ERROR_SINGULARITY", this.getLocalizedText(RtcpConstants.Strings.RTCP_SCRIPT_ERROR_SINGULARITY));
            line = line.replaceAll("RTCP_SCRIPT_ERROR_PLANNINGFAILED", this.getLocalizedText(RtcpConstants.Strings.RTCP_SCRIPT_ERROR_PLANNINGFAILED));
            line = line.replaceAll("RTCP_SCRIPT_ERROR_DAEMONSTOPPED", this.getLocalizedText(RtcpConstants.Strings.RTCP_SCRIPT_ERROR_DAEMONSTOPPED));
            line = line.replaceAll("RTCP_SCRIPT_ERROR_SERVERBUSY", this.getLocalizedText(RtcpConstants.Strings.RTCP_SCRIPT_ERROR_SERVERBUSY));
            line = line.replaceAll("RTCP_SCRIPT_ERROR_NOTINITIALIZED", this.getLocalizedText(RtcpConstants.Strings.RTCP_SCRIPT_ERROR_NOTINITIALIZED));
            writer.appendLine(line);
        }
        br.close();
        isReader.close();
    }

    private void writeToolpathMessageSection(ScriptWriter writer) throws IOException {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("script_getToolpathMessage.txt");
        InputStreamReader isReader = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isReader);
        String line = null;
        while ((line = br.readLine()) != null) {
            line = line.replaceAll("RTCP_TOOLPATH_VALIDATION_ERROR_NONE", this.getLocalizedText(RtcpConstants.Strings.RTCP_TOOLPATH_VALIDATION_ERROR_NONE));
            line = line.replaceAll("RTCP_TOOLPATH_VALIDATION_ERROR_FILELOAD", this.getLocalizedText(RtcpConstants.Strings.RTCP_TOOLPATH_VALIDATION_ERROR_FILELOAD));
            line = line.replaceAll("RTCP_TOOLPATH_VALIDATION_ERROR_PARSE", this.getLocalizedText(RtcpConstants.Strings.RTCP_TOOLPATH_VALIDATION_ERROR_PARSE));
            line = line.replaceAll("RTCP_TOOLPATH_VALIDATION_ERROR_EMPTYTOOLPATH", this.getLocalizedText(RtcpConstants.Strings.RTCP_TOOLPATH_VALIDATION_ERROR_EMPTYTOOLPATH));
            line = line.replaceAll("RTCP_TOOLPATH_VALIDATION_ERROR_UNSUPPORTEDTYPE", this.getLocalizedText(RtcpConstants.Strings.RTCP_TOOLPATH_VALIDATION_ERROR_UNSUPPORTEDTYPE));
            line = line.replaceAll("RTCP_TOOLPATH_VALIDATION_ERROR_UNKNOWN", this.getLocalizedText(RtcpConstants.Strings.RTCP_TOOLPATH_VALIDATION_ERROR_UNKNOWN));
            writer.appendLine(line);
        }
        br.close();
        isReader.close();
    }

    @Override
    public void addRtcpMoveNode(RtcpMoveNode moveNode) {
        if (!moveNodes.contains(moveNode)) {
            moveNodes.addElement(moveNode);
        }
        moveNode.setInTheInternalList(true);
    }

    @Override
    public void addRtcpWaypointNode(RtcpWaypointNode waypointNode) {
        for (RtcpMoveNode moveNode : moveNodes) {
            if (!moveNode.locateChild(waypointNode)) continue;
            waypointNode.setParent(moveNode);
            break;
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean isDuplicateWaypointName(RtcpWaypointNode waypoint, String name) {
        for (RtcpMoveNode parentNode : moveNodes) {
            if (!parentNode.isDuplicateWaypointName(waypoint, name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isNestedMoveNode(RtcpMoveNode moveNode) {
        int nodeCount = moveNodes.size();
        for (int index = 0; index < nodeCount; ++index) {
            RtcpMoveNode parentNode = moveNodes.get(index);
            if (!parentNode.locateChild(moveNode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<FeaturePoint> getPointFeatures() {
        return this.apiProvider.getInstallationAPI().getFeatureModel().getGeomFeatures(FeaturePoint.class);
    }

    @Override
    public Collection<FeaturePlane> getPlaneFeatures() {
        return this.apiProvider.getInstallationAPI().getFeatureModel().getGeomFeatures(FeaturePlane.class);
    }

    @Override
    protected void updateDisplays() {
        this.view.updateDaemonSection();
    }

    @Override
    public RtcpMoveNode getParent(RtcpCircleMoveNode circleMoveNode) {
        for (RtcpMoveNode moveNode : moveNodes) {
            if (!moveNode.locateChild(circleMoveNode)) continue;
            return moveNode;
        }
        return null;
    }

    @Override
    public LinkedHashMap<String, RtcpWaypointNode> getAllWaypoints(RtcpWaypointNode.WaypointType type) {
        LinkedHashMap<String, RtcpWaypointNode> retList = new LinkedHashMap<String, RtcpWaypointNode>();
        for (RtcpMoveNode moveNode : moveNodes) {
            for (RtcpWaypointNode wpNode : moveNode.getWaypoints(type)) {
                retList.put(wpNode.getWaypointName(), wpNode);
            }
        }
        return retList;
    }

    @Override
    public boolean isPowerOn() {
        return RobotRealtimeReader.getRobotMode() > 3.0;
    }

    protected void startXmlrpcClient() {
        RtcpXmlRpcClient.startXmlrpcClient();
    }

    protected void stopXmlrpcClient() {
        RtcpXmlRpcClient.stopXmlrpcClient();
    }

    @Override
    public void updateDaemonStateStarted(boolean isStarted) {
        this.dataModel.remove("RTCP_DAEMON_STARTED");
        this.dataModel.set("RTCP_DAEMON_STARTED", isStarted);
        if (isStarted) {
            this.getToolpathIoHandler().updateController();
        }
    }

    public RegularTcpCollectionHandler getRegularTcpHandler() {
        return this.regularTcpHandler;
    }

    public void setRegularTcpHandler(RegularTcpCollectionHandler regularTcpHandler) {
        this.regularTcpHandler = regularTcpHandler;
    }

    public RtcpCollectionHandler getRtcpHandler() {
        return this.rtcpHandler;
    }

    public void setRtcpHandler(RtcpCollectionHandler rtcpHandler) {
        this.rtcpHandler = rtcpHandler;
    }

    public PcsCollectionHandler getPcsHandler() {
        return this.pcsHandler;
    }

    public void setPcsHandler(PcsCollectionHandler pcsHandler) {
        this.pcsHandler = pcsHandler;
    }

    public PlaneFeatureCollectionHandler getPlaneFeatureHandler() {
        return this.planeFeatureHandler;
    }

    public void setPlaneFeatureHandler(PlaneFeatureCollectionHandler planeFeatureHandler) {
        this.planeFeatureHandler = planeFeatureHandler;
    }

    public ToolpathInfo getToolpathHandler() {
        return this.toolpathHandler;
    }

    protected void setToolpathHandler(ToolpathHandler toolpathHandler) {
        this.toolpathHandler = toolpathHandler;
    }

    public ToolpathIoInfo getToolpathIoHandler() {
        return this.toolpathIoHandler;
    }

    protected void setToolpathIoHandler(ToolpathIoInfo toolpathIoHandler) {
        this.toolpathIoHandler = toolpathIoHandler;
    }
}

