/*
 * Decompiled with CFR 0.152.
 */
package com.energid.urcap.remotetcp.impl;

import com.energid.urcap.remotetcp.impl.Common.Style;
import com.energid.urcap.remotetcp.impl.InstallationNode.RtcpDaemonService;
import com.energid.urcap.remotetcp.impl.RemoteTcpInstallationNodeContribution;
import com.energid.urcap.remotetcp.impl.RemoteTcpInstallationNodeView;
import com.ur.urcap.api.contribution.ViewAPIProvider;
import com.ur.urcap.api.contribution.installation.ContributionConfiguration;
import com.ur.urcap.api.contribution.installation.CreationContext;
import com.ur.urcap.api.contribution.installation.InstallationAPIProvider;
import com.ur.urcap.api.contribution.installation.swing.SwingInstallationNodeService;
import com.ur.urcap.api.domain.SystemAPI;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.robot.RobotModel;
import java.io.File;
import java.util.Locale;
import org.osgi.framework.BundleContext;

public class RemoteTcpInstallationNodeService
implements SwingInstallationNodeService<RemoteTcpInstallationNodeContribution, RemoteTcpInstallationNodeView> {
    private final RtcpDaemonService daemonService;
    private final BundleContext bundleContext;
    private final String GENERIC_EXEC = "UReSystemControlExec.xml";
    private final String UR3_EXEC = "UR3eSystemControlExec.xml";
    private final String UR5_EXEC = "UR5eSystemControlExec.xml";
    private final String UR10_EXEC = "UR10eSystemControlExec.xml";
    private final String UR16_EXEC = "UR16eSystemControlExec.xml";
    private final String UR20_EXEC = "UR20SystemControlExec.xml";
    private final String UR30_EXEC = "UR30SystemControlExec.xml";
    private final String BASE_PATH = "com/energid/urcap/remotetcp/impl/daemon/";

    public RemoteTcpInstallationNodeService(RtcpDaemonService daemonService, BundleContext context) {
        this.daemonService = daemonService;
        this.bundleContext = context;
    }

    public void configureContribution(ContributionConfiguration configuration) {
    }

    public String getTitle(Locale locale) {
        return "Remote TCP & Toolpath";
    }

    public RemoteTcpInstallationNodeView createView(ViewAPIProvider apiProvider) {
        Style style = new Style();
        return new RemoteTcpInstallationNodeView(style);
    }

    public RemoteTcpInstallationNodeContribution createInstallationNode(InstallationAPIProvider apiProvider, RemoteTcpInstallationNodeView view, DataModel model, CreationContext context) {
        this.creatSoftLinkForController(apiProvider.getSystemAPI());
        return new RemoteTcpInstallationNodeContribution(apiProvider, model, view, this.daemonService);
    }

    private void creatSoftLinkForController(SystemAPI api) {
        RobotModel.RobotType robotType = api.getRobotModel().getRobotType();
        System.out.println("Remote TCP robot type: " + robotType.toString());
        String execFile = "";
        switch (robotType) {
            case UR3: {
                execFile = "UR3eSystemControlExec.xml";
                break;
            }
            case UR5: {
                execFile = "UR5eSystemControlExec.xml";
                break;
            }
            case UR7: {
                execFile = "UR5eSystemControlExec.xml";
                break;
            }
            case UR10: {
                execFile = "UR10eSystemControlExec.xml";
                break;
            }
            case UR12: {
                execFile = "UR10eSystemControlExec.xml";
                break;
            }
            case UR16: {
                execFile = "UR16eSystemControlExec.xml";
                break;
            }
            case UR20: {
                execFile = "UR20SystemControlExec.xml";
                break;
            }
            case UR30: {
                execFile = "UR30SystemControlExec.xml";
                break;
            }
            default: {
                System.err.println("Remote TCP unrecoginized robot type: " + robotType.toString());
            }
        }
        File toFile = this.bundleContext.getBundle().getDataFile("com/energid/urcap/remotetcp/impl/daemon/UReSystemControlExec.xml");
        try {
            if (toFile.exists()) {
                toFile.delete();
            }
            String command = "ln -sf " + execFile + " " + toFile.getPath();
            Process p = Runtime.getRuntime().exec(command);
            p.waitFor();
            p.destroy();
        }
        catch (Exception ex) {
            System.err.println("Remote TCP cannot create a link for the robot controller.");
        }
    }
}

