/*
 * Decompiled with CFR 0.152.
 */
package com.energid.urcap.remotetcp.impl;

import com.energid.urcap.remotetcp.impl.Common.RtcpConstants;
import com.energid.urcap.remotetcp.impl.Common.Style;
import com.energid.urcap.remotetcp.impl.InstallationNode.DaemonInstallationViewHelper;
import com.energid.urcap.remotetcp.impl.InstallationNode.RtcpInstallationSetupViewHelper;
import com.energid.urcap.remotetcp.impl.InstallationNode.RtcpPcsInstallationViewHelper;
import com.energid.urcap.remotetcp.impl.InstallationNode.ToolpathInstallationViewHelper;
import com.energid.urcap.remotetcp.impl.InstallationNode.ToolpathIoViewHelper;
import com.energid.urcap.remotetcp.impl.Instructions.InstructionsViewHelper;
import com.energid.urcap.remotetcp.impl.Interfaces.LocalizationInfo;
import com.energid.urcap.remotetcp.impl.RemoteTcpInstallationNodeContribution;
import com.ur.urcap.api.contribution.installation.InstallationAPIProvider;
import com.ur.urcap.api.contribution.installation.swing.SwingInstallationNodeView;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardInputFactory;
import java.awt.BorderLayout;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RemoteTcpInstallationNodeView
implements SwingInstallationNodeView<RemoteTcpInstallationNodeContribution> {
    private InstallationAPIProvider apiProvider;
    private final Style style;
    private RemoteTcpInstallationNodeContribution contribution;
    private KeyboardInputFactory keyboardFactory;
    private RtcpInstallationSetupViewHelper rtcpSetupView;
    private RtcpPcsInstallationViewHelper pcsView;
    private ToolpathInstallationViewHelper toolpathView;
    private ToolpathIoViewHelper toolpathIoView;
    private DaemonInstallationViewHelper daemonView;
    private InstructionsViewHelper instructionsManager;
    private JPanel mainContainer;
    private JPanel rtcpPanel;
    private JPanel pcsPanel;
    private JPanel toolpathPanel;
    private JPanel toolpathIoPanel;
    private JPanel homePanel;
    private JPanel instructionsPanel;
    private JTabbedPane tabbedPanel;
    private LocalizationInfo localization;
    private boolean uiReady;
    private RtcpInstallationViewType currentViewType;
    private ViewContentSelector viewContentSelector;

    public RemoteTcpInstallationNodeView(Style style) {
        this.style = style;
        this.uiReady = false;
        this.currentViewType = RtcpInstallationViewType.Home;
        this.viewContentSelector = new ViewContentSelector();
    }

    public void setAPIProvider(InstallationAPIProvider api) {
        this.apiProvider = api;
        this.keyboardFactory = this.apiProvider.getUserInterfaceAPI().getUserInteraction().getKeyboardInputFactory();
        this.rtcpSetupView.setKeyboardFactory(this.keyboardFactory);
        this.rtcpSetupView.setApiProvider(api);
        this.pcsView.setKeyboardFactory(this.keyboardFactory);
        this.pcsView.setApiProvider(api);
        this.toolpathIoView.setApiProvider(api);
    }

    public void buildUI(JPanel panel, RemoteTcpInstallationNodeContribution contribution) {
        try {
            this.contribution = contribution;
            panel.setLayout(new BorderLayout());
            this.localization = contribution;
            this.mainContainer = new JPanel();
            this.mainContainer.setLayout(new BoxLayout(this.mainContainer, 1));
            this.mainContainer.setAlignmentY(0.0f);
            this.mainContainer.setAlignmentX(0.0f);
            this.daemonView = new DaemonInstallationViewHelper(contribution, this.style, this.viewContentSelector);
            this.homePanel = this.daemonView.createDaemonPanel();
            this.rtcpSetupView = new RtcpInstallationSetupViewHelper(this.contribution.getRtcpHandler(), this.contribution, this.style, this.viewContentSelector);
            this.rtcpPanel = this.rtcpSetupView.createRtcpPanel();
            this.pcsView = new RtcpPcsInstallationViewHelper(this.contribution.getPcsHandler(), this.contribution.getRtcpHandler(), this.contribution, this.style, this.viewContentSelector);
            this.pcsPanel = this.pcsView.createPcsPanel();
            this.toolpathView = new ToolpathInstallationViewHelper(this.contribution.getToolpathHandler(), contribution, this.style, this.viewContentSelector);
            this.toolpathPanel = this.toolpathView.createToolpathPanel();
            this.toolpathIoView = new ToolpathIoViewHelper(this.contribution.getToolpathIoHandler(), contribution, this.style, this.viewContentSelector);
            this.toolpathIoPanel = this.toolpathIoView.createToolpathIoPanel();
            this.instructionsManager = new InstructionsViewHelper(this.localization, this.style, this.viewContentSelector);
            this.instructionsPanel = this.instructionsManager.getInstructionsPanel();
            this.tabbedPanel = new JTabbedPane();
            this.tabbedPanel.setAlignmentX(0.0f);
            this.tabbedPanel.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    RemoteTcpInstallationNodeView.this.updateViewForIndex(RemoteTcpInstallationNodeView.this.tabbedPanel.getSelectedIndex());
                }
            });
            this.mainContainer.add(this.homePanel);
            panel.add(this.mainContainer);
            this.DoNothingJustThrowException();
            this.uiReady = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void updateMainContainer() {
        this.mainContainer.removeAll();
        switch (this.currentViewType) {
            case Home: {
                this.mainContainer.add(this.homePanel);
                break;
            }
            case RemoteTcpToolpath: {
                this.tabbedPanel.removeAll();
                this.tabbedPanel.addTab(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_INSTRUCTIONS), this.instructionsPanel);
                this.tabbedPanel.addTab(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_TOOLPATH), this.toolpathPanel);
                this.tabbedPanel.addTab(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_IO), this.toolpathIoPanel);
                this.tabbedPanel.addTab(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_REMOTETCP), this.rtcpPanel);
                this.tabbedPanel.addTab(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_PCS), this.pcsPanel);
                this.mainContainer.add(this.tabbedPanel);
                break;
            }
            case RemoteTcpLinearCircular: {
                this.tabbedPanel.removeAll();
                this.tabbedPanel.addTab(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_INSTRUCTIONS), this.instructionsPanel);
                this.tabbedPanel.addTab(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_REMOTETCP), this.rtcpPanel);
                this.mainContainer.add(this.tabbedPanel);
                break;
            }
            case RegularTcpToolpath: {
                this.tabbedPanel.removeAll();
                this.tabbedPanel.addTab(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_INSTRUCTIONS), this.instructionsPanel);
                this.tabbedPanel.addTab(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_TOOLPATH), this.toolpathPanel);
                this.tabbedPanel.addTab(this.localization.getLocalizedText(RtcpConstants.Strings.RTCP_INST_IO), this.toolpathIoPanel);
                this.mainContainer.add(this.tabbedPanel);
                break;
            }
        }
        this.instructionsManager.setInstructionsContent(this.currentViewType);
        this.mainContainer.revalidate();
        this.mainContainer.repaint();
    }

    private void DoNothingJustThrowException() throws IOException {
    }

    protected void updateViewForIndex(int selectedIndex) {
        block0 : switch (this.currentViewType) {
            case Home: {
                break;
            }
            case RemoteTcpToolpath: {
                switch (selectedIndex) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        this.toolpathView.updateView();
                        break block0;
                    }
                    case 2: {
                        this.toolpathIoView.updateView();
                        break block0;
                    }
                    case 3: {
                        this.rtcpSetupView.updateView();
                        break block0;
                    }
                    case 4: {
                        this.pcsView.updateView();
                        break block0;
                    }
                }
                break;
            }
            case RemoteTcpLinearCircular: {
                switch (selectedIndex) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        this.rtcpSetupView.updateView();
                        break block0;
                    }
                }
                break;
            }
            case RegularTcpToolpath: {
                switch (selectedIndex) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        this.toolpathView.updateView();
                        break block0;
                    }
                    case 2: {
                        this.toolpathIoView.updateView();
                        break block0;
                    }
                }
                break;
            }
        }
    }

    public void updateView() {
        this.updateDaemonSection();
        this.updateViewForIndex(this.tabbedPanel.getSelectedIndex());
    }

    public void updateDaemonSection() {
        if (this.uiReady) {
            this.daemonView.updateView();
        }
    }

    public class ViewContentSelector {
        public void setSelection(RtcpInstallationViewType applicationType) {
            RemoteTcpInstallationNodeView.this.currentViewType = applicationType;
            RemoteTcpInstallationNodeView.this.updateMainContainer();
        }

        public RtcpInstallationViewType getViewType() {
            return RemoteTcpInstallationNodeView.this.currentViewType;
        }
    }

    public static enum RtcpInstallationViewType {
        Home,
        RemoteTcpToolpath,
        RemoteTcpLinearCircular,
        RegularTcpToolpath;

    }
}

