/*
 * Decompiled with CFR 0.152.
 */
package com.energid.urcap.remotetcp.impl;

import com.energid.urcap.remotetcp.i18n.LanguagePack;
import com.energid.urcap.remotetcp.i18n.TextResource;
import com.energid.urcap.remotetcp.i18n.UnitsResource;
import com.energid.urcap.remotetcp.impl.Common.RobotRealtimeReader;
import com.energid.urcap.remotetcp.impl.Common.RtcpConstants;
import com.energid.urcap.remotetcp.impl.Common.RtcpXmlRpcClient;
import com.energid.urcap.remotetcp.impl.InstallationNode.RtcpDaemonService;
import com.energid.urcap.remotetcp.impl.Interfaces.LocalizationInfo;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpDaemonControl;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpRobotInfo;
import com.ur.urcap.api.contribution.DaemonContribution;
import com.ur.urcap.api.contribution.InstallationNodeContribution;
import com.ur.urcap.api.contribution.installation.InstallationAPIProvider;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.system.localization.UnitType;
import com.ur.urcap.api.domain.value.PoseFactory;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.urcap.api.domain.value.simple.SimpleValueFactory;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.SwingWorker;

public class RtcpInstallationContributionBase
implements InstallationNodeContribution,
RtcpDaemonControl,
RtcpRobotInfo,
LocalizationInfo {
    protected final InstallationAPIProvider apiProvider;
    protected final PoseFactory poseFactory;
    protected final SimpleValueFactory valueFactory;
    protected final DataModel dataModel;
    protected final RtcpDaemonService daemonService;
    protected final LanguagePack languagePack;
    protected final UnitType systemOfMeasurement;
    protected boolean daemonEnabled = false;
    protected boolean daemonStarted = false;
    private final int DAEMON_START_STOP_WAIT_TIMEOUT = 5000;
    protected final int IS_DAEMON_REACHABLE_TIMEOUT = 10000;

    public RtcpInstallationContributionBase(InstallationAPIProvider apiProvider, DataModel model, RtcpDaemonService daemon) {
        this.apiProvider = apiProvider;
        this.poseFactory = apiProvider.getInstallationAPI().getValueFactoryProvider().getPoseFactory();
        this.valueFactory = apiProvider.getInstallationAPI().getValueFactoryProvider().getSimpleValueFactory();
        this.dataModel = model;
        this.daemonService = daemon;
        this.languagePack = new LanguagePack(apiProvider.getSystemAPI().getSystemSettings().getLocalization());
        this.systemOfMeasurement = this.languagePack.getUnitType();
    }

    @Override
    public TextResource getTextResource() {
        return this.languagePack.getTextResource();
    }

    @Override
    public UnitsResource getUnitsResource() {
        return this.languagePack.getUnitsResource();
    }

    @Override
    public Length.Unit getSystemLengthUnit() {
        return this.systemOfMeasurement == UnitType.METRIC ? Length.Unit.MM : Length.Unit.IN;
    }

    @Override
    public double getConvertedLengthForStorage(double inputValue) {
        Length inputLength = this.valueFactory.createLength(inputValue, this.getSystemLengthUnit());
        return inputLength.getAs(Length.Unit.MM);
    }

    @Override
    public double getConvertedLengthForDisplay(double inputValue) {
        Length inputLength = this.valueFactory.createLength(inputValue, Length.Unit.MM);
        return inputLength.getAs(this.getSystemLengthUnit());
    }

    @Override
    public double parseForLocalizedValue(String input) {
        NumberFormat format = NumberFormat.getInstance(this.apiProvider.getSystemAPI().getSystemSettings().getLocalization().getLocale());
        try {
            Number number = format.parse(input);
            return number.doubleValue();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    @Override
    public String getLocalizedText(RtcpConstants.Strings string) {
        return this.getTextResource().getStringByKey(string.toString());
    }

    @Override
    public String getLocalizedLengthUnit() {
        return this.getUnitsResource().getLengthUnit(this.getSystemLengthUnit());
    }

    @Override
    public String getLocalizedSpeedUnit() {
        return this.getUnitsResource().getSpeedUnit(this.getSystemLengthUnit());
    }

    @Override
    public String getLocalizedAccelerationUnit() {
        return this.getUnitsResource().getAccelerationUnit(this.getSystemLengthUnit());
    }

    public void openView() {
    }

    public void closeView() {
    }

    public void generateScript(ScriptWriter writer) {
    }

    @Override
    public boolean isPowerOn() {
        return RobotRealtimeReader.getRobotMode() > 3.0;
    }

    @Override
    public void applyDesiredDaemonStatus() {
        if (this.isDaemonEnabled().booleanValue()) {
            try {
                this.awaitDaemonRunning(5000L);
            }
            catch (Exception e) {
                System.err.println("Starting the controller failed.");
            }
        } else {
            try {
                this.awaitDaemonStopping(5000L);
            }
            catch (Exception e) {
                System.err.println("Stopping the controller failed.");
            }
        }
    }

    private Boolean isDaemonEnabled() {
        return this.daemonEnabled;
    }

    private void awaitDaemonRunning(final long timeOutMilliSeconds) throws InterruptedException {
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                RtcpInstallationContributionBase.this.daemonService.getDaemon().start();
                long endTime = System.nanoTime() + timeOutMilliSeconds * 1000L * 1000L;
                while (System.nanoTime() < endTime && !RtcpInstallationContributionBase.this.isServerReachable()) {
                    Thread.sleep(100L);
                }
                return null;
            }

            @Override
            public void done() {
                RtcpInstallationContributionBase.this.updateDisplays();
            }
        };
        worker.execute();
    }

    private void awaitDaemonStopping(final long timeOutMilliSeconds) throws InterruptedException {
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                RtcpInstallationContributionBase.this.daemonService.getDaemon().stop();
                long endTime = System.nanoTime() + timeOutMilliSeconds * 1000L * 1000L;
                while (System.nanoTime() < endTime && RtcpInstallationContributionBase.this.isServerReachable()) {
                    Thread.sleep(100L);
                }
                return null;
            }

            @Override
            public void done() {
                RtcpInstallationContributionBase.this.updateDisplays();
            }
        };
        worker.execute();
    }

    protected void updateDisplays() {
    }

    @Override
    public DaemonContribution.State getDaemonState() {
        return this.daemonService.getDaemon().getState();
    }

    @Override
    public void setDaemonEnabled(Boolean enable) {
        this.daemonEnabled = enable;
    }

    @Override
    public boolean isServerReachable() {
        Object[] methods = RtcpXmlRpcClient.getMethodList();
        return methods != null && RtcpXmlRpcClient.getLastError().isEmpty();
    }

    @Override
    public DaemonContribution.State getDaemonDesiredState() {
        boolean isDesiredDaemonStateStart = this.dataModel.get("RTCP_DAEMON_STARTED", false);
        if (isDesiredDaemonStateStart) {
            return DaemonContribution.State.RUNNING;
        }
        return DaemonContribution.State.STOPPED;
    }

    @Override
    public boolean hasDeamonStarted() {
        return this.daemonStarted;
    }

    @Override
    public boolean waitForDaemon(int timeout) {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < (long)timeout) {
            if (this.isServerReachable()) {
                return true;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }
}

