/*
 * Decompiled with CFR 0.152.
 */
package com.energid.urcap.remotetcp.impl.WaypointNodes;

import com.energid.urcap.remotetcp.impl.Common.RtcpConstants;
import com.energid.urcap.remotetcp.impl.Common.RtcpMotionParameters;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpProgramInfo;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpWaypointNode;
import com.energid.urcap.remotetcp.impl.RemoteTcpInstallationNodeContribution;
import com.energid.urcap.remotetcp.impl.WaypointNodes.RtcpEndpointProgramNodeView;
import com.energid.urcap.remotetcp.impl.WaypointNodes.RtcpWaypointContributionBase;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.contribution.program.ProgramAPIProvider;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.script.ScriptWriter;
import java.util.LinkedHashMap;

public class RtcpEndpointProgramNodeContribution
extends RtcpWaypointContributionBase
implements ProgramNodeContribution {
    private final RtcpEndpointProgramNodeView view;

    public RtcpEndpointProgramNodeContribution(ProgramAPIProvider apiProvider, RtcpEndpointProgramNodeView view, DataModel model) {
        this.apiProvider = apiProvider;
        this.programApi = apiProvider.getProgramAPI();
        this.undoRedoManager = apiProvider.getProgramAPI().getUndoRedoManager();
        this.view = view;
        this.model = model;
        this.waypointName = model.get("WAYPOINT_NAME", "");
        if (this.waypointName.equals("")) {
            RtcpProgramInfo programInfo = (RtcpProgramInfo)this.programApi.getInstallationNode(RemoteTcpInstallationNodeContribution.class);
            LinkedHashMap<String, RtcpWaypointNode> waypoints = programInfo.getAllWaypoints(RtcpWaypointNode.WaypointType.Endpoint);
            this.waypointName = RtcpWaypointContributionBase.makeWaypointName(this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_ENDPOINT_PROGRAMNODE_TREETEXT), waypoints);
        }
        model.set("WAYPOINT_NAME", this.waypointName);
    }

    public void openView() {
        this.checkParent();
        this.viewHelper = this.view.getHelper();
        this.viewHelper.setContribution(this);
        this.view.setApiProvider(this.apiProvider);
        this.viewHelper.updateView();
    }

    public void closeView() {
    }

    public String getTitle() {
        return this.getWaypointName();
    }

    public boolean isDefined() {
        return this.getJointPositions() != null;
    }

    public void generateScript(ScriptWriter writer) {
        if (!this.isExecuting) {
            String message = "popup(\"" + this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_SINGLESTEPPING_MESSAGE) + "\", title=\"" + this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_WARNING_TITLE) + "\", error=True, blocking=False)";
            writer.appendLine(message);
        }
        this.isExecuting = false;
    }

    @Override
    public RtcpWaypointNode.WaypointType getWaypointType() {
        return RtcpWaypointNode.WaypointType.Endpoint;
    }

    @Override
    public void writeScriptForMoveNode(ScriptWriter writer, String waypointId, int order, RtcpMotionParameters params) {
        this.checkParent();
        this.isExecuting = true;
    }
}

