/*
 * Decompiled with CFR 0.152.
 */
package com.energid.urcap.remotetcp.impl.WaypointNodes;

import com.energid.urcap.remotetcp.impl.Common.RtcpConstants;
import com.energid.urcap.remotetcp.impl.Common.RtcpMotionParameters;
import com.energid.urcap.remotetcp.impl.Common.RtcpNamedPose;
import com.energid.urcap.remotetcp.impl.Common.RtcpXmlRpcClient;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpNamedPoseInfo;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpToolpathNode;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpWaypointNode;
import com.energid.urcap.remotetcp.impl.Interfaces.ToolpathInfo;
import com.energid.urcap.remotetcp.impl.RemoteTcpInstallationNodeContribution;
import com.energid.urcap.remotetcp.impl.WaypointNodes.RtcpWaypointContributionBase;
import com.ur.urcap.api.contribution.program.ProgramAPIProvider;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.undoredo.UndoableChanges;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.simple.Angle;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.urcap.api.domain.variable.Variable;
import java.util.Arrays;
import java.util.Collection;

public class RtcpToolpathContributionBase
extends RtcpWaypointContributionBase
implements RtcpToolpathNode {
    protected String toolpathName;

    public RtcpToolpathContributionBase(ProgramAPIProvider apiProvider, DataModel model) {
        this.apiProvider = apiProvider;
        this.programApi = apiProvider.getProgramAPI();
        this.undoRedoManager = apiProvider.getProgramAPI().getUndoRedoManager();
        this.model = model;
    }

    @Override
    public RtcpWaypointNode.WaypointType getWaypointType() {
        return RtcpWaypointNode.WaypointType.Toolpath;
    }

    @Override
    public void writeScriptForMoveNode(ScriptWriter writer, String scriptId, int order, RtcpMotionParameters params) {
        this.checkParent();
        int pathID = this.loadToolpath();
        this.scriptId = scriptId;
        String loadCommand = "";
        loadCommand = "mc_set_pcs(" + this.getPcs() + ")";
        writer.appendLine(loadCommand);
        loadCommand = this.scriptId + " = mc_add_path(" + pathID + ", " + this.getToolAcceleration() / 1000.0 + ", " + this.getToolSpeed() / 1000.0 + ", " + this.getBlendRadius() / 1000.0 + ")";
        writer.appendLine(loadCommand);
        writer.appendLine("mc_debugMsg(\"" + this.getWaypointName() + " is ID \", " + scriptId + ")");
        loadCommand = "mc_set_pcs(" + this.createZeroPose().toString() + ")";
        writer.appendLine(loadCommand);
        this.isExecuting = true;
    }

    private int loadToolpath() {
        return RtcpXmlRpcClient.loadToolpath("/programs/" + this.getSelectedToolpath(), this.getToolSpeedSelection() == ToolSpeedSelection.FEEDRATE, 120);
    }

    protected String getPcs() {
        if (this.getPcsModeSelection() == PcsMode.VARIABLE) {
            return this.getVariableNameForPcs();
        }
        return this.getPoseForSelectedPcs().toString();
    }

    public void readDataModel() {
    }

    public String getSelectedToolpath() {
        String toolpath = this.getSelectedToolpathInternal();
        if (toolpath.equals("RTCP_TOOLPATH_DATAMODEL_SELECT_DEFAULT_VALUE")) {
            return this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_TOOLPATH_SELECT_DEFAULT);
        }
        return toolpath;
    }

    private String getSelectedToolpathInternal() {
        return this.model.get("TOOLPATH_NAME", "RTCP_TOOLPATH_DATAMODEL_SELECT_DEFAULT_VALUE");
    }

    public void updateSelectedToolpath(final String toolpath) {
        this.undoRedoManager.recordChanges(new UndoableChanges(){

            public void executeChanges() {
                RtcpToolpathContributionBase.this.model.remove("TOOLPATH_NAME");
                if (toolpath.equals(RtcpToolpathContributionBase.this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_TOOLPATH_SELECT_DEFAULT))) {
                    RtcpToolpathContributionBase.this.model.set("TOOLPATH_NAME", "RTCP_TOOLPATH_DATAMODEL_SELECT_DEFAULT_VALUE");
                } else {
                    RtcpToolpathContributionBase.this.model.set("TOOLPATH_NAME", toolpath);
                }
            }
        });
    }

    public void updateToolpathPcs(final Pose origin) {
        this.undoRedoManager.recordChanges(new UndoableChanges(){

            public void executeChanges() {
                RtcpToolpathContributionBase.this.model.remove("TOOLPATH_PCS");
                RtcpToolpathContributionBase.this.model.set("TOOLPATH_PCS", origin);
            }
        });
    }

    public void updateUsesVariableForPcs(final PcsMode mode) {
        this.undoRedoManager.recordChanges(new UndoableChanges(){

            public void executeChanges() {
                RtcpToolpathContributionBase.this.model.remove("RTCP_TOOLPATH_DATAMODEL_PCSMODESELECTION");
                RtcpToolpathContributionBase.this.model.set("RTCP_TOOLPATH_DATAMODEL_PCSMODESELECTION", mode.name());
            }
        });
    }

    public void updateToolSpeedSelection(final ToolSpeedSelection toolspeedSelection) {
        this.undoRedoManager.recordChanges(new UndoableChanges(){

            public void executeChanges() {
                RtcpToolpathContributionBase.this.model.remove("RTCP_TOOLPATH_DATAMODEL_TOOLSPEEDSELECTION");
                RtcpToolpathContributionBase.this.model.set("RTCP_TOOLPATH_DATAMODEL_TOOLSPEEDSELECTION", toolspeedSelection.name());
            }
        });
    }

    public ToolSpeedSelection getToolSpeedSelection() {
        String val = this.model.get("RTCP_TOOLPATH_DATAMODEL_TOOLSPEEDSELECTION", ToolSpeedSelection.SHARED.name());
        return ToolSpeedSelection.valueOf(val);
    }

    public void updateToolAccelerationSelection(final ToolAccelerationSelection toolaccelerationSelection) {
        this.undoRedoManager.recordChanges(new UndoableChanges(){

            public void executeChanges() {
                RtcpToolpathContributionBase.this.model.remove("RTCP_TOOLPATH_DATAMODEL_TOOLACCELERATIONSELECTION");
                RtcpToolpathContributionBase.this.model.set("RTCP_TOOLPATH_DATAMODEL_TOOLACCELERATIONSELECTION", toolaccelerationSelection.name());
            }
        });
    }

    public ToolAccelerationSelection getToolAccelerationSelection() {
        String val = this.model.get("RTCP_TOOLPATH_DATAMODEL_TOOLACCELERATIONSELECTION", ToolAccelerationSelection.SHARED.name());
        return ToolAccelerationSelection.valueOf(val);
    }

    public void updateVariableNameForPcs(final String variableName) {
        this.undoRedoManager.recordChanges(new UndoableChanges(){

            public void executeChanges() {
                RtcpToolpathContributionBase.this.model.remove("VARNAME_PCS");
                if (variableName.equals(RtcpToolpathContributionBase.this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_TOOLPATH_VARIABLE_DEFAULT))) {
                    RtcpToolpathContributionBase.this.model.set("VARNAME_PCS", "RTCP_TOOLPATH_DATAMODEL_VARIABLE_DEFAULT_VALUE");
                } else {
                    RtcpToolpathContributionBase.this.model.set("VARNAME_PCS", variableName);
                }
            }
        });
    }

    public PcsMode getPcsModeSelection() {
        String val = this.model.get("RTCP_TOOLPATH_DATAMODEL_PCSMODESELECTION", PcsMode.FIXED.name());
        return PcsMode.valueOf(val);
    }

    public String getVariableNameForPcs() {
        String varName = this.getVariableNameForPcsInternal();
        if (varName.equals("RTCP_TOOLPATH_DATAMODEL_VARIABLE_DEFAULT_VALUE")) {
            return this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_TOOLPATH_VARIABLE_DEFAULT);
        }
        return varName;
    }

    private String getVariableNameForPcsInternal() {
        return this.model.get("VARNAME_PCS", "RTCP_TOOLPATH_DATAMODEL_VARIABLE_DEFAULT_VALUE");
    }

    public String[] getVariables() {
        Collection collectionVariables = this.apiProvider.getProgramAPI().getVariableModel().getAll();
        String[] variables = new String[collectionVariables.size()];
        int index = 0;
        for (Variable var : collectionVariables) {
            if (var.getType() == Variable.Type.FEATURE) continue;
            variables[index++] = var.getDisplayName();
        }
        return variables;
    }

    protected Pose createZeroPose() {
        Pose pose = null;
        if (this.apiProvider != null) {
            pose = this.apiProvider.getProgramAPI().getValueFactoryProvider().getPoseFactory().createPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Length.Unit.MM, Angle.Unit.RAD);
        }
        return pose;
    }

    @Override
    public String getErrorMessage() {
        if (!this.isToolpathSelected()) {
            return this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_TOOLPATH_ERROR_TOOLPATHNOTSELECTED);
        }
        if (!this.isSelectedToolpathValid()) {
            return this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_TOOLPATH_ERROR_TOOLPATHMISSING);
        }
        if (this.getPcsModeSelection() == PcsMode.FIXED) {
            if (!this.isPcsSelected()) {
                return this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_TOOLPATH_ERROR_PCSNOTSELECTED);
            }
            if (!this.isSelectedPcsValid()) {
                return this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_TOOLPATH_ERROR_PCSMISSING);
            }
        }
        if (this.getPcsModeSelection() == PcsMode.VARIABLE) {
            if (!this.isPcsVariableSelected()) {
                return this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_TOOLPATH_ERROR_PCSVARIABLEMISSING);
            }
            if (!this.isPcsVariableValid()) {
                return this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_TOOLPATH_ERROR_VARIABLEMISSING);
            }
        }
        return "";
    }

    protected String getSelectedPcsInternal() {
        return this.model.get("SELECTED_PCS", "RTCP_TOOLPATH_DATAMODEL_SELECTEDS_DEFAULT_VALUE");
    }

    @Override
    public boolean isPcsVariableSelected() {
        return !this.getVariableNameForPcsInternal().equals("RTCP_TOOLPATH_DATAMODEL_VARIABLE_DEFAULT_VALUE");
    }

    @Override
    public boolean isPcsVariableValid() {
        String[] variables = this.getVariables();
        return Arrays.asList(variables).contains(this.getVariableNameForPcs());
    }

    @Override
    public boolean isToolpathSelected() {
        return !this.getSelectedToolpathInternal().equals("RTCP_TOOLPATH_DATAMODEL_SELECT_DEFAULT_VALUE");
    }

    @Override
    public boolean isSelectedToolpathValid() {
        return Arrays.asList(this.getToolpathFiles()).contains(this.getSelectedToolpath());
    }

    public String[] getToolpathFiles() {
        return this.getToolpathInfo().getImportedToolpathFiles();
    }

    public String[] getPcsList() {
        return this.getPcsInfo().getAvailablePoses();
    }

    @Override
    public String getSelectedPcs() {
        String selectedPcs = this.getSelectedPcsInternal();
        if (this.isDefaultPcs(selectedPcs)) {
            return this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_TOOLPATH_SELECTED_PCS_DEFAULT);
        }
        return selectedPcs;
    }

    public Pose getPoseForSelectedPcs() {
        String selectedPcs = this.getSelectedPcsInternal();
        RtcpNamedPose pcs = this.isDefaultPcs(selectedPcs) ? this.getPcsInfo().getNamedPoseById(this.getPcsInfo().getDefaultNamedPose()) : this.getPcsInfo().getNamedPoseById(selectedPcs);
        return pcs.getPose();
    }

    protected boolean isDefaultPcs(String selectedPcs) {
        return selectedPcs.equals("RTCP_TOOLPATH_DATAMODEL_SELECTEDS_DEFAULT_VALUE");
    }

    public void updateSelectedPcs(final String pcs) {
        this.undoRedoManager.recordChanges(new UndoableChanges(){

            public void executeChanges() {
                RtcpToolpathContributionBase.this.model.remove("SELECTED_PCS");
                if (pcs.equals(RtcpToolpathContributionBase.this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_TOOLPATH_SELECTED_PCS_DEFAULT))) {
                    RtcpToolpathContributionBase.this.model.set("SELECTED_PCS", "RTCP_TOOLPATH_DATAMODEL_SELECTEDS_DEFAULT_VALUE");
                } else {
                    RtcpToolpathContributionBase.this.model.set("SELECTED_PCS", pcs);
                }
            }
        });
    }

    @Override
    public void renameSelectedPcs(String oldName, final String newName) {
        if (this.getSelectedPcs().equals(oldName)) {
            this.undoRedoManager.recordChanges(new UndoableChanges(){

                public void executeChanges() {
                    RtcpToolpathContributionBase.this.model.remove("SELECTED_PCS");
                    if (newName.equals(RtcpToolpathContributionBase.this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_TOOLPATH_SELECTED_PCS_DEFAULT))) {
                        RtcpToolpathContributionBase.this.model.set("SELECTED_PCS", "RTCP_TOOLPATH_DATAMODEL_SELECTEDS_DEFAULT_VALUE");
                    } else {
                        RtcpToolpathContributionBase.this.model.set("SELECTED_PCS", newName);
                    }
                }
            });
        }
    }

    @Override
    public double getToolSpeed() {
        ToolSpeedSelection selection = this.getToolSpeedSelection();
        if (selection == ToolSpeedSelection.FEEDRATE) {
            return 0.0;
        }
        if (selection == ToolSpeedSelection.SHARED) {
            return this.parentMove.getToolSpeed();
        }
        return this.model.get("WAYPOINT_TOOLSPEED", 100.0);
    }

    @Override
    public double getToolAcceleration() {
        ToolAccelerationSelection selection = this.getToolAccelerationSelection();
        if (selection == ToolAccelerationSelection.SHARED) {
            return this.parentMove.getToolAcceleration();
        }
        return this.model.get("WAYPOINT_TOOLACC", 1000.0);
    }

    @Override
    public boolean isSelectedPcsValid() {
        String selectedPcs = this.getSelectedPcsInternal();
        if (!this.isDefaultPcs(selectedPcs)) {
            return Arrays.asList(this.getPcsInfo().getAvailablePoses()).contains(selectedPcs);
        }
        return true;
    }

    @Override
    public boolean isPcsSelected() {
        return true;
    }

    protected RtcpNamedPoseInfo getPcsInfo() {
        return ((RemoteTcpInstallationNodeContribution)this.programApi.getInstallationNode(RemoteTcpInstallationNodeContribution.class)).getPcsHandler();
    }

    protected ToolpathInfo getToolpathInfo() {
        return ((RemoteTcpInstallationNodeContribution)this.programApi.getInstallationNode(RemoteTcpInstallationNodeContribution.class)).getToolpathHandler();
    }

    public static enum ToolAccelerationSelection {
        SHARED,
        CUSTOM;

    }

    public static enum ToolSpeedSelection {
        FEEDRATE,
        SHARED,
        CUSTOM;

    }

    public static enum PcsMode {
        FIXED,
        VARIABLE;

    }
}

