/*
 * Decompiled with CFR 0.152.
 */
package com.energid.urcap.remotetcp.impl.WaypointNodes;

import com.energid.urcap.remotetcp.impl.Common.RtcpConstants;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpProgramInfo;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpWaypointNode;
import com.energid.urcap.remotetcp.impl.RemoteTcpInstallationNodeContribution;
import com.energid.urcap.remotetcp.impl.WaypointNodes.RtcpToolpathContributionBase;
import com.energid.urcap.remotetcp.impl.WaypointNodes.RtcpToolpathProgramNodeView;
import com.energid.urcap.remotetcp.impl.WaypointNodes.RtcpWaypointContributionBase;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.contribution.program.ProgramAPIProvider;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.script.ScriptWriter;
import java.util.LinkedHashMap;

public class RtcpToolpathProgramNodeContribution
extends RtcpToolpathContributionBase
implements ProgramNodeContribution {
    private RtcpToolpathProgramNodeView view;

    public RtcpToolpathProgramNodeContribution(ProgramAPIProvider apiProvider, RtcpToolpathProgramNodeView view, DataModel model) {
        super(apiProvider, model);
        this.view = view;
        this.waypointName = model.get("WAYPOINT_NAME", "");
        if (this.waypointName.equals("")) {
            RtcpProgramInfo programInfo = (RtcpProgramInfo)this.programApi.getInstallationNode(RemoteTcpInstallationNodeContribution.class);
            LinkedHashMap<String, RtcpWaypointNode> toolpaths = programInfo.getAllWaypoints(RtcpWaypointNode.WaypointType.Toolpath);
            this.waypointName = RtcpWaypointContributionBase.makeWaypointName(this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_TOOLPATH_PROGRAMNODE_TREETEXT), toolpaths);
        }
        model.set("WAYPOINT_NAME", this.waypointName);
    }

    public void openView() {
        this.checkParent();
        this.viewHelper = this.view.getHelper();
        this.viewHelper.setContribution(this);
        this.view.setApiProvider(this.apiProvider);
        this.viewHelper.updateView();
    }

    public void closeView() {
    }

    public String getTitle() {
        return this.getWaypointName();
    }

    public boolean isDefined() {
        return this.getErrorMessage().isEmpty();
    }

    public void generateScript(ScriptWriter writer) {
        if (this.isExecuting) {
            writer.appendLine("mc_run_motion(" + this.scriptId + ")");
        } else {
            String message = "popup(\"" + this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_SINGLESTEPPING_MESSAGE) + "\", title=\"" + this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_WARNING_TITLE) + "\", error=True, blocking=False)";
            writer.appendLine(message);
        }
        this.isExecuting = false;
    }

    @Override
    public RtcpWaypointNode.WaypointType getWaypointType() {
        return RtcpWaypointNode.WaypointType.Toolpath;
    }
}

