/*
 * Decompiled with CFR 0.152.
 */
package com.energid.urcap.remotetcp.impl.WaypointNodes;

import com.energid.urcap.remotetcp.impl.Common.RobotRealtimeReader;
import com.energid.urcap.remotetcp.impl.Common.RtcpComboRenderer;
import com.energid.urcap.remotetcp.impl.Common.RtcpConstants;
import com.energid.urcap.remotetcp.impl.Common.RtcpUtils;
import com.energid.urcap.remotetcp.impl.Common.RtcpXmlRpcClient;
import com.energid.urcap.remotetcp.impl.Common.Style;
import com.energid.urcap.remotetcp.impl.Common.WideComboBox;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpWaypointNode;
import com.energid.urcap.remotetcp.impl.WaypointNodes.RtcpToolpathContributionBase;
import com.energid.urcap.remotetcp.impl.WaypointNodes.RtcpWaypointViewHelper;
import com.ur.urcap.api.contribution.program.ProgramAPIProvider;
import com.ur.urcap.api.domain.userinteraction.robot.movement.MovementCompleteEvent;
import com.ur.urcap.api.domain.userinteraction.robot.movement.MovementErrorEvent;
import com.ur.urcap.api.domain.userinteraction.robot.movement.RobotMovementCallback;
import com.ur.urcap.api.domain.value.Pose;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;

public class RtcpToolpathViewHelperBase
extends RtcpWaypointViewHelper {
    protected RtcpToolpathContributionBase toolpathContribution;
    protected JLabel labelToolpath;
    protected JLabel labelPcs;
    protected JLabel labelVariable;
    protected WideComboBox selectToolpathCombo;
    protected JComboBox selectPcsCombo;
    protected JComboBox selectModeCombo;
    protected JComboBox selectVariableCombo;
    protected RtcpComboRenderer toolpathSelectionRenderer;
    protected RtcpComboRenderer pcsSelectionRenderer;
    protected RtcpComboRenderer variableSelectionRenderer;
    protected boolean toolpathComboListens = true;
    protected boolean pcsComboListens = true;
    protected boolean modeComboListens = true;
    protected boolean variableComboListens = true;
    protected Box boxModeContent;
    protected Box boxFixedPcsArea;
    protected Box boxVariablePcsArea;
    protected JRadioButton feedrateRadioButton;
    protected JRadioButton sharedToolSpeedRadioButton;
    protected JRadioButton customToolSpeedRadioButton;
    protected JRadioButton sharedToolAccelerationRadioButton;
    protected JRadioButton customToolAccelerationRadioButton;
    protected boolean usesBlendRadius = true;

    public RtcpToolpathViewHelperBase(JPanel container, Style style) {
        super(container, style);
        this.bottomSectionVSpacing = 30;
        this.lowerSectionVSpacing = 20;
        this.poseSectionVSpacing = 10;
        this.messageSectionVSpacing = 50;
        this.toolpathSelectionRenderer = new RtcpComboRenderer(style);
        this.pcsSelectionRenderer = new RtcpComboRenderer(style);
        this.variableSelectionRenderer = new RtcpComboRenderer(style);
    }

    @Override
    public void updateView() {
        this.updateToolpathList();
        boolean isVariablePcs = this.toolpathContribution.getPcsModeSelection() == RtcpToolpathContributionBase.PcsMode.VARIABLE;
        this.nameLabel.setText(this.contribution.getWaypointName());
        this.updateModeList(isVariablePcs);
        if (isVariablePcs) {
            this.updateVariableList();
            this.boxModeContent.add(this.boxVariablePcsArea);
        } else {
            this.updatePcsList();
            this.boxModeContent.add(this.boxFixedPcsArea);
        }
        this.moveHereButton.setEnabled(this.canEnableMoveHere());
        this.updateToolParametersView();
        this.updateText();
        this.showValidationWarning();
    }

    @Override
    protected boolean canEnableMoveHere() {
        boolean canMove = this.toolpathContribution.isToolpathSelected() && this.toolpathContribution.isSelectedToolpathValid() && this.toolpathContribution.isPcsSelected() && this.toolpathContribution.isSelectedPcsValid() && this.contribution.getParent().isSelectedRtcpValid();
        return canMove;
    }

    private void updateToolParametersView() {
        boolean sharingBlendRadius = this.contribution.isUsingSharedBlendRadius();
        this.sharedBlendRadiusRadioButton.setSelected(sharingBlendRadius);
        this.customBlendRadiusRadioButton.setSelected(!sharingBlendRadius);
        this.setBoxEnabled((Box)this.blendEditBlock, !sharingBlendRadius);
        this.updateBlendRadiusField(sharingBlendRadius);
        RtcpToolpathContributionBase.ToolSpeedSelection toolspeedSelection = this.toolpathContribution.getToolSpeedSelection();
        this.feedrateRadioButton.setSelected(toolspeedSelection == RtcpToolpathContributionBase.ToolSpeedSelection.FEEDRATE);
        this.sharedToolSpeedRadioButton.setSelected(toolspeedSelection == RtcpToolpathContributionBase.ToolSpeedSelection.SHARED);
        this.customToolSpeedRadioButton.setSelected(toolspeedSelection == RtcpToolpathContributionBase.ToolSpeedSelection.CUSTOM);
        this.setBoxEnabled((Box)this.speedEditBlock, toolspeedSelection == RtcpToolpathContributionBase.ToolSpeedSelection.CUSTOM);
        this.updateToolSpeedFields(toolspeedSelection);
        RtcpToolpathContributionBase.ToolAccelerationSelection toolaccelerationSelection = this.toolpathContribution.getToolAccelerationSelection();
        this.sharedToolAccelerationRadioButton.setSelected(toolaccelerationSelection == RtcpToolpathContributionBase.ToolAccelerationSelection.SHARED);
        this.customToolAccelerationRadioButton.setSelected(toolaccelerationSelection == RtcpToolpathContributionBase.ToolAccelerationSelection.CUSTOM);
        this.setBoxEnabled((Box)this.accelerationEditBlock, toolaccelerationSelection == RtcpToolpathContributionBase.ToolAccelerationSelection.CUSTOM);
        this.updateToolAccelerationFields(toolaccelerationSelection);
    }

    private void updateVariableList() {
        Border border;
        this.variableComboListens = false;
        String[] variables = this.toolpathContribution.getVariables();
        String selectedVariable = this.toolpathContribution.getVariableNameForPcs();
        String defaultVariable = this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_TOOLPATH_VARIABLE_DEFAULT);
        this.selectVariableCombo.removeAllItems();
        this.variableSelectionRenderer.setMissingItem("");
        if (selectedVariable.equals(defaultVariable) || !selectedVariable.equals(defaultVariable) && !Arrays.asList(variables).contains(selectedVariable)) {
            this.variableSelectionRenderer.setMissingItem(selectedVariable);
            this.selectVariableCombo.addItem(selectedVariable);
            border = BorderFactory.createLineBorder(this.style.getGoldYellow2(), 2);
        } else {
            border = BorderFactory.createLineBorder(this.style.getBorderColor(), 1);
        }
        for (String item : variables) {
            this.selectVariableCombo.addItem(item);
        }
        if (selectedVariable != null && !selectedVariable.isEmpty()) {
            this.selectVariableCombo.setSelectedItem(selectedVariable);
        }
        this.selectVariableCombo.setBorder(border);
        this.variableComboListens = true;
    }

    private void updateModeList(boolean isVariablePcs) {
        this.modeComboListens = false;
        this.selectModeCombo.removeAllItems();
        this.selectModeCombo.addItem(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_TOOLPATH_MODE_FIXEDPCS));
        this.selectModeCombo.addItem(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_TOOLPATH_MODE_VARIABLEPCS));
        this.boxModeContent.removeAll();
        if (isVariablePcs) {
            this.selectModeCombo.setSelectedIndex(1);
        } else {
            this.selectModeCombo.setSelectedIndex(0);
        }
        this.modeComboListens = true;
    }

    public void updateText() {
        this.labelToolpath.setText(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_TOOLPATH_SELECT_TOOLPATHFILE));
        this.labelVariable.setText(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_TOOLPATH_SELECT_VARIABLE));
        this.moveHereButton.setText(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_TOOLPATH_MOVETOFIRST));
        this.sharedBlendRadiusRadioButton.setText(RtcpUtils.encloseWithHtml(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_WAYPOINT_USESHARED_BLENDRADIUS)));
        this.customBlendRadiusRadioButton.setText(RtcpUtils.encloseWithHtml(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_BLENDRADIUS)));
        this.feedrateRadioButton.setText(RtcpUtils.encloseWithHtml(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_TOOLPATH_FEEDRATE)));
        this.sharedToolSpeedRadioButton.setText(RtcpUtils.encloseWithHtml(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_TOOLPATH_SHAREDTOOLSPEED)));
        this.customToolSpeedRadioButton.setText(RtcpUtils.encloseWithHtml(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_TOOLSPEED)));
        this.sharedToolAccelerationRadioButton.setText(RtcpUtils.encloseWithHtml(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_TOOLPATH_SHAREDTOOLACCELERATION)));
        this.customToolAccelerationRadioButton.setText(RtcpUtils.encloseWithHtml(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_TOOLACCELERATION)));
        this.waypointButton.setText(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_WAYPOINT));
        this.circleMoveButton.setText(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_CIRCLEMOVE));
        this.toolpathButton.setText(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_TOOLPATH));
        this.labelSpeedUnit.setText(this.contribution.getLocalizationInfo().getLocalizedSpeedUnit());
        this.labelRadiusUnit.setText(this.contribution.getLocalizationInfo().getLocalizedLengthUnit());
        this.labelAccelerationUnit.setText(RtcpUtils.encloseWithHtml(this.contribution.getLocalizationInfo().getLocalizedAccelerationUnit()));
    }

    @Override
    protected Box createUpperSection() {
        Box main = Box.createVerticalBox();
        main.setAlignmentX(0.0f);
        main.setAlignmentY(0.0f);
        main.setMaximumSize(new Dimension(700, 140));
        main.setBorder(this.defaultBorder);
        Box boxNameAndMode = this.createNameAndModeArea();
        Box boxSelections = this.createSelectionsArea();
        main.add(boxNameAndMode);
        main.add(this.createVerticalSpacing(10));
        main.add(boxSelections);
        return main;
    }

    private Box createNameAndModeArea() {
        int areaWidth = 300;
        int buttonHeight = 40;
        Dimension nameAreaSize = new Dimension(areaWidth, buttonHeight);
        Box main = Box.createHorizontalBox();
        main.setAlignmentX(0.0f);
        main.setBorder(this.defaultBorder);
        Box nameArea = this.makeNameArea(nameAreaSize);
        Box modeArea = this.makeModeArea();
        main.add(nameArea);
        main.add(Box.createHorizontalGlue());
        main.add(modeArea);
        return main;
    }

    private Box makeModeArea() {
        Box main = Box.createHorizontalBox();
        main.setAlignmentX(0.0f);
        main.setBorder(this.defaultBorder);
        this.selectModeCombo = new JComboBox();
        this.selectModeCombo.setName(this.controlNameBase + "_SelectMode");
        this.selectModeCombo.setAlignmentX(0.0f);
        this.selectModeCombo.setMaximumSize(this.style.getSelectionComboboxSize());
        this.selectModeCombo.setPreferredSize(this.style.getSelectionComboboxSize());
        this.selectModeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!RtcpToolpathViewHelperBase.this.modeComboListens) {
                    return;
                }
                int modeIndex = RtcpToolpathViewHelperBase.this.selectModeCombo.getSelectedIndex();
                if (modeIndex != -1) {
                    RtcpToolpathContributionBase.PcsMode pcsMode = modeIndex == 0 ? RtcpToolpathContributionBase.PcsMode.FIXED : RtcpToolpathContributionBase.PcsMode.VARIABLE;
                    RtcpToolpathViewHelperBase.this.toolpathContribution.updateUsesVariableForPcs(RtcpToolpathContributionBase.PcsMode.values()[modeIndex]);
                    RtcpToolpathViewHelperBase.this.updateView();
                }
            }
        });
        main.add(this.selectModeCombo);
        return main;
    }

    private Box createSelectionsArea() {
        Box main = Box.createHorizontalBox();
        main.setAlignmentX(0.0f);
        main.setBorder(this.defaultBorder);
        this.setButton = new JButton();
        Box boxToolpathSelection = this.createToolpathSelectionArea();
        this.boxModeContent = this.createModeContentBox();
        this.boxFixedPcsArea = this.createFixedPcsArea();
        this.boxVariablePcsArea = this.createVariablePcsArea();
        main.add(boxToolpathSelection);
        main.add(this.createHorizontalSpacing(30));
        main.add(this.boxModeContent);
        return main;
    }

    private Box createModeContentBox() {
        Box main = Box.createHorizontalBox();
        return main;
    }

    private Box createToolpathSelectionArea() {
        Box main = Box.createVerticalBox();
        main.setAlignmentX(0.0f);
        this.labelToolpath = new JLabel();
        this.labelToolpath.setMaximumSize(this.style.getSelectionComboboxLabelSize());
        this.labelToolpath.setPreferredSize(this.style.getSelectionComboboxLabelSize());
        main.add(this.labelToolpath);
        main.add(this.createVerticalSpacing(2));
        this.selectToolpathCombo = new WideComboBox();
        this.selectToolpathCombo.setName(this.controlNameBase + "_SelectToolpath");
        this.selectToolpathCombo.setAlignmentX(0.0f);
        this.selectToolpathCombo.setMaximumSize(this.style.getSelectionComboboxSize());
        this.selectToolpathCombo.setPreferredSize(this.style.getSelectionComboboxSize());
        this.selectToolpathCombo.setRenderer(this.toolpathSelectionRenderer);
        this.selectToolpathCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!RtcpToolpathViewHelperBase.this.toolpathComboListens) {
                    return;
                }
                Object item = RtcpToolpathViewHelperBase.this.selectToolpathCombo.getModel().getSelectedItem();
                if (item != null) {
                    RtcpToolpathViewHelperBase.this.toolpathContribution.updateSelectedToolpath(item.toString());
                    RtcpToolpathViewHelperBase.this.updateView();
                }
            }
        });
        main.add(this.selectToolpathCombo);
        return main;
    }

    private Box createFixedPcsArea() {
        Box main = Box.createHorizontalBox();
        main.setAlignmentX(0.0f);
        Box boxSelectPcsArea = this.createSelectPcsArea();
        Box boxMoveHereArea = this.createMoveHereSection();
        main.add(boxSelectPcsArea);
        main.add(Box.createHorizontalGlue());
        main.add(boxMoveHereArea);
        return main;
    }

    private Box createSelectPcsArea() {
        Box main = Box.createVerticalBox();
        main.setAlignmentX(0.0f);
        main.setBorder(this.defaultBorder);
        this.labelPcs = new JLabel();
        this.labelPcs.setMaximumSize(this.style.getSelectionComboboxLabelSize());
        this.labelPcs.setPreferredSize(this.style.getSelectionComboboxLabelSize());
        main.add(this.labelPcs);
        main.add(this.createVerticalSpacing(2));
        this.selectPcsCombo = new JComboBox();
        this.selectPcsCombo.setName(this.controlNameBase + "_SelectPcs");
        this.selectPcsCombo.setAlignmentX(0.0f);
        this.selectPcsCombo.setMaximumSize(this.style.getSelectionComboboxSize());
        this.selectPcsCombo.setPreferredSize(this.style.getSelectionComboboxSize());
        this.selectPcsCombo.setRenderer(this.pcsSelectionRenderer);
        this.selectPcsCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!RtcpToolpathViewHelperBase.this.pcsComboListens) {
                    return;
                }
                Object item = RtcpToolpathViewHelperBase.this.selectPcsCombo.getModel().getSelectedItem();
                if (item != null) {
                    RtcpToolpathViewHelperBase.this.toolpathContribution.updateSelectedPcs(item.toString());
                    RtcpToolpathViewHelperBase.this.updateView();
                }
            }
        });
        main.add(this.selectPcsCombo);
        return main;
    }

    @Override
    protected Box createMoveHereSection() {
        int buttonHeight = 40;
        int buttonWidth = 220;
        Box main = Box.createVerticalBox();
        main.setAlignmentX(0.0f);
        main.setBorder(this.defaultBorder);
        this.moveHereButton = this.createMoveHereButton(buttonHeight, buttonWidth);
        this.moveHereButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RtcpToolpathViewHelperBase.this.actionMoveHere();
            }
        });
        main.add(Box.createVerticalGlue());
        main.add(this.moveHereButton);
        return main;
    }

    protected void actionMoveHere() {
        Object[] values;
        if (!this.checkDaemon()) {
            return;
        }
        Pose poseRtcp = this.contribution.getParent().getSelectedRtcpPose();
        Pose posePcs = this.toolpathContribution.getPoseForSelectedPcs();
        Pose poseFirstPoint = null;
        Object[] tcpData = RobotRealtimeReader.getCurrentTCPData();
        if (tcpData == null) {
            JOptionPane.showMessageDialog(null, this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_WAYPOINT_ERROR_MOVEHEREFAILED), this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_WARNING_TITLE), 2);
            return;
        }
        String toolpathPath = "/programs/" + this.toolpathContribution.getSelectedToolpath();
        Object retValFirstPoint = RtcpXmlRpcClient.moveToFirstPoint(toolpathPath, posePcs, 120);
        if (retValFirstPoint != null) {
            values = (Object[])retValFirstPoint;
            if (values.length == 0) {
                this.handleMoveHereError();
                return;
            }
        } else {
            this.handleMoveHereError();
            return;
        }
        poseFirstPoint = this.makePose(values);
        Object retVal = RtcpXmlRpcClient.moveHere(poseFirstPoint, poseRtcp, (double[])tcpData[0], (double[])tcpData[1], 2);
        if (retVal != null) {
            Object[] values2 = (Object[])retVal;
            if (values2.length != 0) {
                Pose solvedPose = this.makePose(values2);
                try {
                    this.apiProvider.getUserInterfaceAPI().getUserInteraction().getRobotMovement().requestUserToMoveRobot(solvedPose, new RobotMovementCallback(){

                        public void onComplete(MovementCompleteEvent event) {
                        }

                        public void onError(MovementErrorEvent event) {
                            RtcpToolpathViewHelperBase.this.reportMovementError(event);
                        }
                    });
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                return;
            }
            this.handleMoveHereError();
        } else {
            this.handleMoveHereError();
        }
    }

    private Box createVariablePcsArea() {
        Box main = Box.createVerticalBox();
        main.setBorder(this.defaultBorder);
        this.labelVariable = new JLabel();
        main.add(this.labelVariable);
        main.add(this.createVerticalSpacing(2));
        this.selectVariableCombo = new JComboBox();
        this.selectVariableCombo.setName(this.controlNameBase + "_SelectVariable");
        this.selectVariableCombo.setAlignmentX(0.0f);
        this.selectVariableCombo.setMaximumSize(this.style.getSelectionComboboxSize());
        this.selectVariableCombo.setPreferredSize(this.style.getSelectionComboboxSize());
        this.selectVariableCombo.setRenderer(this.variableSelectionRenderer);
        this.selectVariableCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!RtcpToolpathViewHelperBase.this.variableComboListens) {
                    return;
                }
                Object item = RtcpToolpathViewHelperBase.this.selectVariableCombo.getModel().getSelectedItem();
                if (item != null) {
                    RtcpToolpathViewHelperBase.this.toolpathContribution.updateVariableNameForPcs(item.toString());
                    RtcpToolpathViewHelperBase.this.updateView();
                }
            }
        });
        main.add(this.selectVariableCombo);
        return main;
    }

    @Override
    protected Box createMotionParametersSection() {
        Box main = Box.createHorizontalBox();
        main.setAlignmentX(0.0f);
        main.setAlignmentY(0.0f);
        main.setBorder(this.defaultBorder);
        Box leftSide = Box.createVerticalBox();
        leftSide.setAlignmentX(0.0f);
        leftSide.setAlignmentY(0.0f);
        leftSide.setBorder(this.defaultBorder);
        int commonHeight = 40;
        int radioWidth = 35;
        int labelWidth = 200;
        Dimension areaSize = new Dimension(radioWidth + labelWidth, 3 * commonHeight);
        leftSide.setMinimumSize(areaSize);
        leftSide.setMaximumSize(areaSize);
        leftSide.setPreferredSize(areaSize);
        Box blendRadiusSection = this.createBlendRadiusSection();
        Box toolSpeedSection = this.createToolSpeedSection();
        if (this.usesBlendRadius) {
            leftSide.add(blendRadiusSection);
        }
        leftSide.add(Box.createVerticalGlue());
        main.add(leftSide);
        main.add(this.createHorizontalSpacing(20));
        main.add(toolSpeedSection);
        return main;
    }

    @Override
    protected Box createToolSpeedSection() {
        int commonHeight = 40;
        int radioWidth = 35;
        int labelWidth = 250;
        int editWidth = 180;
        Box main = Box.createVerticalBox();
        main.setAlignmentX(0.0f);
        main.setAlignmentY(0.0f);
        Dimension areaSize = new Dimension(radioWidth + labelWidth + editWidth, 3 * commonHeight);
        main.setMinimumSize(areaSize);
        main.setMaximumSize(areaSize);
        main.setPreferredSize(areaSize);
        main.setBorder(this.defaultBorder);
        this.feedrateRadioButton = new JRadioButton();
        this.feedrateRadioButton.setAlignmentY(0.5f);
        this.feedrateRadioButton.setName(this.controlNameBase + "_SelectFeedRate");
        this.sharedToolSpeedRadioButton = new JRadioButton();
        this.sharedToolSpeedRadioButton.setAlignmentY(0.5f);
        this.sharedToolSpeedRadioButton.setName(this.controlNameBase + "_SelectSharedToolSpeed");
        this.customToolSpeedRadioButton = new JRadioButton();
        this.customToolSpeedRadioButton.setAlignmentY(0.5f);
        this.customToolSpeedRadioButton.setName(this.controlNameBase + "_SelectCustomToolSpeed");
        this.fieldSpeed = this.createValueTextField(0);
        this.fieldSpeed.setName(this.controlNameBase + "_ToolSpeed");
        this.labelSpeedUnit = new JLabel();
        this.speedEditBlock = this.createHorizontalValueEditBlock(this.fieldSpeed, null, this.labelSpeedUnit);
        ButtonGroup group = new ButtonGroup();
        group.add(this.feedrateRadioButton);
        group.add(this.sharedToolSpeedRadioButton);
        group.add(this.customToolSpeedRadioButton);
        this.feedrateRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RtcpToolpathViewHelperBase.this.toolSpeedSelectionHandler();
            }
        });
        this.sharedToolSpeedRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RtcpToolpathViewHelperBase.this.toolSpeedSelectionHandler();
            }
        });
        this.customToolSpeedRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RtcpToolpathViewHelperBase.this.toolSpeedSelectionHandler();
            }
        });
        Box row1 = this.createSizedHorizontalBox(radioWidth + labelWidth + editWidth, commonHeight);
        row1.setAlignmentX(0.0f);
        row1.setAlignmentY(0.0f);
        Box row2 = this.createSizedHorizontalBox(radioWidth + labelWidth + editWidth, commonHeight);
        row2.setAlignmentX(0.0f);
        row2.setAlignmentY(0.0f);
        Box row3 = this.createSizedHorizontalBox(radioWidth + labelWidth + editWidth, commonHeight);
        row3.setAlignmentX(0.0f);
        row3.setAlignmentY(0.0f);
        Box row11 = this.createSizedHorizontalBox(radioWidth + labelWidth, commonHeight);
        row11.setAlignmentX(0.0f);
        row11.add(this.feedrateRadioButton);
        row1.add(row11);
        Box row21 = this.createSizedHorizontalBox(radioWidth + labelWidth, commonHeight);
        row21.setAlignmentX(0.0f);
        row21.add(this.sharedToolSpeedRadioButton);
        row2.add(row21);
        Box row31 = this.createSizedHorizontalBox(radioWidth + labelWidth, commonHeight);
        row31.setAlignmentX(0.0f);
        row31.add(this.customToolSpeedRadioButton);
        row3.add(row31);
        Box row32 = this.createSizedHorizontalBox(editWidth, commonHeight);
        row32.setAlignmentX(0.0f);
        row32.add(this.speedEditBlock);
        row3.add(row32);
        main.add(row1);
        main.add(row2);
        main.add(row3);
        return main;
    }

    private Box createToolAccelerationSection() {
        int commonHeight = 45;
        int radioWidth = 35;
        int labelWidth = 250;
        int editWidth = 180;
        Box main = Box.createVerticalBox();
        main.setAlignmentX(0.0f);
        Dimension areaSize = new Dimension(radioWidth + labelWidth + editWidth, 3 * commonHeight);
        main.setMinimumSize(areaSize);
        main.setMaximumSize(areaSize);
        main.setPreferredSize(areaSize);
        main.setBorder(this.defaultBorder);
        this.sharedToolAccelerationRadioButton = new JRadioButton();
        this.sharedToolAccelerationRadioButton.setAlignmentY(0.5f);
        this.sharedToolAccelerationRadioButton.setName(this.controlNameBase + "_SelectSharedToolAcceleration");
        this.customToolAccelerationRadioButton = new JRadioButton();
        this.customToolAccelerationRadioButton.setAlignmentY(0.5f);
        this.customToolAccelerationRadioButton.setName(this.controlNameBase + "_SelectCustomToolAcceleration");
        this.fieldAcceleration = this.createValueTextField(1);
        this.fieldAcceleration.setName(this.controlNameBase + "_ToolAcceleration");
        this.labelAccelerationUnit = new JLabel();
        this.accelerationEditBlock = this.createHorizontalValueEditBlock(this.fieldAcceleration, null, this.labelAccelerationUnit);
        ButtonGroup group = new ButtonGroup();
        group.add(this.sharedToolAccelerationRadioButton);
        group.add(this.customToolAccelerationRadioButton);
        this.sharedToolAccelerationRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RtcpToolpathViewHelperBase.this.toolAccelerationSelectionHandler();
            }
        });
        this.customToolAccelerationRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RtcpToolpathViewHelperBase.this.toolAccelerationSelectionHandler();
            }
        });
        Box row1 = this.createSizedHorizontalBox(radioWidth + labelWidth + editWidth, commonHeight);
        row1.setAlignmentX(0.0f);
        row1.setAlignmentY(0.0f);
        Box row2 = this.createSizedHorizontalBox(radioWidth + labelWidth + editWidth, commonHeight);
        row2.setAlignmentX(0.0f);
        row2.setAlignmentY(0.0f);
        Box row11 = this.createSizedHorizontalBox(radioWidth + labelWidth, commonHeight);
        row11.setAlignmentX(0.0f);
        row11.add(this.sharedToolAccelerationRadioButton);
        row1.add(row11);
        Box row21 = this.createSizedHorizontalBox(radioWidth + labelWidth, commonHeight);
        row21.setAlignmentX(0.0f);
        row21.add(this.customToolAccelerationRadioButton);
        row2.add(row21);
        Box row22 = this.createSizedHorizontalBox(editWidth, commonHeight);
        row22.setAlignmentX(0.0f);
        row22.add(this.accelerationEditBlock);
        row2.add(row22);
        main.add(row1);
        main.add(row2);
        return main;
    }

    protected void toolSpeedSelectionHandler() {
        RtcpToolpathContributionBase.ToolSpeedSelection selection = RtcpToolpathContributionBase.ToolSpeedSelection.SHARED;
        if (this.feedrateRadioButton.isSelected()) {
            selection = RtcpToolpathContributionBase.ToolSpeedSelection.FEEDRATE;
        } else if (this.sharedToolSpeedRadioButton.isSelected()) {
            selection = RtcpToolpathContributionBase.ToolSpeedSelection.SHARED;
        } else if (this.customToolSpeedRadioButton.isSelected()) {
            selection = RtcpToolpathContributionBase.ToolSpeedSelection.CUSTOM;
        }
        this.toolpathContribution.updateToolSpeedSelection(selection);
        this.updateToolParametersView();
    }

    protected void toolAccelerationSelectionHandler() {
        RtcpToolpathContributionBase.ToolAccelerationSelection selection = RtcpToolpathContributionBase.ToolAccelerationSelection.SHARED;
        if (this.sharedToolAccelerationRadioButton.isSelected()) {
            selection = RtcpToolpathContributionBase.ToolAccelerationSelection.SHARED;
        } else if (this.customToolAccelerationRadioButton.isSelected()) {
            selection = RtcpToolpathContributionBase.ToolAccelerationSelection.CUSTOM;
        }
        this.toolpathContribution.updateToolAccelerationSelection(selection);
        this.updateToolParametersView();
    }

    private void updateToolSpeedFields(RtcpToolpathContributionBase.ToolSpeedSelection selection) {
        double toolSpeed = 0.0;
        if (selection == RtcpToolpathContributionBase.ToolSpeedSelection.FEEDRATE) {
            this.fieldSpeed.setText("N/A");
            return;
        }
        toolSpeed = this.contribution.getToolSpeed();
        double dispSpeed = this.contribution.getLocalizationInfo().getConvertedLengthForDisplay(toolSpeed);
        this.fieldSpeed.setText(this.formatters[0].format(dispSpeed));
    }

    private void updateToolAccelerationFields(RtcpToolpathContributionBase.ToolAccelerationSelection selection) {
        double toolAcceleration = 0.0;
        toolAcceleration = this.contribution.getToolAcceleration();
        double dispAcceleration = this.contribution.getLocalizationInfo().getConvertedLengthForDisplay(toolAcceleration);
        this.fieldAcceleration.setText(this.formatters[1].format(dispAcceleration));
    }

    @Override
    protected Box createBottomSection() {
        Box main = Box.createHorizontalBox();
        main.setAlignmentX(0.0f);
        main.setBorder(this.defaultBorder);
        int commonHeight = 40;
        int radioWidth = 35;
        int labelWidth = 200;
        Dimension areaSize = new Dimension(radioWidth + labelWidth, 3 * commonHeight);
        Box addNodesSection = this.makeAddNodeButtons();
        addNodesSection.setMinimumSize(areaSize);
        addNodesSection.setMaximumSize(areaSize);
        addNodesSection.setPreferredSize(areaSize);
        Box toolAccelerationSection = this.createToolAccelerationSection();
        main.add(addNodesSection);
        main.add(this.createHorizontalSpacing(20));
        main.add(toolAccelerationSection);
        main.add(this.createHorizontalSpacing(50));
        return main;
    }

    public void updateToolpathList() {
        Border border;
        Object[] toolPaths = this.toolpathContribution.getToolpathFiles();
        Arrays.sort(toolPaths);
        this.toolpathComboListens = false;
        this.selectToolpathCombo.removeAllItems();
        this.toolpathSelectionRenderer.setMissingItem("");
        String selectedToolpath = this.toolpathContribution.getSelectedToolpath();
        String defaultToolpath = this.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_TOOLPATH_SELECT_DEFAULT);
        if (selectedToolpath.equals(defaultToolpath) || !selectedToolpath.equals(defaultToolpath) && !Arrays.asList(toolPaths).contains(selectedToolpath)) {
            this.toolpathSelectionRenderer.setMissingItem(selectedToolpath);
            this.selectToolpathCombo.addItem(selectedToolpath);
            border = BorderFactory.createLineBorder(this.style.getGoldYellow2(), 2);
            this.selectToolpathCombo.setBorder(border);
        } else {
            border = BorderFactory.createLineBorder(this.style.getBorderColor(), 1);
            this.selectToolpathCombo.setBorder(border);
        }
        if (toolPaths != null) {
            for (Object toolpath : toolPaths) {
                this.selectToolpathCombo.addItem(toolpath);
            }
        }
        this.selectToolpathCombo.getModel().setSelectedItem(this.toolpathContribution.getSelectedToolpath());
        this.toolpathComboListens = true;
    }

    public void updatePcsList() {
        Border border;
        String[] pcsList = this.toolpathContribution.getPcsList();
        this.pcsComboListens = false;
        this.selectPcsCombo.removeAllItems();
        this.pcsSelectionRenderer.setMissingItem("");
        String selectedPcs = this.toolpathContribution.getSelectedPcs();
        String defaultPcs = this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_TOOLPATH_SELECTED_PCS_DEFAULT);
        if (!selectedPcs.equals(defaultPcs) && !Arrays.asList(pcsList).contains(selectedPcs)) {
            this.pcsSelectionRenderer.setMissingItem(selectedPcs);
            this.selectPcsCombo.addItem(selectedPcs);
            border = BorderFactory.createLineBorder(this.style.getGoldYellow2(), 2);
            this.selectPcsCombo.setBorder(border);
        } else {
            border = BorderFactory.createLineBorder(this.style.getBorderColor(), 1);
            this.selectPcsCombo.setBorder(border);
        }
        this.selectPcsCombo.addItem(defaultPcs);
        if (pcsList != null) {
            for (String pcs : pcsList) {
                this.selectPcsCombo.addItem(pcs);
            }
        }
        this.selectPcsCombo.getModel().setSelectedItem(this.toolpathContribution.getSelectedPcs());
        this.pcsComboListens = true;
    }

    @Override
    public void setApiProvider(ProgramAPIProvider apiProvider) {
        super.setApiProvider(apiProvider);
    }

    @Override
    public void setContribution(RtcpWaypointNode contribution) {
        super.setContribution(contribution);
        this.toolpathContribution = (RtcpToolpathContributionBase)contribution;
    }
}

