/*
 * Decompiled with CFR 0.152.
 */
package com.energid.urcap.remotetcp.impl.WaypointNodes;

import com.energid.urcap.remotetcp.impl.Common.RtcpConstants;
import com.energid.urcap.remotetcp.impl.Common.RtcpMotionParameters;
import com.energid.urcap.remotetcp.impl.Interfaces.LocalizationInfo;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpMoveNode;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpProgramInfo;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpWaypointNode;
import com.energid.urcap.remotetcp.impl.RemoteTcpInstallationNodeContribution;
import com.energid.urcap.remotetcp.impl.WaypointNodes.RtcpWaypointViewHelper;
import com.ur.urcap.api.contribution.program.ProgramAPIProvider;
import com.ur.urcap.api.domain.ProgramAPI;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.undoredo.UndoRedoManager;
import com.ur.urcap.api.domain.undoredo.UndoableChanges;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.jointposition.JointPosition;
import com.ur.urcap.api.domain.value.jointposition.JointPositions;
import com.ur.urcap.api.domain.value.simple.Angle;
import java.util.LinkedHashMap;

public class RtcpWaypointContributionBase
implements RtcpWaypointNode {
    protected ProgramAPI programApi;
    protected ProgramAPIProvider apiProvider;
    protected UndoRedoManager undoRedoManager;
    protected RtcpWaypointViewHelper viewHelper;
    protected DataModel model;
    protected RtcpMoveNode parentMove = null;
    protected String waypointName;
    protected String scriptId;
    protected boolean isExecuting = false;

    @Override
    public void setWaypointPose(final Pose pose, final JointPositions jointPositions) {
        this.undoRedoManager.recordChanges(new UndoableChanges(){

            public void executeChanges() {
                RtcpWaypointContributionBase.this.model.remove("WAYPOINT_JOINTS");
                RtcpWaypointContributionBase.this.model.remove("WAYPOINT_RTCPPOSE");
                RtcpWaypointContributionBase.this.model.set("WAYPOINT_JOINTS", jointPositions);
                RtcpWaypointContributionBase.this.model.set("WAYPOINT_RTCPPOSE", pose);
            }
        });
    }

    @Override
    public RtcpWaypointNode.WaypointType getWaypointType() {
        return RtcpWaypointNode.WaypointType.Unknown;
    }

    @Override
    public boolean isUsingSharedBlendRadius() {
        return this.model.get("SHARING_BLENDRADIUS", true);
    }

    @Override
    public void setUsingSharedBlendRadius(final boolean isShared) {
        this.undoRedoManager.recordChanges(new UndoableChanges(){

            public void executeChanges() {
                RtcpWaypointContributionBase.this.model.remove("SHARING_BLENDRADIUS");
                RtcpWaypointContributionBase.this.model.set("SHARING_BLENDRADIUS", isShared);
            }
        });
    }

    @Override
    public boolean isUsingSharedToolParameters() {
        return this.model.get("SHARING_PARAMS", true);
    }

    @Override
    public void setUsingSharedToolParameters(final boolean isShared) {
        this.undoRedoManager.recordChanges(new UndoableChanges(){

            public void executeChanges() {
                RtcpWaypointContributionBase.this.model.remove("SHARING_PARAMS");
                RtcpWaypointContributionBase.this.model.set("SHARING_PARAMS", isShared);
            }
        });
    }

    @Override
    public double getBlendRadius() {
        if (this.isUsingSharedBlendRadius()) {
            return this.parentMove.getBlendRadius();
        }
        return this.model.get("WAYPOINT_BLENDRADIUS", 25.0);
    }

    @Override
    public double getToolSpeed() {
        if (this.isUsingSharedToolParameters()) {
            return this.parentMove.getToolSpeed();
        }
        return this.model.get("WAYPOINT_TOOLSPEED", 100.0);
    }

    @Override
    public double getToolAcceleration() {
        if (this.isUsingSharedToolParameters()) {
            return this.parentMove.getToolAcceleration();
        }
        return this.model.get("WAYPOINT_TOOLACC", 1000.0);
    }

    @Override
    public void setBlendRadius(final double blendRadius) {
        this.undoRedoManager.recordChanges(new UndoableChanges(){

            public void executeChanges() {
                RtcpWaypointContributionBase.this.model.remove("WAYPOINT_BLENDRADIUS");
                RtcpWaypointContributionBase.this.model.set("WAYPOINT_BLENDRADIUS", blendRadius);
            }
        });
    }

    @Override
    public void setToolSpeed(final double toolSpeed) {
        this.undoRedoManager.recordChanges(new UndoableChanges(){

            public void executeChanges() {
                RtcpWaypointContributionBase.this.model.remove("WAYPOINT_TOOLSPEED");
                RtcpWaypointContributionBase.this.model.set("WAYPOINT_TOOLSPEED", toolSpeed);
            }
        });
    }

    @Override
    public void setToolAcceleration(final double toolAcceleration) {
        this.undoRedoManager.recordChanges(new UndoableChanges(){

            public void executeChanges() {
                RtcpWaypointContributionBase.this.model.remove("WAYPOINT_TOOLACC");
                RtcpWaypointContributionBase.this.model.set("WAYPOINT_TOOLACC", toolAcceleration);
            }
        });
    }

    @Override
    public String getWaypointName() {
        return this.waypointName;
    }

    @Override
    public void setWaypointName(final String name) {
        this.waypointName = name;
        this.undoRedoManager.recordChanges(new UndoableChanges(){

            public void executeChanges() {
                RtcpWaypointContributionBase.this.model.remove("WAYPOINT_NAME");
                RtcpWaypointContributionBase.this.model.set("WAYPOINT_NAME", name);
            }
        });
    }

    @Override
    public void setParent(RtcpMoveNode moveNode) {
        this.parentMove = moveNode;
    }

    @Override
    public RtcpMoveNode getParent() {
        return this.parentMove;
    }

    @Override
    public JointPositions getJointPositions() {
        JointPositions joints = this.model.get("WAYPOINT_JOINTS", (JointPositions)null);
        return joints;
    }

    public void checkParent() {
        if (this.parentMove == null) {
            RtcpProgramInfo programInfo = (RtcpProgramInfo)this.programApi.getInstallationNode(RemoteTcpInstallationNodeContribution.class);
            programInfo.addRtcpWaypointNode(this);
        }
    }

    @Override
    public void writeScriptForMoveNode(ScriptWriter writer, String waypointId, int order, RtcpMotionParameters params) {
    }

    @Override
    public Pose getCalculatedPose() {
        return this.model.get("WAYPOINT_RTCPPOSE", (Pose)null);
    }

    public static String getJointPositionAngles(JointPositions jointPositions, Angle.Unit unit) {
        JointPosition[] jps = jointPositions.getAllJointPositions();
        String positions = "[" + jps[0].getAngle(unit) + ", " + jps[1].getAngle(unit) + ", " + jps[2].getAngle(unit) + ", " + jps[3].getAngle(unit) + ", " + jps[4].getAngle(unit) + ", " + jps[5].getAngle(unit) + "]";
        return positions;
    }

    public static String makeWaypointName(String namePrefix, LinkedHashMap<String, RtcpWaypointNode> waypoints) {
        int index = 1;
        String newName;
        while (waypoints.containsKey(newName = namePrefix + "_" + index)) {
            ++index;
        }
        return newName;
    }

    public String getLocalizedText(RtcpConstants.Strings string) {
        return this.getParent().getLocalizationInfo().getLocalizedText(string);
    }

    @Override
    public LocalizationInfo getLocalizationInfo() {
        LocalizationInfo localizationInfo = (LocalizationInfo)this.apiProvider.getProgramAPI().getInstallationNode(RemoteTcpInstallationNodeContribution.class);
        return localizationInfo;
    }

    @Override
    public String getErrorMessage() {
        return "";
    }
}

