/*
 * Decompiled with CFR 0.152.
 */
package com.energid.urcap.remotetcp.impl.WaypointNodes;

import com.energid.urcap.remotetcp.impl.Common.RobotRealtimeReader;
import com.energid.urcap.remotetcp.impl.Common.RtcpConstants;
import com.energid.urcap.remotetcp.impl.Common.RtcpUtils;
import com.energid.urcap.remotetcp.impl.Common.RtcpViewHelperBase;
import com.energid.urcap.remotetcp.impl.Common.RtcpXmlRpcClient;
import com.energid.urcap.remotetcp.impl.Common.Style;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpDaemonControl;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpProgramInfo;
import com.energid.urcap.remotetcp.impl.Interfaces.RtcpWaypointNode;
import com.energid.urcap.remotetcp.impl.RemoteTcpInstallationNodeContribution;
import com.energid.urcap.remotetcp.impl.WaypointNodes.RtcpToolpathProgramNodeService;
import com.ur.urcap.api.contribution.DaemonContribution;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.contribution.URCapProgramNodeService;
import com.ur.urcap.api.domain.program.structure.TreeNode;
import com.ur.urcap.api.domain.userinteraction.RobotPositionCallback;
import com.ur.urcap.api.domain.userinteraction.inputvalidation.InputValidator;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardInputCallback;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardTextInput;
import com.ur.urcap.api.domain.userinteraction.robot.movement.MovementCompleteEvent;
import com.ur.urcap.api.domain.userinteraction.robot.movement.MovementErrorEvent;
import com.ur.urcap.api.domain.userinteraction.robot.movement.RobotMovementCallback;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.jointposition.JointPositions;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class RtcpWaypointViewHelper
extends RtcpViewHelperBase {
    protected RtcpWaypointNode contribution;
    protected JButton nameEditButton;
    protected JLabel nameLabel;
    protected JButton moveHereButton;
    protected JTextField fieldBlend;
    protected JTextField fieldSpeed;
    protected JTextField fieldAcceleration;
    protected Component blendEditBlock;
    protected Component speedEditBlock;
    protected Component accelerationEditBlock;
    protected JRadioButton sharedBlendRadiusRadioButton;
    protected JRadioButton customBlendRadiusRadioButton;
    protected JRadioButton sharedToolParamsRadioButton;
    protected JRadioButton customToolParamsRadioButton;
    protected JLabel toolAcceleration;
    protected JButton setButton;
    protected JButton waypointButton;
    protected JButton circleMoveButton;
    protected JButton toolpathButton;
    protected boolean canAddWaypoint = true;
    protected boolean canAddCircleMove = true;
    protected boolean canAddToolpath = true;
    protected Class<? extends URCapProgramNodeService> toolpathService;
    protected JLabel labelRadiusUnit;
    protected JLabel labelSpeedUnit;
    protected JLabel labelAccelerationUnit;
    protected final DecimalFormat format_2 = new DecimalFormat("#0.##");
    protected final DecimalFormat format_1 = new DecimalFormat("#0.#");
    protected JointPositions jointPositions = null;
    protected Pose calculatedPose = null;
    protected JLabel messageLabel;
    protected int bottomSectionVSpacing = 50;
    protected int lowerSectionVSpacing = 15;
    protected int poseSectionVSpacing = 20;
    protected int messageSectionVSpacing = 10;
    protected HashMap<MovementErrorEvent.ErrorType, RtcpConstants.Strings> movementErrors;
    protected boolean isUsingMotionParams = true;
    protected boolean canAddNodes = false;
    protected final int ee_id = 0;
    protected final String buffer_mode = "";

    public RtcpWaypointViewHelper(JPanel container, Style style) {
        this.style = style;
        this.container = container;
        this.formatters = new DecimalFormat[]{this.format_1, this.format_1, this.format_2};
        this.textFieldWidth = 80;
        this.valueBlockAlignmentY = 0.5f;
        this.editFieldAlignmentY = 0.5f;
        this.borderThickness = 0;
        this.defaultBorder = BorderFactory.createLineBorder(Color.BLACK, this.borderThickness);
        this.toolpathService = RtcpToolpathProgramNodeService.class;
        this.movementErrors = new HashMap<MovementErrorEvent.ErrorType, RtcpConstants.Strings>(){
            {
                this.put(MovementErrorEvent.ErrorType.UNKNOWN, RtcpConstants.Strings.RTCP_WAYPOINT_MOVEHERE_ERROR_UNKNOWN);
                this.put(MovementErrorEvent.ErrorType.UNREACHABLE_POSE, RtcpConstants.Strings.RTCP_WAYPOINT_MOVEHERE_ERROR_UNREACHABLEPOSE);
                this.put(MovementErrorEvent.ErrorType.INVALID_JOINT_POSITIONS, RtcpConstants.Strings.RTCP_WAYPOINT_MOVEHERE_ERROR_INVALIDJOINTPOSITIONS);
            }
        };
    }

    public void buildMainPanel() {
        this.container.setLayout(new BoxLayout(this.container, 1));
        Box upperSection = this.createUpperSection();
        Box parametersSection = this.createMotionParametersSection();
        Box bottomSection = this.createBottomSection();
        this.container.add(upperSection);
        if (this.isUsingMotionParams()) {
            this.container.add(this.createVerticalSpacing(this.lowerSectionVSpacing));
            this.container.add(parametersSection);
        }
        if (this.getCanAddNodes()) {
            this.container.add(this.createVerticalSpacing(this.bottomSectionVSpacing));
            this.container.add(bottomSection);
        }
        Box messagesSection = Box.createHorizontalBox();
        messagesSection.setAlignmentX(0.0f);
        messagesSection.setBorder(this.defaultBorder);
        messagesSection.add(this.createsMessageArea());
        this.container.add(this.createVerticalSpacing(this.messageSectionVSpacing));
        this.container.add(messagesSection);
        this.container.add(Box.createVerticalGlue());
    }

    protected Box createUpperSection() {
        Box main = Box.createHorizontalBox();
        main.setAlignmentX(0.0f);
        main.setAlignmentY(0.0f);
        main.setMaximumSize(new Dimension(700, 140));
        main.setBorder(this.defaultBorder);
        Box setPoseSection = this.createSetPoseSection();
        Box moveHereSection = this.createMoveHereSection();
        main.add(setPoseSection);
        main.add(moveHereSection);
        return main;
    }

    protected Box createSetPoseSection() {
        int areaWidth = 300;
        int buttonWidth = 250;
        int buttonHeight = 40;
        Dimension nameAreaSize = new Dimension(areaWidth, buttonHeight);
        Dimension setButtonSize = new Dimension(buttonWidth, buttonHeight);
        Box main = Box.createVerticalBox();
        main.setAlignmentX(0.0f);
        main.setBorder(this.defaultBorder);
        Box nameArea = this.makeNameArea(nameAreaSize);
        main.add(nameArea);
        this.setButton = this.makeSetWaypointButton(setButtonSize);
        main.add(this.createVerticalSpacing(20));
        main.add(this.createHorizontalSpacing(40));
        main.add(this.setButton);
        main.add(Box.createHorizontalGlue());
        return main;
    }

    public JButton makeSetWaypointButton(Dimension setButtonSize) {
        JButton setButton = new JButton();
        setButton.setName(this.controlNameBase + "_SetWaypoint");
        setButton.setAlignmentX(0.0f);
        setButton.setMinimumSize(setButtonSize);
        setButton.setMaximumSize(setButtonSize);
        setButton.setPreferredSize(setButtonSize);
        setButton.setBackground(this.style.getURBlue());
        setButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RtcpDaemonControl daemonControl = (RtcpDaemonControl)RtcpWaypointViewHelper.this.apiProvider.getProgramAPI().getInstallationNode(RemoteTcpInstallationNodeContribution.class);
                if (daemonControl.getDaemonState() != DaemonContribution.State.RUNNING || !daemonControl.isServerReachable()) {
                    JOptionPane.showMessageDialog(null, RtcpUtils.encloseWithHtml(RtcpWaypointViewHelper.this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_WAYPOINT_ERROR_DAEMONSTOPPED)), RtcpWaypointViewHelper.this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_WARNING_TITLE), 2);
                    return;
                }
                if (!RtcpWaypointViewHelper.this.contribution.getParent().isSelectedRtcpValid()) {
                    JOptionPane.showMessageDialog(null, RtcpUtils.encloseWithHtml(RtcpWaypointViewHelper.this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_MOVEP_ERROR_RTCPMISSING)), RtcpWaypointViewHelper.this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_WARNING_TITLE), 2);
                    return;
                }
                RtcpWaypointViewHelper.this.apiProvider.getUserInterfaceAPI().getUserInteraction().getUserDefinedRobotPosition(new RobotPositionCallback(){

                    public void onOk(Pose notUsed, JointPositions q) {
                        RtcpWaypointViewHelper.this.jointPositions = q;
                        int ee_set_id = RtcpWaypointViewHelper.this.contribution.getParent().getSelectedEndEffectorIndex();
                        Pose poseRtcp = RtcpWaypointViewHelper.this.contribution.getParent().getSelectedRtcpPose();
                        try {
                            Pose calculatedPose = RtcpWaypointViewHelper.this.calculateRtcpPose(ee_set_id, poseRtcp, RtcpWaypointViewHelper.this.jointPositions);
                            RtcpWaypointViewHelper.this.setCalculatedPose(calculatedPose);
                            RtcpWaypointViewHelper.this.moveHereButton.setEnabled(RtcpWaypointViewHelper.this.canEnableMoveHere());
                            RtcpWaypointViewHelper.this.contribution.setWaypointPose(calculatedPose, RtcpWaypointViewHelper.this.jointPositions);
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(null, RtcpUtils.encloseWithHtml(RtcpWaypointViewHelper.this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_WAYPOINT_ERROR_DAEMONSTOPPED)), RtcpWaypointViewHelper.this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_WARNING_TITLE), 2);
                        }
                    }
                });
            }
        });
        return setButton;
    }

    protected boolean canEnableMoveHere() {
        boolean canMove = this.jointPositions != null && this.contribution.getParent().isSelectedRtcpValid();
        return canMove;
    }

    public Box makeNameArea(Dimension areaSize) {
        Box nameArea = Box.createHorizontalBox();
        nameArea.setAlignmentX(0.0f);
        nameArea.setBorder(this.defaultBorder);
        nameArea.setMinimumSize(areaSize);
        nameArea.setMaximumSize(areaSize);
        nameArea.setPreferredSize(areaSize);
        this.nameEditButton = new JButton();
        this.nameEditButton.setIcon(RtcpWaypointViewHelper.getIconResource("edit_icon.png"));
        this.nameEditButton.setName(this.controlNameBase + "_EditName");
        this.nameEditButton.setAlignmentX(0.0f);
        this.nameEditButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RtcpWaypointViewHelper.this.waypointNameButtonHandler();
            }
        });
        nameArea.add(this.nameEditButton);
        this.nameLabel = new JLabel();
        this.nameLabel.setName(this.controlNameBase + "_Name");
        this.nameLabel.setAlignmentX(0.0f);
        nameArea.add(this.createHorizontalSpacing(10));
        nameArea.add(this.nameLabel);
        return nameArea;
    }

    protected Box createMoveHereSection() {
        int buttonHeight = 40;
        int buttonWidth = 200;
        int buttonOffset = 60;
        Box main = Box.createVerticalBox();
        main.setAlignmentX(0.0f);
        main.setBorder(this.defaultBorder);
        this.moveHereButton = this.createMoveHereButton(buttonHeight, buttonWidth);
        this.moveHereButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!RtcpWaypointViewHelper.this.checkDaemon()) {
                    return;
                }
                Pose poseRtcp = RtcpWaypointViewHelper.this.contribution.getParent().getSelectedRtcpPose();
                Pose poseWaypoint = RtcpWaypointViewHelper.this.getCalculatedPose();
                Object[] tcpData = RobotRealtimeReader.getCurrentTCPData();
                if (tcpData == null) {
                    JOptionPane.showMessageDialog(null, RtcpWaypointViewHelper.this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_WAYPOINT_ERROR_MOVEHEREFAILED), RtcpWaypointViewHelper.this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_WARNING_TITLE), 2);
                    return;
                }
                Object retVal = RtcpXmlRpcClient.moveHere(poseWaypoint, poseRtcp, (double[])tcpData[0], (double[])tcpData[1], 2);
                if (retVal != null) {
                    Object[] values = (Object[])retVal;
                    if (values.length != 0) {
                        Pose solvedPose = RtcpWaypointViewHelper.this.makePose(values);
                        try {
                            RtcpWaypointViewHelper.this.apiProvider.getUserInterfaceAPI().getUserInteraction().getRobotMovement().requestUserToMoveRobot(solvedPose, new RobotMovementCallback(){

                                public void onComplete(MovementCompleteEvent event) {
                                }

                                public void onError(MovementErrorEvent event) {
                                    RtcpWaypointViewHelper.this.reportMovementError(event);
                                }
                            });
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                        return;
                    }
                    RtcpWaypointViewHelper.this.handleMoveHereError();
                } else {
                    RtcpWaypointViewHelper.this.handleMoveHereError();
                }
            }
        });
        main.add(this.createVerticalSpacing(buttonOffset));
        main.add(this.moveHereButton);
        main.add(Box.createHorizontalGlue());
        return main;
    }

    protected void handleMoveHereError() {
        String errorMsg = RtcpXmlRpcClient.getLastError();
        System.out.println("Error message from XMLRPC: " + errorMsg);
        if (errorMsg.equals("Timed out")) {
            JOptionPane.showMessageDialog(null, this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_WAYPOINT_ERROR_MOVEHERETIMEDOUT), this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_WARNING_TITLE), 2);
        } else {
            JOptionPane.showMessageDialog(null, this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_WAYPOINT_ERROR_MOVEHEREFAILED), this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_WARNING_TITLE), 2);
        }
    }

    protected boolean checkDaemon() {
        RtcpDaemonControl daemonControl = (RtcpDaemonControl)this.apiProvider.getProgramAPI().getInstallationNode(RemoteTcpInstallationNodeContribution.class);
        if (daemonControl.getDaemonState() == DaemonContribution.State.RUNNING && daemonControl.isServerReachable()) {
            return true;
        }
        JOptionPane.showMessageDialog(null, RtcpUtils.encloseWithHtml(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_WAYPOINT_ERROR_DAEMONSTOPPED)), this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_WARNING_TITLE), 2);
        return false;
    }

    protected JButton createMoveHereButton(int buttonHeight, int buttonWidth) {
        JButton button = new JButton();
        button.setName(this.controlNameBase + "_MoveHere");
        button.setAlignmentX(0.0f);
        button.setMinimumSize(new Dimension(buttonWidth, buttonHeight));
        button.setMaximumSize(new Dimension(buttonWidth, buttonHeight));
        button.setPreferredSize(new Dimension(buttonWidth, buttonHeight));
        button.setEnabled(false);
        return button;
    }

    protected Box createMotionParametersSection() {
        Box main = Box.createHorizontalBox();
        main.setAlignmentX(0.0f);
        main.setAlignmentY(0.0f);
        main.setBorder(this.defaultBorder);
        Box blendRadiusSection = this.createBlendRadiusSection();
        Box toolSpeedSection = this.createToolSpeedSection();
        main.add(blendRadiusSection);
        main.add(this.createHorizontalSpacing(20));
        main.add(toolSpeedSection);
        return main;
    }

    private Component createsMessageArea() {
        Box box = Box.createVerticalBox();
        box.setAlignmentY(0.0f);
        box.setBorder(this.defaultBorder);
        this.messageLabel = new JLabel();
        this.messageLabel.setName(this.controlNameBase + "_MessageLabel");
        this.messageLabel.setIcon(RtcpWaypointViewHelper.getIconResource("warning_icon_small.png"));
        this.messageLabel.setAlignmentY(0.0f);
        box.add(this.messageLabel);
        return box;
    }

    protected Box createBlendRadiusSection() {
        int commonHeight = 40;
        int radioWidth = 35;
        int labelWidth = 200;
        Box main = Box.createVerticalBox();
        main.setAlignmentX(0.0f);
        main.setMinimumSize(new Dimension(radioWidth + labelWidth, 3 * commonHeight));
        main.setBorder(this.defaultBorder);
        this.sharedBlendRadiusRadioButton = new JRadioButton();
        this.sharedBlendRadiusRadioButton.setAlignmentY(0.5f);
        this.sharedBlendRadiusRadioButton.setName(this.controlNameBase + "_SelectSharedRadius");
        this.customBlendRadiusRadioButton = new JRadioButton();
        this.customBlendRadiusRadioButton.setAlignmentX(0.5f);
        this.customBlendRadiusRadioButton.setName(this.controlNameBase + "_SelectCustomRadius");
        ButtonGroup group = new ButtonGroup();
        group.add(this.sharedBlendRadiusRadioButton);
        group.add(this.customBlendRadiusRadioButton);
        this.sharedBlendRadiusRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RtcpWaypointViewHelper.this.blendSelectionHandler();
            }
        });
        this.customBlendRadiusRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RtcpWaypointViewHelper.this.blendSelectionHandler();
            }
        });
        this.fieldBlend = this.createValueTextField(2);
        this.fieldBlend.setName(this.controlNameBase + "_BlendRadius");
        this.labelRadiusUnit = new JLabel();
        this.blendEditBlock = this.createHorizontalValueEditBlock(this.fieldBlend, null, this.labelRadiusUnit);
        this.sharedBlendRadiusRadioButton.setSelected(true);
        this.setBoxEnabled((Box)this.blendEditBlock, false);
        Box row1 = this.createSizedHorizontalBox(radioWidth + labelWidth, commonHeight);
        row1.setAlignmentX(0.0f);
        row1.setAlignmentY(0.0f);
        Box row2 = this.createSizedHorizontalBox(radioWidth + labelWidth, commonHeight);
        row2.setAlignmentX(0.0f);
        row2.setAlignmentY(0.0f);
        Box row3 = this.createSizedHorizontalBox(radioWidth + labelWidth, commonHeight);
        row3.setAlignmentX(0.0f);
        row3.setAlignmentY(0.0f);
        Box row11 = this.createSizedHorizontalBox(radioWidth + labelWidth, commonHeight);
        row11.setAlignmentX(0.0f);
        row11.add(this.sharedBlendRadiusRadioButton);
        row1.add(row11);
        Box row21 = this.createSizedHorizontalBox(radioWidth + labelWidth, commonHeight);
        row21.setAlignmentX(0.0f);
        row21.add(this.customBlendRadiusRadioButton);
        row2.add(row21);
        Box row31 = this.createSizedHorizontalBox(radioWidth, commonHeight);
        row31.setAlignmentX(0.0f);
        row31.add(Box.createHorizontalStrut(radioWidth));
        row3.add(row31);
        Box row32 = this.createSizedHorizontalBox(labelWidth, commonHeight);
        row32.setAlignmentX(0.0f);
        row32.add(this.blendEditBlock);
        row3.add(row32);
        main.add(row1);
        main.add(row2);
        main.add(row3);
        return main;
    }

    protected Box createToolSpeedSection() {
        int commonHeight = 40;
        int radioWidth = 35;
        int labelWidth = 250;
        int editWidth = 180;
        Box main = Box.createVerticalBox();
        main.setAlignmentX(0.0f);
        Dimension areaSize = new Dimension(radioWidth + labelWidth + editWidth, 3 * commonHeight);
        main.setMinimumSize(areaSize);
        main.setMaximumSize(areaSize);
        main.setPreferredSize(areaSize);
        main.setBorder(this.defaultBorder);
        this.sharedToolParamsRadioButton = new JRadioButton();
        this.sharedToolParamsRadioButton.setAlignmentY(0.5f);
        this.sharedToolParamsRadioButton.setName(this.controlNameBase + "_SelectSharedParams");
        this.customToolParamsRadioButton = new JRadioButton();
        this.customToolParamsRadioButton.setAlignmentY(0.5f);
        this.customToolParamsRadioButton.setName(this.controlNameBase + "_SelectCustomParams");
        this.toolAcceleration = new JLabel();
        this.toolAcceleration.setAlignmentY(0.5f);
        this.fieldSpeed = this.createValueTextField(0);
        this.fieldSpeed.setName(this.controlNameBase + "_ToolSpeed");
        this.labelSpeedUnit = new JLabel();
        this.speedEditBlock = this.createHorizontalValueEditBlock(this.fieldSpeed, null, this.labelSpeedUnit);
        this.fieldAcceleration = this.createValueTextField(1);
        this.fieldAcceleration.setName(this.controlNameBase + "_ToolAcceleration");
        this.labelAccelerationUnit = new JLabel();
        this.accelerationEditBlock = this.createHorizontalValueEditBlock(this.fieldAcceleration, null, this.labelAccelerationUnit);
        ButtonGroup group = new ButtonGroup();
        group.add(this.sharedToolParamsRadioButton);
        group.add(this.customToolParamsRadioButton);
        this.sharedToolParamsRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RtcpWaypointViewHelper.this.toolValuesSelectionHandler();
            }
        });
        this.customToolParamsRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RtcpWaypointViewHelper.this.toolValuesSelectionHandler();
            }
        });
        Box row1 = this.createSizedHorizontalBox(radioWidth + labelWidth + editWidth, commonHeight);
        row1.setAlignmentX(0.0f);
        row1.setAlignmentY(0.0f);
        Box row2 = this.createSizedHorizontalBox(radioWidth + labelWidth + editWidth, commonHeight);
        row2.setAlignmentX(0.0f);
        row2.setAlignmentY(0.0f);
        Box row3 = this.createSizedHorizontalBox(radioWidth + labelWidth + editWidth, commonHeight);
        row3.setAlignmentX(0.0f);
        row3.setAlignmentY(0.0f);
        Box row11 = this.createSizedHorizontalBox(radioWidth + labelWidth, commonHeight);
        row11.setAlignmentX(0.0f);
        row11.add(this.sharedToolParamsRadioButton);
        row1.add(row11);
        Box row21 = this.createSizedHorizontalBox(radioWidth + labelWidth, commonHeight);
        row21.setAlignmentX(0.0f);
        row21.add(this.customToolParamsRadioButton);
        row2.add(row21);
        Box row22 = this.createSizedHorizontalBox(editWidth, commonHeight);
        row22.setAlignmentX(0.0f);
        row22.add(this.speedEditBlock);
        row2.add(row22);
        Box row31 = this.createSizedHorizontalBox(radioWidth, commonHeight);
        row31.setAlignmentX(0.0f);
        row31.add(Box.createHorizontalStrut(radioWidth));
        row3.add(row31);
        Box row32 = this.createSizedHorizontalBox(labelWidth, commonHeight);
        row32.setAlignmentX(0.0f);
        row32.add(this.toolAcceleration);
        row3.add(row32);
        Box row33 = this.createSizedHorizontalBox(editWidth, commonHeight);
        row33.setAlignmentX(0.0f);
        row33.add(this.accelerationEditBlock);
        row3.add(row33);
        this.sharedToolParamsRadioButton.setSelected(true);
        this.setBoxEnabled((Box)this.speedEditBlock, true);
        this.setBoxEnabled((Box)this.accelerationEditBlock, true);
        main.add(row1);
        main.add(row2);
        main.add(row3);
        return main;
    }

    protected Box createBottomSection() {
        return this.makeAddNodeButtons();
    }

    public Box makeAddNodeButtons() {
        int boxWidth = 200;
        Box main = Box.createVerticalBox();
        main.setAlignmentX(0.0f);
        main.setBorder(this.defaultBorder);
        Icon plusIcon = RtcpWaypointViewHelper.getIconResource("plus_icon.png");
        JPanel buttonBox = new JPanel(new GridLayout(3, 1, 5, 10));
        buttonBox.setMaximumSize(new Dimension(boxWidth, 120));
        buttonBox.setPreferredSize(new Dimension(boxWidth, 120));
        buttonBox.setAlignmentX(0.0f);
        buttonBox.setAlignmentY(0.0f);
        this.waypointButton = new JButton();
        this.waypointButton.setIcon(plusIcon);
        this.waypointButton.setHorizontalAlignment(2);
        this.waypointButton.setMargin(new Insets(3, 10, 3, 10));
        this.waypointButton.setName(this.controlNameBase + "_AddWaypoint");
        this.waypointButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TreeNode thisNode = RtcpWaypointViewHelper.this.apiProvider.getProgramAPI().getProgramModel().getRootTreeNode((ProgramNodeContribution)RtcpWaypointViewHelper.this.contribution);
                RtcpWaypointViewHelper.this.contribution.getParent().insertWaypoint(thisNode);
            }
        });
        if (this.canAddWaypoint) {
            buttonBox.add(this.waypointButton);
        }
        this.circleMoveButton = new JButton();
        this.circleMoveButton.setIcon(plusIcon);
        this.circleMoveButton.setHorizontalAlignment(2);
        this.circleMoveButton.setMargin(new Insets(3, 10, 3, 10));
        this.circleMoveButton.setName(this.controlNameBase + "_AddCircleMove");
        this.circleMoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TreeNode thisNode = RtcpWaypointViewHelper.this.apiProvider.getProgramAPI().getProgramModel().getRootTreeNode((ProgramNodeContribution)RtcpWaypointViewHelper.this.contribution);
                RtcpWaypointViewHelper.this.contribution.getParent().insertCircleMove(thisNode);
            }
        });
        if (this.canAddCircleMove) {
            buttonBox.add(this.circleMoveButton);
        }
        this.toolpathButton = new JButton();
        this.toolpathButton.setIcon(plusIcon);
        this.toolpathButton.setHorizontalAlignment(2);
        this.toolpathButton.setMargin(new Insets(3, 10, 3, 10));
        this.toolpathButton.setName(this.controlNameBase + "_AddToolpath");
        this.toolpathButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TreeNode thisNode = RtcpWaypointViewHelper.this.apiProvider.getProgramAPI().getProgramModel().getRootTreeNode((ProgramNodeContribution)RtcpWaypointViewHelper.this.contribution);
                RtcpWaypointViewHelper.this.contribution.getParent().insertToolpath(thisNode, RtcpWaypointViewHelper.this.toolpathService);
            }
        });
        if (this.canAddToolpath) {
            buttonBox.add(this.toolpathButton);
        }
        Box westBox = Box.createHorizontalBox();
        westBox.setAlignmentX(0.0f);
        westBox.add(buttonBox);
        westBox.add(Box.createHorizontalGlue());
        main.add(westBox);
        return main;
    }

    protected Box createSizedHorizontalBox(int width, int height) {
        Box box = Box.createHorizontalBox();
        box.setBorder(this.defaultBorder);
        box.setMinimumSize(new Dimension(width, height));
        box.setMaximumSize(new Dimension(width, height));
        return box;
    }

    protected void waypointNameButtonHandler() {
        KeyboardTextInput keyboardInput = this.getKeyboardForStringField();
        keyboardInput.setInitialValue(this.nameLabel.getText());
        keyboardInput.setErrorValidator((InputValidator)new InputValidator<String>(){
            private String message = "";

            public boolean isValid(String value) {
                RtcpProgramInfo programInfo = (RtcpProgramInfo)RtcpWaypointViewHelper.this.apiProvider.getProgramAPI().getInstallationNode(RemoteTcpInstallationNodeContribution.class);
                String modifiedName = RtcpUtils.modifyName(value);
                RtcpConstants.Strings messageEnum = RtcpUtils.validateName(modifiedName);
                if (!messageEnum.equals((Object)RtcpConstants.Strings.RTCP_VALIDATION_NAMEISVALID)) {
                    this.message = messageEnum.equals((Object)RtcpConstants.Strings.RTCP_VALIDATION_ERROR_DEFAULT) ? "" : RtcpWaypointViewHelper.this.contribution.getLocalizationInfo().getLocalizedText(messageEnum);
                    return false;
                }
                if (programInfo.isDuplicateWaypointName(RtcpWaypointViewHelper.this.contribution, modifiedName)) {
                    this.message = RtcpWaypointViewHelper.this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_WAYPOINT_DUPLICATENAME_MESSAGE);
                    return false;
                }
                return true;
            }

            public String getMessage(String value) {
                return this.message;
            }
        });
        keyboardInput.show(this.nameEditButton, this.getKeyboardCallbackForWaypointName());
    }

    private KeyboardInputCallback<String> getKeyboardCallbackForWaypointName() {
        return new KeyboardInputCallback<String>(){

            public void onOk(String value) {
                String modifiedName = RtcpUtils.modifyName(value);
                RtcpWaypointViewHelper.this.contribution.setWaypointName(modifiedName);
                RtcpWaypointViewHelper.this.nameLabel.setText(modifiedName);
                RtcpWaypointViewHelper.this.contribution.setWaypointName(modifiedName);
            }
        };
    }

    @Override
    protected KeyboardInputCallback<Double> getKeyboardCallbackForValue(final JTextField field, final int valueIndex) {
        return new KeyboardInputCallback<Double>(){

            public void onOk(Double value) {
                field.setText(RtcpWaypointViewHelper.this.formatters[valueIndex].format(value));
                double metricVal = RtcpWaypointViewHelper.this.contribution.getLocalizationInfo().getConvertedLengthForStorage(value);
                RtcpWaypointViewHelper.this.updateMotionValue(valueIndex, metricVal);
            }
        };
    }

    protected void updateMotionValue(int motionValueIndex, double motionValue) {
        switch (motionValueIndex) {
            case 0: {
                this.contribution.setToolSpeed(motionValue);
                break;
            }
            case 1: {
                this.contribution.setToolAcceleration(motionValue);
                break;
            }
            case 2: {
                this.contribution.setBlendRadius(motionValue);
                break;
            }
        }
    }

    public void setContribution(RtcpWaypointNode contribution) {
        this.contribution = contribution;
    }

    public void updateView() {
        this.setJointPositions(this.contribution.getJointPositions());
        this.setCalculatedPose(this.contribution.getCalculatedPose());
        this.nameLabel.setText(this.contribution.getWaypointName());
        this.updateText();
        boolean sharingBlendRadius = this.contribution.isUsingSharedBlendRadius();
        this.sharedBlendRadiusRadioButton.setSelected(sharingBlendRadius);
        this.customBlendRadiusRadioButton.setSelected(!sharingBlendRadius);
        this.setBoxEnabled((Box)this.blendEditBlock, !sharingBlendRadius);
        this.updateBlendRadiusField(sharingBlendRadius);
        boolean sharingToolValues = this.contribution.isUsingSharedToolParameters();
        this.sharedToolParamsRadioButton.setSelected(sharingToolValues);
        this.customToolParamsRadioButton.setSelected(!sharingToolValues);
        this.setBoxEnabled((Box)this.speedEditBlock, !sharingToolValues);
        this.setBoxEnabled((Box)this.accelerationEditBlock, !sharingToolValues);
        this.updateToolParametersFields(sharingToolValues);
        if (this.moveHereButton != null) {
            this.moveHereButton.setEnabled(this.canEnableMoveHere());
        }
        this.showValidationWarning();
    }

    private void updateText() {
        this.moveHereButton.setText(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_WAYPOINT_MOVEHERE));
        this.sharedBlendRadiusRadioButton.setText(RtcpUtils.encloseWithHtml(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_WAYPOINT_USESHARED_BLENDRADIUS)));
        this.customBlendRadiusRadioButton.setText(RtcpUtils.encloseWithHtml(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_BLENDRADIUS)));
        this.sharedToolParamsRadioButton.setText(RtcpUtils.encloseWithHtml(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_WAYPOINT_USESHARED_TOOLPARAMS)));
        this.customToolParamsRadioButton.setText(RtcpUtils.encloseWithHtml(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_TOOLSPEED)));
        this.setButton.setText(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_WAYPOINT_SET));
        this.waypointButton.setText(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_WAYPOINT));
        this.circleMoveButton.setText(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_CIRCLEMOVE));
        this.toolpathButton.setText(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_TOOLPATH));
        this.toolAcceleration.setText(this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_TOOLACCELERATION));
        this.labelSpeedUnit.setText(this.contribution.getLocalizationInfo().getLocalizedSpeedUnit());
        this.labelAccelerationUnit.setText(RtcpUtils.encloseWithHtml(this.contribution.getLocalizationInfo().getLocalizedAccelerationUnit()));
        this.labelRadiusUnit.setText(this.contribution.getLocalizationInfo().getLocalizedLengthUnit());
    }

    public JointPositions getJointPositions() {
        return this.jointPositions;
    }

    public void setJointPositions(JointPositions jointPositions) {
        this.jointPositions = jointPositions;
    }

    private void blendSelectionHandler() {
        boolean sharingBlendRadius = this.sharedBlendRadiusRadioButton.isSelected();
        this.setBoxEnabled((Box)this.blendEditBlock, !sharingBlendRadius);
        this.contribution.setUsingSharedBlendRadius(sharingBlendRadius);
        this.updateBlendRadiusField(sharingBlendRadius);
    }

    protected void toolValuesSelectionHandler() {
        boolean sharingToolValues = this.sharedToolParamsRadioButton.isSelected();
        this.setBoxEnabled((Box)this.speedEditBlock, !sharingToolValues);
        this.setBoxEnabled((Box)this.accelerationEditBlock, !sharingToolValues);
        this.contribution.setUsingSharedToolParameters(sharingToolValues);
        this.updateToolParametersFields(sharingToolValues);
    }

    private void updateToolParametersFields(boolean sharingToolValues) {
        double toolSpeed = 0.0;
        double toolAcceleration = 0.0;
        if (sharingToolValues) {
            toolSpeed = this.contribution.getParent().getToolSpeed();
            toolAcceleration = this.contribution.getParent().getToolAcceleration();
        } else {
            toolSpeed = this.contribution.getToolSpeed();
            toolAcceleration = this.contribution.getToolAcceleration();
        }
        double dispSpeed = this.contribution.getLocalizationInfo().getConvertedLengthForDisplay(toolSpeed);
        double dispAcceleration = this.contribution.getLocalizationInfo().getConvertedLengthForDisplay(toolAcceleration);
        this.fieldSpeed.setText(this.formatters[0].format(dispSpeed));
        this.fieldAcceleration.setText(this.formatters[1].format(dispAcceleration));
    }

    protected void updateBlendRadiusField(boolean sharingBlendRadius) {
        double blendRadius = 0.0;
        blendRadius = sharingBlendRadius ? this.contribution.getParent().getBlendRadius() : this.contribution.getBlendRadius();
        double dispRadius = this.contribution.getLocalizationInfo().getConvertedLengthForDisplay(blendRadius);
        this.fieldBlend.setText(this.formatters[2].format(dispRadius));
    }

    public Pose getCalculatedPose() {
        return this.calculatedPose;
    }

    public void setCalculatedPose(Pose pose) {
        this.calculatedPose = pose;
    }

    public boolean isUsingMotionParams() {
        return this.isUsingMotionParams;
    }

    public void setUsingMotionParams(boolean isUsingMotionParams) {
        this.isUsingMotionParams = isUsingMotionParams;
    }

    private boolean getCanAddNodes() {
        return this.canAddNodes;
    }

    public void setCanAddNodes(boolean canAddNodes) {
        this.canAddNodes = canAddNodes;
    }

    protected void showValidationWarning() {
        String message = this.contribution.getErrorMessage();
        this.messageLabel.setVisible(false);
        if (!message.isEmpty()) {
            if (message.startsWith("<html>")) {
                this.messageLabel.setText(message);
            } else {
                this.messageLabel.setText("<html>" + message + "</html>");
            }
            this.messageLabel.setVisible(true);
        }
    }

    protected void reportMovementError(MovementErrorEvent event) {
        MovementErrorEvent.ErrorType errorType = event.getErrorType();
        JOptionPane.showMessageDialog(null, RtcpUtils.encloseWithHtml(this.contribution.getLocalizationInfo().getLocalizedText(this.movementErrors.get(errorType))), this.contribution.getLocalizationInfo().getLocalizedText(RtcpConstants.Strings.RTCP_COMMON_WARNING_TITLE), 2);
    }
}

