/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.io.impl.tool;

import com.ur.lang.EnumUtils;
import com.ur.polyscope.io.AnalogDomain;
import com.ur.polyscope.io.impl.tool.InstallationLoaded;
import com.ur.polyscope.io.impl.tool.MonitorInstallationLoad;
import com.ur.polyscope.io.impl.tool.RxIdleCharsValidators;
import com.ur.polyscope.io.impl.tool.ToolCommInfoView;
import com.ur.polyscope.io.impl.tool.ToolIOService;
import com.ur.polyscope.io.impl.tool.TxIdleCharsValidators;
import com.ur.polyscope.io.internal.EnumsResource;
import com.ur.polyscope.io.tool.InternalToolIOService;
import com.ur.polyscope.io.tool.ToolAnalogInputViewModel;
import com.ur.polyscope.io.tool.ToolCommInfo;
import com.ur.polyscope.io.tool.ToolIOSettings;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.view.constants.toolcomm.BaudRate;
import com.ur.view.constants.toolcomm.Parity;
import com.ur.view.constants.toolcomm.StopBits;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;

public class ToolCommInfoPresenter
implements InstallationLoaded {
    public static final int PIN_0 = 2;
    public static final int PIN_1 = 3;
    private ToolCommInfoView view;
    private final Provider<ToolIOSettings> toolIOSettingsProvider;
    private InternalToolIOService ioService;
    private final EnumsResource enumsResource;
    private final MonitorInstallationLoad installationMonitor;
    private final ToolIOService toolIOService;
    private final ValidationStrategy rxIdleCharsValidator;
    private final ValidationStrategy txIdleCharsValidator;

    @Inject
    ToolCommInfoPresenter(Provider<ToolIOSettings> toolIOSettingsProvider, InternalToolIOService ioService, EnumsResource enumsResource, MonitorInstallationLoad installationMonitor, ToolIOService toolIOService, RxIdleCharsValidators rxIdleCharsValidators, TxIdleCharsValidators txIdleCharsValidators) {
        this.toolIOSettingsProvider = toolIOSettingsProvider;
        this.ioService = ioService;
        this.enumsResource = enumsResource;
        this.installationMonitor = installationMonitor;
        this.toolIOService = toolIOService;
        this.rxIdleCharsValidator = rxIdleCharsValidators.getRxIdleCharsValidator();
        this.txIdleCharsValidator = txIdleCharsValidators.getTxIdleCharsValidator();
    }

    public void setView(ToolCommInfoView view) {
        this.view = view;
        view.initializeView(new ToolCommViewInitializer(EnumUtils.createEnumResourceValueMap(BaudRate.class, (String)this.enumsResource.toolcommBaudrate()), EnumUtils.createEnumResourceValueMap(Parity.class, (String)this.enumsResource.toolcommParity()), EnumUtils.createEnumResourceValueMap(StopBits.class, (String)this.enumsResource.toolcommStopbits()), this.rxIdleCharsValidator, this.txIdleCharsValidator));
    }

    @Override
    public void modelUpdated() {
        ToolIOSettings toolIOSettings = (ToolIOSettings)this.toolIOSettingsProvider.get();
        ToolCommInfo toolCommInfo = toolIOSettings.getToolCommInfo();
        this.view.updateView(new ToolAnalogInputViewModel(this.ioService.getToolAnalogInputPinDisplayName(0), this.ioService.getToolAnalogInputPinDisplayName(1), AnalogDomain.byId((int)toolIOSettings.getAnalogInputRange()[2]), AnalogDomain.byId((int)toolIOSettings.getAnalogInputRange()[3]), toolCommInfo.isEnabled(), toolCommInfo.getBaudRate(), toolCommInfo.getParity(), toolCommInfo.getStopBits(), toolCommInfo.getRxIdleChars(), toolCommInfo.getTxIdleChars()));
    }

    public void updateModel(AnalogDomain pin0Domain, AnalogDomain pin1Domain, boolean enabled, BaudRate baudRate, Parity parity, StopBits stopBits, float rxIdleChars, float txIdleChars) {
        ToolCommInfo newValue = new ToolCommInfo(enabled, baudRate, parity, stopBits, rxIdleChars, txIdleChars);
        this.toolIOService.setAnalogInputDomains(pin0Domain, pin1Domain);
        this.toolIOService.setToolCommInfo(newValue);
        this.modelUpdated();
    }

    public void startBackgroundService() {
        this.installationMonitor.startMonitoringInstallationLoad(this);
    }

    public void stopBackgroundService() {
        this.installationMonitor.stopMonitoringInstallationLoad(this);
    }

    public static class ToolCommViewInitializer {
        public final Map<BaudRate, String> baudRates;
        public final Map<Parity, String> parities;
        public final Map<StopBits, String> stopBits;
        private final ValidationStrategy rxIdleCharsValidator;
        private final ValidationStrategy txIdleCharsValidator;

        public ToolCommViewInitializer(Map<BaudRate, String> baudRates, Map<Parity, String> parities, Map<StopBits, String> stopBits, ValidationStrategy rxIdleCharsValidator, ValidationStrategy txIdleCharsValidator) {
            this.baudRates = baudRates;
            this.parities = parities;
            this.stopBits = stopBits;
            this.rxIdleCharsValidator = rxIdleCharsValidator;
            this.txIdleCharsValidator = txIdleCharsValidator;
        }

        public ValidationStrategy getRxIdleCharsValidator() {
            return this.rxIdleCharsValidator;
        }

        public ValidationStrategy getTxIdleCharsValidator() {
            return this.txIdleCharsValidator;
        }
    }
}

