/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.io.impl.tool;

import com.google.inject.Inject;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.io.AnalogDomain;
import com.ur.polyscope.io.impl.tool.ToolIOController;
import com.ur.polyscope.io.tool.ToolCommInfo;
import com.ur.util.logging.Log;
import com.ur.view.constants.dev.ToolDigitalOutputMode;
import com.ur.view.constants.dev.ToolOutputMode;
import java.text.MessageFormat;

public class ToolIOControllerImpl
implements ToolIOController {
    private static final int PIN_0 = 0;
    private static final int PIN_1 = 1;
    private static final String SET_TOOL_OUTPUT_MODE = "set_tool_output_mode({0})";
    private static final String SET_TOOL_DIGITAL_OUTPUT_MODE = "set_tool_digital_output_mode({0}, {1})";
    private static final String SET_TOOL_OUTPUT_MODE_MF = "sec setToolOutputMode():\n {0}\nend\n";
    private static final String SET_TOOL_DIGITAL_OUTPUT_MODE_MF = "sec setToolDigitalOutputMode():\n {0}\nend\n";
    private static final String SET_TOOL_VOLTAGE_MF = "sec setToolVoltage():\n {0}\nend\n";
    private static final String SET_TOOL_VOLTAGE = "set_tool_voltage({0})";
    private static final String SET_TOOL_COMM = "set_tool_communication({0}, {1}, {2}, {3}, {4}, {5})";
    private static final String SET_TOOL_COMM_MF = "sec setToolComm():\n {0}\nend\n";
    private ControllerInterface controllerInterface;

    @Inject
    public ToolIOControllerImpl(ControllerInterface controllerInterface) {
        this.controllerInterface = controllerInterface;
    }

    @Override
    public void sendToolDigitalOutputModesToController(ToolDigitalOutputMode pin0Mode, ToolDigitalOutputMode pin1Mode) {
        this.sendToolDigitalOutputModeToController(0, pin0Mode);
        this.sendToolDigitalOutputModeToController(1, pin1Mode);
    }

    @Override
    public void sendToolVoltageToController(int voltage) {
        String setOutput = MessageFormat.format(SET_TOOL_VOLTAGE_MF, this.getSetToolVoltageString(voltage));
        this.controllerInterfaceRunScript(setOutput);
    }

    @Override
    public void sendToolAnalogInputDomain(AnalogDomain pin0Domain, AnalogDomain pin1Domain) {
        this.sendSetToolAnalogInputDomain(0, pin0Domain.asId());
        this.sendSetToolAnalogInputDomain(1, pin1Domain.asId());
    }

    @Override
    public void sendToolCommInfoToController(ToolCommInfo toolCommInfo) {
        String s = MessageFormat.format(SET_TOOL_COMM_MF, this.getSetToolCommunicationString(toolCommInfo));
        this.controllerInterfaceRunScript(s);
    }

    @Override
    public void sendToolOutputModeToController(ToolOutputMode mode) {
        String setOutput = MessageFormat.format(SET_TOOL_OUTPUT_MODE_MF, this.getSetToolOutputModeString(mode));
        this.controllerInterfaceRunScript(setOutput);
    }

    private void controllerInterfaceRunScript(String script) {
        Log.debug((String)("Sending script to controller: " + script));
        this.controllerInterface.runScript(script);
    }

    private void sendToolDigitalOutputModeToController(int pin, ToolDigitalOutputMode mode) {
        String setPin = MessageFormat.format(SET_TOOL_DIGITAL_OUTPUT_MODE_MF, this.getSetToolDigitalOutputModeString(pin, mode));
        this.controllerInterfaceRunScript(setPin);
    }

    private String getBooleanAsString(boolean b) {
        return b ? "True" : "False";
    }

    private void sendSetToolAnalogInputDomain(int pin, int val) {
        StringBuffer b = new StringBuffer();
        b.append("sec setToolAnalogInputDomain():\n");
        b.append("  set_tool_analog_input_domain(" + pin + ", " + val + ")\n");
        b.append("end\n");
        this.controllerInterfaceRunScript(b.toString());
    }

    @Override
    public String getSetToolCommunicationString(ToolCommInfo toolCommInfo) {
        return MessageFormat.format(SET_TOOL_COMM, this.getBooleanAsString(toolCommInfo.isEnabled()), "" + toolCommInfo.getBaudRate().getId(), "" + toolCommInfo.getParity().getId(), "" + toolCommInfo.getStopBits().getId(), "" + toolCommInfo.getRxIdleChars(), "" + toolCommInfo.getTxIdleChars());
    }

    @Override
    public String getSetToolOutputModeString(ToolOutputMode mode) {
        return MessageFormat.format(SET_TOOL_OUTPUT_MODE, mode.getId());
    }

    @Override
    public String getSetToolDigitalOutputModeString(int pin, ToolDigitalOutputMode mode) {
        return MessageFormat.format(SET_TOOL_DIGITAL_OUTPUT_MODE, pin, mode.getId());
    }

    @Override
    public String getSetToolVoltageString(int voltage) {
        return MessageFormat.format(SET_TOOL_VOLTAGE, voltage);
    }
}

