/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.io.impl.tool;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.polyscope.io.AnalogDomain;
import com.ur.polyscope.io.impl.tool.ToolIOController;
import com.ur.polyscope.io.impl.tool.ToolIOService;
import com.ur.polyscope.io.tool.InternalToolIOService;
import com.ur.polyscope.io.tool.Pin;
import com.ur.polyscope.io.tool.ToolCommInfo;
import com.ur.polyscope.io.tool.ToolIOSettings;
import com.ur.polyscope.io.tool.ToolIOSettingsProvider;
import com.ur.polyscope.io.tool.ToolMode;
import com.ur.polyscope.io.tool.Voltage;
import com.ur.polyscope.program.ProgramTreeRenderingTriggerer;
import com.ur.util.event.EventManager;
import com.ur.util.event.NotificationStrategy;
import com.ur.view.constants.dev.ToolOutputMode;

@Singleton
public class ToolIOServiceImpl
implements ToolIOService {
    private final ToolIOSettingsProvider toolIOSettingsProvider;
    private final ProgramTreeRenderingTriggerer programTreeRenderer;
    private final ToolIOController toolIOController;
    private final InternalToolIOService ioService;
    private EventManager eventManager;
    private final long STATE_UPDATE_INTERVAL_MS = 250L;

    @Inject
    public ToolIOServiceImpl(ToolIOSettingsProvider toolIOSettingsProvider, ToolIOController toolIOController, InternalToolIOService ioService, EventManager eventManager, ProgramTreeRenderingTriggerer toolIOProgramTreeRenderer) {
        this.toolIOSettingsProvider = toolIOSettingsProvider;
        this.programTreeRenderer = toolIOProgramTreeRenderer;
        this.toolIOController = toolIOController;
        this.ioService = ioService;
        this.eventManager = eventManager;
    }

    @Override
    public void setToolVoltage(Voltage voltage) {
        ToolIOSettings toolIOSettings = this.toolIOSettingsProvider.get();
        if (toolIOSettings.getToolVoltage() != voltage) {
            this.toolIOSettingsProvider.get().setToolVoltage(voltage);
            this.toolIOController.sendToolVoltageToController(voltage.getVoltageValue());
            this.fireInstallationChangedEvent();
            this.programTreeRenderer.reRenderTree(250L, true);
        }
    }

    @Override
    public Voltage getToolVoltage() {
        return this.toolIOSettingsProvider.get().getToolVoltage();
    }

    @Override
    public void setAnalogInputDomains(AnalogDomain analogZeroInputDomain, AnalogDomain analogOneInputDomain) {
        boolean dirty = false;
        ToolIOSettings toolIOSettings = this.toolIOSettingsProvider.get();
        if (toolIOSettings.getAnalogInput(Pin.TWO) != analogZeroInputDomain) {
            this.ioService.setAnalogInputRange(Pin.TWO.getPinValue(), analogZeroInputDomain.asId());
            this.toolIOSettingsProvider.get().setAnalogInput(Pin.TWO, analogZeroInputDomain);
            dirty = true;
        }
        if (toolIOSettings.getAnalogInput(Pin.THREE) != analogOneInputDomain) {
            this.ioService.setAnalogInputRange(Pin.THREE.getPinValue(), analogOneInputDomain.asId());
            this.toolIOSettingsProvider.get().setAnalogInput(Pin.THREE, analogOneInputDomain);
            dirty = true;
        }
        if (dirty) {
            this.toolIOController.sendToolAnalogInputDomain(analogZeroInputDomain, analogOneInputDomain);
            this.fireInstallationChangedEvent();
            this.programTreeRenderer.reRenderTree(250L, true);
        }
    }

    @Override
    public AnalogDomain getAnalogInput(Pin index) {
        return this.toolIOSettingsProvider.get().getAnalogInput(index);
    }

    @Override
    public void setToolOutputMode(ToolMode toolMode) {
        ToolIOSettings toolIOSettings = this.toolIOSettingsProvider.get();
        if (!toolIOSettings.getToolMode().equals((Object)toolMode)) {
            this.toolIOSettingsProvider.get().setToolMode(toolMode);
            this.toolIOController.sendToolOutputModeToController(toolMode.getOutputMode());
            if (toolMode.getOutputMode() == ToolOutputMode.OUTPUT) {
                this.toolIOController.sendToolDigitalOutputModesToController(toolMode.getPin0Mode(), toolMode.getPin1Mode());
            }
            this.fireInstallationChangedEvent();
            this.programTreeRenderer.reRenderTree(250L, true);
        }
    }

    @Override
    public ToolMode getToolMode() {
        return this.toolIOSettingsProvider.get().getToolMode();
    }

    @Override
    public void setToolCommInfo(ToolCommInfo toolCommInfo) {
        if (!this.getToolCommInfo().equals((Object)toolCommInfo)) {
            this.toolIOSettingsProvider.get().setToolCommInfo(toolCommInfo);
            this.toolIOController.sendToolCommInfoToController(toolCommInfo);
            this.fireInstallationChangedEvent();
            this.programTreeRenderer.reRenderTree(250L, true);
        }
    }

    @Override
    public ToolCommInfo getToolCommInfo() {
        return this.toolIOSettingsProvider.get().getToolCommInfo();
    }

    protected void fireInstallationChangedEvent() {
        this.eventManager.fireEvent(InstallationStateListener.class, (NotificationStrategy)new NotificationStrategy<InstallationStateListener>(){

            public void notify(InstallationStateListener installationStateListener) {
                installationStateListener.installationModified();
            }
        });
    }
}

