/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.io.impl.tool;

import com.ur.polyscope.installation.InstallationComponentConversionStrategy;
import com.ur.polyscope.io.AnalogDomain;
import com.ur.polyscope.io.impl.tool.ToolIOConversionStrategyTemplate;
import com.ur.polyscope.io.impl.tool.ToolIOService;
import com.ur.polyscope.io.tool.Pin;
import com.ur.polyscope.io.tool.ToolAnalogInputViewModel;
import com.ur.polyscope.io.tool.ToolCommInfo;
import com.ur.polyscope.io.tool.ToolIOSettings;
import com.ur.polyscope.io.tool.ToolMode;
import com.ur.polyscope.io.tool.Voltage;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.view.constants.dev.ToolDigitalOutputMode;
import com.ur.view.constants.dev.ToolOutputMode;
import com.ur.view.constants.toolcomm.BaudRate;
import com.ur.view.constants.toolcomm.Parity;
import com.ur.view.constants.toolcomm.StopBits;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;

public class ToolIOSettingsConversionStrategy
extends ToolIOConversionStrategyTemplate<ToolIOSettings>
implements InstallationComponentConversionStrategy<ToolIOSettings> {
    public static final String ANALOG_INPUT_2 = "toolAnalogInput2";
    public static final String ANALOG_INPUT_3 = "toolAnalogInput3";
    public static final String ENABLED = "enabled";
    public static final String BAUD_RATE = "baudRate";
    public static final String PARITY = "parity";
    public static final String STOP_BITS = "stopBits";
    public static final String RX_IDLE_CHARS = "rxIdleChars";
    public static final String TX_IDLE_CHARS = "txIdleChars";
    public static final String DIGITAL_OUTPUT_0 = "toolDigitalOutput0";
    public static final String DIGITAL_OUTPUT_1 = "toolDigitalOutput1";
    public static final String OUTPUT_MODE = "toolOutputMode";
    public static final String TOOL_OUTPUT_VOLTAGE = "toolOutputVoltage";
    private Provider<ToolIOSettings> toolIOSettingsProvider;

    @Inject
    public ToolIOSettingsConversionStrategy(Provider<ToolIOSettings> toolIOSettingsProvider) {
        super(ToolIOSettings.class);
        this.toolIOSettingsProvider = toolIOSettingsProvider;
    }

    public void marshal(ToolIOSettings ioSettings, PersistWriter writer) {
        ToolCommInfo toolCommInfo = ioSettings.getToolCommInfo();
        ToolMode toolMode = ioSettings.getToolMode();
        writer.addAttribute(ENABLED, toolCommInfo.isEnabled());
        writer.addAttribute(ANALOG_INPUT_2, (Enum)AnalogDomain.byId((int)ioSettings.getAnalogInput(Pin.TWO).asId()));
        writer.addAttribute(ANALOG_INPUT_3, (Enum)AnalogDomain.byId((int)ioSettings.getAnalogInput(Pin.THREE).asId()));
        writer.addAttribute(BAUD_RATE, (Enum)toolCommInfo.getBaudRate());
        writer.addAttribute(PARITY, (Enum)toolCommInfo.getParity());
        writer.addAttribute(STOP_BITS, (Enum)toolCommInfo.getStopBits());
        writer.addAttribute(RX_IDLE_CHARS, (double)toolCommInfo.getRxIdleChars());
        writer.addAttribute(TX_IDLE_CHARS, (double)toolCommInfo.getTxIdleChars());
        writer.addAttribute(OUTPUT_MODE, (Enum)toolMode.getOutputMode());
        writer.addAttribute(DIGITAL_OUTPUT_0, (Enum)toolMode.getPin0Mode());
        writer.addAttribute(DIGITAL_OUTPUT_1, (Enum)toolMode.getPin1Mode());
        writer.addAttribute(TOOL_OUTPUT_VOLTAGE, (Enum)ioSettings.getToolVoltage());
    }

    public ToolIOSettings unmarshal(PersistReader reader) {
        ToolIOSettings settings = (ToolIOSettings)this.toolIOSettingsProvider.get();
        settings.setToolCommInfo(new ToolCommInfo(reader.getBooleanAttribute(ENABLED, false), (BaudRate)reader.getEnumAttribute(BAUD_RATE, BaudRate.class, (Enum)ToolAnalogInputViewModel.DEFAULT_BAUD_RATE), (Parity)reader.getEnumAttribute(PARITY, Parity.class, (Enum)ToolAnalogInputViewModel.DEFAULT_PARITY), (StopBits)reader.getEnumAttribute(STOP_BITS, StopBits.class, (Enum)ToolAnalogInputViewModel.DEFAULT_STOP_BITS), reader.getFloatAttribute(RX_IDLE_CHARS, 1.5f), reader.getFloatAttribute(TX_IDLE_CHARS, 3.5f)));
        ToolOutputMode toolOutputMode = (ToolOutputMode)reader.getEnumAttribute(OUTPUT_MODE, ToolOutputMode.class, (Enum)ToolMode.DEFAULT_OUTPUT_MODE);
        settings.setToolMode(new ToolMode(toolOutputMode, (ToolDigitalOutputMode)reader.getEnumAttribute(DIGITAL_OUTPUT_0, ToolDigitalOutputMode.class, (Enum)ToolMode.DEFAULT_DIGITAL_OUTPUT_MODE), (ToolDigitalOutputMode)reader.getEnumAttribute(DIGITAL_OUTPUT_1, ToolDigitalOutputMode.class, (Enum)ToolMode.DEFAULT_DIGITAL_OUTPUT_MODE)));
        settings.setToolVoltage(this.readToolVoltage(reader));
        settings.setAnalogInput(Pin.TWO, this.getAnalogInputValue(reader, ANALOG_INPUT_2));
        settings.setAnalogInput(Pin.THREE, this.getAnalogInputValue(reader, ANALOG_INPUT_3));
        return settings;
    }

    private AnalogDomain getAnalogInputValue(PersistReader reader, String analogInput) {
        AnalogDomain analogDomain = (AnalogDomain)reader.getEnumAttribute(analogInput, AnalogDomain.class, (Enum)AnalogDomain.VOLTAGE);
        if (analogDomain == null) {
            return AnalogDomain.VOLTAGE;
        }
        return AnalogDomain.values()[analogDomain.asId()];
    }

    private Voltage readToolVoltage(PersistReader reader) {
        Voltage voltage = ToolIOService.DEFAULT_TOOL_OUTPUT_VOLTAGE;
        String stringAttribute = reader.getStringAttribute(TOOL_OUTPUT_VOLTAGE);
        if (stringAttribute == null) {
            return voltage;
        }
        return this.isStringInt(stringAttribute) ? Voltage.enumValueOf((int)Integer.parseInt(stringAttribute)) : Voltage.valueOf((String)stringAttribute);
    }

    public boolean isStringInt(String stringInt) {
        try {
            Integer.parseInt(stringInt);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    @Override
    public Map<String, Class<? extends ToolIOSettings>> getClassAliases(boolean forMarshalling) {
        return Collections.singletonMap("ToolCommSettings", ToolIOSettings.class);
    }

    @Override
    public Map<String, Class<? extends ToolIOSettings>> getTypeAliases(boolean forMarshalling) {
        return Collections.singletonMap("ToolCommSettings", ToolIOSettings.class);
    }
}

