/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.io.impl.tool;

import com.ur.polyscope.installation.InstallationComponent;
import com.ur.polyscope.io.AnalogDomain;
import com.ur.polyscope.io.impl.tool.ToolIOController;
import com.ur.polyscope.io.impl.tool.ToolIOService;
import com.ur.polyscope.io.tool.InternalToolIOService;
import com.ur.polyscope.io.tool.Pin;
import com.ur.polyscope.io.tool.ToolAnalogInputViewModel;
import com.ur.polyscope.io.tool.ToolCommInfo;
import com.ur.polyscope.io.tool.ToolIOSettings;
import com.ur.polyscope.io.tool.ToolMode;
import com.ur.polyscope.io.tool.Voltage;
import com.ur.polyscope.scriptwriter.PreambleScript;
import com.ur.polyscope.scriptwriter.ScriptGeneratorLookup;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import javax.inject.Inject;

public class ToolIOSettingsImpl
implements ToolIOSettings,
InstallationComponent,
PreambleScript {
    private ToolCommInfo toolCommInfo;
    private ToolMode toolMode;
    private Voltage toolVoltage;
    private int[] analogInputRange = new int[]{1, 1, 1, 1};
    private ToolIOController toolIOController;

    @Inject
    public ToolIOSettingsImpl(ToolIOController toolIOController, InternalToolIOService internalToolIOService) {
        this.toolIOController = toolIOController;
        this.toolCommInfo = new ToolCommInfo(false, ToolAnalogInputViewModel.DEFAULT_BAUD_RATE, ToolAnalogInputViewModel.DEFAULT_PARITY, ToolAnalogInputViewModel.DEFAULT_STOP_BITS, 1.5f, 3.5f);
        this.toolMode = new ToolMode();
        this.toolVoltage = ToolIOService.DEFAULT_TOOL_OUTPUT_VOLTAGE;
        int i = 0;
        while (i < this.analogInputRange.length) {
            this.analogInputRange[i] = internalToolIOService.getAnalogInputRange(i);
            ++i;
        }
    }

    public ToolCommInfo getToolCommInfo() {
        return this.toolCommInfo;
    }

    public void setToolCommInfo(ToolCommInfo toolCommInfo) {
        this.toolCommInfo = toolCommInfo;
    }

    public ToolMode getToolMode() {
        return this.toolMode;
    }

    public void setToolMode(ToolMode toolMode) {
        this.toolMode = toolMode;
    }

    public Voltage getToolVoltage() {
        return this.toolVoltage;
    }

    public void setToolVoltage(Voltage toolVoltage) {
        this.toolVoltage = toolVoltage;
    }

    public AnalogDomain getAnalogInput(Pin index) {
        int id = this.analogInputRange[index.getPinValue()];
        return AnalogDomain.values()[id];
    }

    public void setAnalogInput(Pin index, AnalogDomain analogInputValue) {
        this.analogInputRange[index.getPinValue()] = analogInputValue.asId();
    }

    public int[] getAnalogInputRange() {
        return this.analogInputRange;
    }

    public void setAnalogInputRange(int[] analogInputRange) {
        this.analogInputRange = analogInputRange;
    }

    public boolean canGenerateScriptCode() {
        return true;
    }

    public void generatePreambleScript(ScriptWriter writer, ScriptGeneratorLookup scriptGeneratorLookup) {
        writer.appendLine(this.toolIOController.getSetToolCommunicationString(this.toolCommInfo));
        writer.appendLine(this.toolIOController.getSetToolOutputModeString(this.toolMode.getOutputMode()));
        writer.appendLine(this.toolIOController.getSetToolDigitalOutputModeString(0, this.toolMode.getPin0Mode()));
        writer.appendLine(this.toolIOController.getSetToolDigitalOutputModeString(1, this.toolMode.getPin1Mode()));
        writer.appendLine(this.toolIOController.getSetToolVoltageString(this.toolVoltage.getVoltageValue()));
    }

    public Class<?> getType() {
        return ToolIOSettings.class;
    }
}

