/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.io.impl.tool;

import com.ur.lang.EnumUtils;
import com.ur.polyscope.io.impl.tool.InstallationLoaded;
import com.ur.polyscope.io.impl.tool.MonitorInstallationLoad;
import com.ur.polyscope.io.impl.tool.ToolIOService;
import com.ur.polyscope.io.impl.tool.ToolModeView;
import com.ur.polyscope.io.impl.tool.ToolModeViewModel;
import com.ur.polyscope.io.internal.EnumsResource;
import com.ur.polyscope.io.tool.InternalToolIOService;
import com.ur.polyscope.io.tool.ToolMode;
import com.ur.polyscope.io.tool.Voltage;
import com.ur.view.constants.dev.ToolDigitalOutputMode;
import com.ur.view.constants.dev.ToolOutputMode;
import java.util.Map;
import javax.inject.Inject;

public class ToolModePresenter
implements InstallationLoaded {
    private final MonitorInstallationLoad installationMonitor;
    private final EnumsResource enumsResource;
    private final InternalToolIOService ioService;
    private final ToolIOService toolIOService;
    private ToolModeView view;

    @Inject
    public ToolModePresenter(MonitorInstallationLoad installationMonitor, EnumsResource enumsResource, InternalToolIOService ioService, ToolIOService toolIOService) {
        this.installationMonitor = installationMonitor;
        this.enumsResource = enumsResource;
        this.ioService = ioService;
        this.toolIOService = toolIOService;
    }

    public void setView(ToolModeView view) {
        this.view = view;
        ToolMode toolModePersistence = this.toolIOService.getToolMode();
        Map availableModes = EnumUtils.createEnumResourceValueMap(ToolDigitalOutputMode.class, (String)this.enumsResource.devTooldigitaloutputmode());
        ToolDigitalOutputMode pin0Mode = toolModePersistence.getPin0Mode();
        ToolDigitalOutputMode pin1Mode = toolModePersistence.getPin1Mode();
        Voltage toolOutputVoltage = this.toolIOService.getToolVoltage();
        view.initializeView(new ToolModeViewInitializer(availableModes, pin0Mode, pin1Mode, toolOutputVoltage));
    }

    @Override
    public void modelUpdated() {
        ToolMode toolModePersistence = this.toolIOService.getToolMode();
        ToolOutputMode outputMode = toolModePersistence.getOutputMode();
        ToolDigitalOutputMode pin0Mode = toolModePersistence.getPin0Mode();
        ToolDigitalOutputMode pin1Mode = toolModePersistence.getPin1Mode();
        Voltage toolOutputVoltage = this.toolIOService.getToolVoltage();
        this.view.updateView(new ToolModeViewModel(outputMode, pin0Mode, pin1Mode, toolOutputVoltage));
    }

    public void startBackgroundService() {
        this.installationMonitor.startMonitoringInstallationLoad(this);
    }

    public void stopBackgroundService() {
        this.installationMonitor.stopMonitoringInstallationLoad(this);
    }

    public void viewStateChanged(ToolModeViewModel selectionsViewModel) {
        this.toolIOService.setToolOutputMode(new ToolMode(selectionsViewModel.outputMode, selectionsViewModel.pin0Mode, selectionsViewModel.pin1Mode));
        this.toolIOService.setToolVoltage(selectionsViewModel.toolOutputVoltage);
        this.modelUpdated();
    }

    public void outputStateChanged(ToolModeViewModel selectionsViewModel) {
        this.ioService.configureOutputPins(selectionsViewModel.outputMode);
        this.viewStateChanged(selectionsViewModel);
    }

    public static class ToolModeViewInitializer {
        public final Map<ToolDigitalOutputMode, String> toolDigitalOutputModes;
        public final ToolDigitalOutputMode pin0Selection;
        public final ToolDigitalOutputMode pin1Selection;
        public final Voltage toolOutputVoltage;

        public ToolModeViewInitializer(Map<ToolDigitalOutputMode, String> toolDigitalOutputModes, ToolDigitalOutputMode pin0Selection, ToolDigitalOutputMode pin1Selection, Voltage toolOutputVoltage) {
            this.toolDigitalOutputModes = toolDigitalOutputModes;
            this.pin0Selection = pin0Selection;
            this.pin1Selection = pin1Selection;
            this.toolOutputVoltage = toolOutputVoltage;
        }
    }
}

