/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.io.impl.tool;

import com.ur.lang.EnumUtils;
import com.ur.lang.react.Consumer;
import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.monitor.model.Masterboard;
import com.ur.polyscope.io.AnalogDomain;
import com.ur.polyscope.io.impl.tool.ToolModeViewModel;
import com.ur.polyscope.io.internal.EnumsResource;
import com.ur.polyscope.io.tool.InternalToolIOService;
import com.ur.polyscope.io.tool.ToolCommInfo;
import com.ur.polyscope.io.tool.ToolIOStateView;
import com.ur.polyscope.io.tool.ToolIOStateViewModel;
import com.ur.polyscope.io.tool.ToolPresenter;
import com.ur.polyscope.program.ProgramModeHolder;
import com.ur.polyscope.robot.configuration.RobotConfigurationProvider;
import com.ur.polyscope.robot.configuration.RobotTool;
import com.ur.util.event.Subscription;
import com.ur.view.constants.dev.ToolOutputMode;
import javax.inject.Inject;
import javax.inject.Provider;

public class ToolPresenterImpl
implements ToolPresenter {
    private static final ToolIOStateViewModel.AnalogInputModel DEFAULT_INPUT_MODEL = new ToolIOStateViewModel.AnalogInputModel();
    private static final ToolIOStateViewModel.AnalogCommModel DEFAULT_COMM_MODEL = new ToolIOStateViewModel.AnalogCommModel();
    private static final ToolIOStateViewModel.DigitalOutputModel DEFAULT_DIGITAL_OUTPUT_MODEL = new ToolIOStateViewModel.DigitalOutputModel();
    private static final String IDLE_CHARS_FORMAT = "%.2f";
    private final ProgramModeHolder programModeService;
    private final InternalToolIOService ioService;
    private final Recipe<ToolCommInfo> toolCommInfoRecipe;
    private final EnumsResource enumsResource;
    private final Provider<ToolModeViewModel> toolModeProvider;
    private final Provider<Masterboard> masterBoardProvider;
    private RobotTool robotTool;
    private ToolIOStateView view;
    private Subscription subscriber = Subscription.NULL;

    @Inject
    ToolPresenterImpl(EnumsResource enumsResource, ProgramModeHolder programModeService, InternalToolIOService ioService, RobotConfigurationProvider robot, @Source(value=ToolCommInfo.class) Recipe<ToolCommInfo> toolCommInfoRecipe, @Source(value=ToolModeViewModel.class) Recipe<ToolModeViewModel> toolModeRecipe, @Source(value=Masterboard.class) Recipe<Masterboard> masterboardRecipe) {
        this.programModeService = programModeService;
        this.ioService = ioService;
        this.toolCommInfoRecipe = toolCommInfoRecipe;
        this.enumsResource = enumsResource;
        this.toolModeProvider = toolModeRecipe.lastProvider();
        this.robotTool = robot.getRobotTool();
        this.masterBoardProvider = masterboardRecipe.lastProvider();
    }

    public void setView(ToolIOStateView view) {
        this.view = view;
    }

    public void startBackgroundMonitor() {
        this.subscriber.dispose();
        this.subscriber = this.toolCommInfoRecipe.distinctUntilChanged().executeOnUIThread().subscribe((Consumer)new UpdateToolData(this.view, this.ioService, this.programModeService, this.masterBoardProvider, this.enumsResource, this.toolModeProvider, this.robotTool));
    }

    public void stopBackgroundMonitor() {
        this.subscriber.dispose();
        this.subscriber = Subscription.NULL;
    }

    private static class UpdateToolData
    implements Consumer<ToolCommInfo> {
        private ToolIOStateView view;
        private InternalToolIOService ioService;
        private ProgramModeHolder programModeService;
        private Provider<Masterboard> masterBoardProvider;
        private EnumsResource enumsResource;
        private Provider<ToolModeViewModel> toolModeProvider;
        private RobotTool robotTool;

        public UpdateToolData(ToolIOStateView view, InternalToolIOService ioService, ProgramModeHolder programModeService, Provider<Masterboard> masterBoardProvider, EnumsResource enumsResource, Provider<ToolModeViewModel> toolModeProvider, RobotTool robotTool) {
            this.view = view;
            this.ioService = ioService;
            this.programModeService = programModeService;
            this.masterBoardProvider = masterBoardProvider;
            this.enumsResource = enumsResource;
            this.toolModeProvider = toolModeProvider;
            this.robotTool = robotTool;
        }

        public void accept(ToolCommInfo toolCommInfo) {
            Masterboard masterboard = (Masterboard)this.masterBoardProvider.get();
            ToolIOStateViewModel.AnalogInputModel analogInputModel = masterboard == null ? DEFAULT_INPUT_MODEL : new ToolIOStateViewModel.AnalogInputModel(AnalogDomain.byId((int)((Masterboard)this.masterBoardProvider.get()).getAnalogInputRange()[2]), AnalogDomain.byId((int)((Masterboard)this.masterBoardProvider.get()).getAnalogInputRange()[3]));
            ToolIOStateViewModel.AnalogCommModel analogCommModel = !toolCommInfo.isEnabled() ? DEFAULT_COMM_MODEL : new ToolIOStateViewModel.AnalogCommModel(EnumUtils.getEnumResourceValue((Enum)toolCommInfo.getBaudRate(), (String)this.enumsResource.toolcommBaudrate()), EnumUtils.getEnumResourceValue((Enum)toolCommInfo.getParity(), (String)this.enumsResource.toolcommParity()), EnumUtils.getEnumResourceValue((Enum)toolCommInfo.getStopBits(), (String)this.enumsResource.toolcommStopbits()), String.format(ToolPresenterImpl.IDLE_CHARS_FORMAT, Float.valueOf(toolCommInfo.getRxIdleChars())), String.format(ToolPresenterImpl.IDLE_CHARS_FORMAT, Float.valueOf(toolCommInfo.getTxIdleChars())));
            ToolIOStateViewModel.DigitalOutputModel outputMode = this.toolModeProvider.get() == null ? DEFAULT_DIGITAL_OUTPUT_MODEL : new ToolIOStateViewModel.DigitalOutputModel(this.isEnabled(0), this.isEnabled(1), ((ToolModeViewModel)this.toolModeProvider.get()).outputMode, this.robotTool.getMaximumCurrent(((ToolModeViewModel)this.toolModeProvider.get()).outputMode));
            this.view.updateView(new ToolIOStateViewModel(outputMode, toolCommInfo.isEnabled(), analogCommModel, analogInputModel));
        }

        private boolean isEnabled(int pinId) {
            if (((ToolModeViewModel)this.toolModeProvider.get()).outputMode == ToolOutputMode.POWER) {
                return false;
            }
            int options = this.ioService.getToolDigitalOutputPinModificationChoice(pinId);
            if (options == 0 || this.programModeService.getMode() == ProgramModeHolder.ProgramMode.Editable && options == 1) {
                return this.ioService.isIOPinEnabled(pinId);
            }
            if (this.programModeService.getMode() == ProgramModeHolder.ProgramMode.ReadOnly && options == 1) {
                return false;
            }
            return options != 2;
        }
    }
}

