/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.io.impl.tool.control;

import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.installation.InstallationListener;
import com.ur.polyscope.installation.resource.ResourceControlSettings;
import com.ur.polyscope.installation.resource.ResourceControllerInfo;
import com.ur.polyscope.io.tool.control.ToolIOControlRequest;
import com.ur.polyscope.io.tool.control.ToolIOControlRequestProvider;
import com.ur.polyscope.io.tool.control.ToolIOControlService;
import com.ur.polyscope.io.tool.control.ToolIOControllable;
import com.ur.util.event.EventNotificationService;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ToolIOControlInstallationListener
implements InstallationListener {
    private final ToolIOControlService toolIOControlService;
    private final Set<ToolIOControlRequestProvider> requestProviders;
    private final InstallationComponentLookup installationComponentLookup;

    @Inject
    public ToolIOControlInstallationListener(ToolIOControlService toolIOControlService, Set<ToolIOControlRequestProvider> requestProviders, InstallationComponentLookup installationComponentLookup) {
        this.toolIOControlService = toolIOControlService;
        this.requestProviders = requestProviders;
        this.installationComponentLookup = installationComponentLookup;
        EventNotificationService.register((Object)this, InstallationListener.class, (Object)this);
    }

    private void installationChanged() {
        ResourceControllerInfo currentResourceControllerInfo = this.getInstallationControlInfo();
        this.toolIOControlService.clear();
        this.resetRequests();
        this.restoreControl(currentResourceControllerInfo);
    }

    private void restoreControl(ResourceControllerInfo info) {
        ToolIOControlRequest request;
        if (info == null) {
            return;
        }
        boolean requestFound = false;
        ToolIOControlRequest[] toolIOControlRequestArray = this.toolIOControlService.requests();
        int n = toolIOControlRequestArray.length;
        int n2 = 0;
        while (n2 < n) {
            request = toolIOControlRequestArray[n2];
            if (info.getId().equals(request.getResourceControllerInfo().getId())) {
                this.toolIOControlService.grantControl(request);
                requestFound = true;
                break;
            }
            ++n2;
        }
        if (!requestFound) {
            request = new MissingToolIOControlRequest("ToolIOInterfaceControllable", info);
            this.toolIOControlService.requestControl(new ToolIOControlRequest[]{request});
            this.toolIOControlService.grantControl(request);
        }
    }

    private void resetRequests() {
        for (ToolIOControlRequestProvider provider : this.requestProviders) {
            ToolIOControlRequest[] requests = (ToolIOControlRequest[])provider.get();
            this.toolIOControlService.requestControl(requests);
        }
    }

    private ResourceControllerInfo getInstallationControlInfo() {
        ResourceControlSettings resourceControlSettings = (ResourceControlSettings)this.installationComponentLookup.getComponent(ResourceControlSettings.class);
        if (resourceControlSettings != null) {
            return resourceControlSettings.getResourceControllerInfo("ToolIOInterfaceControllable");
        }
        return null;
    }

    public void onInstallationEvent(InstallationListener.Event event) {
        if (event.getType() == InstallationListener.EventType.CHANGED) {
            this.installationChanged();
        }
    }

    private static class MissingToolIOControlRequest
    extends ToolIOControlRequest {
        MissingToolIOControlRequest(String resourceId, ResourceControllerInfo info) {
            super(resourceId, new ResourceControllerInfo(info.getId(), info.getDisplayName(), info.getVendorName(), true));
        }

        public void onControlGranted(ToolIOControllable controllable) {
        }

        public void onControlRevoked(ToolIOControllable controllable) {
        }
    }
}

